<!doctype html>
<html lang="{{ app()->getLocale() }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="author" content="Sarfraz Ahmed (sarfraznawaz2005@gmail.com)">

    <title>Backup Manager</title>

    <!-- Bootstrap core CSS -->
    <link rel="stylesheet"
          href="{{url('/backupAsset/bootstrap.min.css')}}"
          integrity="sha384-9gVQ4dYFwwWSjIDZnLEWnxCjeSWFphJiwGPXr1jddIhOegiu1FwO5qRGvFXOdJZ4"
          crossorigin="anonymous">

    <link rel="stylesheet" href="{{url('/backupAsset/font-awesome.min.css')}}">

    <link rel="stylesheet" href="{{url('/backupAsset/dataTables.bootstrap4.min.css')}}">
    <link rel="stylesheet" href="{{url('/backupAsset/responsive.bootstrap4.min.css')}}">

    <style>
        body {
            padding-top: 4rem;
            font-size: 0.8rem;
            font-family: sans-serif;
            line-height: 1.0;
            margin-bottom: 50px;
            background-color: #cccccc;
            background-image: url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='8' height='8' viewBox='0 0 8 8'%3E%3Cg fill='%23dddddd' fill-opacity='0.4'%3E%3Cpath fill-rule='evenodd' d='M0 0h4v4H0V0zm4 4h4v4H4V4z'/%3E%3C/g%3E%3C/svg%3E");
        }

        .table td, .table th {
            padding: .50rem;
            vertical-align: middle;
        }

        .table thead {
            background-image: linear-gradient(#eee, #ddd);
        }

        .card-header {
            padding: .40rem 1.25rem;
            line-height: 250%;
        }

        .warning {
            background: #FAF2CC;
        }

        legend {
            border: 0 none;
            font-size: 14px;
            line-height: 20px;
            margin-bottom: 0;
            width: auto;
            padding: 0 10px;
            font-weight: bold;
        }

        fieldset {
            border: 1px solid #e0e0e0;
            padding: 10px;
        }

        /*==================================================
        * Effect 2
        * ===============================================*/
        .shadow {
            position: relative;
        }

        .shadow:before, .shadow:after {
            z-index: -1;
            position: absolute;
            content: "";
            bottom: 15px;
            left: 10px;
            width: 50%;
            top: 80%;
            max-width: 300px;
            background: #222222;
            -webkit-box-shadow: 0 15px 10px #222222;
            -moz-box-shadow: 0 15px 10px #222222;
            box-shadow: 0 15px 10px #222222;
            -webkit-transform: rotate(-3deg);
            -moz-transform: rotate(-3deg);
            -o-transform: rotate(-3deg);
            -ms-transform: rotate(-3deg);
            transform: rotate(-3deg);
        }

        .shadow:after {
            -webkit-transform: rotate(3deg);
            -moz-transform: rotate(3deg);
            -o-transform: rotate(3deg);
            -ms-transform: rotate(3deg);
            transform: rotate(3deg);
            right: 10px;
            left: auto;
        }

        .stripe {
            color: white;
            background: repeating-linear-gradient(45deg, #007BFF, #007BFF 20%, #3898ff 10px, #3898ff);
            background-size: 100% 20px;
        }

        nav {
            background-image: radial-gradient(#9bb3de, #d0d3de); 
			color: #000000;
        }
    </style>

    @stack('styles')
</head>

<body>

<nav class="navbar navbar-expand-md navbar-dark fixed-top">
    <a class="navbar-brand" href="{{route('home.index')}}"><img alt="logo" class="logo-default" src="{{url('/')}}/logo/platinume_logo/logo.png" /></a>

    <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarsExampleDefault"
            aria-controls="navbarsExampleDefault" aria-expanded="false" aria-label="Toggle navigation">
        <span class="navbar-toggler-icon"></span>
    </button>

    <div class="collapse navbar-collapse" id="navbarsExampleDefault">
        <ul class="navbar-nav mr-auto"></ul>

        <ul class="nav navbar-nav navbar-right">
            <li class="nav-item">
                {{--<a class="nav-link" href="#">&nbsp;</a>--}}
            </li>
        </ul>
    </div>
</nav>

<main role="main" class="container">

    <div class="card shadow">
        <div class="card-header bg-primary text-white stripe">
            <strong>@yield('title')</strong>

            <div class="float-right">
                @yield('header')
            </div>
            <div class="clearfix">
				<form class='col-sm-6' action="{{ route('backupmanager_upload') }}" method="post" enctype="multipart/form-data">
					{{ csrf_field() }}
					<div class="form-group">
						<label for="backup_file" class="control-label">{{ trans('backup.upload') }}</label>
						<input type="file" name="backup_file" class="form-control">
					</div>
					<div class="form-group">
						<input type="submit" value="{{ trans('backup.upload') }}" class="btn btn-success btn-sm">
					</div>
				</form>
			</div>
        </div>

        <div class="card-body">
            @if(Session::has('messages'))
                @foreach (Session::get('messages') as $message)
                    <p class="alert alert-{{ $message['type'] }}">
                        <strong>{{ $message['message'] }}</strong>
                    </p>
                @endforeach
            @endif

            @yield('content')
        </div>

    </div>
</main>

<!-- Bootstrap core JavaScript
================================================== -->
<script
        src="{{url('/backupAsset/jquery-3.3.1.slim.min.js')}}"
        integrity="sha384-q8i/X+965DzO0rT7abK41JStQIAqVgRVzpbzo5smXKp4YfRvH+8abtTE1Pi6jizo"
        crossorigin="anonymous">
</script>
<script
        src="{{url('/backupAsset/popper.min.js')}}"
        integrity="sha384-cs/chFZiN24E4KMATLdqdvsezGxaGsi4hLGOzlXwp5UZB1LY//20VyM2taTB4QvJ"
        crossorigin="anonymous">
</script>
<script
        src="{{url('/backupAsset/bootstrap.min.js')}}"
        integrity="sha384-uefMccjFJAIv6A+rW+L4AHf99KvxDjWSu1z9VI8SKNVmz4sk7buKt/6v9KI65qnm"
        crossorigin="anonymous">
</script>

<script src="{{url('/backupAsset/jquery.dataTables.min.js')}}"></script>
<script src="{{url('/backupAsset/dataTables.bootstrap4.min.js')}}"></script>
<script src="{{url('/backupAsset/dataTables.responsive.min.js')}}"></script>
<script src="{{url('/backupAsset/responsive.bootstrap4.min.js')}}"></script>
<script src="{{url('/backupAsset/dataTables.rowGroup.min.js')}}"></script>
<script src="{{url('/backupAsset/sweetalert.min.js')}}"></script>

<script>
    $('[data-toggle="tooltip"]').tooltip();
</script>

@stack('scripts')

</body>
</html>
