@extends('layouts.app')
@section('content')
    <div class="row">

        <div class="portlet light bg-inverse" style="min-height: 100%;">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.ProjectWorkType') </span>
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>
                <div class="tools">
                    <a href="" class="collapse" data-original-title="" title=""> </a>
                    <a href="#portlet-config" data-toggle="modal" class="config" data-original-title="" title=""> </a>
                    <a href="" class="reload" data-original-title="" title=""> </a>
                    <a href="" class="remove" data-original-title="" title=""> </a>
                </div>
            </div>
            <div class="portlet-body form" style="margin-bottom:50%;" id="inventory-category">
                <!-- BEGIN FORM-->
                {!! Form::open(array('route' => 'workType.store','method'=>'POST','class'=>'form-horizontal')) !!}
                {{ csrf_field() }} 
                    <div class="form-body">
                        <div class="col-md-9"> 
                            <div class="form-group">
                                <label class="control-label col-md-3">@lang('layout.WorkType'):</label>
                                <div class="col-md-9">
                                    {{Form::text('name',null,['class' => 'form-control','v-validate' =>'"required"','data-vv-as' => __('layout.WorkType'),'placeholder' => __('layout.WorkType')])}}
                                     <span class="required">@{{ errors.first('name') }}</span>
                                </div>
                            </div> 
                            <div class="form-group">
                                <label class="control-label col-md-3">@lang('layout.Description'):</label>
                                <div class="col-md-9">
                                  {!! Form::textarea('description', null, array('placeholder' => __('layout.Description'),'class' => 'form-control','rows' => 6, 'cols' => 30)) !!}
                                </div>
                            </div>
                        </div>  
                    </div>
                    <div class="col-xs-12 col-sm-10 col-md-11 text-center">
                        <button type="button" @click="handleSubmit($event)" class="btn green">@lang('layout.Submit')</button>
                        <a href="{{route('inventorySite.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                    </div>  
                {!! Form::close() !!}
            </div>                  
            <!-- END FORM-->
        </div>
    </div> 
@endsection

@push('scripts')

<script>
    @if(App::getLocale())
    Vue.use(VeeValidate, {
        locale: '{{App::getLocale()}}',
    });
    @else
    Vue.use(VeeValidate, {
        locale: 'en',
    });
    @endif

    let vu = new Vue({
        el: '#inventory-category',
        data:{

        },
        methods:{
            handleSubmit(e)
            {
                this.$validator.validate()
                .then(valid =>{
                    if(valid)
                    {
                        
                    regForm(e.target);
                    }
                })
            }
        }
    })
</script>
@endpush