@extends('layouts.factor-master')

@section('content')

<h3 class="table-caption" style="text-align: center;">@lang('layout.WeighbridgeReport')</h3>
<table class="main-table">
    <thead>
    <tr>
        <th>
            <i></i> @lang('layout.Type')
        </th>
        <th>
            <i></i> @lang('layout.Number')
        </th>
        <th>
            <i></i> @lang('layout.User')
        </th>
        <th>
            <i></i> @lang('layout.Date')
        </th>
        <th>
            <i></i> @lang('layout.Description')
        </th>
    </tr>
    </thead>
    <tbody>
    <tr>
        <td class="center"> {{ __('layout.'.ucfirst($data['type']))}}  </td>
        <td class="center"> {{ $data['type_number']}}  </td>
        <td class="center"> {{ $data['username']}}  </td>
        <td class="center"> {{ convertDate($data['date'])}}  </td>
        <td class="center"> {{ $data['description']}}  </td>
    </tr>
    </tbody>
</table>
<br>


<div class="row">
    <div class="col-md-6 col-sm-12">
        <div class="portlet green-meadow box" style=" border: 1px solid #2ae0bb;">
            <div class="portlet-title" style=" background-color: #1BBC9B">
                <div class="caption">
                  <table class="main-table">
                    <thead>
                        <tr class="active">
                            <th>@lang('layout.Number')</th>
                            <th>@lang('layout.CarNumber')</th>
                            <th>@lang('layout.DriverName')</th>
                            <th>@lang('layout.Hour')</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr class="active">
                            <td class="center">{{$data['number']}}</td>
                            <td class="center">{{$data['vehicle_number']}}</td>
                            <td class="center">{{$data['driver_name']}}</td>
                            @if(getHourType() == 24)
                            <td class="center">{{(($data['hour'] != null)?(date_format(date_create($data['hour']), 'H:i')):null)}}</td>
                            @else
                            <td class="center">{{(($data['hour'] != null)?(date_format(date_create($data['hour']), 'h:i a')):null)}}</td>
                            @endif
                        </tr>
                    </tbody>
                </table>
                </div>
          
            </div>
  
            <div class="portlet-body">
                <div class="row static-info">
                    <div class="col-md-12 value">
                        <div >
                            <table class="main-table" >
                                <thead>
                                    <tr class="active">
                                        <th>@lang('layout.Item')</th>
                                        <th>@lang('layout.Unit')</th>
                                       <th>@lang('layout.FullWeight')</th>
                                       <th>@lang('layout.EmptyWeight')</th>
                                    </tr>
                                </thead> 
                                <tbody>
                                        <tr>
                                            <td class="center">{{$data['item_name']}}</td>
                                            <td class="center">{{$data['measure_name']}}</td>
                                            <td class="center">{{$data['full_weight']}}</td>
                                            <td class="center">{{$data['empty_weight']}}</td>
                                        </tr>
                                </tbody>
                            </table>
  
                        </div>

                        <h4 style="font-weight:bold;text-align:center;color:rgb(245, 123, 9)">@lang('layout.NetWeight') : {{$data['net_weight']}}</h4>
                    
                         
                    </div>
                    <table class="main-table" >
                        <thead>
                            <tr class="active">
                               <th>@lang('layout.LaboratoryDescription')</th>
                               <th>@lang('layout.LaboratoryQty')</th>
                               <!-- <th></th> -->
                            </tr>
                        </thead> 
                        <tbody>
                            @foreach ($weighbridgeCategory as $item)
                                <tr>
                                    
                                    <td>{{$item->name}}</td>
                                    <td>{{$item->test_qty}}</td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
  </div>


 <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->



@endsection