@extends('layouts.app')

@section('style')
    <style>
        .iconStyle{
            font-size: 20px;
        }

        .modal-container {
            max-height: 600px;
            width: 30% !important;
            max-width: 30% !important;
        }

    </style>
@endsection

@section('content')

<div id="print-modal" >

<report-modal :pdf-route="pdfRoute" :excel-route="excelRoute"
    v-if="is_show" 
    :value-type="'weighbridge_details'"
    
    @closed="closeModal" >

    <div slot="body">
         <input type="hidden" name="id" value="{{$weighbridge->id}}"/>
    </div>
</report-modal>
</div>


  





    <div class="portlet">
        <div class="portlet-title" id="backbtn">
            <div class="caption">
                <i class=""></i>@lang('layout.WeighbridgeShow')
            </div>
            <div class="tools">
            </div>
        </div>
        <div class="portlet-body">
            <div class="table-scrollable">
                <table class="table table-striped table-bordered table-advance table-hover">
                    <thead>
                    <tr>
                        <th>
                            <i></i> @lang('layout.Type')
                        </th>
                        <th class="">
                            <i></i> @lang('layout.Number')
                        </th>
                        <th class="">
                            <i></i> @lang('layout.User')
                        </th>
                        <th>
                            <i></i> @lang('layout.Date')
                        </th>
                        <th>
                            <i></i> @lang('layout.Description')
                        </th>
                    </tr>
                    </thead>
                    <tbody>
                    <tr>
                        <td class=" "> {{ __('layout.'.ucfirst($weighbridge->type))}}  </td>
                        <td class=""> {{ $weighbridge->type_number}}  </td>
                        <td class=""> {{ $weighbridge->username }}  </td>
                        <td> {{ convertDate($weighbridge->date)}}  </td>
                        <td > {{ $weighbridge->description }}  </td>
                    </tr>
                    </tbody>
                </table>
            </div>
        </div>

    </div>

    <div class="row">
    <div class="col-md-12 col-sm-12">
        <div class="portlet green-meadow box">
            <div class="portlet-title">
                <div class="caption">
                    {{-- <i class="icon-user"></i>&nbsp; title --}}
                </div>

                <div class="tools"></div>
                <div class="actions">
                    <span id="anchore-modal">
                        <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                           <i class="fa fa-print"></i>
                        </a>
                       </span>
                </div>
          
            </div>

            <div class="portlet-body">
                <div class="row static-info">
                    <div class="col-md-12 value">

                        <table class="table">
                            <thead>
                                <tr class="active">
                                    <th>@lang('layout.Number')</th>
                                    <th>@lang('layout.CarNumber')</th>
                                    <th>@lang('layout.DriverName')</th>
                                    <th>@lang('layout.Hour')</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr class="active">
                                    <td>{{$weighbridge->number}}</td>
                                    <td>{{$weighbridge->vehicle_number}}</td>
                                    <td>{{$weighbridge->driver_name}}</td>
                                    @if(getHourType() == 24)
                                    <td>{{(($weighbridge->hour != null)?(date_format(date_create($weighbridge->hour), 'H:i')):null)}}</td>
                                    @else
                                    <td>{{(($weighbridge->hour != null)?(date_format(date_create($weighbridge->hour), 'h:i a')):null)}}</td>
                                    @endif
                                </tr>
                            </tbody>
                        </table>
                        <br>

                        <div>
                            <table class="table table-bordered" >
                                <thead>
                                    <tr class="active">
                                        <th>@lang('layout.Item')</th>
                                        <th>@lang('layout.Unit')</th>
                                       <th>@lang('layout.FullWeight')</th>
                                       <th>@lang('layout.EmptyWeight')</th>
                                    </tr>
                                </thead> 
                                <tbody>
                                        <tr>
                                            <td>{{$weighbridge->item_name}}</td>
                                            <td>{{$weighbridge->measure_name}}</td>
                                            <td>{{$weighbridge->full_weight}}</td>
                                            <td>{{$weighbridge->empty_weight}}</td>
                                        </tr>
                                </tbody>
                            </table> 
                            
                            <h4 style="font-weight:bold;text-align:center;color:rgb(245, 123, 9)">@lang('layout.NetWeight') : {{$weighbridge->net_weight}}</h4>
                        </div>
                        <br>

                        <div >
                            <table class="table table-bordered" >
                                <thead>
                                    <tr class="active">
                                       <th>@lang('layout.LaboratoryDescription')</th>
                                       <th>@lang('layout.LaboratoryQty')</th>
                                       <!-- <th></th> -->
                                    </tr>
                                </thead> 
                                <tbody>
                                    @foreach ($weighbridgeCategory as $item)
                                        <tr>
                                            
                                            <td>{{$item->name}}</td>
                                            <td>{{$item->test_qty}}</td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>

                        </div>
                    
                    
                         
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
@include('print.modal')
@push('scripts')

    <script>
 



    var vm =new Vue({

            el: '#print-modal',
            data:{
                is_show: false,
                pdfRoute: '{!!route('export.PDFAny') !!}',
                excelRoute: '{!! route('export.exportCsv') !!}',
            },

            methods:{
                closeModal: function(){
                    this.is_show = !this.is_show;
                }
            }
            });

            new Vue({
            el:'#anchore-modal',
            methods:{
            showModal:function(){
                console.log('trr')
                vm.$data.is_show = true;
            }
            }
            });
    </script>


@endpush
