@extends('layouts.factor-master')

@section('content')

	<h4 class="table-caption" style="text-align: center;">@lang('layout.WeighbridgeReport')</h4>
  @if($from_date || $to_date)
  <table class="main-table">
    <tr>
        @if($from_date)
            <td>
                <span>@lang('layout.FromDate')</span>:
                <BDO DIR="LTR"> @if(\Setting::get('jalali_and_gerogarian_date') == 'true')  {{convertDate($from_date, null, null, ((\Setting::get('date_type') == 'jalali')?'gregorian':'jalali'))}}  <span dir="rtl"> &nbsp;&nbsp;&nbsp;  @lang('layout.MarchingAt')  </span>  @endif  {{convertDate($from_date)}}</BDO>
            </td>
        @endif
        @if($to_date)
            <td>
                <span>@lang('layout.ToDate')</span>:
                <BDO DIR="LTR">@if(\Setting::get('jalali_and_gerogarian_date') == 'true')  {{convertDate($to_date, null, null, ((\Setting::get('date_type') == 'jalali')?'gregorian':'jalali'))}}  <span dir="rtl"> &nbsp;&nbsp;&nbsp;  @lang('layout.MarchingAt')  </span>  @endif  {{convertDate($to_date)}}</BDO>
            </td>
        @endif
    </tr>
  </table>
  <br>
  @endif

<?php 
$counter = 0;
?>

<table class="main-table">
    <thead>
    <tr class="bg">
        <th>@lang('layout.Number')</th>
        <th>@lang('layout.Type')</th>
        <th>@lang('layout.TypeNumber')</th>
        <th>@lang('layout.CarNumber')</th>
        <th>@lang('layout.DriverName')</th>
        <th>@lang('layout.Date')</th>
        <th>@lang('layout.Hour')</th>
        {{-- <th>@lang('layout.Description')</th> --}}
        <th>@lang('layout.Item')</th>
        <th>@lang('layout.Unit')</th>
        <th>@lang('layout.FullWeight')</th>
        <th>@lang('layout.EmptyWeight')</th>
        <th>@lang('layout.NetWeight')</th>
        @if ($sale_comparison)
        <th>@lang('layout.SaleQty')</th>
        <th>@lang('layout.Differ')</th>
        @endif
    </tr>
    </thead>

    <?php
      $count = 0;
      $total_net_qty = 0;
      $total_sale_qty = 0;
      $total_differ_qty = 0;
    ?>
    <tbody>
    @foreach($data AS $record)
    <?php
      $total_net_qty += $record['net_weight'];
      $total_sale_qty += $record['sale_qty'];
      $total_differ_qty += ($record['sale_qty'] - $record['net_weight']);
    ?>
    <tr>
        <td class="center">{{$record['number']}}</td>
        <td class="center">{{ __('layout.'. ucfirst($record['type']))}}</td>
        <td class="center">{{$record['type_number']}}</td>
        <td class="center">{{$record['vehicle_number']}}</td>
        <td class="center">{{$record['driver_name']}}</td>
        <td class="center">{{convertDate($record['date'])}}</td>
        @if(getHourType() == 24)
        <td class="center">{{(($record['hour'] != null)?(date_format(date_create($record['hour']), 'H:i')):null)}}</td>
        @else
        <td class="center">{{(($record['hour'] != null)?(date_format(date_create($record['hour']), 'h:i a')):null)}}</td>
        @endif
        {{-- <td class="center">{{$record['description']}}</td> --}}
        <td class="center">{{$record['item_name']}}</td>
        <td class="center">{{$record['measure_name']}}</td>
        <td class="center">{{$record['full_weight']}}</td>
        <td class="center">{{$record['empty_weight']}}</td>
        <td class="center">{{$record['net_weight']}}</td>
        @if ($sale_comparison)
        <td class="center">{{$record['sale_qty']}}</td>
        <td class="center">{{$record['sale_qty'] - $record['net_weight']}}</td>
        @endif
    </tr>
    @endforeach

  </tbody>
</table>

<table class="main-table">
    <tr class="bg">
        <th>@lang('layout.Total') @lang('layout.NetWeight') : {{$total_net_qty}}</th>
        @if ($sale_comparison)
        <th>@lang('layout.Total') @lang('layout.SaleQty') : {{$total_sale_qty}}</th>
        <th>@lang('layout.Total') @lang('layout.Differ') : {{$total_differ_qty}}</th>
        @endif
    </tr>
</table>



<!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->
@endsection