@extends('layouts.app')


@section('style')
<link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css">
<link href="{{URL::asset('assets/global/plugins/bootstrap-timepicker/css/bootstrap-timepicker.min.css')}}" rel="stylesheet" type="text/css" />
@stop


@section('content')
    <div class="row">

        <div class="portlet light bg-inverse" style="min-height: 100%;">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>&nbsp;
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.WeighbridgeEdit') </span>
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>
                <div class="tools">
                    
                </div>
            </div>

            <div class="portlet-body form" style="margin-bottom:50%;" id="app">
                <!-- BEGIN FORM-->
                {!! Form::model($weighbridge, ['method' => 'PATCH','class'=>'form-horizontal','route' => ['weighbridge.update',$weighbridge->id]]) !!}
                {{ csrf_field() }}
                <div class="form-body">

                    <div class="row">
                        <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                            <div class="form-group">
                                <div class="col-md-12">
                                    <label class="control-label">@lang('layout.Type')</label>
                                    <select name="type" v-model="type" class="form-control">
                                        <option value="">@lang('layout.SelectType')</option>
                                        <option value="purchases">@lang('layout.Purchase')</option>
                                        <option value="builds">@lang('layout.Build')</option>
                                        <option value="transfer_and_loadings">@lang('layout.TransferAndLoading')</option>
                                        <option value="sales">@lang('layout.Sale')</option>
                                    </select>
                                </div>
                            </div>
                        </div>

                         <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                            <div class="form-group">
                                <div class="col-md-12">
                                    <label class="control-label">@lang('layout.TypeNumber')</label>
                                    <input type="number" name="type_number" v-model="type_number" class="form-control">
                                </div>
                            </div>
                        </div>

                        <div class="col-lg-1 col-md-1 col-sm-2 col-xs-12">
                            <div class="form-group">
                                <div class="col-md-12">
                                    <label class="control-label">&nbsp;</label>
                                    <button type="button" class="btn btn-info form-control" @click="searchType">
                                    <i class="fa fa-search"></i>@lang('layout.Search')</button>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <div class="col-lg-3 col-md-3 col-sm-6 col-xs-12">
                                    <label class="control-label">@lang('layout.Number')</label>
                                    {{Form::text('number',null,['class' => 'form-control'])}}
                                </div>

                                <div class="col-lg-3 col-md-3 col-sm-6 col-xs-12">
                                    <label class="control-label">@lang('layout.Date')</label>
                                    {{Form::text('date',null,['class' => 'form-control date'])}}
                                </div>
                                <div class="col-lg-3 col-md-3 col-sm-6 col-xs-12">
                                    <label class="control-label">@lang('layout.Hour')</label>
                                    <div class="input-group"> 
                                        @if(getHourType() == 24)
                                        {{Form::text('hour',null,['class' => 'form-control timepicker timepicker-24'])}}
                                        @else
                                        {{Form::text('hour',null,['class' => 'form-control timepicker timepicker-no-seconds'])}}
                                        @endif
                                        <span class="input-group-btn">
                                            <button class="btn default" type="button">
                                                <i class="fa fa-clock-o"></i>
                                            </button>
                                        </span>
                                    </div>
                                </div>

                                <div class="col-lg-3 col-md-3 col-sm-6 col-xs-12">
                                    <label class="control-label">@lang('layout.Description')</label>
                                    <textarea name="description" class="form-control">{{$weighbridge->description}}</textarea>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <div class="col-lg-4 col-md-4 col-sm-6 col-xs-12">
                                    <label class="control-label">@lang('layout.FullWeight')</label>
                                    {{Form::number('full_weight',null,['class' => 'form-control'])}}
                                </div>
                                <div class="col-lg-4 col-md-4 col-sm-6 col-xs-12">
                                    <label class="control-label">@lang('layout.EmptyWeight')</label>
                                    {{Form::number('empty_weight',null,['class' => 'form-control'])}}
                                </div>
                                <div class="col-lg-4 col-md-4 col-sm-6 col-xs-12">
                                    <label class="control-label">@lang('layout.NetWeight')</label>
                                    {{Form::number('net_weight',null,['class' => 'form-control'])}}
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <div class="col-lg-3 col-md-3 col-sm-6 col-xs-12">
                                    <label class="control-label ">@lang('layout.SelectItem') </label>
                                    <v-select v-if='type' class="vue-select2" v-model="selected_item" label="name" :options="weighbridge_item" @input="(editKey)?labSelectedMeasure():''" @keyup.native="editKey = true" @Click.native="editKey = true" ></v-select>
                                    <v-select v-if='!type' class="vue-select2" v-model="selected_item" label="name" @search="onItemSearch" :options="weighbridge_item" @input="(editKey)?labSelectedMeasure():''" @keyup.native="editKey = true" @Click.native="editKey = true" ></v-select>
                                    <input type="hidden" name="item_id" :value="!selected_item?null:selected_item.item_id" >
                                    <input type="hidden" name="loading_detail_id" :value="!selected_item?null:(!selected_item.loadingDetail?type_detail_id:selected_item.loadingDetail.id)" >
                                    <input type="hidden" name="type_detail_id" :value="!selected_item?type_detail_id:selected_item.type_detail_id" >
                                </div>
                                <div class="col-lg-3 col-md-3 col-sm-6 col-xs-12">
                                    <label class="control-label ">@lang('layout.Unit') </label>
                                    <select name="um_id" class="form-control" v-model="selected_measure">
                                        <option value="null">@lang('layout.Select')</option>
                                        <span v-if="(selected_item ==null)?false:true">
                                            <option v-for="measure in measure" :value="measure.measure_id">
                                                @{{measure.measure_name}}
                                            </option>
                                        </span>
                                    </select>
                                </div>
                                <div class="col-lg-3 col-md-3 col-sm-6 col-xs-12">
                                    <label class="control-label">@lang('layout.CarNumber')</label>
                                    <input type="text" name="vehicle_number" v-model="vehicle" class="form-control" autocomplete="off">
                                </div>
                                <div class="col-lg-3 col-md-3 col-sm-6 col-xs-12">
                                    <label class="control-label">@lang('layout.DriverName')</label>
                                    <input type="text" name="driver_name" v-model="driver" class="form-control" autocomplete="off">
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
                <div class="col-xs-12 col-sm-10 col-md-11 text-center">
                    <button type="button" class="btn green" onclick="regForm(this)">@lang('layout.Submit')</button>
                    <a href="{{url()->previous()}}" class="btn default"><i
                                class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                </div>
                {!! Form::close() !!}
            </div>

            <!-- END FORM-->
        </div>



    </div>

@endsection
@push('scripts')
<script src="{{URL::asset('assets/global/plugins/bootstrap-timepicker/js/bootstrap-timepicker.min.js')}}" type="text/javascript"></script>
<script src="{{URL::asset('assets/pages/scripts/components-date-time-pickers.min.js')}}" type="text/javascript"></script>

    <script type="text/javascript">
        Vue.component('v-select', VueSelect.VueSelect);

        
        var weighbridge_item = {!! $weighbridge_item!!}
        var selected_item = {!! $selected_item!!} 
        
        var measureUnitList  = {!! $measureUnitList!!}
        var selected_measure = {!! $selected_measure!!}

        let v = new Vue({
            el: '#app',
            data: {
                weighbridge_item:weighbridge_item,
                selected_item_weighbridge:selected_item,
                weighbridge_measure:measureUnitList,
                selected_measure_weighbridge:selected_measure,

                type_number:null,
                editKey: false,
                type:'',
                weighbridge_item:weighbridge_item,
                selected_item:selected_item,
                measure:measureUnitList,
                vehicle:null,
                driver:null,
                type_detail_id:null,
                selected_measure:1
            },
            mounted: function () {
                @if($weighbridge->type && $type_number)
                this.type = "{{$weighbridge->type}}";
                this.type_number = "{{$type_number}}";
                @endif

                @if($weighbridge->measure_id)
                this.selected_measure = "{{$weighbridge->measure_id}}";
                @endif

                @if($weighbridge->vehicle_number)
                this.vehicle = "{{$weighbridge->vehicle_number}}";
                @endif
                @if($weighbridge->driver_name)
                this.driver = "{{$weighbridge->driver_name}}";
                @endif

                @if($weighbridge->type_detail_id)
                this.type_detail_id = "{{$weighbridge->type_detail_id}}";
                @endif
             
            },
            methods: {

                searchType()
                {
                    if(this.type && this.type_number)
                    {
                        axios.get("{{route('laboratory.search')}}", {
                            params: {
                                type: this.type,
                                type_number: this.type_number,
                            }
                        })
                        .then(function (response) {
                            v.weighbridge_item = [];
                            v.selected_item=null;
                            if (response.data.length > 0) {
                                v.weighbridge_item = response.data;
                            }
                        })
                        .catch(function (error) {
                            console.log(error);
                        })
                    }
                },

                labSelectedMeasure(){
                    if(v.selected_item!=null){
                        // console.log(132, v.selected_item);
                        v.type_detail_id = null;
                        if (v.selected_item.measure) {
                            v.selected_measure = v.selected_item.measure.measure_id;
                            v.measure = v.selected_item.measure_list;
                        } else if(v.selected_item.um_id) {
                            v.selected_measure = v.selected_item.um_id;
                        }
                        if (v.selected_item.loadingDetail) {
                            if (v.selected_item.loadingDetail.driver_type == "OwnDriver") {
                                v.vehicle = v.selected_item.loadingDetail.vehicle_name + " " + v.selected_item.loadingDetail.palet_number;
                                v.driver = v.selected_item.loadingDetail.name;
                            } else{
                                v.vehicle = v.selected_item.loadingDetail.other_vehicle_name;
                                v.driver = v.selected_item.loadingDetail.other_driver_name;
                            }
                        }
                    }
                },

                onItemSearch: _.debounce((search, loading) => {
                    // console.log(234, search);
                    loading(true);
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'itemesSearchSale',
                            keyword: search
                        }
                    })
                    .then(function(response) {
                            v.weighbridge_item = [];
                            v.selected_item=null;
                        if (response.data.length > 0) {
                            v.weighbridge_item = response.data;
                        }
                        loading(false);
                    })
                    .catch(function(error) {
                        console.log(error);
                    })
                }, getDebounceTime()),
             
            }
        })
    </script>

@endpush
 