@extends('layouts.app')

@section('style')
<link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css">
 <link href="{{url('/assets/bootstrap-fileinput/bootstrap-fileinput.css')}}" rel="stylesheet" type="text/css"/>
 <link href="{{URL::asset('assets/global/plugins/bootstrap-timepicker/css/bootstrap-timepicker.min.css')}}" rel="stylesheet" type="text/css" />
 <style>

 
     
 </style>
@stop


@section('content')
    <div class="row">

        <div class="portlet light bg-inverse" style="min-height: 100%;">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i> &nbsp;
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.WeighbridgeCreate') </span>
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>
                <div class="tools">
                    
                </div>
            </div>
            <div id="app" v-cloak class="portlet-body form" style="margin-bottom:50%;">
                <!-- BEGIN FORM-->
                {!! Form::open(array('route' => 'weighbridge.store','method'=>'POST','class'=>'form-horizontal','id'=>'clothCategory-submit')) !!}
                {{ csrf_field() }}
                <div class="form-body">

                    <div class="row">
                        <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                            <div class="form-group">
                                <div class="col-md-12">
                                    <label class="control-label">@lang('layout.Type')</label>
                                    <select name="type" v-model="type" class="form-control">
                                        <option value="">@lang('layout.SelectType')</option>
                                        <option value="purchases">@lang('layout.Purchase')</option>
                                        <option value="builds">@lang('layout.Build')</option>
                                        <option value="transfer_and_loadings">@lang('layout.TransferAndLoading')</option>
                                        <option value="sales">@lang('layout.Sale')</option>
                                    </select>
                                </div>
                            </div>
                        </div>

                         <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                            <div class="form-group">
                                <div class="col-md-12">
                                    <label class="control-label">@lang('layout.TypeNumber')</label>
                                    <input type="number" name="type_number" v-model="type_number" class="form-control">
                                </div>
                            </div>
                        </div>

                        <div class="col-lg-1 col-md-1 col-sm-2 col-xs-12">
                            <div class="form-group">
                                <div class="col-md-12">
                                    <label class="control-label">&nbsp;</label>
                                    <button type="button" class="btn btn-info form-control" @click="searchType">
                                    <i class="fa fa-search"></i>@lang('layout.Search')</button>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <label class="control-label">@lang('layout.Number')</label>
                                    <input type="text" name="number" value="{{$number}}" class="form-control">
                                </div>
                                <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                                    <label class="control-label">@lang('layout.Date')</label>
                                    <input type="text" name="date" class="form-control date" autocomplete="off">
                                </div>
                                <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                                    <label class="control-label">@lang('layout.Date')</label>
                                    <div class="input-group"> 
                                        @if(getHourType() == 24)
                                        <input type="text" class="form-control timepicker timepicker-24" name="hour">
                                        @else
                                        <input type="text" class="form-control timepicker timepicker-no-seconds" name="hour">
                                        @endif
                                        <span class="input-group-btn">
                                            <button class="btn default" type="button">
                                                <i class="fa fa-clock-o"></i>
                                            </button>
                                        </span>
                                    </div>
                                </div>
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <label class="control-label">@lang('layout.Description')</label>
                                    <textarea name="description" class="form-control"></textarea>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="form-group">
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <label class="control-label">@lang('layout.FullWeight')</label>
                                    <input type="number" name="full_weight" class="form-control" autocomplete="off">
                                </div>
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <label class="control-label">@lang('layout.EmptyWeight')</label>
                                    <input type="number" name="empty_weight" class="form-control" autocomplete="off">
                                </div>
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <label class="control-label">@lang('layout.NetWeight')</label>
                                    <input type="number" name="net_weight" class="form-control" autocomplete="off">
                                </div>
                            </div>
                        </div>

                        <div class="col-md-12">
                            <div class="form-group">
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <label class="control-label ">@lang('layout.SelectItem') </label>
                                    <v-select v-if='type' class="vue-select2" v-model="selected_item" label="name" :options="laboratory_item" @input="labSelectedMeasure()"></v-select>
                                    <v-select v-if='!type' class="vue-select2" v-model="selected_item" label="name" @search="onItemSearch" :options="laboratory_item" @input="labSelectedMeasure()"></v-select>
                                    <input type="hidden" name="item_id" :value="!selected_item?null:selected_item.item_id" >
                                    <input type="hidden" name="loading_detail_id" :value="!selected_item?null:(!selected_item.loadingDetail?null:selected_item.loadingDetail.id)" >
                                    <input type="hidden" name="type_detail_id" :value="!selected_item?null:selected_item.type_detail_id" >
                                </div>
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <label class="control-label ">@lang('layout.Unit') </label>
                                    <select name="um_id" class="form-control" v-model="selected_measure">
                                        <option value="null">@lang('layout.Select')</option>
                                        <span v-if="(selected_item ==null)?false:true">
                                            <option v-for="measure in measure" :value="measure.measure_id">
                                                @{{measure.measure_name}}
                                            </option>
                                        </span>
                                    </select>
                                </div>
                                <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                                    <label class="control-label">@lang('layout.CarNumber')</label>
                                    <input type="text" name="vehicle_number" v-model="vehicle" class="form-control" autocomplete="off">
                                </div>
                                <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                                    <label class="control-label">@lang('layout.DriverName')</label>
                                    <input type="text" name="driver_name" v-model="driver" class="form-control" autocomplete="off">
                                </div>
                            </div>
                        </div>
                        @if(count($weighbridgeCategori)>0)
                        <table id="table_content" class="table table-bordered" style="overflow-x: scroll;">
                            <thead style="background-color: #36c6d3; color:white"> 
                            <tr>
                                @foreach ($weighbridgeCategori as $key=>$value)
                                <th>{{$value->name}}</th>
                                @endforeach
                            </tr>
                            </thead>
                            <tbody>
                            <tr>
                                @foreach ($weighbridgeCategori as $key=>$value)
                                <td class="highlight">
                                    <input type="text" name="weight_category[{{$value->id}}]" class="form-control" autocomplete="off">
                                </td> 
                                @endforeach
    
                            </tr> 
                            </tbody>
                        </table>
                        @else
                        <a href="{{route('weighbridge.create')}}"
                            class="btn red">@lang('menu.LaboratoryTest')</a>
                        @endif
                        
                    </div>
                </div>
                <div class="col-md-4 col-md-offset-4 text-center">
                    <br>
                    <button type="button" @click="handleSubmit($event)" class="btn green" >@lang('layout.Submit')</button>
                    <a href="{{route('laboratoryTest.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                </div>
                {!! Form::close() !!}

            </div>

            <!-- END FORM-->
        </div>
    </div>

@endsection
@push('scripts')

<script src="{{URL::asset('assets/global/plugins/bootstrap-timepicker/js/bootstrap-timepicker.min.js')}}" type="text/javascript"></script>
<script src="{{URL::asset('assets/pages/scripts/components-date-time-pickers.min.js')}}" type="text/javascript"></script>

    <script type="text/javascript">
    var laboratory_measure = {!! $measureUnitList!!};

        @if(App::getLocale())
        Vue.use(VeeValidate, {
            locale: '{{App::getLocale()}}',
        });
        @else
        Vue.use(VeeValidate, {
            locale: 'en',
        });
        @endif


        let v = new Vue({
            el: '#app',
            data: {
                cloth_property:[
                        {property_name: null, description: null,type:null,property_order:null}
                    ],
                cloth_style:[
                        {style_name: null, style_description: null,style_order:null}
                    ],
                type_number:null,
                type:null,
                laboratory_item:[],
                selected_item:null,
                vehicle:null,
                driver:null,
                measure: laboratory_measure,
                selected_measure:null
            },
            methods: {
                // search items based on type,type_number
                searchType()
                {
                    if(this.type && this.type_number)
                    {
                        axios.get("{{route('laboratory.search')}}", {
                            params: {
                                type: this.type,
                                type_number: this.type_number,
                                part: 'weighbridge',
                            }
                        })
                        .then(function (response) {
                            v.laboratory_item = [];
                            v.selected_item=null;
                            // console.log(132, response.data);
                            if (response.data.length > 0) {
                                v.laboratory_item = response.data;
                            }
                        })
                        .catch(function (error) {
                            console.log(error);
                        })
                    }
                },

                labSelectedMeasure(){
                    if(v.selected_item!=null){
                        // console.log(132, v.selected_item);
                        if (v.selected_item.measure) {
                            v.selected_measure = v.selected_item.measure.measure_id;
                            v.measure = v.selected_item.measure_list;
                        } else if(v.selected_item.um_id) {
                            v.selected_measure = v.selected_item.um_id;
                        }
                        if (v.selected_item.loadingDetail) {
                            if (v.selected_item.loadingDetail.driver_type == "OwnDriver") {
                                v.vehicle = v.selected_item.loadingDetail.vehicle_name + " " + v.selected_item.loadingDetail.palet_number;
                                v.driver = v.selected_item.loadingDetail.name;
                            } else{
                                v.vehicle = v.selected_item.loadingDetail.other_vehicle_name;
                                v.driver = v.selected_item.loadingDetail.other_driver_name;
                            }
                        }
                    }
                },

                onItemSearch: _.debounce((search, loading) => {
                    // console.log(234, search);
                    loading(true);
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'itemesSearchSale',
                            keyword: search
                        }
                    })
                    .then(function(response) {
                            v.laboratory_item = [];
                            v.selected_item=null;
                        if (response.data.length > 0) {
                            v.laboratory_item = response.data;
                        }
                        loading(false);
                    })
                    .catch(function(error) {
                        console.log(error);
                    })
                }, getDebounceTime()),

                
                handleSubmit(e) {
                    this.$validator.validate().then(valid => {
                        if (valid) {
                            // alert(e.target);
                            regForm(e.target);
                        }
                    });
                },
                addNew(index) {
                    if (this.cloth_property[index + 1] == undefined) {
                        this.cloth_property.push({property_name: null, description: null,type:null,property_order:null});
                    }

                },

                deleteItem(index) {
                    this.cloth_property.splice(index, 1);
                }   

                

            }
        })
    </script>

@endpush
 