@extends('layouts.factor-master')

@section('content')

<h3 class="table-caption" style="text-align: center;">@lang('layout.WeighbridgeReport')</h3>

@if($from_date || $to_date)
<table class="main-table">
    <tr class="bg">
        @if($from_date)
            <td>
                <span>@lang('layout.FromDate')</span>:
                <BDO DIR="LTR">{{convertDate($from_date)}}</BDO>
            </td>
        @endif
        @if($to_date)
            <td>
                <span>@lang('layout.ToDate')</span>:
                <BDO DIR="LTR">{{convertDate($to_date)}}</BDO>
            </td>
        @endif
    </tr>
</table>
<br>
@endif

@if($report_type=="details")
@foreach($data AS $record)

<div class="row">
    <div class="col-md-6 col-sm-12">
        <div class="portlet green-meadow box" style=" border: 1px solid #2ae0bb;">
            <div class="portlet-title" style=" background-color: #1BBC9B">
                <div class="caption">
                  <table class="main-table">
                    <thead>
                        <tr class="active">
                            <th>@lang('layout.Number')</th>
                            <th>@lang('layout.CarNumber')</th>
                            <th>@lang('layout.DriverName')</th>
                            <th>@lang('layout.Date')</th>
                            <th>@lang('layout.Hour')</th>
                            <th>@lang('layout.Description')</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr class="active">
                            <td class="center">{{$record['number']}}</td>
                            <td class="center">{{$record['vehicle_number']}}</td>
                            <td class="center">{{$record['driver_name']}}</td>
                            <td class="center">{{convertDate($record['date'])}}</td>
                            @if(getHourType() == 24)
                            <td class="center">{{(($record['hour'] != null)?(date_format(date_create($record['hour']), 'H:i')):null)}}</td>
                            @else
                            <td class="center">{{(($record['hour'] != null)?(date_format(date_create($record['hour']), 'h:i a')):null)}}</td>
                            @endif


                            <td class="center">{{$record['description']}}</td>
                        </tr>
                    </tbody>
                </table>
                </div>
          
            </div>
  
            <div class="portlet-body">
                <div class="row static-info">
                    <div class="col-md-12 value">
                        <div >
                            <table class="main-table" >
                                <thead>
                                    <tr class="active">
                                        <th>@lang('layout.Item')</th>
                                        <th>@lang('layout.Unit')</th>
                                       <th>@lang('layout.FullWeight')</th>
                                       <th>@lang('layout.EmptyWeight')</th>
                                    </tr>
                                </thead> 
                                <tbody>
                                        <tr>
                                            <td class="center">{{$record['item_name']}}</td>
                                            <td class="center">{{$record['measure_name']}}</td>
                                            <td class="center">{{$record['full_weight']}}</td>
                                            <td class="center">{{$record['empty_weight']}}</td>
                                        </tr>
                                </tbody>
                            </table>
  
                        </div>

                        <h4 style="font-weight:bold;text-align:center;color:rgb(245, 123, 9)">@lang('layout.NetWeight') : {{$record['net_weight']}}</h4>
                    
                         
                    </div>
                </div>
            </div>
        </div>
    </div>
  </div>

<br>
@endforeach
@endif

@if($report_type!="details")

<table class="main-table">

 <tr class="bg">
  <td class="center">  @lang('layout.Record')  </td>
  <th>@lang('layout.Number')</th>
  <th>@lang('layout.CarNumber')</th>
  <th>@lang('layout.DriverName')</th>
  <th>@lang('layout.Item')</th>
  <th>@lang('layout.Unit')</th>
  <th>@lang('layout.FullWeight')</th>
  <th>@lang('layout.EmptyWeight')</th>
  <th>@lang('layout.NetWeight')</th>
  <th>@lang('layout.Date')</th>
  <th>@lang('layout.Hour')</th>
  <th>@lang('layout.Description')</th>
  

 </tr>
<?php 
$count = 0;
?>


@foreach($data AS $record)
<tr>
  <td class="center">{{++$count}}</td>
  <td class="center">{{$record['number']}}</td>
  <td class="center">{{$record['vehicle_number']}}</td>
  <td class="center">{{$record['driver_name']}}</td>
  <td class="center">{{$record['item_name']}}</td>
  <td class="center">{{$record['measure_name']}}</td>
  <td class="center">{{$record['full_weight']}}</td>
  <td class="center">{{$record['empty_weight']}}</td>
  <td class="center">{{$record['net_weight']}}</td>
  <td class="center">{{convertDate($record['date'])}}</td>

    @if(getHourType() == 24)
    <td>{{(($record['hour'] != null)?(date_format(date_create($record['hour']), 'H:i')):null)}}</td>
    @else
    <td>{{(($record['hour'] != null)?(date_format(date_create($record['hour']), 'h:i a')):null)}}</td>
    @endif
  <td class="center">{{$record['description']}}</td>
</tr>
@endforeach   

</table>

@endif


 <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->



@endsection