@extends('layouts.factor-master')

@section('content')

    <?php
    $report = customeReportNew('statement');
    
    $_date = !in_array('date', $report);
    $_transactionID = !in_array('transactionID', $report);
    $_account = !in_array('account', $report);
    $_type = !in_array('type', $report);
    $_receivable = !in_array('receivable', $report);
    $_payable = !in_array('payable', $report);
    $_currency = !in_array('currency', $report);
    $_rate = !in_array('rate', $report);
    $_receivable_home_currency = !in_array('receivable_home_currency', $report);
    $_payable_home_currency = !in_array('payable_home_currency', $report);
    $_description = !in_array('description', $report);
    $_item = !in_array('item', $report);
    $_name = !in_array('name', $report);
    $_quantity = !in_array('quantity', $report);
    $_measure = !in_array('measure', $report);
    $_price = !in_array('price', $report);
    $_total = !in_array('total', $report);
    $_number = !in_array('number', $report);
    $_receivable_total = !in_array('receivable_total', $report);
    $_payable_total = !in_array('payable_total', $report);
    $_details = !in_array('details', $report);
    $_balance = !in_array('balance', $report);
    $_area = !in_array('area', $report);
    $_member_class = !in_array('member_class', $report);
    $_total_item = !in_array('total_item', $report);
    $_report_total = !in_array('report_total', $report);
    $_hesab_sabiqa = !in_array('hesab_sabiqa', $report);
    $_customer_summary = !in_array('customer_summary', $report);
    $_total_home_currency = !in_array('total_home_currency', $report);
    $_customer_code = !in_array('customer_code', $report);
    $_customer_email = !in_array('customer_email', $report);
    $_customer_phone = !in_array('customer_phone', $report);
    $_customer_job = !in_array('customer_job', $report);
    $_measure1 = !in_array('measure1', $report);
    $_measure2 = !in_array('measure2', $report);

    $_transferCode = !in_array('transferCode', $report);
    $_driver = !in_array('driver', $report);
    $_plateNumber = !in_array('plateNumber', $report);
    $_expense = !in_array('expense', $report);
    $_remain = !in_array('remain', $report);

    ?>

    <?php
    if($member){
    ?>
    <h4>
    </h4>
    <table class="main-table">
        <tr class="center">
            <td>@lang('layout.Name') : {{$member[0]->name}}</td>
            <td>@lang('layout.Code') : {{$member[0]->code}}</td>
            <td>@lang('layout.JobTitle') : {{$member[0]->job_name}}</td>
            <td>@lang('layout.Email') : {{$member[0]->email}}</td>
            <td>@lang('layout.Phone') : {{$member[0]->phone}}, {{$member[0]->phone2}}</td>

        </tr>
    </table>
    <?php
    }
    ?>
    <br>
    <?php
    $count = 0;
    $currency_data = [];
    $total_payable = 0;
    $total_receivable = 0;
    $balance = 0;
    $statement_flag = '';
    $statement_flag_change = '';

    ?>
    @if(count($memberRecord))
        <h3 class="table-caption" style="text-align: center;">@lang('layout.StatementDetails')</h3>

            @if($from_date || $to_date)
            <div class="col-md-6">
                <div class="portlet sale-summary">
                    <div class="portlet-title">
                        <div class="caption font-red sbold" style="font-size: 20px"> @lang('layout.HesabSabiqa') </div>
                        <div class="tools">
                            <a class="reload" href="javascript:;"> </a>
                        </div>
                    </div>
                    <div class="portlet-body">
                        <div class="table-scrollable">
                            <table class="main-table border-blue-soft">
                                <thead>
                                <tr style="background-color: #2AB4C0">
                                    <th>
                                        <i class="fa fa-briefcase"></i> @lang('layout.Currency')
                                    </th>
                                    <th class="hidden-xs">
                                        <i class="fa fa-user"></i> @lang('layout.SReceivable')</th>
                                    <th>
                                        <i class="fa fa-briefcase"></i> @lang('layout.SPayable') </th>

                                </tr>
                                </thead>
                                <tbody>

                                @foreach(getStatementDate($member[0]->id,$from_date) AS $rec)
                                    <tr>
                                        <td class="highlight">
                                        <?php if($sum_previous_balance){ 
                                            $balance = $rec['balance']; 
                                            if ($balance > 0) {
                                                $statement_flag = 'receivable';
                                                $statement_flag_change = 'payable';
                                            } else {
                                                $statement_flag = 'payable';
                                                $statement_flag_change = 'receivable';
                                            }
                                        } ?>
                                            {{$rec['currency']}}
                                        </td>
                                        <td class=""> {{ myRound($rec['invoice']) }}</td>
                                        <td> {{ myRound($rec['payment']) }}</td>

                                    </tr>
                                @endforeach
                                </tbody>
                            </table>
                        </div>

                    </div>
                </div>
            </div>

    @endif
    <br>


        <table class="main-table">
            <thead>
            <tr class="bg">
                <td  class="center" >
                    <div > @lang('layout.Record') </div>
                </td>
                @if($_transactionID)
                    <td  class="center" >
                        <div > @lang('layout.TransactionID') </div>
                    </td>
                @endif
                @if($_date)
                    <td  class="center" >
                        <div > @lang('layout.Date') </div>
                    </td>
					@endif
					
					<td  class="center" >
                        <div > @lang('layout.Account') </div>
                    </td>

                @if($_description)
                    <td  class="center"  >
                        <div > @lang('layout.Description') </div>
                    </td>@endif

                @if($_type)
                    <td  class="center" >
                        <div > @lang('layout.Type') </div>
                    </td>@endif
                @if($_receivable)
                    <td  class="center" >
                        <div > @lang('layout.Bordgi')</div>        
 
                    </td>@endif   
                @if($_payable)
                    <td  class="center" >
                        <div > @lang('layout.RasidGi')</div>
                    </td>@endif
                @if($_currency)
                    <td  class="center" >
                        <div > @lang('layout.Currency') </div>
                    </td>@endif
                @if($_rate)
                    <td  class="center" >
                        <div > @lang('layout.Rate') </div>
                    </td>@endif
                @if($_receivable_home_currency)
                    <td  class="center" >
                        <div > @lang('layout.Bordgi') {{getHomeCurrency()[getCurrencyType()]}}</div>
                    </td>@endif
                @if($_payable_home_currency)
                    <td  class="center" >
                        <div > @lang('layout.RasidGi') {{getHomeCurrency()[getCurrencyType()]}}</div>
                    </td>@endif
                @if($_balance)
                    <td  class="center" >
                        <div >@lang('layout.AlBagi')</div>
                    </td>@endif
              
            </tr>
            </thead>

            @foreach($memberRecord AS $record)
                <?php
                    if ($report_type) {
                        $p = 0;
                        $r = 0;
                        $tpp=0;
                        $trr=0;

                        $r = ($record->type == 'r' OR $record->type == "rr") ? $record->Amount : 0;
                        $p = ($record->type == 'p' OR $record->type == 'pp') ? $record->Amount : 0;

                        $totalg = SumToNumber($p, $r);
                        $tpp = $totalg['a'];
                        $trr = $totalg['b'];

                        if ($report_type == 'Receivable' && $tpp > 0) {
                        } elseif ($report_type == 'Payable' && $trr > 0) {
                        } else {
                            continue;
                        }
                    }
                ?>
                <tr @if($record->checkout == 'yes') style="background-color: #c6ffa8" @endif >
                    <td class="center">{{++$count}}</td>
                    @if($_transactionID)
                        <td class="center" style="width:50px;">{{$record->transaction_id}}</td>
                    @endif
                    @if($_date)
                        <td class="center">{{convertDate($record->Date)}} @if($record->hour) <br/> {!! date_format(date_create($record->hour), 'h:i a') !!} @endif</td>@endif
                        <td class="center">{{$record->Account}}</td>

                     @if($_description)
                        <td > 
                            <?php 
                            $des = wordwrap($record->Description,40,"<br/>\n",false);
                            echo $des;
                            ?>
                            
                            
                        </td>@endif

                    @if($_type)
                        <td class="center"><span>{{__('type.'.$record->Type)}}</span>:
                            {{$record->number}}</td>@endif
                    <?php
                    $p = 0;
                    $r = 0;
                    $r = ($record->type == 'r' OR $record->type == "rr") ? $record->Amount : 0;

                    $p = ($record->type == 'p' OR $record->type == 'pp') ? $record->Amount : 0;

                    $totalg = SumToNumber($p, $r);
                    $tpp = $totalg['a'];
                    $trr = $totalg['b'];
                    if (array_key_exists($record->Currency, $currency_data)) {

                        if(systemConfig()[30] == 1){
                        $total_payable += $tpp / $record->static_rate * $record->Rate;
                        }else{
                            $total_payable += $tpp / $record->Rate;
                        }

                        if(systemConfig()[30] == 1){
                        $total_receivable += $trr / $record->static_rate * $record->Rate;
                        }else{
                            $total_receivable += $trr / $record->Rate;
                        }

                        $p_p = $currency_data[$record->Currency]['p'];
                        $p_r = $currency_data[$record->Currency]['r'];

                        $b_p_p = $currency_data[$record->Currency]['BP'];
                        $b_p_r = $currency_data[$record->Currency]['BR'];

                        if(systemConfig()[30] == 1){
                        $currency_data[$record->Currency] = [
                            'p' => $tpp + $p_p,
                            'r' => $trr + $p_r,
                            'BP' => $b_p_p + ($tpp / $record->static_rate * $record->Rate),
                            'BR' => $b_p_r + ($trr / $record->static_rate * $record->Rate),
                        ];
                    }else{
                            $currency_data[$record->Currency] = [
                                'p' => $tpp + $p_p,
                                'r' => $trr + $p_r,
                                'BP' => $b_p_p + ($tpp / $record->Rate),
                                'BR' => $b_p_r + ($trr / $record->Rate),
                            ];
                        } 
                    } else {
                        if(systemConfig()[30] == 1){
                            $total_payable += $tpp / $record->static_rate * $record->Rate;
                        }else{
                            $total_payable += $tpp / $record->Rate;
                        }

                        if(systemConfig()[30] == 1){
                        $total_receivable += $trr / $record->static_rate * $record->Rate;
                        }else{
                            $total_receivable += $trr / $record->Rate;
                        }

                        if(systemConfig()[30] == 1){
                        $currency_data[$record->Currency] = [
                            'p' => $tpp,
                            'r' => $trr,
                            'BP' => $tpp / $record->static_rate * $record->Rate,
                            'BR' => $trr / $record->static_rate * $record->Rate,
                        ];
                    }else{
                            $currency_data[$record->Currency] = [
                                'p' => $tpp,
                                'r' => $trr,
                                'BP' => $tpp / $record->Rate,
                                'BR' => $trr / $record->Rate,
                            ];
                        }


                    }


                    // begin check for balance
                    if ($statement_flag == '') {
                        if ($tpp) {
                            $statement_flag = 'payable';
                            $statement_flag_change = 'receivable';
                            if(systemConfig()[30] == 1){
                                $balance += $tpp / $record->static_rate * $record->Rate;
                            }else{
                                $balance += $tpp / $record->Rate;
                            }
                        } else {
                            $statement_flag = 'receivable';
                            $statement_flag_change = 'payable';
                            if(systemConfig()[30] == 1){
                                $balance += $trr / $record->static_rate * $record->Rate;
                            }else{
                                $balance += $trr / $record->Rate;
                            }
                        }
                    } else {
                        if ($trr) {
                            if(systemConfig()[30] == 1){
                            ($statement_flag == 'receivable') ? $balance += $trr / $record->static_rate * $record->Rate : $balance -= $trr / $record->static_rate * $record->Rate;
                        }else{
                                ($statement_flag == 'receivable') ? $balance += $trr / $record->Rate : $balance -= $trr / $record->Rate;
                            }

                        } else {
                            if(systemConfig()[30] == 1){
                            ($statement_flag == 'payable') ? $balance += $tpp /  $record->static_rate * $record->Rate : $balance -= $tpp /  $record->static_rate * $record->Rate;
                        }else{
                                ($statement_flag == 'payable') ? $balance += $tpp / $record->Rate : $balance -= $tpp / $record->Rate;
                            }

                        }
                    }
                    // end check balance
                    ?>
                    @if($_receivable)
                        <td class="center ltr" @if($trr) style="background-color: #fbc0c0;" @endif >
                            <BDO DIR="LTR">
                                    {{($trr)?myRound($trr):''}}
                            </BDO>
                        </td>
                    @endif
                    @if($_payable)
                        <td class="center ltr" >
                            <BDO DIR="LTR">
                                    {{($tpp)?myRound($tpp):''}}
                            </BDO>
                        </td>
                    @endif
                    @if($_currency)
                        <td class="center" >{{$record->Currency}}</td>@endif
                    @if($_rate)
                        <td class="center" >{{myRound($record->Rate)}}</td>@endif


                    @if($_receivable_home_currency)
                        <td class="center ltr" >
                            @if(systemConfig()[30] == 1)
                            {{($trr)?myRound($trr/$record->static_rate * $record->Rate):''}}
                            @else 
                            {{($trr)?myRound($trr/$record->Rate):''}}
                            @endif

                        </td>@endif
                    @if($_payable_home_currency)
                        <td class="center ltr">
                            @if(systemConfig()[30] == 1)
                            {{($tpp)?myRound($tpp/$record->static_rate * $record->Rate):''}}
                            @else 
                            {{($tpp)?myRound($tpp/$record->Rate):''}}
                            @endif

                        </td>@endif
                    @if($_balance)
                        <td class="center ltr">
                            @if($balance>0)
                                {{myRound(abs($balance))}}
                                {{getHomeCurrency()[getCurrencyType()]}}
                                :{{__('layout.'.ucfirst($statement_flag))}}
                            @else
                                {{myRound(abs($balance))}}
                                {{getHomeCurrency()[getCurrencyType()]}}
                                :{{__('layout.'.ucfirst($statement_flag_change))}}
                            @endif

                        </td>
                    @endif
                   
                </tr>
            @endforeach

        </table>
        <br>
    @endif

    @if(count($items))
        <?php
        $measure_total = [];
        ?>
        <table class="main-table">


            <tr class="bg">
                <td>
                    <div class="center"> @lang('layout.Record') </div>
                </td>
                @if($_transactionID)
                    <td>
                        <div class="center"> @lang('layout.TransactionID') </div>
                    </td>
                @endif
                @if($_date)
                    <td>
                        <div class="center"> @lang('layout.Date') </div>
                    </td>@endif
                @if($_type)
                    <td>
                        <div class="center"> @lang('layout.Type') </div>
                    </td>@endif
                @if($_receivable)
                    <td>
                        <div class="center"> @lang('layout.SReceivable')  </div>
                    </td>@endif
                @if($_payable)
                    <td>
                        <div class="center"> @lang('layout.SPayable') </div>
                    </td>@endif
                @if($_currency)
                    <td>
                        <div class="center"> @lang('layout.Currency') </div>
                    </td>@endif
                @if($_rate)
                    <td>
                        <div class="center"> @lang('layout.Rate') </div>
                    </td>@endif
                @if($_receivable_home_currency)
                    <td>
                        <div class="center"> @lang('layout.SReceivable') {{getHomeCurrency()[getCurrencyType()]}} </div>
                    </td>@endif
                @if($_payable_home_currency)
                    <td>
                        <div class="center"> @lang('layout.SPayable') {{getHomeCurrency()[getCurrencyType()]}} </div>
                    </td>@endif
                @if($_description)
                    <td style="display: <?=(!show('description', $report)) ? 'none' : '';?>">
                        <div class="center"> @lang('layout.Description') </div>
                    </td>@endif
                @if($_item)
                    <td>
                        <div class="center"> @lang('layout.Item') </div>
                    </td>@endif
                @if($_item)
                    <td>
                        <div class="center"> @lang('layout.Quantity') </div>
                    </td>@endif
                @if($_item)
                    <td>
                        <div class="center"> @lang('layout.Measure') </div>
                    </td>@endif
                @if($_item)
                    <td>
                        <div class="center"> @lang('layout.Price') </div>
                    </td>@endif
                @if($_item)
                    <td>
                        <div class="center"> @lang('layout.Total') </div>
                    </td>@endif
            </tr>
            @foreach($items AS $item)
                <?php
                $p = 0;
                $r = 0;
                $r = ($item['type'] == 'r' OR $item['type'] == "rr") ? $item['Amount'] : 0;

                $p = ($item['type'] == 'p' OR $item['type'] == 'pp') ? $item['Amount'] : 0;

                $totalg = SumToNumber($p, $r);
                $tpp = $totalg['a'];
                $trr = $totalg['b'];
                if (array_key_exists($item['Currency'], $currency_data)) {
                    $total_payable += $tpp / $item['Rate'];
                    $total_receivable += $trr / $item['Rate'];

                    $p_p = $currency_data[$item['Currency']]['p'];
                    $p_r = $currency_data[$item['Currency']]['r'];

                    $b_p_p = $currency_data[$item['Currency']]['BP'];
                    $b_p_r = $currency_data[$item['Currency']]['BR'];

                    $currency_data[$item['Currency']] = [
                        'p' => $tpp + $p_p,
                        'r' => $trr + $p_r,
                        'BP' => $b_p_p + ($tpp / $item['Rate']),
                        'BR' => $b_p_r + ($trr / $item['Rate']),
                    ];
                } else {
                    $total_payable += $tpp / $item['Rate'];
                    $total_receivable += $trr / $item['Rate'];
                    $currency_data[$item['Currency']] = [
                        'p' => $tpp,
                        'r' => $trr,
                        'BP' => $tpp / $item['Rate'],
                        'BR' => $trr / $item['Rate'],
                    ];
                }
                ?>




                @if($item['items'])
                    @foreach($item['items'] AS $detail)

                        <?php
                        if (array_key_exists($detail['Measure'], $measure_total)) {
                            $p_q = $measure_total[$detail['Measure']]['qty'];
                            $p_t = $measure_total[$detail['Measure']]['total'];

                            $measure_total[$detail['Measure']]['qty'] = $p_q + $detail['Qty'];
                            $measure_total[$detail['Measure']]['total'] = $p_t + $detail['Cost'] * $detail['Qty'];
                        } else {
                            $measure_total[$detail['Measure']] = [
                                'qty' => $detail['Qty'],
                                'total' => $detail['Cost'] * $detail['Qty'],
                            ];
                        }
                        ?>


                        <tr @if($item['checkout'] == 'yes') style="background-color: #c6ffa8" @endif >
                            <td>
                                <div class="center">{{++$count}}</div>
                            </td>
                            @if($_transactionID)
                                <td class="center" style="width:50px;">{{$item['transaction_id']}}</td>
                            @endif
                            @if($_date)
                                <td class="center">{{convertDate($item['Date'])}}</td>@endif
                            @if($_type)
                                <td>
                                    <div class="center">
                                        <span>{{__('type.'.$item['Type'])}}</span><span>:</span><span>{{$item['number']}}</span>
                                    </div>
                                </td>@endif


                            @if($_receivable)
                                <td class="center ltr">
                                    <BDO DIR="LTR">
                                        @if(getHomeCurrency()[getCurrencyType()] !=$item['Currency'])
                                            {{($trr)?myRound($trr):''}}
                                        @endif
                                    </BDO>
                                </td>@endif

                            @if($_payable)
                                <td class="center ltr" >
                                    <BDO DIR="LTR">
                                        @if(getHomeCurrency()[getCurrencyType()] !=$item['Currency'])
                                            {{($tpp)?myRound($tpp):''}}
                                        @endif
                                    </BDO>
                                </td>@endif

                            @if($_currency)
                                <td class="center" >{{$item['Currency']}}</td>@endif
                            @if($_rate)
                                <td class="center" >{{myRound($item['Rate'])}}</td>@endif
                            @if($_receivable_home_currency)
                                <td class="center">
                                    @if(systemConfig()[30] == 1)
                                    {{($trr)?myRound($trr/$item['static_rate'] * $item['Rate']):''}}
                                    @else
                                    {{($trr)?myRound($trr/$item['Rate']):''}}
                                    @endif  
                                </td>@endif
                            @if($_payable_home_currency) 
                                <td class="center">
                                    @if(systemConfig()[30] == 1)
                                    {{($tpp)?myRound($tpp/$item['static_rate'] * $item['Rate']):''}}
                                    @else 
                                    {{($tpp)?myRound($tpp/$item['Rate']):''}}
                                    @endif  
                                </td>@endif
                            @if($_description)
                                <td class="center">
                                    <?php 
                                        $des = wordwrap($item['description'],40,"<br/>\n",false);
                                        echo $des;
                                    ?>
                                </td>@endif
                            @if($_item)
                                <td>{{$detail['ItemName']}}</td>@endif
                            @if($_item)
                                <td>{{$detail['Qty']}}</td>@endif
                            @if($_item)
                                <td>{{$detail['Measure']}}</td>@endif
                            @if($_item)
                                <td>{{myRound($detail['Cost'])}}</td>@endif
                            @if($_item)
                                <td>{{myRound(($detail['Cost']*$detail['Qty']))}} {{$item['Currency']}}</td>@endif

                        <tr>
                    @endforeach
                @endif





            @endforeach
        </table>
        @if(count($measure_total))
            <table>
                <tr>
                    <td>
                        <div class="center"> @lang('layout.Record') </div>
                    </td>
                    <td>
                        <div class="center"> @lang('layout.Measure')</div>
                    </td>
                    <td>
                        <div class="center"> @lang('layout.Quantity')</div>
                    </td>
                    <td>
                        <div class="center"> @lang('layout.Cost')</div>
                    </td>
                </tr>
                @foreach($measure_total AS $k=>$v)
                    <tr>
                        <td>
                            <div class="center"> @lang('layout.Record') </div>
                        </td>
                        <td>
                            <div class="center"> {{$k}}</div>
                        </td>
                        <td>
                            <div class="center"> {{$v['qty']}}</div>
                        </td>
                        <td>
                            <div class="center"> {{$v['total']}}</div>
                        </td>
                    </tr>
                @endforeach

            </table>
        @endif
        <br>

    @endif

    <!-- begin sammary -->
    @if(count($currency_data))
        <table class="main-table">

            <tr class="bg">
                @if($_receivable_total)
                    <td>
                        <div class="center"> @lang('layout.BordgiTotal') </div>
                    </td>@endif
                @if($_payable_total)
                    <td>
                        <div class="center"> @lang('layout.RasidGiTotal') </div>
                    </td>@endif
                @if($_details)
                    <td>
                        <div class="center"> @lang('layout.Details') </div>
                    </td>@endif
            </tr>

            <tr>

                <?php
                $t_payable = 0;
                $t_receivable = 0;
                $a = SumToNumber($total_payable, $total_receivable);
                $t_payable = $a['a'];
                $t_receivable = $a['b'];
                ?>
                @if($_receivable_total)
                    <td class="center ltr">{{myRound($t_receivable)}} {{getHomeCurrency()[getCurrencyType()]}}</td>@endif
                @if($_payable_total)
                    <td class="center ltr">{{myRound($t_payable)}} {{getHomeCurrency()[getCurrencyType()]}}</td>@endif

                @if($_details)
                    <td width="60%">

                        <table class="main-table" style="width:100%">
                            <tr class="bg">
                                <td width="20%">
                                    <div class="center"> @lang('layout.Currency') </div>
                                </td>
                                <td width="20%">
                                    <div class="center ltr"> @lang('layout.Bordgi') </div>
                                </td>
                                <td width="20%">
                                    <div class="center ltr"> @lang('layout.RasidGi') </div>
                                </td>
                                <td width="20%">
                                    <div class="center ltr"> @lang('layout.AlBagi') </div>   
                                </td>
                                @if ($report_type)
                                <td width="10%">
                                    <div class="center ltr"> @lang('layout.Balance') {{getHomeCurrency()[getCurrencyType()]}} </div>
                                </td>
                                <td width="10%">
                                    <div class="center ltr"> @lang('layout.Rate')  </div>
                                </td>
                                @endif
                            </tr>
                            <?php
                            $count = 0;
                            $tempName = '';
                            ?>
                            @foreach($currency_data AS $k=>$v)

                                <?php
                                $rowSpan = -1;
                                if ($tempName == $k) {
                                    $rowSpan++;
                                }
                                $tempName = $k;
                                ?>

                                <tr>
                                    
                                    <?php
                                        $bt_payable = 0;
                                        $bt_receivable = 0;
                                        $a = SumToNumber($v['p'], $v['r']);
                                        $bt_payable = $a['a'];
                                        $bt_receivable = $a['b'];

                                        $base_payable = 0;
                                        $base_receivable = 0;
                                        $b = SumToNumber($v['BP'], $v['BR']);
                                        $base_payable = $b['a'];
                                        $base_receivable = $b['b'];

                                    ?>

                                    <td class="center ltr" ><BDO DIR="LTR">{{$k}}</BDO></td>
                                    <td class="center ltr" ><BDO DIR="LTR">{{myRound($v['r'])}}</BDO></td>
                                    <td class="center ltr" ><BDO DIR="LTR">{{myRound($v['p'])}}</BDO></td>
                                    @if($bt_receivable !=0)
                                    <td class="center ltr" @if($bt_receivable) style="background-color: #fbc0c0;" @endif  >
                                        <BDO DIR="LTR">
                                            {{myRound($bt_receivable)}} {{$k}}
                                        </BDO>
                                        <span>&nbsp;@lang('layout.Receivable')&nbsp;</span>
                                    </td>
                                    @if ($report_type)
                                    <td class="center ltr" @if($bt_receivable) style="background-color: #fbc0c0;" @endif  >
                                        <BDO DIR="LTR">
                                            {{myRound($base_receivable)}}
                                        </BDO>
                                    </td>
                                    <td class="center ltr" @if($bt_receivable) style="background-color: #fbc0c0;" @endif  >
                                        <BDO DIR="LTR">
                                            {{myRound($bt_receivable / $base_receivable)}}
                                        </BDO>
                                    </td>
                                    @endif
                                    @else
                                    <td class="center ltr" >
                                        <BDO DIR="LTR">
                                            {{myRound($bt_payable)}} {{$k}}

                                        </BDO>
                                        <span>&nbsp;@lang('layout.Payable')&nbsp;</span>
                                    </td>
                                    @if ($report_type)
                                    <td class="center ltr" >
                                        <BDO DIR="LTR">
                                            {{myRound($base_payable)}}
                                        </BDO>
                                    </td>
                                    <td class="center ltr" >
                                        <BDO DIR="LTR">
                                            {{myRound($bt_payable / $base_payable)}}
                                        </BDO>
                                    </td>
                                    @endif
                                    @endif
                                </tr>
                            @endforeach
                        </table>

                    </td>
                @endif
            </tr>
        </table>
    @endif
    <!-- end sammary -->


    <br>
    @if($from_date || $to_date)
        <div class="col-md-6">
            <div class="portlet sale-summary">
                <div class="portlet-title">
                    <div class="caption font-red sbold" style="font-size: 20px"> @lang('layout.CustomerSummary') </div>
                    <div class="tools">
                        <a class="reload" href="javascript:;"> </a>
                    </div>
                </div>
                <div class="portlet-body">
                    <div class="table-scrollable">
                        <table class="main-table border-blue-soft">
                            <thead>
                            <tr style="background-color: #2AB4C0">
                                <th>
                                    <i class="fa fa-briefcase"></i> @lang('layout.Currency')
                                </th>
                                <th class="hidden-xs">
                                    <i class="fa fa-user"></i> @lang('layout.SReceivable')</th>
                                <th>
                                    <i class="fa fa-briefcase"></i> @lang('layout.SPayable') </th>

                            </tr>
                            </thead>
                            <tbody>
                            @foreach(getStatement($member[0]->id) AS $rec)
                                <tr>
                                    <td class="highlight">
                                        {{$rec['currency']}}
                                    </td>
                                    <td class=""> {{ myRound($rec['invoice']) }}</td>
                                    <td> {{ myRound($rec['payment']) }}</td>

                                </tr>
                            @endforeach
                            </tbody>
                        </table>
                    </div>

                </div>
            </div>
        </div>

    @endif    



           <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->

@endsection