@extends('layouts.app')
@section('style')
    {{-- <link rel="stylesheet" type="text/css" href="{{URL::asset('sass/pages/profile-2.scss')}}"> --}}
    <style type="text/css">
        .padding {
            padding: 0px;
        }
    </style>

@stop
@section('content')
    @include('customers.modal')

    <div id="print-modal">
        <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute"
                      v-if="is_show"
                      :value-type="''"
                      @closed="closeModal">
            <div slot="body">
                <input type="hidden" name="member_id" value="{{$vendor->member_id}}"/>
                <input type="hidden" name="type" :value="type"/>
                <div class="row">
                    <div class="form-group">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="control-label"> @lang('layout.Date')</label>
                                <div class="input-group">
                                    <input class="form-control date" id="range-from-example" name="from_date"
                                           autocomplete="off"> 
                                    <span class="input-group-addon"> @lang('layout.To') </span>
                                    <input class="form-control date" id="range-to-example" name="to_date"
                                           autocomplete="off">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </report-modal>
    </div>

    <div id="print-modal-purch">
        <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute"
                      v-if="is_show"
                      :value-type="''"
                      @closed="closeModal">
            <div slot="body">
                <input type="hidden" name="member_id" value="{{$vendor->member_id}}"/>
                <input type="hidden" name="type" :value="type"/>
                <div class="row">
                    <div class="col-md-12" style="padding-right: 0px !important; padding-left: 0px !important;" >
                        <div class="col-md-6">
                            <label class="control-label ">@lang('layout.SelectItem') </label>
                            <v-select class="vue-select2" v-model="selectedItem1" label="name" @search="onItemSearch" :options="itemlist" >
                            </v-select>
                            <input type="hidden" name="item_id" v-model.number="(!selectedItem1)?null:selectedItem1.id" >
                        </div>
                    </div>

                    <div class="form-group">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="control-label"> @lang('layout.Date')</label>
                                <div class="input-group">
                                    <input class="form-control date" id="range-from-example" name="from_date"
                                           autocomplete="off"> 
                                    <span class="input-group-addon"> @lang('layout.To') </span>
                                    <input class="form-control date" id="range-to-example" name="to_date"
                                           autocomplete="off">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </report-modal>
    </div>


    <div id="print-modal_statement">
        <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute"
                      v-if="is_show"
                      :value-type="'vendorStatement'"
                      @closed="closeModal">

            <div slot="body">
                <input type="hidden" name="type" value="vendorStatement"/>
                <input type="hidden" name="type_name" value="Vendor"/>
                <input type="hidden" name="member_id" value="{{$vendor->member_id}}"/>
                <div class="row">
                    <div class="form-group">

                        <div class="col-md-2">
                            <label>@lang('layout.HomeCurency')</label>
                            <input class="mt-checkbox" type="checkbox" name="home_currency" checked="">
                        </div>
                        <div class="col-md-3">
                            <label>@lang('layout.SumPreviousBalance')</label>
                            <input class="mt-checkbox" type="checkbox" name="sum_previous_balance" >
                        </div>  
                        <div class="col-md-3">
                            <label>@lang('layout.Driver')</label>
                            <input class="mt-checkbox" type="checkbox" name="driver" >
                        </div>
                        <div class="col-md-2">
                            <label>@lang('layout.PurchaseOrder')</label>
                            <input class="mt-checkbox" type="checkbox" name="show_purchase_order" >
                        </div>
                        <div class="col-md-2">
                            <label>@lang('layout.FixedAsset')</label>
                            <input class="mt-checkbox" type="checkbox" name="show_fixed_asset" >
                        </div>
                        <div class="col-md-12">
                            <label class="control-label ">@lang('layout.Currency') </label>
                            <select name="currency" class="form-control">
                                <option value="">@lang('layout.Select')</option>
                                @foreach(currencyList() AS $currency)
                                    <option value="{{$currency->code}}">{{$currency->code}}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-md-12">
                            <label class="control-label ">@lang('layout.SelectType') </label>
                            <select name="category" class="form-control">
                                <option selected="selected" value="">@lang('layout.WithoutItem')</option>
                                @if(systemConfig()[23] == 1)
                                <option value="item">@lang('layout.WithItem')</option>
                                <option value="afghan">@lang('layout.Satement1')</option>
                                <option value="satement_item">@lang('layout.Satement2') @lang('layout.WithItem')</option>
                                @endif
                            </select>
                        </div>

                        <div class="col-md-12">
                            <label class="control-label ">@lang('layout.ReportType') </label>
                            <select name="report_type" id="" class="form-control">
                                <option value="">@lang('layout.SelectReportType')</option>
                                <option value="Receivable">@lang('layout.Payable')</option>
                                <option value="Payable">@lang('layout.Receivable')</option>
                            </select>  
                        </div>

                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="control-label"> @lang('layout.Date')</label>
                                <div class="input-group">
                                    <input class="form-control date" id="range-from-example" name="from_date"
                                           autocomplete="off">

                                    <span class="input-group-addon"> @lang('layout.To') </span>
                                    <input class="form-control date" id="range-to-example" name="to_date"
                                           autocomplete="off"> 
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </report-modal>
    </div>

    <div class="portlet">
        <div class="portlet-title" id="backbtn">
            <div class="caption">
                <i class=""></i>@lang('layout.ShowVendor')
            </div>
            <div class="tools">
                <a href="javascript:;" class="collapse" data-original-title="" title=""> </a>
                <a href="#portlet-config" data-toggle="modal" class="config" data-original-title="" title=""> </a>
            </div>
        </div>
        <div class="portlet-body">
            <div class="tabbable-line tabbable-full-width">
                <ul class="nav nav-tabs">
                    <li class="active">
                        <a href="#tab_1_1" data-toggle="tab"> @lang('layout.Overview') </a>
                    </li>
                    <li>
                        <a href="#tab_1_3" data-toggle="tab"> @lang('layout.Info') </a>
                    </li>
                    <div class="btn-group pull-right ">
                        <span id="app" v-cloak>
                                
                            <button class="btn btn-success" v-if="!checkStatus" onclick="location.href='{{route('memberOpeningBalance.create',$vendor->id)}}'">@lang('layout.OpeningBalance')</button>
                            <button v-if="!checkStatus" type=button  class="btn btn-success" v-on:click="checkoutModal = true">@lang('layout.Checkout')</button>

                            <!-- use the modal component, pass in the prop -->
                            <modal v-if="checkoutModal" @close="checkoutModal = false">
                                <h3 slot="header">@lang('layout.Checkout')</h3>
                                <div slot="body">
                                <div class="row">
                                    <div class="form-group">
                                    {{Form::open(['route'=>['customer.checkout',$vendor->id],'method'=>'post','class'=> 'form-horizontal','id'=>'customer-checkout'])}}
                                        <div class="col-md-12"> 
                                            <div class="form-group">
                                                <label class="control-label ">@lang('layout.TransactionID')</label>
                                                <input type="number" name="transaction_id" class="form-control" >
                                                <input type="hidden" name="form_type" v-model="form_type" >
                                            </div>
                                        </div>
                                        {{Form::close()}}
                                    </div>
                                </div>
                                </div>
                                <div slot="footer">
                                <button type=button class="btn btn-success" v-on:click="checkoutSubmit('add')">
                                    @lang('layout.OK')
                                </button>
                                <button type=button class="btn btn-danger" v-on:click="checkoutSubmit('delete')">
                                    @lang('layout.Delete')
                                </button>
                                <button type=button class="btn btn-danger" v-on:click="checkoutModal = false">
                                @lang('layout.Cancel')
                                </button>
                            </div>
                            </modal>

                        </span>


                    </div>
                </ul>
                <div class="tab-content">
                    <div class="tab-pane active" id="tab_1_1">
                        <div class="row">
                            <div class="col-lg-12 col-md-12 col-sm-12" style="border-radius: 8px; padding: 0px 0px 0px 0px;">
                                <div style="display: flex;justify-content: space-around;flex-wrap: wrap;">
                                    <div class="col-lg-6 col-md-12 col-sm-12 col-xs-12" style="box-shadow: 0px 0px 3px rgba(172, 171, 171, 0.877);border-radius: 8px;margin-left: 10px !important; padding: 10px;margin-bottom: 10px;">
                                        <div style="display: flex;align-items: center;">
                                            <div title="{{$vendor->name}}" class="twPc-avatarLink" style="margin-left: 10px;">
                                                @if($vendor->photo ==Null)
                                                    <img class="twPc-avatarImg" src="{{asset('uploads/avatar.png')}}"  style="width:150px; height:150px;border-radius: 50%;border: 5px solid rgb(80, 129, 141);">
                                                @else
                                                    <img class=" twPc-avatarImg" src="{!!url('/uploads/'.$vendor->photo)!!}" style="width:150px; height:150px;border-radius: 50%;border: 5px solid rgb(80, 129, 141);">
                                                @endif
                                            </div>
                                            <table class="table table-bordered">
                                                <tr>
                                                    <th colspan="2" class="text-center" style="font-size: 20px;font-weight: bold;">{{$vendor->name}}</th>
                                                </tr>
                                                {{-- <tr>
                                                    @if($vendor->name)
                                                    <th class="text-center"><i class="fa fa-user"></i></th>
                                                    <td class="text-center">{{$vendor->name}}</td>
                                                    @endif
                                                </tr> --}}
                                                <tr>
                                                    @if($vendor->phone)
                                                    <th class="text-center"><i class="fa fa-mobile"></i></th>
                                                    <td class="text-center">{{$vendor->phone}}</td>
                                                    @endif
                                                </tr>
                                                <tr>
                                                    @if($vendor->email)
                                                    <th class="text-center"><i class="fa fa fa-envelope"></i></th>
                                                    <td class="text-center">{{$vendor->email}}</td>
                                                    @endif
                                                </tr>
                                                <tr>
                                                    @if($vendor->city)
                                                    <th class="text-center"><i class="fa fa-home"></i></th>
                                                    <td class="text-center">{{$vendor->city}}</td>
                                                    @endif
                                                </tr>
                                                <tr>
                                                    @if($vendor->reg_date)
                                                    <th class="text-center"><i class="fa fa-calendar-plus-o"></i></th>
                                                    <td class="text-center">{{convertDate($vendor->reg_date)}}</td>
                                                    @endif
                                                </tr>
                                            </table>
                                        </div>    
                                    </div>
                                    {{-- <div class="col-lg-1 col-md-12 col-sm-12 col-xs-12"></div> --}}
                                    <div class="col-lg-5 col-md-12 col-sm-12 col-xs-12" style="box-shadow: 0px 0px 3px rgba(172, 171, 171, 0.877);border-radius: 8px;">
                                        <div id="member_statement" v-cloak>
                                            <div class="portlet sale-summary">
                                                <div class="portlet-title" style="display: flex; justify-content: center">
                                                    <div class="caption font-black text-center"> @lang('layout.VendorSummary') </div>
                                                    <div class="tools">
                                                        {{-- <a class="reload" href="javascript:;"> </a> --}}
                                                    </div>
                                                </div>
                                                <div class="portlet-body">
                                                    <div v-if="isLoading">
                                                        <div class="table-scrollable">
                                                            <table class="table">
                                                                <tr>
                                                                    <td colspan="3" style="text-align: center">
                                                                        <img src="{{asset('ltr/assets/layouts/layout/img/load8.gif')}}" style="width: 80px"/>
                                                                    </td>
                                                                </tr>
                                                            </table>
                                                        </div>
                                                    </div>
                                                    <div v-else>
                                                    <div class="table-scrollable">
                                                        <table class="table table-striped table-bordered table-advance table-hover" >
                                                            <thead>
                                                            <tr>
                                                                <th class="text-center">
                                                                    <i class="fa fa-money"></i> @lang('layout.Currency')
                                                                </th>
                                                                <th class="text-center">
                                                                    <i class="fa fa-briefcase"></i> @lang('layout.Receivable')
                                                                </th>
                                                                <th class="text-center">
                                                                    <i class="fa fa-briefcase"></i> @lang('layout.Payable')
                                                                </th>
    
                                                            </tr>
                                                            </thead>
                                                            <tbody v-if="summary">
                                                                <tr v-for="summ in summary">
                                                                    <td class="text-center"> @{{ summ.currency }} </td>
                                                                    <td class="text-center"> @{{format_number(Number(summ.invoice)) }} </td>
                                                                    <td class="text-center"> @{{ format_number(Number(summ.payment)) }}</td>
                                                                </tr>
                                                            </tbody>
                                                        </table>
                                                    </div>
                                                    </div>
    
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        {{-- <div class="">
                            <div class="col-md-2">
                                <ul class="list-unstyled profile-nav">
                                    <li>
                                        <div title="{{$vendor->name}}" class="twPc-avatarLink">
                                            @if($vendor->photo ==Null)
                                                <img class="twPc-avatarImg" src="{{asset('uploads/avatar.png')}}"
                                                     style="width:170px; height:170px;">
                                            @else
                                                <img class=" twPc-avatarImg" src="{!!url('/uploads/'.$vendor->photo)!!}"
                                                     style="width:170px; height:170px;">
                                            @endif
                                        </div>
                                    </li>
                                </ul>
                            </div>
                            <div class="col-md-10">
                                <div class="row">
                                    <div class="col-md-6 profile-info">
                                        <h1 class="font-green sbold uppercase">{{$vendor->name}}</h1>
                                        <div style="margin-top: 20%;">
                                            <ul class="list-inline">
                                                <li>
                                                    <i class="fa fa-user"></i> {{$vendor->name}}
                                                </li>
                                                <li>
                                                    <i class="fa fa-mobile"></i> {{$vendor->phone}}
                                                </li>
                                                <li>
                                                    <i class="fa fa fa-envelope"></i> {{$vendor->email}}
                                                </li>
                                                <li>
                                                    <i class="fa fa-home"></i> {{$vendor->city}}
                                                </li>
                                                <li>
                                                    <i class="fa fa-calendar-plus-o"></i> {{convertDate($vendor->reg_date)}}
                                                </li>
                                            </ul>
                                        </div>
                                    </div>

                                    <div class="col-md-6" id="member_statement" v-cloak>
                                        <div class="portlet sale-summary">
                                            <div class="portlet-title">
                                                <div class="caption font-red sbold"> @lang('layout.VendorSummary') </div>
                                                <div class="tools">
                                                    <a class="reload" href="javascript:;"> </a>
                                                </div>
                                            </div>
                                            <div class="portlet-body">
                                                <div v-if="isLoading">
                                                    <div class="table-scrollable">
                                                        <table class="table">
                                                            <tr>
                                                                <td colspan="3" style="text-align: center">
                                                                    <img src="{{asset('ltr/assets/layouts/layout/img/load8.gif')}}" style="width: 80px"/>
                                                                </td>

                                                            </tr>
                                                        </table>
                                                    </div>
                                                </div>
                                                <div v-else>
                                                <div class="table-scrollable">
                                                    <table class="table table-striped table-bordered table-advance table-hover" >
                                                        <thead>
                                                        <tr>
                                                            <th>
                                                                <i class="fa fa-money"></i> @lang('layout.Currency')
                                                            </th>
                                                            <th class="">
                                                                <i class="fa fa-briefcase"></i> @lang('layout.Receivable')
                                                            </th>
                                                            <th>
                                                                <i class="fa fa-briefcase"></i> @lang('layout.Payable')
                                                            </th>

                                                        </tr>
                                                        </thead>
                                                        <tbody v-if="summary">
                                                            <tr v-for="summ in summary">
                                                                <td> @{{ summ.currency }} </td>
                                                                <td> @{{format_number(Number(summ.invoice)) }} </td>
                                                                <td> @{{ format_number(Number(summ.payment)) }}</td>
                                                            </tr>
                                                        </tbody>
                                                    </table>
                                                </div>
                                                </div>

                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div> --}}
                        <div class="">
                            <div class="tabbable-line tabbable-custom-profile">
                                <ul class="nav nav-tabs">
                                    @if(systemConfig()[23] == 1)
                                    <li class="">
                                        <a href="#Purchases" data-toggle="tab" id="Purch-table">
                                            <i class=" icon-basket-loaded"></i><b> @lang('layout.Purchases') </b></a>
                                    </li>
                                    <li class="">
                                        <a href="#bill" data-toggle="tab" id="ven-bill">
                                            <i class="icon-note"></i><b> @lang('layout.Bills')</b> </a>
                                    </li>
                                    @endif
                                    <li class="">
                                        <a href="#payments" data-toggle="tab" id="cus-payments">
                                            <i class="fa  "></i><b> @lang('layout.Pyments') </b></a>
                                    </li>
                                    <li class="active">
                                        <a href="#statement" data-toggle="tab" id=cus-statement>
                                            <i class="icon-credit-card"></i><b> @lang('layout.Statements') </b></a>
                                    </li>
                                    @if(systemConfig()[20] == 1)
                                    <li class="">
                                        <a href="#contracts" data-toggle="tab" id="cus-contracts">
                                            <i class="fa  "></i><b> @lang('menu.Contract') </b></a>
                                    </li>
                                    @endif
                                </ul>
                                <div class="tab-content padding" style="padding: 0px;">
                                    <div class="tab-pane " id="Purchases">
                                        <div class="row">
                                            <div class="col-md-12">
                                                <!-- BEGIN EXAMPLE TABLE PORTLET-->
                                                <div class="portlet light bordered">
                                                    <div class="portlet-title">
                                                        <div class="caption font-dark">
                                                            <i class="icon-settings font-dark"></i>
                                                            <span class="caption-subject bold uppercase">@lang('layout.PurchasesDetails')</span>
                                                        </div>
                                                        <div class="actions">

                                                            <span id="anchore-modal">
                                                                <a href="#" @click.prevent="showModal('purchaselist')" id="" class="btn  btn-success">
                                                                    <i class="fa fa-print"></i>
                                                                </a>
                                                            </span>
                                                        </div>
                                                    </div>
                                                    <div class="portlet-body">
                                                        <table class="table table-striped table-bordered table-hover" id="pur">
                                                            <thead>
                                                            <tr>
                                                                <th>@lang('layout.PurchaseNumber')</th>
                                                                <th>@lang('layout.ReferenceNumber')</th>
                                                                <th>@lang('layout.Account')</th>
                                                                <th>@lang('layout.Date')</th>
                                                                <th>@lang('layout.Type')</th>
                                                                <th>@lang('layout.Amount')</th>
                                                                <th>@lang('layout.Currency')</th>
                                                                <th>@lang('layout.Actions')</th>
                                                            </tr>
                                                            </thead>
                                                        </table>
                                                    </div>
                                                </div>
                                                <!-- END EXAMPLE TABLE PORTLET-->
                                            </div>
                                        </div>
                                    </div>
                                    <!--tab-pane-->
                                    <div class="tab-pane" id="bill">
                                        <div class="row">
                                            <div class="col-md-12">
                                                <!-- BEGIN EXAMPLE TABLE PORTLET-->
                                                <div class="portlet light bordered">
                                                    <div class="portlet-title">
                                                        <div class="caption font-dark">
                                                            <i class="icon-settings font-dark"></i>
                                                            <span class="caption-subject bold uppercase">@lang('layout.BillDetails')</span>
                                                        </div>
                                                        <div class="actions">

                                                            <button onclick="openModal('builllist')" id="" class="btn  btn-success"><i class="fa fa-print"></i>
                                                            </button>

                                                            <span id="anchore-purch-modal">
                                                                <a href="#" @click.prevent="showModal('purchase_item')" id="" class="btn  btn-success">
                                                                    <i class="fa fa-print"></i>
                                                                </a>
                                                            </span>
                                                        </div>
                                                    </div>
                                                    <div class="portlet-body">
                                                        <table class="table table-striped table-bordered table-hover"
                                                               id="bills">
                                                            <thead>
                                                            <tr>
                                                                <th>@lang('layout.BillNumber')</th>
                                                                <th>@lang('layout.ReferenceNumber')</th>
                                                                <th>@lang('layout.Account')</th>
                                                                <th>@lang('layout.Date')</th>
                                                                <th>@lang('layout.Amount')</th>
                                                                <th>@lang('layout.Currency')</th>
                                                                <th>@lang('layout.Actions')</th>
                                                            </tr>
                                                            </thead>
                                                        </table>
                                                    </div>
                                                </div>
                                                <!-- END EXAMPLE TABLE PORTLET-->
                                            </div>
                                        </div>
                                    </div>
                                    <div class="tab-pane" id="payments">
                                        <div class="row">
                                            <div class="col-md-12">
                                                <!-- BEGIN EXAMPLE TABLE PORTLET-->
                                                <div class="portlet light bordered">
                                                    <div class="portlet-title">
                                                        <div class="caption font-dark">
                                                            <i class="icon-settings font-dark"></i>
                                                            <span class="caption-subject bold uppercase">@lang('layout.PaymentsDetails')</span>
                                                        </div>
                                                        <div class="actions">

                                                            <button onclick="openModal('all_pay')" id=""
                                                                    class="btn  btn-success"><i class="fa fa-print"></i>
                                                            </button>
                                                        </div>
                                                    </div>
                                                    <div class="portlet-body">
                                                        <table class="table table-striped table-bordered table-hover"
                                                               id="payment-table">
                                                            <thead>
                                                            <tr>
                                                                <th>@lang('layout.Number')</th>
                                                                <th>@lang('layout.ReferenceNumber')</th>
                                                                <th>@lang('layout.Account')</th>
                                                                <th>@lang('layout.Date')</th>
                                                                <th>@lang('layout.Amount')</th>
                                                                <th>@lang('layout.Rate')</th>
                                                                <th>@lang('layout.Currency')</th>
                                                                <th>@lang('layout.Actions')</th>
                                                            </tr>
                                                            </thead>
                                                        </table>
                                                    </div>
                                                </div>
                                                <!-- END EXAMPLE TABLE PORTLET-->
                                            </div>
                                        </div>
                                    </div>
                                    <div class="tab-pane active" id="statement">
                                        <div class="row">
                                            <div class="col-md-12">
                                                <!-- BEGIN EXAMPLE TABLE PORTLET-->
                                                <div class="portlet light bordered">
                                                    <div class="portlet-title">
                                                        <div class="caption font-dark">
                                                            <i class="icon-settings font-dark"></i>
                                                            <span class="caption-subject bold uppercase">@lang('layout.StatementDetails')</span>
                                                        </div>
                                                        <div class="actions">

                                                            <button onclick="openModal('statement',true)" id=""
                                                                    class="btn  btn-success"><i class="fa fa-print"></i>
                                                            </button>
                                                        </div>


                                                    </div>
                                                    <div class="portlet-body">
                                                        <table class="table table-striped table-bordered table-hover"
                                                               id="statement-table">
                                                            <thead>
                                                            <tr>
                                                                <th>@lang('layout.Account')</th>
                                                                <th>@lang('layout.Description')</th>
                                                                <th>@lang('layout.Currency')</th>
                                                                <th>@lang('layout.Rate')</th>
                                                                <th>@lang('layout.Type')</th>
                                                                <th>@lang('layout.Receivable')</th>
                                                                <th>@lang('layout.Payable')</th>
                                                                <th>@lang('layout.Date')</th>
                                                            </tr>
                                                            </thead>
                                                        </table>
                                                    </div>
                                                </div>
                                                <!-- END EXAMPLE TABLE PORTLET-->
                                            </div>
                                        </div>
                                    </div>
                                    <div class="tab-pane" id="contracts">
                                        <div class="row">
                                            <div class="col-md-12">
                                                <!-- BEGIN EXAMPLE TABLE PORTLET-->
                                                <div class="portlet light bordered">
                                                    <div class="portlet-title">
                                                        <div class="caption font-dark">
                                                            <i class="icon-settings font-dark"></i>
                                                            <span class="caption-subject bold uppercase">@lang('menu.Contract')</span>
                                                        </div>
                                                        <div class="actions"> 
                                                            <button onclick="openModal('all_contract')" id=""
                                                                    class="btn  btn-success"><i class="fa fa-print"></i>
                                                            </button>
                                                        </div>
                                                    </div>
                                                    <div class="portlet-body">
                                                        <table class="table table-striped table-bordered table-hover"
                                                               id="contract-table">
                                                            <thead>
                                                            <tr>
                                                                <th>#</th>
                                                                <th>@lang('layout.Code')</th>
                                                                <th>@lang('layout.ContractName')</th>
                                                                <th>@lang('layout.Bank')</th>
                                                                <th>@lang('layout.Amount')</th>
                                                                <th>@lang('layout.Currency')</th>
                                                                <th>@lang('layout.Rate')</th>
                                                                <th>@lang('layout.Total')
                                                                    <span>{{getHomeCurrency()['code']}}</span>
                                                                </th>
                                                                <th>@lang('layout.Date')</th>
                                                                <th>@lang('layout.Status')</th>
                                                                <th>@lang('layout.User')</th>
                                                                <th>@lang('layout.Actions')</th>
                                                            </tr>
                                                            </thead>
                                                        </table>
                                                    </div>
                                                </div>
                                                <!-- END EXAMPLE TABLE PORTLET-->
                                            </div>
                                        </div>
                                    </div>
                                    <!--  -->
                                </div>
                            </div>
                        </div>
                    </div>
                    <!--tab_1_2-->
                    <div class="tab-pane" id="tab_1_3">
                        <div class=" profile-account">
                            <div class="col-md-3">
                                <ul class="ver-inline-menu tabbable margin-bottom-10">
                                    <li class="active">
                                        <a data-toggle="tab" href="#tab_1-1">
                                            <i class="icon-user"></i> @lang('layout.PersonalInfo') </a>
                                        <span class="after"> </span>
                                    </li>
                                    <li>
                                        <a data-toggle="tab" href="#tab_2-2">
                                            <i class="icon-home"></i> @lang('layout.AddressInfo') </a>
                                    </li>
                                    <li>
                                        <a data-toggle="tab" href="#tab_3-3">
                                            <i class="fa fa-bars"></i> @lang('layout.OtherInformations') </a>
                                    </li>
                                </ul>
                            </div>
                            <div class="col-md-9">
                                <div class="tab-content">
                                    <div id="tab_1-1" class="tab-pane active">
                                        <div class="row">
                                            <div class="col-md-12">
                                                <table class="table">
                                                    <tr style="background-color: rgb(80, 129, 141) !important; color: white !important;">
                                                        <th class="text-center">@lang('layout.Email')</th>
                                                        <th class="text-center">@lang('layout.Phone')</th>
                                                        <th class="text-center">@lang('layout.Phone2')</th>
                                                        <th class="text-center">@lang('layout.Code')</th>
                                                        <th class="text-center">@lang('layout.Gender')</th>
                                                        <th class="text-center">@lang('layout.DateOfBirth')</th>
                                                        <th class="text-center">@lang('layout.Membership')</th>
                                                        <th class="text-center">@lang('layout.Date')</th>
                                                    </tr>
                                                    <tr class="active">
                                                        <td class="text-center"> {{ $vendor->email }}  </td>
                                                        <td class="text-center"> {{ $vendor->phone }}  </td>
                                                        <td class="text-center"> {{ $vendor->phone2 }}  </td>
                                                        <td class="text-center"> {{ $vendor->code }}  </td>
                                                        <td class="text-center"> {{ $vendor->gender }}  </td>
                                                        <td class="text-center"> {{ convertDate($vendor->date_of_birth) }}  </td>
                                                        <td class="text-center"> {{ $vendor->membership }}  </td>
                                                        <td class="text-center"> {{ $vendor->reg_date }}  </td>
                                                    </tr>
                                                    <tr style="background-color: rgb(80, 129, 141) !important; color: white !important;">
                                                        <th class="text-center">@lang('layout.ReferenceNumber')</th>
                                                        <th class="text-center">@lang('layout.Description')</th>
                                                    </tr>
                                                    <tr class="active">
                                                        <td class="text-center"> {{ $vendor->ref_no }}  </td>
                                                        <td class="text-center"> {{ $vendor->description }}  </td>
                                                    </tr>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                    <div id="tab_2-2" class="tab-pane">
                                        <div class="row">
                                            <div class="col-md-12">
                                                <table class="table">
                                                    <thead>
                                                        <tr>
                                                            <th class="text-center">@lang('layout.Address1')</th>
                                                            <th class="text-center">@lang('layout.Address2')</th>
                                                            <th class="text-center">@lang('layout.PostCode')</th>
                                                            <th class="text-center">@lang('layout.City')</th>
                                                            <th class="text-center">@lang('layout.Country')</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <tr class="active">
                                                            <td class="text-center"> {{ $vendor->address1 }}  </td>
                                                            <td class="text-center"> {{ $vendor->address2 }}  </td>
                                                            <td class="text-center"> {{ $vendor->post_code }}  </td>
                                                            <td class="text-center"> {{ $vendor->city }}  </td>
                                                            <td class="text-center"> {{ $vendor->country }}  </td>
                                                        </tr>
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>

                                                     <div id="tab_3-3" class="tab-pane">
                                        <div class="row">
                                            <div class="col-md-12">
                                                <table class="table">
                                                    <thead>
                                                        <tr>
                                                            <th class="text-center">@lang('layout.LicenseNumber')</th>
                                                            <th class="text-center">@lang('layout.IdentifyType')</th>
                                                            <th class="text-center">@lang('layout.LicenseIssueDate')</th>
                                                            <th class="text-center">@lang('layout.LicenseExpireDate')</th>
                                                            <th class="text-center">@lang('layout.PassportNumber')</th>
                                                            <th class="text-center">@lang('layout.SSID')</th>
                                                            <th class="text-center">@lang('layout.BossName')</th>
                                                            <th class="text-center">@lang('layout.BossSSN')</th>
                                                            <th class="text-center">@lang('layout.BossPassport')</th>
                                                            <th class="text-center">@lang('layout.AssistantName')</th>
                                                            <th class="text-center">@lang('layout.AssistantSSN')</th>
                                                            <th class="text-center">@lang('layout.AssistantPassport')</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <tr class="active">
                                                            <td class="text-center"> {{ $vendor->company_license_number }}  </td> 
                                                            @if($vendor->identify_type != '')
                                                            <td class="text-center"> {{__("layout.".$vendor->identify_type)}}  </td>
                                                            @else
                                                            <td class="text-center"> </td>
                                                            @endif
                                                            <td class="text-center"> {{ convertDate($vendor->license_issue_date) }}  </td>
                                                            <td class="text-center"> {{ convertDate($vendor->license_expire_date) }}  </td>
                                                            <td class="text-center"> {{ $vendor->passport }}  </td>
                                                            <td class="text-center"> {{ $vendor->ss_id }}  </td>
                                                            <td class="text-center"> {{ $vendor->boss_name }}  </td>
                                                            <td class="text-center"> {{ $vendor->boss_ssn }}  </td>
                                                            <td class="text-center"> {{ $vendor->boss_passport }}  </td>
                                                            <td class="text-center"> {{ $vendor->assistant_name }}  </td>
                                                            <td class="text-center"> {{ $vendor->assistant_ssn }}  </td>
                                                            <td class="text-center"> {{ $vendor->assistant_passport }}  </td>
                                                        </tr>
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>


                                </div>
                            </div>
                            <!--end col-md-9-->
                        </div>
                    </div>
                    <!--end tab-pane-->

                    <!--end tab-pane-->
                </div>
            </div>
        </div>
    </div>
    <iframe id="payframe" style="display: none;"></iframe>

@endsection


@include('print.modal')
@push('scripts')

    <script>
        Vue.component("v-select", VueSelect.VueSelect);
        @if (Session('payment_id'))
        printVoucher("{{Session('payment_id')}}")
        @endif

        //   function printVoucher(id){
        //     document.getElementById("payframe").src ="{{url('printPayment')}}/"+id;

        // }
        function printVoucher(id) {
            document.location.href = "{{url('printPayment')}}/" + id;

        }

        Vue.component('modal', {
            template: '#modal-template'
        });

        new Vue({
            el: '#app',
            data: {
                balance: {},

                amount: null,
                selectedCurrency:{!! json_encode(Currency()->getCurrency()) !!},
                currency:{!!  json_encode(getCurrencies()) !!},
                showModal: false,
                prepaidModal: false,
                checkoutModal: false,
                form_type: 'add',
                checkStatus: "{{$vendor->status}}"
            },
            computed: {

                // accountUpdate() {
                //     var b = _.clone(Banks)
                //     return this.accounts = b.filter((account) => {
                //         return (new RegExp(this.selectedCurrency.code.toLowerCase())).test(account.code.toLowerCase())
                //     })
                // },
            },
            methods: {

                openingSubmit() {

                    swal({
                        title: "Are you sure?",
                        text: "",
                        icon: "info",
                        buttons: true,
                        dangerMode: true,
                    })
                        .then((willDelete) => {
                            if (willDelete) {
                                document.getElementById("customer-opening-balance").submit()

                            } else {

                            }
                        });
                },
                prepaidSubmit() {

                    swal({
                        title: "Are you sure?",
                        text: "",
                        icon: "info",
                        buttons: true,
                        dangerMode: true,
                    })
                        .then((willDelete) => {
                            if (willDelete) {
                                document.getElementById("customer-prepaid-balance").submit()

                            } else {

                            }
                        });
                },
                checkoutSubmit(form_type) {
                    this.form_type = form_type;
                    swal({
                        title: "@lang('layout.AreYouSure?')",
                        text: "",
                        icon: "info",
                        buttons: ["@lang('layout.Cancel')", "@lang('layout.Submit')"],
                        dangerMode: true,
                    })

                        .then((willDelete) => {
                            if (willDelete) {
                                document.getElementById("customer-checkout").submit();
                            } else {

                            }
                        });
                }
            }

        });


        $(document).ready(function () {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
            $('#Purch-table').on('shown.bs.tab', function (event) {
                $('#pur').DataTable({
                    scrollCollapse: true,
                    serverSide: true,
                    paging: true,
                    responsive:'{{responsiveDataTable()}}',
                        pagingType:'{{paginationType()}}',
                    retrieve: true,
                    ajax: {
                        url: '{{route("vendor.show",$vendor->id)}}',
                        data: {type: 'purchase'}
                    },

                    columns: [
                        {data: 'Number', name: 'purchases.number'},
                        {data: 'ref_no', name: 'purchases.ref_no'},
                        {data: 'Account', name: 'accounts.name'},
                        {data: 'Date', name: 'Date'},
                        {data: 'Type', name: 'purchases.type'},
                        {data: 'Amount', name: 'Amount', orderable: false, searchable: false},
                        {data: 'Currency', name: 'transactions.unit'},
                        {data: 'actions', name: 'actions', orderable: false, searchable: false},
                    ]
                });
            });
        });


        // Purchases  scripts end

        // Invoices  scripts starts

        $(document).ready(function () {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
            $('#ven-bill').on('shown.bs.tab', function (event) {

                $('#bills').DataTable({
                    scrollCollapse: true,
                    serverSide: true,
                    paging: true,
                    responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                    retrieve: true,
                    ajax: {

                        url: '{{route("vendor.show",$vendor->id)}}',
                        data: {type: 'bill'}
                    },
                    columns: [
                        {data: 'Number', name: 'number'},
                        {data: 'ref_no', name: 'ref_no'},
                        {data: 'Account', name: 'accounts.name'},
                        {data: 'Date', name: 'Date'},
                        {data: 'Amount', name: 'transactions.amount', orderable: false, searchable: false},
                        {data: 'Currency', name: 'transactions.unit'},
                        {data: 'actions', name: 'actions', orderable: false, searchable: false},
                    ]
                });

            });
        });

        // Payments scripts

        $(document).ready(function () {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
            $('#cus-payments').on('shown.bs.tab', function (event) {

                $('#payment-table').DataTable({
                    scrollCollapse: true,
                    serverSide: true,
                    paging: true,
                    responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                    retrieve: true,

                    ajax: {
                        url: '{{route("vendor.show",$vendor->id)}}',
                        data: {type: 'payment'}
                    },
                    columns: [

                        {data: 'number', name: 'payments.number'},
                        {data: 'ref_no', name: 'payments.ref_no'},
                        {data: 'Account', name: 'accounts.name'},
                        {data: 'Date', name: 'Date', searchable: false},
                        {data: 'Amount', name: 'Amount', orderable: false, searchable: false},
                        {data: 'Rate', name: 'Rate', orderable: false, searchable: false},
                        {data: 'Currency', name: 'transactions.unit'},
                        {data: 'actions', name: 'actions', orderable: false, searchable: false},
                    ]
                });

            });
        });

        // Pyaments  scripts end        
        
        // Contract scripts
        $(document).ready(function () {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
            $('#cus-contracts').on('shown.bs.tab', function (event) {

                $('#contract-table').DataTable({
                    scrollCollapse: true,
                    serverSide: true,
                    paging: true,
                    responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                    retrieve: true,
                    ajax: {
                        url: '{{route("vendor.show",$vendor->id)}}',
                        data: {type: 'contract'}
                    },
                    columns: [
                        {data: 'id', name: 'contracts.id', searchable: false},
                        {data: 'Contract_Code', name: 'contracts.contract_no'},
                        {data: 'Contract_Name', name: 'contracts.company_name'},
                        {data: 'Account', name: 'account', orderable: false, searchable: false},
                        {data: 'Amount', name: 'amount', orderable: false, searchable: false},
                        {data: 'Currency', name: 'currency', orderable: false, searchable: false},
                        {data: 'Rate', name: 'rate', orderable: false, searchable: false},
                        {data: 'totalInDollar', name: 'totalInDollar', orderable: false, searchable: false},
                        {data: 'Date', name: 'date', searchable: false},
                        {data: 'Status', name: 'status', orderable: false, searchable: false},
                        {data: 'user', name: 'users.name'},
                        {data: 'actions', name: 'actions', orderable: false, searchable: false}
                    ]
                });

            });
        });
        // Contract scripts end

        // begin of statement
        $(document).ready(function () {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
            $('#cus-statement').on('shown.bs.tab', function (event) {
                $('#statement-table').DataTable({
                    scrollCollapse: true,
                    serverSide: true,
                    paging: true,
                    responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                    retrieve: true,
                    order: [[7, "desc"]],
                    ajax: {
                        url: '{{route("vendor.show",$vendor->member_id)}}',
                        data: {type: 'statements'}
                    },
                    columns: [
                        {data: 'Account', name: 'Account'},
                        {data: 'Description', name: 'Description'},
                        {data: 'Currency', name: 'Currency'},
                        {data: 'Rate', name: 'Rate'},
                        {data: 'Type', name: 'Type'},
                        {data: 'Receiable', name: 'Receiable'},
                        {data: 'Payable', name: 'Payable'},
                        {data: 'Date', name: 'Date'}
                    ]
                });
            });
            
            $('#statement-table').DataTable({
                scrollCollapse: true,
                serverSide: true,
                paging: true,
                responsive:'{{responsiveDataTable()}}',
            pagingType:'{{paginationType()}}',
                retrieve: true,
                order: [[7, "desc"]],
                ajax: {
                    url: '{{route("vendor.show",$vendor->member_id)}}',
                    data: {type: 'statements'}
                },
                columns: [
                    {data: 'Account', name: 'Account'},
                    {data: 'Description', name: 'Description'},
                    {data: 'Currency', name: 'Currency'},
                    {data: 'Rate', name: 'Rate'},
                    {data: 'Type', name: 'Type'},
                    {data: 'Receiable', name: 'Receiable'},
                    {data: 'Payable', name: 'Payable'},
                    {data: 'Date', name: 'Date'}
                ]
            });
        });

        // end of statement


        function openModal(type, is_statment = false) {
            if (is_statment == false) {

                anchorM.showModal(type);
            }
            else {
                vm_statement.$data.is_show = true;
            }
        }


        var mems = new Vue({
            el: '#member_statement',
            data: {
                summary: null,
                isLoading:true
            },
            mounted: function() {
                var member = {{$vendor->member_id}};
                this.getSummary(member);
            },
            methods: {
                getSummary(member) {
                if (member) {
                    axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: 'memberStatment',
                                member_id: member,
                            }
                        })
                        .then(function(response) {
                            mems.summary = response.data;
                            mems.isLoading = false;
                            // console.log(123, mems.summary);
                        })
                        .catch(function(error) {
                            // mems.summary = [];
                            console.log(error);
                        });
                }
            },
            }
        });  

        var vm = new Vue({

            el: '#print-modal',
            data: {
                is_show: false,
                pdfRoute: '{!!route('export.PDFAll') !!}',
                excelRoute: '{!! route('export.ExcelAll') !!}',
                type: null
            },

            methods: {
                closeModal: function () {
                    this.is_show = !this.is_show;
                }
            }
        });

        var anchorM = new Vue({
            el: '#anchore-modal',
            methods: {
                showModal: function (type = null) {
                    vm.$data.type = type;
                    console.log('trr', type)
                    vm.$data.is_show = true;
                }
            }
        });

        var vp = new Vue({

            el: '#print-modal-purch',
            data: {
                is_show: false,
                pdfRoute: '{!!route('export.PDFAll') !!}',
                excelRoute: '{!! route('export.PDFAll') !!}',
                type: null,
                itemlist: [],
                selectedItem1: null
            },

            methods: {
                closeModal: function () {
                    this.is_show = !this.is_show;
                },

            onItemSearch(search, loading) {
                loading(true);
                this.searchItem(search, loading, this);
            },
            //ajax call to get items
            searchItem(search, loading, vm) {
                axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'anyTable',
                            'search_column': 'name',
                            'table_name': 'items',
                            keyword: search,
                        }
                    })
                    .then(function(response) {
                        this.itemlist = [];
                        if (response.data.length > 0) {
                            vm.itemlist = response.data;
                            // console.log('data', vm.itemlist);
                        }
                        loading(false);
                    })
                    .catch(function(error) {
                        console.log(error);
                    })
            },

            }
        });

        var anchorPurch = new Vue({
            el: '#anchore-purch-modal',
            methods: {
                showModal: function (type = null) {
                    vp.$data.type = type;
                    vp.$data.is_show = true;
                }
            }
        });

        var vm_statement = new Vue({ 
            el: '#print-modal_statement',
            data: {
                is_show: false,
                pdfRoute: '{!!route('export.PDFAny') !!}',
                excelRoute: '{!! route('export.exportCsv') !!}',
                type: null
            },
            methods: {
                closeModal: function () {
                    this.is_show = !this.is_show;
                }
            }
        });
    </script>
@endpush