@extends('layouts.factor-master')
@section('style')
<style type="text/css">
  .customer_p {
    font-size: 30px;
    font-weight: bold;
    font-style: normal;
    color: #32c5d2;
  }

  .th {
    background-color: #e5f8ff;
  }
</style>

@stop
@section('content')
<?php
  $report = customeReportNew('member_general_statement');
  $_name = !in_array('name', $report);
  $_phone = !in_array('phone', $report);
  $_member_class = !in_array('member_class', $report);
  $_receivable_home_currency = !in_array('receivable_home_currency', $report);
  $_payable_home_currency = !in_array('payable_home_currency', $report);
  $_balance_home_currency = !in_array('balance_home_currency', $report);
  $_total_balance = !in_array('total_balance', $report);
  $_currency = !in_array('currency', $report);
  $_receivable = !in_array('receivable', $report);
  $_payable = !in_array('payable', $report);
  $_balance = !in_array('balance', $report);
  $_total = !in_array('total', $report);
  $_total_per_currency = !in_array('total_per_currency', $report);
  $_city = !in_array('city1', $report);
  $_address = !in_array('address1', $report);

  $balance_per_currency_receive = [];
  $balance_per_currency_payable = [];
  $balance_per_currency_rec_pay = [];
  $report_type = (isset($report_type))?$report_type:null;
?>
@if($data && $data !=[])
<?php
  $type = $type_name;
  $typeName = '';
  if ($type == 'Customer') {
    $typeName = __('layout.Customer');
  }
  if ($type == "Vendor") {
    $typeName = __('layout.Vendor');
  }
  if ($type == "Employee") {
    $typeName = __('layout.Employee');
  }
  if ($type == "Driver") {
    $typeName = __('layout.Driver');
  }
?>
@if($type)
<h3 class="table-caption" style="text-align: center;">@lang('layout.StatementDetails')-{{$typeName}}</h3>
@else
<h3 class="table-caption" style="text-align: center;">@lang('layout.StatementDetails')</h3>
@endif
@if($member_class)
<table class="main-table">
  <tr class="center">
    <td class="customer_p">@lang('layout.Class'): [{{$member_class->name}}]</td>
  </tr>
</table>
@endif
<table class="main-table">
  <tr>
    @if($from_date)
    <td>
      <span>@lang('layout.FromDate')</span>:
      <BDO DIR="LTR">{{convertDate($from_date)}}</BDO>
    </td>
    @endif
    @if($to_date)
    <td>
      <span>@lang('layout.ToDate')</span>:
      <BDO DIR="LTR">{{convertDate($to_date)}}</BDO>
    </td>
    @endif
  </tr>
</table>
<table class="main-table" style="margin: 6px 0px;" >
  @if($ClassName)
  <tr>
    <td>
      <span>@lang('menu.FinancialClass')</span>: {{$ClassName}}
    </td>
  </tr>
  @endif
</table>
<br>
<table class="main-table">
  <thead>
    <tr class="bg">
      <td>
        <div class="center">@lang('layout.Number')</div>
      </td>
      @if($_name)<td>
        <div class="center"> @lang('layout.Code') </div>
      </td>@endif
      @if($_name)<td>
        <div class="center"> @lang('layout.Name') </div>
      </td>@endif
      @if($_phone)<td>
        <div class="center"> @lang('layout.Phone') </div>
      </td>@endif
      @if(!$member_class)
      @if($_member_class)<td>
        <div class="center"> @lang('layout.Class') </div>
      </td>@endif
      @endif
      @if($_city)<td>
        <div class="center"> @lang('layout.City') </div>
      </td>@endif
      @if($_address)<td>
        <div class="center"> @lang('layout.Address') </div>
      </td>@endif
      @if($_payable_home_currency)<td>
        <div class="center"> @lang('layout.PayableTotal') </div>
      </td>@endif
      @if($_receivable_home_currency)<td>
        <div class="center"> @lang('layout.ReceivableTotal') </div>
      </td>@endif
      @if($_total_balance)<td>
        <div class="center"> @lang('layout.TotalBalances') {{getHomeCurrency()[getCurrencyType()]}} </div>
      </td>@endif
      @if(getLastMemberStatementDates() == 'true')
      <td>
        <div class="center"> @lang('layout.LastDate')  </div>
      </td>
      @endif
      @if($_currency)<th>
        <div class="center"> @lang('layout.Currency') </div>
      </th>@endif
      @if(isset($all_statment) && $all_statment)
      @if($_receivable)<th>
        <div class="center"> @lang('layout.All') @lang('layout.Receivable') </div>
      </th>@endif
      @if($_payable)<th>
        <div class="center"> @lang('layout.All') @lang('layout.Payable') </div>
      </th>@endif
      @endif
      @if($_receivable)<th>
        <div class="center"> @lang('layout.Receivable') </div>
      </th>@endif
      @if($_payable)<th>
        <div class="center"> @lang('layout.Payable') </div>
      </th>@endif
      @if($_balance)<th>
        <div class="center"> @lang('layout.Balance') </div>
      </th>@endif
    </tr>
  </thead>
  <tbody>
    <?php
      $count = 0;
      $tempName = '';
      $totalP = 0;
      $totalR = 0;
      $name_array = [];
      //
      $test = 0;
    ?>
    @foreach($data AS $key=>$value)
    <?php
      $rowCount = count($value['Currency'])+1;
      if ($report_type && $report_type != '') {
        $check = true;
        foreach ($value['Currency'] as $key11=>$rec1) {
          $result11 = SumToNumber($rec1['Payable'], $rec1['Receivable']);
          $r11 = $result11['b'];
          $p11 = $result11['a'];
          if ($report_type == 'Receivable' && $p11 > 0) {
            $check = false;
          } elseif ($report_type == 'Payable' && $r11 > 0) {
            $check = false;
          } else {
            $rowCount = $rowCount-1;
          }
        }
        if ($check) {
            continue;
        }
      }
      $result = SumToNumber($value['TotalAmountP'], $value['TotalAmountR']);
      $p = $result['a'];
      $r = $result['b'];
      if ($report_type && $report_type != '') {
        if ($report_type == 'Receivable' && $p != 0) {
          $totalP += $p;
        } elseif ($report_type == 'Payable' && $r != 0) {
          $totalR += $r;
        }
      } else {
        if ($p != 0) {
          $totalP += $p;
        } elseif ($r != 0) {
          $totalR += $r;
        }
      }
    ?>
    <tr>
      <td class="center" rowspan="{{$rowCount}}">{{++$count}}</td>
      @if($_name)<td class="center" rowspan="{{$rowCount}}">{{$value['code']}}</td>@endif
      @if($_name)<td class="center" rowspan="{{$rowCount}}">{{$key}}</td>@endif
      @if($_phone)<td class="center" rowspan="{{$rowCount}}">{{$value['Phone']}}</td>@endif
      @if(!$member_class)
      @if($_member_class)<td class="center" rowspan="{{$rowCount}}">{{$value['ClassName']}}</td>@endif
      @endif
      @if($_city)<td class="center" rowspan="{{$rowCount}}">{{$value['City']}}</td>@endif
      @if($_address)<td class="center" rowspan="{{$rowCount}}">{{$value['Address']}}</td>@endif
      @if($_payable_home_currency)<td class="center bg-blue" rowspan="{{$rowCount}}">{{myRound($value['TotalAmountP'])}} {{getHomeCurrency()[getCurrencyType()]}}</td>@endif
      @if($_receivable_home_currency)<td class="center bg-blue" rowspan="{{$rowCount}}">{{myRound($value['TotalAmountR'])}} {{getHomeCurrency()[getCurrencyType()]}}</td>@endif
      @if($_total_balance) 
      <td class="center" rowspan="{{$rowCount}}">
        <?php
          $result = SumToNumber($value['TotalAmountP'], $value['TotalAmountR']);
          $p = $result['a'];
          $r = $result['b'];
          if ($p != 0) {
            if (array_key_exists($key . '-' . $value['Phone'], $name_array)) {
            } else {
              $name_array[$key . '-' . $value['Phone']] = $key . '-' . $value['Phone'];
              // $totalP+=$p;
            }
            echo myRound($p) . ' ' . __('layout.Payable');
          } elseif ($r != 0) {
            if (array_key_exists($key . '-' . $value['Phone'], $name_array)) {
            } else {
              $name_array[$key . '-' . $value['Phone']] = $key . '-' . $value['Phone'];
              // $totalR+=$r;
            }
            echo myRound($r) . ' ' . __('layout.Receivable');
          } else {
            echo '0';
          }
        ?>
      </td>@endif
      @if(getLastMemberStatementDates() == 'true')
      <td class="center bg-blue" rowspan="{{$rowCount}}">
        @if(isset($value['dateP']))
        {{convertDate($value['dateP'])}}-@lang('layout.Payable') 
        @endif
        @if(isset($value['dateP']) && isset($value['dateR']))
        <br/>
        @endif
        @if(isset($value['dateR']))
        {{convertDate($value['dateR'])}}-@lang('layout.Receivable') 
        @endif
      </td>
      @endif
      <td style="padding:0px; margin:0px">
        {{-- <table class="main-table">
          <thead>
            <tr class="th">
              @if($_currency)<th>
                <div class="center"> @lang('layout.Currency') </div>
              </th>@endif
              @if($_receivable)<th>
                <div class="center"> @lang('layout.Receivable') </div>
              </th>@endif
              @if($_payable)<th>
                <div class="center"> @lang('layout.Payable') </div>
              </th>@endif
              @if($_balance)<th>
                <div class="center"> @lang('layout.Balance') </div>
              </th>@endif
            </tr>
          </thead>
          <tbody>
            @foreach($value['Currency'] AS $key1=>$rec)
            <tr>
              @if($_currency)<td class="center">{{$key1}}</td>@endif
              @if($_receivable)<td class="center">{{myRound($rec['Receivable'])}}</td>@endif
              @if($_payable)<td class="center"> {{myRound($rec['Payable'])}}</td>@endif
              @if($_balance)
              <td class="center">
                <?php
                $result1 = SumToNumber($rec['Payable'], $rec['Receivable']);
                $p1 = $result1['a'];
                $r1 = $result1['b'];
                ?>
                @if($r1 !=0)
                {{myRound($r1)}}
                @lang('layout.Receivable')
                @elseif($p1 !=0)
                {{myRound($p1)}}
                @lang('layout.Payable')
                @endif
                <!-- 
                @if(round($r1,1)>0)
                {{round($r1,2)}}:
                  @lang('layout.Receivable')
                  @elseif(round($p1,1)>0)
                  {{round($p1,2)}}:
                @lang('layout.Payable')
                @endif -->
              </td>
              @endif
            </tr>
            @endforeach
          </tbody>
        </table> --}}
        @foreach($value['Currency'] AS $key1=>$rec)
        <?php
          $result1 = SumToNumber($rec['Payable'], $rec['Receivable']);
          $r1 = $result1['b'];
          $p1 = $result1['a'];
          if ($report_type && $report_type != '') {
            if ($report_type == 'Receivable' && $p1 > 0) {
            } elseif ($report_type == 'Payable' && $r1 > 0) {
            } else {
              continue;
            }
          }
          if ($r1 != 0) {
            if (array_key_exists($key1, $balance_per_currency_receive)) {
              $balance_per_currency_receive[$key1] = $balance_per_currency_receive[$key1] + $r1;
            } else {
              $balance_per_currency_receive[$key1] = $r1;
            }
            if (array_key_exists($key1, $balance_per_currency_rec_pay)) {
              $balance_per_currency_rec_pay[$key1]['rec'] = $balance_per_currency_rec_pay[$key1]['rec'] + $r1;
            } else {
              $balance_per_currency_rec_pay[$key1]['rec'] = $r1;
              $balance_per_currency_rec_pay[$key1]['pay'] = 0;
            }
          }
          if ($p1 != 0) {
            if (array_key_exists($key1, $balance_per_currency_payable)) {
              $balance_per_currency_payable[$key1] = $balance_per_currency_payable[$key1] + $p1;
            } else {
              $balance_per_currency_payable[$key1] = $p1;
            }
            if (array_key_exists($key1, $balance_per_currency_rec_pay)) {
              $balance_per_currency_rec_pay[$key1]['pay'] = $balance_per_currency_rec_pay[$key1]['pay'] + $p1;
            } else {
              $balance_per_currency_rec_pay[$key1]['pay'] = $p1;
              $balance_per_currency_rec_pay[$key1]['rec'] = 0;
            }
          }
        ?>
        <tr style="border: none !important; padding:0px; margin:0px">
            @if($_currency)<td>{{$key1}}</td>@endif
            @if(isset($all_statment) && $all_statment)
            @if($_receivable)<td>{{myRound($rec['AllReceivable'])}}</td>@endif
            @if($_payable)<td>{{myRound($rec['AllPayable'])}}</td>@endif
            @endif
            @if($_receivable)<td>{{myRound($rec['Receivable'])}}</td>@endif
            @if($_payable)<td>{{myRound($rec['Payable'])}}</td>@endif
            @if($_balance)
            <td>
              <?php
                $result1 = SumToNumber($rec['Payable'], $rec['Receivable']);
                $p1 = $result1['a'];
                $r1 = $result1['b'];
              ?>
              @if($r1 !=0)
              {{myRound($r1)}}
              @lang('layout.Receivable')
              @elseif($p1 !=0)
              {{myRound($p1)}}
              @lang('layout.Payable')
              @endif
            </td>
            @endif
        </tr>
        @endforeach        
      </td>
      <?php
      // dd($currencies);
      ?>
      @endforeach
    </tr>
  </tbody>
</table>
@if($_total)
<table class="main-table bg">
  <tr>
    <td width="25%">
      <div class="center"> @lang('layout.Payable') </div>
    </td>
    <td width="25%">
      <div class="center"> {{myRound($totalP)}} {{getHomeCurrency()[getCurrencyType()]}} </div>
    </td>
    <td width="25%">
      <div class="center"> @lang('layout.Receivable') </div>
    </td>
    <td width="25%">
      <div class="center"> {{myRound($totalR)}} {{getHomeCurrency()[getCurrencyType()]}}</div>
    </td>
  </tr>
  <tr>
</table>
<table class="main-table bg">
  <tr>
    <?php if ($totalR >= $totalP) { ?>
      <td width="20%">
        <div class="center"> @lang('layout.Total') </div>
      </td>
      <td width="">
        <div class="center"> @lang('layout.Receivable') </div>
      </td>
      <td width="">
        <div class="center"> {{myRound($totalR - $totalP)}} {{getHomeCurrency()[getCurrencyType()]}} </div>
      </td>
      <?php
        $totalRP = $totalR - $totalP;
        } else {
        $totalRP = $totalP - $totalR;
      ?>
      <td width="20%">
        <div class="center"> @lang('layout.Total') </div>
      </td>
      <td width="">
        <div class="center"> @lang('layout.Payable') </div>
      </td>
      <td width="">
        <div class="center"> {{myRound($totalP - $totalR)}} {{getHomeCurrency()[getCurrencyType()]}} </div>
      </td>
    <?php } ?>
  </tr>
  {{-- @if($totalRP > 0 && $currency_rate >0 && $currency_name)
  <tr>
    <td colspan="1">
      <div class="center">@lang('layout.SelectedCurrency')</div>
    </td>
    <td colspan="1">
      <div class="center">@lang('layout.Rate') : {{$currency_rate}} </div>
    </td>
    <td>
      <div class="center">{{myRound($totalRP * $currency_rate)}} {{$currency_name}}</div>
    </td>
  </tr>
  @endif --}}
  @if(isset($currency_rate) && isset($currency_total))
  @if($totalRP > 0 && $currency_rate >0 && $currency_total)
    <tr>
      <td colspan="1"><div class="center">@lang('layout.SelectedCurrency')</div></td>
      <td colspan="1"><div class="center">@lang('layout.Rate') : {{$currency_rate}} </div></td>
      <td><div class="center">{{myRound($totalRP * $currency_rate)}} {{$currency_total}}</div></td>
    </tr>
  @endif
  @endif
</table>
@endif
@endif


@if($_total_per_currency)


    <!-- <table style="width: 100%; margin-top: 10px;">
        <tr>
          @if($balance_per_currency_receive)
            <td style="text-align: left; width:40%">
                <table class="main-table">
                    <tr class="bg">
                        <td align="center" colspan="2">
                            <b>@lang('layout.Receivable')</b>
                        </td>

                    </tr>
                  
                    <?php
                    foreach ($balance_per_currency_receive as $key => $currency) {
                    ?>
                      <tr>
                        <td><div class="center">{{$key}}</div></td>
                        <td><div class="center">{{round($currency,2)}}</div></td>

                      </tr>
                      <?php
                    }
                      ?>
                </table>
            </td>
            @endif
            @if($balance_per_currency_payable)
            <td style="text-align: right; width:30%">
                <table class="main-table">
                    <tr class="bg">
                        <td align="center" colspan="2"><b>@lang('layout.Payable')</b></td>
                    </tr>
                  
                    <?php
                    foreach ($balance_per_currency_payable as $key => $currency) {
                    ?>
                      <tr>
                        <td><div class="center">{{$key}}</div></td>
                        <td><div class="center">{{round($currency,2)}}</div></td>

                      </tr>
                      <?php
                    }
                      ?>
                </table>
            </td>
            @endif
        </tr>
    </table> -->

<table style="width: 100%; margin-top: 10px;">
  <tr>
    @if($balance_per_currency_rec_pay)
    <td style="">
      <table class="main-table">
        <tr class="bg">
          <td align="center" colspan="1">
            <b>@lang('layout.Currency')</b>
          </td>
          <td align="center" colspan="1">
            <b>@lang('layout.Receivable')</b>
          </td>
          <td align="center" colspan="1">
            <b>@lang('layout.Payable')</b>
          </td>
          <td align="center" colspan="1">
            <b>@lang('layout.Balance')</b>
          </td>
        </tr>
        <?php
        foreach ($balance_per_currency_rec_pay as $key => $currency) {
        ?>
          <tr>
            <td>
              <div class="center">{{$key}}</div>
            </td>
            <td>
              <div class="center">{{myRound($currency['rec'])}}</div>
            </td>
            <td>
              <div class="center">{{myRound($currency['pay'])}}</div>
            </td>
            @if($currency['rec'] >= $currency['pay'])
            <td>
              <div class="center">{{myRound($currency['rec'] - $currency['pay'])}} @lang('layout.Receivable')</div>
            </td>
            @else
            <td>
              <div class="center">{{myRound($currency['pay'] - $currency['rec'])}} @lang('layout.Payable')</div>
            </td>
            @endif
          </tr>
        <?php
        }
        ?>
      </table>
    </td>
    @endif
  </tr>
</table>

@endif

<!--  signature -->
<table style="width: 100%" class="signtable">
  <tr>
    @foreach(getCompanyInfo('sign','reports') AS $info)
    <td style="text-align: left; width:40%">
      <table>

        <tr>
          <td align="right" class="signsize">{{$info['name']}}</td>
        </tr>

      </table>
    </td>
    @endforeach
  </tr>
</table>
<!-- End signature -->



@endsection