@extends('layouts.factor-master')
@section('style')
<style type="text/css">
    .customer_p {
        font-size: 30px;
        font-weight: bold;
        font-style: normal;
        color: #32c5d2;
    }
    .th {
        background-color: #e5f8ff;
    }
</style>
@stop
@section('content')
<?php
    $report = customeReportNew('member_general_statement');
    $_name = !in_array('name', $report);
    $_phone = !in_array('phone', $report);
    $_member_class = !in_array('member_class', $report);
    $_receivable_home_currency = !in_array('receivable_home_currency', $report);
    $_payable_home_currency = !in_array('payable_home_currency', $report);
    $_balance_home_currency = !in_array('balance_home_currency', $report);
    $_total_balance = !in_array('total_balance', $report);
    $_currency = !in_array('currency', $report);
    $_receivable = !in_array('receivable', $report);
    $_payable = !in_array('payable', $report);
    $_balance = !in_array('balance', $report);
    $_total = !in_array('total', $report);
    $_total_per_currency = !in_array('total_per_currency', $report);
    $_city = !in_array('city1', $report);
    $_address = !in_array('address1', $report);

    $balance_per_currency_receive = [];
    $balance_per_currency_payable = [];
    $quantity_per_item = [];
?>

@if($data && $data !=[])

<h3 class="table-caption" style="text-align: center;">@lang('layout.StatementDetails')</h3>

@if($member_class)
<table class="main-table">
    <tr class="center">
        <td class="customer_p">@lang('layout.Class'): [{{$member_class->name}}]</td>
    </tr>
</table>
@endif

<table class="main-table">
    <tr>
        @if($from_date)
        <td>
            <span>@lang('layout.FromDate')</span>:
            <BDO DIR="LTR">{{convertDate($from_date)}}</BDO>
        </td>
        @endif
        @if($to_date)
        <td>
            <span>@lang('layout.ToDate')</span>:
            <BDO DIR="LTR">{{convertDate($to_date)}}</BDO>
        </td>
        @endif
    </tr>


</table>
<br>

<table class="main-table">
    <thead>
        <tr class="bg">
            <td width="3%" class="center">
                <div class="center">@lang('layout.Number')</div>
            </td>
            @if($_name)<td class="center" width="3%">
                <div class="center"> @lang('layout.Code') </div>
            </td>@endif
            @if($_name)<td class="center">
                <div class="center"> @lang('layout.Name') </div>
            </td>@endif
            @if($_phone)<td class="center">
                <div class="center"> @lang('layout.Phone') </div>
            </td>@endif

            @if(!$member_class)
            @if($_member_class)<td class="center">
                <div class="center"> @lang('layout.Class') </div>
            </td>@endif
            @endif

            @if($_city)<td class="center">
                <div > @lang('layout.City') </div>
            </td>@endif
            <!-- @if($_address)<td>
                <div class="center"> @lang('layout.Address') </div>
            </td>@endif -->
            <!-- @if($_payable_home_currency)<td>
                <div class="center"> @lang('layout.PayableTotal') </div>
            </td>@endif
            @if($_receivable_home_currency)<td>
                <div class="center"> @lang('layout.ReceivableTotal') </div>
            </td>@endif -->
            @if($_total_balance)<td class="center">
                <div class="center"> @lang('layout.TotalBalances') {{getHomeCurrency()[getCurrencyType()]}} </div>
            </td>@endif

            <td width="30%">
                <center> @lang('layout.Currency') @lang('layout.Balance') </center>
            </td>
            <td width="25%">
                <center> @lang('layout.Item') </center>
            </td>

        </tr>
    </thead>
    <tbody>
        <?php
        $count = 0;
        $tempName = '';
        $totalP = 0;
        $totalR = 0;

        $name_array = [];

        $test = 0;
        ?>
        @foreach($data AS $key=>$value)


        <?php

        $result = SumToNumber($value['TotalAmountP'], $value['TotalAmountR']);

        $p = $result['a'];
        $r = $result['b'];


        if ($p != 0) {
            $totalP += $p;
        } elseif ($r != 0) {
            $totalR += $r;
        }

        ?>

        <tr>
            <td class="center">{{++$count}}</td>
            @if($_name)<td class="center">{{$value['code']}} 12</td>@endif
            @if($_name)<td class="center">{{$key}}</td>@endif
            @if($_phone)<td class="center">{{$value['Phone']}}</td>@endif
            @if(!$member_class)
            @if($_member_class)<td class="center">{{$value['ClassName']}}</td>@endif
            @endif
            @if($_city)<td class="center">{{$value['City']}}</td>@endif
            <!-- @if($_address)<td class="center">{{$value['Address']}}</td>@endif -->

            <!-- @if($_payable_home_currency)<td class="center bg-blue">{{round($value['TotalAmountP'],2)}} {{getHomeCurrency()['code']}}</td>@endif
            @if($_receivable_home_currency)<td class="center bg-blue">{{round($value['TotalAmountR'],2)}} {{getHomeCurrency()['code']}}</td>@endif -->
            @if($_total_balance)
            <td class="center">
                <?php

                $result = SumToNumber($value['TotalAmountP'], $value['TotalAmountR']);

                $p = $result['a'];
                $r = $result['b'];

                if ($p != 0) {

                    if (array_key_exists($key . '-' . $value['Phone'], $name_array)) {
                    } else {

                        $name_array[$key . '-' . $value['Phone']] = $key . '-' . $value['Phone'];
                        // $totalP+=$p;
                    }

                    echo round($p, 2) . ' ' . __('layout.Payable');
                } elseif ($r != 0) {


                    if (array_key_exists($key . '-' . $value['Phone'], $name_array)) {
                    } else {

                        $name_array[$key . '-' . $value['Phone']] = $key . '-' . $value['Phone'];
                        // $totalR+=$r;
                    }

                    echo round($r, 2) . ' ' . __('layout.Receivable');
                } else {
                    echo '0';
                }


                ?>

            </td>
            @endif
            <td>
                @if($value['Currency'])
                <table class="main-table">
                    <thead>
                        <tr class="th">
                            @if($_currency)<th>
                                <div class="center"> @lang('layout.Currency') </div>
                            </th>@endif
                            @if($_receivable)<th>
                                <div class="center"> @lang('layout.Receivable') </div>
                            </th>@endif
                            @if($_payable)<th>
                                <div class="center"> @lang('layout.Payable') </div>
                            </th>@endif
                            @if($_balance)<th>
                                <div class="center"> @lang('layout.Balance') </div>
                            </th>@endif
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($value['Currency'] AS $key1=>$rec)

                        <?php

                        $result1 = SumToNumber($rec['Payable'], $rec['Receivable']);
                        $r1 = $result1['b'];
                        $p1 = $result1['a'];
                        if ($r1 != 0) {
                            if (array_key_exists($key1, $balance_per_currency_receive)) {

                                $balance_per_currency_receive[$key1] = $balance_per_currency_receive[$key1] + $r1;
                            } else {

                                $balance_per_currency_receive[$key1] = $r1;
                            }
                        }
                        if ($p1 != 0) {
                            if (array_key_exists($key1, $balance_per_currency_payable)) {

                                $balance_per_currency_payable[$key1] = $balance_per_currency_payable[$key1] + $p1;
                            } else {

                                $balance_per_currency_payable[$key1] = $p1;
                            }
                        }

                        ?>

                        <tr>
                            @if($_currency)<td class="center">{{$key1}}</td>@endif
                            @if($_receivable)<td class="center">{{round($rec['Receivable'],2)}}</td>@endif
                            @if($_payable)<td class="center"> {{round($rec['Payable'],2)}}</td>@endif

                            @if($_balance)
                            <td class="center">
                                <?php
                                $result1 = SumToNumber($rec['Payable'], $rec['Receivable']);
                                $p1 = $result1['a'];
                                $r1 = $result1['b'];
                                ?>
                                @if($r1 !=0)
                                {{round($r1,2)}}:
                                @lang('layout.Receivable')

                                @elseif($p1 !=0)

                                {{round($p1,2)}}:
                                @lang('layout.Payable')

                                @endif

                            </td>
                            @endif


                        </tr>
                        @endforeach
                    </tbody>
                </table>
                @endif
            </td>
            <td>
                @if($value['item'])
                <table class="main-table">
                    <thead>
                        <tr class="th">
                            <th>
                                <div class="center"> @lang('layout.Item') </div>
                            </th>
                            <th>
                                <div class="center"> @lang('layout.Measure') </div>
                            </th>
                            <th>
                                <div class="center"> @lang('layout.Quantity') </div>
                            </th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($value['item'] AS $key2=>$it)

                        <?php
                        if (array_key_exists($it['name'], $quantity_per_item)) {

                            $quantity_per_item[$it['name']] = $quantity_per_item[$it['name']] + $it['qty'];
                        } else {

                            $quantity_per_item[$it['name']] = $it['qty'];
                        }

                        ?>

                        <tr>
                            <td class="center">{{$it['name']}}</td>
                            <td class="center">{{$it['measure']}}</td>
                            <td class="center">{{round($it['qty'],2)}}</td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
                @endif
            </td>
            @endforeach
        </tr>



    </tbody>
</table>
@if($_total)
<table class="main-table bg">
    <tr>
        <td width="25%">
            <div class="center"> @lang('layout.Payable') </div>
        </td>
        <td width="25%">
            <div class="center"> {{round($totalP,2)}} {{getHomeCurrency()[getCurrencyType()]}} </div>
        </td>
        <td width="25%">
            <div class="center"> @lang('layout.Receivable') </div>
        </td>
        <td width="25%">
            <div class="center"> {{round($totalR,2)}} {{getHomeCurrency()[getCurrencyType()]}}</div>
        </td>
    </tr>
    <tr>
</table>
<table class="main-table bg">
    <tr>
        <?php if ($totalR >= $totalP) { ?>
            <td width="20%">
                <div class="center"> @lang('layout.Total') </div>
            </td>
            <td width="">
                <div class="center"> @lang('layout.Receivable') </div>
            </td>
            <td width="">
                <div class="center"> {{MyRound($totalR - $totalP)}} {{getHomeCurrency()[getCurrencyType()]}} </div>
            </td>
        <?php
            $totalRP = $totalR - $totalP;
        } else {
            $totalRP = $totalP - $totalR;
        ?>
            <td width="20%">
                <div class="center"> @lang('layout.Total') </div>
            </td>
            <td width="">
                <div class="center"> @lang('layout.Payable') </div>
            </td>
            <td width="">
                <div class="center"> {{MyRound($totalP - $totalR)}} {{getHomeCurrency()[getCurrencyType()]}} </div>
            </td>
        <?php } ?>
    </tr>
</table>
@endif
@endif

@if($_total_per_currency)
<table class="main-table">
    <tr>
        @if($balance_per_currency_receive)
        <td style="text-align: center; width:50%">
            <table style="width: 100%;">
                <tr class="bg">
                    <td align="center" colspan="2">
                        <b>@lang('layout.Receivable')</b>
                    </td>

                </tr>

                <?php
                foreach ($balance_per_currency_receive as $key => $currency) {
                ?>
                    <tr>
                        <td>
                            <div class="center">{{$key}}</div>
                        </td>
                        <td>
                            <div class="center">{{round($currency,2)}}</div>
                        </td>

                    </tr>
                <?php
                }
                ?>
            </table>
        </td>
        @endif
        @if($balance_per_currency_payable)
        <td style="text-align: center; width:50%">
            <table style="width: 100%;">
                <tr class="bg">
                    <td align="center" colspan="2"><b>@lang('layout.Payable')</b></td>
                </tr>

                <?php
                foreach ($balance_per_currency_payable as $key => $currency) {
                ?>
                    <tr>
                        <td>
                            <div class="center">{{$key}}</div>
                        </td>
                        <td>
                            <div class="center">{{round($currency,2)}}</div>
                        </td>

                    </tr>
                <?php
                }
                ?>
            </table>
        </td>
        @endif
    </tr>
</table>
@endif

@if($quantity_per_item)
<table class="main-table">
    <tr class="bg">
        <td align="center" colspan="2">
            <b>@lang('layout.TotalItems') @lang('layout.Customer')</b>
        </td>
    </tr>
    <tr class="bg">
        <td><b>@lang('layout.Item')</b></td>
        <td><b>@lang('layout.Quantity')</b></td>
    </tr>

    <?php
    foreach ($quantity_per_item as $keyitem => $quty) {
    ?>
        <tr>
            <td>
                <div class="center">{{$keyitem}}</div>
            </td>
            <td>
                <div class="center">{{round($quty,2)}}</div>
            </td>

        </tr>
    <?php
    }
    ?>
</table>
@endif

<br />
@if($account)
<h4 style="text-align: center;">@lang('layout.Bank')</h4>
<table class="main-table" id="aa" cellpadding="5px">
    <thead>
        <tr class="bg">
            <td class="center" style="font-weight: bold; font-size:18px">
                <div> @lang('layout.Record') </div>
            </td>
            <td class="center" style="font-weight: bold; font-size:18px">
                <div> @lang('layout.AccountNumber')</div>
            </td>
            <td class="center" style="font-weight: bold; font-size:18px">
                <div> @lang('layout.AccountName') </div>
            </td>
            <td class="center" style="font-weight: bold; font-size:18px">
                <div> @lang('layout.Amount')</div>
            </td>
            <td class="center" style="font-weight: bold; font-size:18px">
                <div> @lang('layout.Currency')</div>
            </td>
        </tr>

    </thead>
    <?php
    $count = 0;
    $total_per_currencys = [];
    ?>
    @foreach($account AS $record)

    <?php
    if (array_key_exists($record['Currency'], $total_per_currencys)) {

        $total_per_currencys[$record['Currency']] = $total_per_currencys[$record['Currency']] + $record['Balance'];
    } else {

        $total_per_currencys[$record['Currency']] = $record['Balance'];
    }

    ?>
    <tr>
        <td class="center">{{++$count}}</td>
        <td class="center">{{$record['accountNumber']}}</td>
        <td class="center" style=" color: black; font-weight: bolder; font-size: 25px">{{$record['AccountName']}}</td>
        <td class="center ltr">{{myRound($record['Balance'],2)}}</td>
        <td class="center">{{$record['Currency']}}</td>
    </tr>
    @endforeach
</table>
@if($total_per_currencys)
<table class="main-table">
    <tr class="bg">
        <td align="center" colspan="2">
            <b>@lang('layout.Total')</b>
        </td>
    </tr>
    <?php
    foreach ($total_per_currencys as $keycu => $val_amo) {
    ?>
        <tr>
            <td>
                <div class="center">{{$keycu}}</div>
            </td>
            <td>
                <div class="center">{{myRound($val_amo)}}</div>
            </td>

        </tr>
    <?php
    }
    ?>
</table>
@endif
@endif

<br />
@if($inventory)
<h4 style="text-align: center;">@lang('layout.InStock')</h4>
<table class="main-table">
    <thead>
        <tr class="bg">
            <th>
                <div class="center"> @lang('layout.Record') </div>
            </th>
            <th>
                <div class="center"> @lang('layout.Item') </div>
            </th>
            <th>
                <div class="center"> @lang('layout.Measure') </div>
            </th>
            <th>
                <div class="center"> @lang('layout.Quantity') </div>
            </th>
        </tr>
    </thead>
    <tbody>
        <?php
        $count = 0;
        ?>
        @foreach($inventory AS $inven)
        <tr>
            <td class="center">{{++$count}}</td>
            <td class="center">{{$inven['Name']}}</td>
            <td class="center">{{$inven['Measure']}}</td>
            <td class="center">{{myRound($inven['Quantity'])}}</td>
        </tr>
        @endforeach
    </tbody>
</table>
@endif

<!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table>

                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>

            </table>
        </td>
        @endforeach
    </tr>
</table>
<!-- End signature -->



@endsection