@extends('layouts.factor-master')
@section('style')
<style type="text/css">
  .customer_p {
    font-size: 30px;
    font-weight: bold;
    font-style: normal;
    color: #32c5d2;
  }
</style>

@stop
@section('content')
<?php

$report = customeReportNew('member_general_statement');
$_name = !in_array('name', $report);
$_phone = !in_array('phone', $report);
$_member_class = !in_array('member_class', $report);
$_receivable_home_currency = !in_array('receivable_home_currency', $report);
$_payable_home_currency = !in_array('payable_home_currency', $report);
$_balance_home_currency = !in_array('balance_home_currency', $report);
$_total_balance = !in_array('total_balance', $report);
$_currency = !in_array('currency', $report);
$_receivable = !in_array('receivable', $report);
$_payable = !in_array('payable', $report);
$_balance = !in_array('balance', $report);
$_total = !in_array('total', $report);
$_total_per_currency = !in_array('total_per_currency', $report);

$_city = !in_array('city1', $report);
$_address = !in_array('address1', $report);

$balance_per_currency_receive = [];
$balance_per_currency_payable = [];
?>

@if($data && $data !=[])


<?php


$type = $type_name;
$typeName = '';

if ($type == 'Customer') {
  $typeName = __('layout.Customer');
}
if ($type == "Vendor") {
  $typeName = __('layout.Vendor');
}
if ($type == "Employee") {
  $typeName = __('layout.Employee');
}
if ($type == "Driver") {
  $typeName = __('layout.Driver');
}


?>

@if($type)
<h3 class="table-caption" style="text-align: center;">@lang('layout.StatementDetails')-{{$typeName}}</h3>
@else
<h3 class="table-caption" style="text-align: center;">@lang('layout.StatementDetails')</h3>
@endif

@if($member_class)
<table class="main-table">
  <tr class="center">
    <td class="customer_p">@lang('layout.Class'): [{{$member_class->name}}]</td>



  </tr>
</table>
@endif

<table class="main-table">
  <tr>
    @if($from_date)
    <td>
      <span>@lang('layout.FromDate')</span>:
      <BDO DIR="LTR">{{convertDate($from_date)}}</BDO>
    </td>
    @endif
    @if($to_date)
    <td>
      <span>@lang('layout.ToDate')</span>:
      <BDO DIR="LTR">{{convertDate($to_date)}}</BDO>
    </td>
    @endif
  </tr>
</table>
<table class="main-table" style="margin: 6px 0px;" >
  @if($ClassName)
  <tr>
    <td>
      <span>@lang('menu.FinancialClass')</span>: {{$ClassName}}
    </td>
  </tr>
  @endif
</table>
<br>

<table class="main-table">
  <thead>
    <tr class="bg">
      <th>
        <div class="center">@lang('layout.Number')</div>
      </th>
      @if($_name)
      <th>
        <div class="center"> @lang('layout.Code') </div>
      </th>@endif
      @if($_name)
      <th>
        <div class="center"> @lang('layout.Name') </div>
      </th>@endif
      @if($_phone)
      <th>
        <div class="center"> @lang('layout.Phone') </div>
      </th>@endif

      @if(!$member_class)
      @if($_member_class)
      <th>
        <div class="center"> @lang('layout.Class') </div>
      </th>@endif
      @endif

      @if($_city)
      <th>
        <div class="center"> @lang('layout.City') </div>
      </th>@endif
      @if($_address)
      <th>
        <div class="center"> @lang('layout.Address') </div>
      </th>@endif
      @if($_payable_home_currency)
      <th>
        <div class="center"> @lang('layout.PayableTotal') </div>
      </th>@endif
      @if($_receivable_home_currency)
      <th>
        <div class="center"> @lang('layout.ReceivableTotal') </div>
      </th>@endif
      @if($_total_balance)
      <th>
        <div class="center"> @lang('layout.TotalBalances') {{getHomeCurrency()[getCurrencyType()]}} </div>
      </th>@endif
      @if($_currency)
      <th>
        <div class="center"> @lang('layout.Currency') </div>
      </th>@endif
      @if(isset($all_statment) && $all_statment)
      @if($_receivable)<th  class="center" ><div > @lang('layout.All') @lang('layout.Receivable') </div></th>@endif
      @if($_payable)<th class="center" ><div > @lang('layout.All') @lang('layout.Payable') </div></th>@endif
      @endif
      @if($_receivable)
      <th>
        <div class="center"> @lang('layout.Receivable') </div>
      </th>@endif
      @if($_payable)
      <th>
        <div class="center"> @lang('layout.Payable') </div>
      </th>@endif
      @if($_balance)
      <th>
        <div class="center"> @lang('layout.Balance') </div>
      </th>@endif
      @if(getLastMemberStatementDates() == 'true')
      <th>
        <div class="center"> @lang('layout.LastDate')  </div>
      </th>
      @endif
    </tr>
  </thead>
  <tbody>
    <?php
    $count = 0;
    $tempName = '';
    $totalP = 0;
    $totalR = 0;

    $name_array = [];

    $test = 0;
    ?>
    @foreach($data AS $key=>$value)


    <?php

    $result = SumToNumber($value['TotalAmountP'], $value['TotalAmountR']);

    $p = $result['a'];
    $r = $result['b'];

    if ($report_type == 'Receivable' && $p > 0) {
    } elseif ($report_type == 'Payable' && $r > 0) {
    } else {
      continue;
    }

    if ($p != 0) {
      $totalP += $p;
    } elseif ($r != 0) {
      $totalR += $r;
    }

    ?>

    @foreach($value['Currency'] AS $key1=>$rec)

    <?php

    $result1 = SumToNumber($rec['Payable'], $rec['Receivable']);
    $r1 = $result1['b'];
    $p1 = $result1['a'];
    if ($report_type == 'Payable' && $r1 != 0) {
      if (array_key_exists($key1, $balance_per_currency_receive)) {

        $balance_per_currency_receive[$key1] = $balance_per_currency_receive[$key1] + $r1;
      } else {

        $balance_per_currency_receive[$key1] = $r1;
      }
    }
    if ($report_type == 'Receivable' && $p1 != 0) {
      if (array_key_exists($key1, $balance_per_currency_payable)) {

        $balance_per_currency_payable[$key1] = $balance_per_currency_payable[$key1] + $p1;
      } else {

        $balance_per_currency_payable[$key1] = $p1;
      }
    }

    ?>

    <tr>
      <td class="center">{{++$count}}</td>
      @if($_name)<td class="center">{{$value['code']}}</td>@endif
      @if($_name)<td class="center">{{$key}}</td>@endif
      @if($_phone)<td class="center">{{$value['Phone']}}</td>@endif
      @if(!$member_class)
      @if($_member_class)<td class="center">{{$value['ClassName']}}</td>@endif
      @endif
      @if($_city)<td class="center">{{$value['City']}}</td>@endif
      @if($_address)<td class="center">{{$value['Address']}}</td>@endif

      @if($_payable_home_currency)<td class="center bg-blue">{{myRound($value['TotalAmountP'])}} {{getHomeCurrency()[getCurrencyType()]}}</td>@endif
      @if($_receivable_home_currency)<td class="center bg-blue">{{myRound($value['TotalAmountR'])}} {{getHomeCurrency()[getCurrencyType()]}}</td>@endif
      @if($_total_balance) <td class="center">
        <?php

        $result = SumToNumber($value['TotalAmountP'], $value['TotalAmountR']);

        $p = $result['a'];
        $r = $result['b'];

        if ($p != 0) {

          if (array_key_exists($key . '-' . $value['Phone'], $name_array)) {
          } else {

            $name_array[$key . '-' . $value['Phone']] = $key . '-' . $value['Phone'];
            // $totalP+=$p;
          }

          echo myRound($p) . ' ' . __('layout.Payable');
        } elseif ($r != 0) {


          if (array_key_exists($key . '-' . $value['Phone'], $name_array)) {
          } else {

            $name_array[$key . '-' . $value['Phone']] = $key . '-' . $value['Phone'];
            // $totalR+=$r;
          }

          echo myRound($r) . ' ' . __('layout.Receivable');
        } else {
          echo '0';
        }


        ?>

      </td>@endif

      @if($_currency)<td class="center">{{$key1}}</td>@endif
      @if(isset($all_statment) && $all_statment)
      @if($_receivable)<td class="center">{{myRound($rec['AllReceivable'])}}</td>@endif
      @if($_payable)<td class="center"> {{myRound($rec['AllPayable'])}}</td>@endif
      @endif
      @if($_receivable)<td class="center">{{myRound($rec['Receivable'])}}</td>@endif
      @if($_payable)<td class="center"> {{myRound($rec['Payable'])}}</td>@endif

      @if($_balance)
      <td class="center">
        <?php
        $result1 = SumToNumber($rec['Payable'], $rec['Receivable']);
        $p1 = $result1['a'];
        $r1 = $result1['b'];
        ?>
        @if($r1 !=0)
        {{myRound($r1)}}:
        @lang('layout.Receivable')

        @elseif($p1 !=0)

        {{myRound($p1)}}:
        @lang('layout.Payable')

        @endif

        <!-- 
          @if(myRound($r1)>0)
          {{myRound($r1)}}:
            @lang('layout.Receivable')

            @elseif(myRound($p1,1)>0)

            {{myRound($p1)}}:
          @lang('layout.Payable')
    
          @endif -->

      </td>
      @endif
      @if(getLastMemberStatementDates() == 'true')<td class="center bg-blue">
        @if(isset($value['dateP']))
        {{convertDate($value['dateP'])}}-@lang('layout.Payable') 
        @endif
        @if(isset($value['dateP']) && isset($value['dateR']))
        <br/>
        @endif
        @if(isset($value['dateR']))
        {{convertDate($value['dateR'])}}-@lang('layout.Receivable') 
        @endif
      </td>@endif


    </tr>
    @endforeach

    <?php

    // dd($currencies);
    ?>
    @endforeach




  </tbody>
</table>
@if($_total)
@if($totalP)
{{-- <table class="main-table bg">
  <tr>
    <td width="50%">
      <div class="center"> @lang('layout.Payable') </div>
    </td>
    <td width="50%">
      <div class="center"> {{myRound($totalP)}} {{getHomeCurrency()[getCurrencyType()]}} </div>
    </td>
  </tr>
  <tr>
</table> --}}
<table class="main-table bg">
  <tr>
  <?php if($totalR >= $totalP){ ?>
    <td  width="20%"><div class="center"> @lang('layout.Total') </div></td>
    <td  width=""><div class="center"> @lang('layout.Receivable') </div></td>
    <td  width=""><div class="center"> {{myRound($totalR - $totalP)}} {{getHomeCurrency()[getCurrencyType()]}} </div></td>
  <?php
    $totalRP = $totalR - $totalP;
  }else{ 
    $totalRP = $totalP - $totalR;
  ?>
    <td  width="20%"><div class="center"> @lang('layout.Total') </div></td>
    <td  width=""><div class="center"> @lang('layout.Payable') </div></td>
    <td  width=""><div class="center"> {{myRound($totalP - $totalR)}} {{getHomeCurrency()[getCurrencyType()]}} </div></td>
  <?php } ?>
  </tr>
  @if(isset($currency_rate) && isset($currency_total))
  @if($totalRP > 0 && $currency_rate >0 && $currency_total)
    <tr>
      <td colspan="1"><div class="center">@lang('layout.SelectedCurrency')</div></td>
      <td colspan="1"><div class="center">@lang('layout.Rate') : {{$currency_rate}} </div></td>
      <td><div class="center">{{myRound($totalRP * $currency_rate)}} {{$currency_total}}</div></td>
    </tr>
    @endif
    @endif
</table>
@endif
@if($totalR)
{{-- <table class="main-table bg">
  <tr>
    <td width="50%">
      <div class="center"> @lang('layout.Receivable') </div>
    </td>
    <td width="50%">
      <div class="center"> {{myRound($totalR)}} {{getHomeCurrency()[getCurrencyType()]}}</div>
    </td>
  </tr>
  <tr>
</table> --}}
<table class="main-table bg">
  <tr>
    <?php if ($totalR >= $totalP) { ?>
      <td width="20%">
        <div class="center"> @lang('layout.Total') </div>
      </td>
      <td width="">
        <div class="center"> @lang('layout.Receivable') </div>
      </td>
      <td width="">
        <div class="center"> {{myRound($totalR - $totalP)}} {{getHomeCurrency()[getCurrencyType()]}} </div>
      </td>
    <?php
      $totalRP = $totalR - $totalP;
    } else {
      $totalRP = $totalP - $totalR;
    ?>
      <td width="20%">
        <div class="center"> @lang('layout.Total') </div>
      </td>
      <td width="">
        <div class="center"> @lang('layout.Payable') </div>
      </td>
      <td width="">
        <div class="center"> {{myRound($totalP - $totalR)}} {{getHomeCurrency()[getCurrencyType()]}} </div>
      </td>
    <?php } ?>
  </tr>
  {{-- @if($totalRP > 0 && $currency_rate >0 && $currency_name)
  <tr>
    <td colspan="1">
      <div class="center">@lang('layout.SelectedCurrency')</div>
    </td>
    <td colspan="1">
      <div class="center">@lang('layout.Rate') : {{$currency_rate}} </div>
    </td>
    <td>
      <div class="center">{{myRound($totalRP * $currency_rate)}} {{$currency_name}}</div>
    </td>
  </tr>
  @endif --}}
  @if(isset($currency_rate) && isset($currency_total))
  @if($totalRP > 0 && $currency_rate >0 && $currency_total)
    <tr>
      <td colspan="1"><div class="center">@lang('layout.SelectedCurrency')</div></td>
      <td colspan="1"><div class="center">@lang('layout.Rate') : {{$currency_rate}} </div></td>
      <td><div class="center">{{myRound($totalRP * $currency_rate)}} {{$currency_total}}</div></td>
    </tr>
  @endif
  @endif
</table>
@endif
@endif
@endif


@if($_total_per_currency)


<table style="width: 100%; margin-top: 10px;">
  <tr>
    @if($balance_per_currency_receive)
    <td style="text-align: left; width:40%">
      <table class="main-table">
        <tr class="bg">
          <td align="center" colspan="2">
            <b>@lang('layout.Receivable')</b>
          </td>

        </tr>

        <?php
        foreach ($balance_per_currency_receive as $key => $currency) {
        ?>
          <tr>
            <td>
              <div class="center">{{$key}}</div>
            </td>
            <td>
              <div class="center">{{myRound($currency)}}</div>
            </td>

          </tr>
        <?php
        }
        ?>
      </table>
    </td>
    @endif
    @if($balance_per_currency_payable)
    <td style="text-align: right; width:30%">
      <table class="main-table">
        <tr class="bg">
          <td align="center" colspan="2"><b>@lang('layout.Payable')</b></td>
        </tr>

        <?php
        foreach ($balance_per_currency_payable as $key => $currency) {
        ?>
          <tr>
            <td>
              <div class="center">{{$key}}</div>
            </td>
            <td>
              <div class="center">{{myRound($currency)}}</div>
            </td>

          </tr>
        <?php
        }
        ?>
      </table>
    </td>
    @endif
  </tr>
</table>
@endif


<!--  signature -->
<table style="width: 100%" class="signtable">
  <tr>
    @foreach(getCompanyInfo('sign','reports') AS $info)
    <td style="text-align: left; width:40%">
      <table>

        <tr>
          <td align="right" class="signsize">{{$info['name']}}</td>
        </tr>

      </table>
    </td>
    @endforeach
  </tr>
</table>
<!-- End signature -->



@endsection