@extends('layouts.app')
@section('content')
    <div id="print-modal">
        <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show"
                      :value-type="'member_statment'"
                      @closed="closeModal">
            <div slot="body">
                <input type="hidden" name="type_name" value="Vendor"/>
                <div class="row">
                    <div class="form-group">
                        <div class="col-md-4">
                            <label class="control-label ">@lang('layout.SelectType') </label>
                            <select name="category" id="" class="form-control">
                                <option value="" selected="selected">@lang('layout.WithStatment')</option>
                                <option value="2">@lang('layout.WithoutStatment')</option>
                                <option value="3">@lang('layout.MemberWithoutTransaction')</option>
                                <option value="1">@lang('layout.All')</option>
                            </select>
                        </div>
                        <div class="col-md-4">
                            <label class="control-label ">@lang('layout.SelectMember') </label>
                            <v-select class="vue-select2"
                                      v-model="selectedMember"
                                      :multiple="true" label="name"
                                      @search="onMemberSearch"
                                      :options="memberlist">
                            </v-select>
                            <input type="hidden" name="member_id"
                                   :value="member_id.length > 0 ? member_id:null">
                        </div>
                        <div class="col-md-4">
                            <label class="control-label ">@lang('layout.SelectClass') </label>
                            <select name="class_id" id="" class="form-control">
                                <option value="">@lang('layout.SelectClass')</option>
                                @foreach($member_class as  $class)
                                    <option value="{{$class->id}}">{{$class->name}}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="col-md-12" style="padding-right: 0px !important; padding-left: 0px !important;">
                        <div class="col-md-4">
                            <label class="control-label ">@lang('layout.ReportType') </label>
                            <select name="report_type" id="" class="form-control">
                                <option value="">@lang('layout.SelectReportType')</option>
                                <option value="Receivable">@lang('layout.Payable')</option>
                                <option value="Payable">@lang('layout.Receivable')</option>
                            </select>
                        </div>
                        <div  class="col-md-4">
                            <label class="control-label ">@lang('layout.Style') </label>
                            <select name="style" class="form-control">
                                <option  value="" selected="selected">@lang('layout.Default')</option>
                                <option  value="1">@lang('layout.Style') 1</option>
                            </select>
                        </div>
                        @if(getFinancialClass() =='true') 
                        @permission('financialClass-list')
                        <div class="col-md-4">
                            <label class="control-label"> @lang('menu.FinancialClass')</label>
                            <select name="financial_class_id" class="form-control" >
                                <option value="">@lang('layout.SelectClass')</option>
                                <option value="Unclassified">Unclassified</option>
                                <option v-for="cla in financial_classes" :value="cla.id" :key="cla.id" >@{{cla.name}}</option>
                            </select>
                        </div>
                        @endpermission
                        @endif
                    </div>
                </div>
                <div class="row">
                    <div class="form-group">
                        <div class="col-md-6">
                        <label class="control-label">@lang('layout.Currency') </label>
                        <select class="form-control" v-model="selected_currency" >
                            <option v-for="curre in currencies" :value="curre">@{{ curre.code }}</option>
                        </select>
                        <input type="hidden" name="currency" v-bind:value="(selected_currency)?selected_currency.code:null"/>
                        </div>
                        <div class="col-md-6">
                        <span v-if="selected_currency">
                            <span v-if="selected_currency.code != code">
                            <label class="control-label">@lang('layout.Rate') </label>
                                    <div class="input-group">
                                        <input v-model="selected_currency.rate" class="form-control" name="currency_rate"
                                            type="number" step="any" min="0"  >
                                        <span class="input-group-addon">@{{selected_currency.symbol}}</span>
                                    </div>
                            </span>
                        </span>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="form-group">
                        <div class="col-md-4">
                            <label class="control-label ">@lang('layout.Date')</label>
                                <select name="period" v-model="period" @input="getDates()" class="form-control">
                                <option value="CustomDates">@lang('type.CustomDates')</option>
                                <option value="Today">@lang('type.Today')</option>
                                <option value="Yesterday">@lang('type.Yesterday')</option>
                                <option value="ThisWeek">@lang('type.ThisWeek')</option>
                                <option value="LastWeek">@lang('type.LastWeek')</option>
                                <option value="WeekToDate">@lang('type.WeekToDate')</option>
                                <option value="ThisMonth">@lang('type.ThisMonth')</option>
                                <option value="MonthToDate">@lang('type.MonthToDate')</option>
                                <option value="ThisQuarter">@lang('type.ThisQuarter')</option>
                                <option value="QuarterToDate">@lang('type.QuarterToDate')</option>
                                <option value="ThisYear">@lang('type.ThisYear')</option>
                                <option value="YearToDate">@lang('type.YearToDate')</option>
                            </select>
                        </div>
                        <div class="col-md-8" v-show="period == 'CustomDates'">
                            <div class="form-group">
                                <label class="control-label"> @lang('layout.Date')</label>
                                <div class="input-group">
                                    <input class="form-control date" id="range-from-example" v-model="from_date" name="from_date" autocomplete="off">
                                    <span class="input-group-addon"> @lang('layout.To') </span>
                                    <input class="form-control date" id="range-to-example" v-model="to_date" name="to_date" autocomplete="off">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </report-modal>
    </div>
    @include('vendors.modal')
    <!-- END PAGE HEADER-->

    <!-- BEGIN TAB PORTLET-->


    <div class="row">

        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase">@lang('layout.VendorList')</span>
                </div>
                <div class="tools"></div>
                <div class="pull-right">
                    @permission('vendor-export')
                    <span id="anchore-modal">
                           <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                              <i class="fa fa-print"></i>
                           </a>
                       </span>
                    @endpermission
                    @permission('vendor-create')
                    <a href="{{route('vendor.create')}}">
                        <button id="sample_editable_1_new" class="btn btn-success">
                            <i class="fa fa-plus"></i> @lang('layout.AddNew')
                        </button>
                    </a>
                    @endpermission
                </div>
            </div>
            <div class="portlet-body">

                <template v-cloak id="company_ll">
                    <company @company="setCompany"></company>
                </template>

                <table class="table table-striped table-bordered table-hover" dt-responsive
                 width="100%" cellspacing="0" width="100%" id="vendor">
                <thead>
                <tr>
                    <th>@lang('layout.Code')</th>
                    <th>@lang('layout.FullName') </th>
                    @if(getCustomerStatement() =="true")
                        <th>@lang('layout.TotalBalances') 

                            @if(getCustomerStatementType() == "currency")
                             <span></span>
                            @else
                                {{getHomeCurrency()["code"]}} 
                            @endif
                         </th>
                     @endif
                    <!-- <th>@lang('layout.Email') </th> -->
                    <th>@lang('layout.Phone') </th>
                    <!-- <th>@lang('layout.CreatedAt') </th> -->
                    <th>@lang('layout.Address')</th>
                    <th>@lang('layout.Status')</th>
                    @if(member_class_customer_list()=="true")
                    <th>@lang('layout.Class')</th>
                    @endif
                    <th>@lang('layout.User')</th>
                    <th>@lang('layout.Actions') </th>
                </tr>
                </thead>
                <tfoot>

                </tfoot>
                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>


    <!-- END TAB PORTLET-->

    <!-- END CONTENT BODY -->


@stop
@include('print.modal')
@include('groupCompanyFilter.select')
@push('scripts')
    <script src="{{URL::asset('multiple-select/js/jquery.multiselect.js')}}"></script>
    <script>
        $(document).ready(function () {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
            $('#vendor').DataTable({
                ajax: '{{route("vendor.index")}}',
                pageLength:'{{getPageRows()}}',
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                scrollCollapse: true,
                serverSide: true,
                paging: true,
                order: [["{{orderByColumn()=='number'?0:1}}", "{{getRowOrder()}}"]],
                buttons: [{
                    extend: 'excel',
                    text: '',
                    key: {
                        key: 'x',
                        altkey: true
                    }
                }],
                columns: [
                    {data: 'code', name: 'code'},
                    {data: 'name', name: 'name'},
                     @if(getCustomerStatement() =="true") {
                        data: 'totalBalances',
                        name: 'totalBalances',
                        orderable: false,
                        searchable: false
                    }, @endif
                    // {data: 'email', name: 'email'},
                    {data: 'phone', name: 'phone'},
                    // {data: 'created_at', name: 'measure', orderable: false, searchable: false},
                    {data: 'address1', name: 'member_informations.address1'},
                    {data: 'status', name: 'status'},
                    @if(member_class_customer_list()=="true")
                    {data: 'member_class', name: 'member_classes.name'},
                    @endif
                    {data: 'user', name: 'users.name'},
                    {data: 'actions', name: 'account', orderable: false, searchable: false},
//            { data: 'measure_unit_id', name: 'quantity' },
//            { data: 'measure_unit', name: 'rate' },


                ]


            });


        });
        Vue.component('v-select', VueSelect.VueSelect);


        // for new modal

        var currencies = {!! $currencies !!};
        var code = '{!! getHomeCurrency()['code'] !!}';

        var vm = new Vue({
            el: '#print-modal',
            data: {
                period: 'CustomDates',
                from_date: null,
                to_date: null,
                is_show: false,
                pdfRoute: '{!!route('export.PDFAll') !!}',
                excelRoute: '{!! route('export.ExcelAll') !!}',
                currencies: currencies,
                selected_currency: null,
                code: code,
                financial_classes: {!!getFinancialClassList()!!},
                selectedMember: [],
                memberlist: [],
                member_id: []

            },
            watch: {
                selectedMember: function (newVal, oldVal) {
                    let x = [];
                    newVal.forEach(function (e) {
                        x.push(e.id);
                    });

                    this.member_id = x;
                    console.log('x value');
                    console.log(x);
                }
            },
            methods: {
                closeModal: function () {
                    this.is_show = !this.is_show
                },

                onMemberSearch(search, loading) {
                    loading(true);
                    this.searchMember(search, loading, this);
                },

                //ajax call to get items
                searchMember(search, loading, vm) {
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'member',
                            type: 'Vendor',
                            search: search,
                        }
                    })
                        .then(function (response) {
                            this.memberlist = [];
                            if (response.data.length > 0) {
                                vm.memberlist = response.data;
                                console.log('data', vm.memberlist);
                            }
                            loading(false);
                        })
                        .catch(function (error) {
                            console.log(error);
                        })
                },
                //ajax call to get dates
                getDates() {
                    setTimeout((function () {
                    vm.getDate(vm.period);
                        // console.log(12);
                    }), 2e2);
                },
                getDate(period) {
                    if (period) {
                    // console.log(3232, period);
                    if (period != 'CustomDates') {
                        axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'getDatesByPeriod',
                            period: period,
                        }
                        })
                        .then(function(response) {
                        vm.from_date = null;
                        vm.to_date = null;
                        if (response.data) {
                            vm.from_date = response.data.start;
                            vm.to_date = response.data.end;
                            // console.log('data', response.data);
                        }
                        })
                        .catch(function(error) {
                        vm.period = 'CustomDates';
                        vm.from_date = null;
                        vm.to_date = null;
                        })
                    } else {
                        vm.from_date = null;
                        vm.to_date = null;
                    }
                    }
                },

            }
        });


        new Vue({
            el: '#anchore-modal',
            methods: {
                showModal: function () {
                    vm.$data.is_show = true;

                }
            }
        });
        // /for new modal

        new Vue({
            el: '#company_ll',
            methods: {
                setCompany: function (event) {
                    window.location.reload();
                }
            }
        });
    </script>


@endpush

@section('vselectStyle')
    <style type="text/css">
        .v-select .selected-tag {
            height: auto !important;
        }
    </style>
@endsection