@extends('layouts.app')
@section('style')
 <link rel="stylesheet" type="text/css" href="{{URL::asset('multiple-select/css/jquery.multiselect.css')}}">

@stop


@section('content')
{{-- {{dd($vendor)}} --}}
    <div class="row">


        <div class="portlet light bg-inverse">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>&nbsp;
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.Edit')  </span>
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.VendorInformation') </span> 
                </div>
            </div>
            <div class="portlet-body form">
                <!-- BEGIN FORM-->
                {!! Form::model($vendor,['method' => 'PATCH','route' => ['vendor.update',$vendor->id],'class'=>'form-horizontal','files'=> true])!!} 
               <div class="form-body">
                    <div class="row">
                        <div class="col-md-6">
                            <label class="control-label">@lang('layout.FullName')</label>
                            {!! Form::text('name', null, array('class' => 'form-control')) !!}
                        </div>
                        <!--/span-->
                        <div class="col-md-3">
                                <label class="control-label">@lang('layout.Code')</label>
                                    {!! Form::text('code', null, array('class' => 'form-control')) !!}  
                        </div>
                        <div class="col-md-3">
                                <label class="control-label">@lang('layout.Type')</label>
                                {!! Form::select('type[]', $type,$vendor->types, array('class' => 'form-control', 'multiple'=>'multiple','id'=>'type')) !!}
                        </div>
                        <!--/span-->
                    </div>
                    <div class="row" id="app">
                        <div class="col-md-6">
                                <label class="control-label">@lang('layout.AccountsReceivable')</label>
                                    <v-select :disabled="canUpdate =='canNot'" label="name" v-model="selected_receivable" :options="receivable" >
                                    </v-select>
                                    <input type="hidden" name="receivable" :value="(selected_receivable==null)?null:selected_receivable.id">
                        </div>
                        <div class="col-md-6">
                                <label class="control-label">@lang('layout.AccountsPayable')</label>
                                      <v-select :disabled="canUpdate =='canNot'" label="name" v-model="selected_payable" :options="payable"  >
                                      </v-select>
                                      <input type="hidden" name="payable" :value="(selected_payable==null)?null:selected_payable.id">
                        </div>
                    </div>
                    <div  >
                    </div>


            <br>
            <!----------------------------------------------------------------------------------
            ------------------------------------------------------------------------------------
            ----------------------Begin Other INformations--------------------------------------
            ------------------------------------------------------------------------------------>
            <div class="row">
                <div class="col-md-12">
                    <!-- BEGIN TAB PORTLET-->
                    <div class="portlet light bordered" >
                        
                        <div class="portlet-body">
                            <div class="tabbable tabbable-tabdrop">
                                <ul class="nav nav-pills"  style="background-color: rgb(236, 238, 241)">
                                    <li class="active">
                                        <a href="#tab1" data-toggle="tab" aria-expanded="false"><i class="fa fa-home"></i> @lang('layout.Address')</a>
                                    </li>
                                    <li class="">
                                        <a href="#tab2" data-toggle="tab" aria-expanded="false"><i class="fa fa-phone"></i> @lang('layout.Contacts')</a>
                                    </li>
                                    <li class="">
                                        <a href="#tab4" data-toggle="tab" aria-expanded="true"><i class="fa fa-warning"></i> @lang('layout.RiskManagement')</a>
                                    </li>
                                    <li class="">
                                        <a href="#tab5" data-toggle="tab" aria-expanded="false"><i class="fa fa-calendar"></i> @lang('layout.Date')</a>
                                    </li>
                                    <li class="">
                                        <a href="#tab6" data-toggle="tab" aria-expanded="false"><i class="fa fa-image"></i> @lang('layout.Photo')</a>
                                    </li>
                                    <li class="">
                                        <a href="#tab7" data-toggle="tab" aria-expanded="false"><i class="fa fa-bars"></i> @lang('layout.OtherInfo')</a>
                                    </li> 
                                    <li class="">
                                        <a href="#tab8" data-toggle="tab" aria-expanded="false"><i class="fa fa-archive"></i> @lang('layout.JobTitle')</a>
                                    </li> 
                                    <li class="">
                                        <a href="#tab9" data-toggle="tab" aria-expanded="false"><i class="fa fa-info-circle"></i> @lang('layout.OtherInformations')</a>
                                    </li> 
                                </ul>
                                <div class="tab-content">
                                    <div class="tab-pane active" id="tab1">
                                        <div class="row">
                                            <div class="col-md-4">
                                                    <label class="control-label ">@lang('layout.Address1')</label>
                                                    {!! Form::text('address1', null, array('placeholder' =>__('layout.Address1'),'class' => 'form-control')) !!}
                                            </div> 
                                            <div class="col-md-4">
                                                    <label class="control-label ">@lang('layout.Address2')</label>
                                                    {!! Form::text('address2', null, array('class' => 'form-control')) !!}
                                             </div>
                                             <div class="col-md-4">
                                                    <label class="control-label ">@lang('layout.PostCode')</label>
                                                    {!! Form::number('post_code', null, array('class' => 'form-control')) !!} 
                                            </div>
                                            
            
                                        </div> 
                                        <div class="row">
                                            <div class="col-md-6">
                                                  <label class="control-label">@lang('layout.City')</label>
                                                    {!! Form::text('city', null, array('class' => 'form-control')) !!}
                                          </div>
                  
                                          <div class="col-md-6" id="countries">
                                                  <label class="control-label">@lang('layout.Country')</label>
                                                  <v-select label="name" v-model="selectedCountry" :options="countries">
                                                    </v-select>
                                                    <input type="hidden" name="country" :value="(selectedCountry==null)?null:selectedCountry.name">
                                                    <input type="hidden" name="country_dial_code" :value="(selectedCountry==null)?null:selectedCountry.dial_code">
                                          </div>
                                      </div>
                                    </div>
                                    <div class="tab-pane" id="tab2">
                                        <div class="row">

                                            <div class="col-md-6" id="phone">
                                                <div class="form-group ">
                                                    <label class="control-label col-md-3">@lang('layout.Phone')</label>
                                                    <div class="col-md-7">
                                                        {!! Form::text('phone', null, array('placeholder' =>__('layout.Phone'),'class' => 'form-control')) !!}
                                                    </div>
                                                    <span class="input-group-addon" style="padding: 8px 0px;" v-if="selectedCountryPhone!=null">
                                                        @{{(selectedCountryPhone==null)?null:selectedCountryPhone.dial_code}}
                                                    </span>
                                                </div>
                                            </div>

                    
                                            <div class="col-md-6">
                                                <div class="form-group ">
                                                    <label class="control-label col-md-3">@lang('layout.Phone2')</label>
                                                    <div class="col-md-9">
                                                        {!! Form::number('phone2', null, array('tabindex' =>'4','class' => 'form-control')) !!}
                                                    </div>
                                                </div>
                                            </div>
                    
                                            <!--/span-->
                                           
                                        </div>
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                <label class="control-label col-md-3">@lang('layout.Email')</label>
                                                <div class="col-md-9">
                                                    {!! Form::text('email', null, array('class' => 'form-control','v-validate' =>'"email"','data-vv-as' => __('layout.Email'))) !!}
                                                </div>
                                            </div>
                                        </div> 
                                        </div>
                                    </div>
                                    <div class="tab-pane " id="tab4">
                                        <!---start currency----->
                                        <div class="col-md-12" style="margin-top: 8px" id="risk_management">
                                        <div class="col-md-12">
                                            <table id="table_content"  class="table table-striped table-bordered table-advance table-hover">                         
                                                <thead>
                                                    <th style="min-width: 150px">@lang('layout.ID')</th>
                                                    <th style="min-width: 150px">@lang('layout.Currency')</th>
                                                    <th style="min-width: 150px">@lang('layout.Rate')</th>
                                                    <th style="min-width: 500px">@lang('layout.Amount')</th>
                                                </thead>
                                                <tbody>
                                                    <tr v-for="currencies in currency">
                                                        <td class="hilight">
                                                            <div class="input-group">
                                                                <span>@{{currencies.id}}</span>
                                                            
                                                            </div>
                                                        </td>
                                                        <td class="hilight">
                                                            <div class="input-group">
                                                                <label>@{{currencies.code}}</label>
                                                                <input type="hidden" name="currency_code[]" :value="(!currencies)?null:currencies.code">
                                                            </div>
                                                        </td>
                                                        <td class="hilight">
                                                            <div class="input-group">
                                                                <label>@{{currencies.exchange_rate}}</label>
                                                                <input type="hidden" name="currency_rate[]" :value="(!currencies)?null:currencies.exchange_rate">
                                                            </div>
                                                        </td>
                                                        <td class="hilight">
                                                            <div class="input-group">
                                                                <input class="form-control" type="number" name="level[]" :value="(!currencies)?null:currencies.level">
                                                            </div>
                                                        </td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                        </div> 
                                        </div>
                                        <!-----end currency------>
                                    </div>
                                    <div class="tab-pane" id="tab5">
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label class="control-label col-md-3">@lang('layout.Date')</label>
                                                    <div class="col-md-9">
                                                        <input type="text" id="reg_date" name="reg_date" class="form-control date" autocomplete="off" value="{{convertDate($vendor->reg_date)}}">
                                                         
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label class="control-label col-md-3">@lang('layout.DateOfBirth')</label>
                                                    <div class="col-md-9">
                                                        <input type="text" id="date_of_birth" name="date_of_birth" class="form-control date" autocomplete="off" value="{{convertDate($vendor->date_of_birth)}}">
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="tab-pane" id="tab6">
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label class="control-label col-md-3">@lang('layout.Photo')</label>
                                                <?php
                                                    $photo = null;
                                                    if($vendor && $vendor->photo!=null)
                                                    {
                                                        $photo =  $vendor->photo;
                                                    }
                                                ?>
                                                <div class="col-md-4">
                                                    <div class="form-group">
                                                        <div class="fileinput fileinput-new" data-provides="fileinput"> 
                                                            <div class="fileinput-new thumbnail" style="width: 200px; height: 150px;">
                                                            <img src="{!!url('/uploads/'.$photo)!!}" alt=""/>
                                                        </div>
                                                            <div class="fileinput-preview fileinput-exists thumbnail"
                                                                style="max-width: 200px; max-height: 150px;"></div>
                                                            <div>
                                                                    <span class="btn default btn-file">
                                                                        <span class="fileinput-new">@lang('layout.SelectImage')</span>
                                                                        <span class="fileinput-exists">@lang('layout.Change')</span>
                                                                        <!-- <input type="file" name="photo">  -->
                                                                        {!! Form::file('photo', []) !!}</span>
                                                                {!! Form::hidden('photo1', (!$vendor)?null:$vendor->photo) !!}
                                                                <a href="javascript:;" class="btn default fileinput-exists"
                                                                data-dismiss="fileinput">@lang('layout.Remove')</a>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="tab-pane" id="tab7">
                                        <div class="row">
                                            <div class="col-md-3">
                                                <label class="control-label">@lang('layout.ReferenceNumber')</label>
                                                {!! Form::text('ref_no',null, array('placeholder' => __('layout.ReferenceNumber'),'class' => 'form-control' ,'autocomplete'=>'off')) !!}
                                            </div>
                                            <div class="col-md-3" id="memberClassDiv">
                                                <label class="control-label ">@lang('layout.Class')</label>
                                                <select name="class" class="form-control select_style">
                                                    <option value="">کلاس را انتخاب کنید</option>
                                                    @forEach($class as $key => $value)
                                                        <option value="{{$key}}" {{$vendor-> class_id == $key ? 'selected' : ''}}>{{$value}}</option>
                                                    @endforeach
                                                </select>
                                                {{-- {{Form::select('class',$class,$vendor->class_id,['class' => 'form-control','placeholder' => 'Select Class'])}} --}}
                                            </div>
                                            <div class="col-md-3">
                                                <label class="control-label">@lang('layout.IdentifyType')</label>
                                                {{-- {!! Form::text('passport', null, array('tabindex' =>'3','class' => 'form-control','autocomplete'=>'off')) !!} --}}
                                                <select name="identify_type" v-model="identify_type" id="identify_app" class="form-control">
                                                    <option value=""> @lang('layout.Select') </option>
                                                    <option value="IdentifyUnreal"> @lang('layout.IdentifyUnreal') </option>
                                                    <option value="IdentifyReal"> @lang('layout.IdentifyReal') </option>
                                                </select>
                                        </div>
                                                <div class="col-md-3">
                                                        <label class="control-label">@lang('layout.Description')</label>
                                                            <textarea name="description" class="form-control">{{$vendor->description}}</textarea>  
                                                </div>
                                            </div>
                                            <div class="row" id="genderApp">
                                                <div class="col-md-6">
                                                    <label class="control-label">@lang('layout.Gender')</label>
                                                            <div style="border: 1px dotted ;">
                                                                <label class="radio-inline">
                                                                    <input type="radio" name="gender"  value="male" v-model="type"> @lang('layout.Male') </label>
                                                                <label class="radio-inline">
                                                                    <input type="radio" name="gender" value="female"  v-model="type">
                                                                    @lang('layout.Female') </label>
                                                            </div>
                                                </div>
                                                <!--/span-->
                                                <div class="col-md-6">
                                                    <div class="form-group">
                                                        <label class="control-label">@lang('layout.Membership')</label>
                                                            <div style="border: 1px dotted ;">
                                                                <label class="radio-inline">
                                                                    <input type="radio" name="membership" value="free" v-model="members"> @lang('layout.Free') </label>
                                                                <label class="radio-inline">
                                                                    <input type="radio" name="membership" value="professiona" v-model="members">
                                                                    @lang('layout.Professional') </label>
                                                            </div>
                                                    </div>
                                                </div>
                                            </div>

            
                                    </div>
                                    <div class="tab-pane" id="tab8">
                                        <div class="row">
                                            <div class="col-md-6">
                                                 <div class="form-group">
                                                     <label class="control-label col-md-3">@lang('layout.JobTitle')</label>
                                                     <div class="col-md-9">
                                                        {!! Form::select('job_title_id[]', $jobTitle,$vendor->memberJobtitle, array('class' => 'form-control', 'multiple'=>'multiple','id'=>'job_title')) !!}
                                                     </div>
                                                 </div>
                                             </div>

                                             
                                             
                                        </div>
                                        <!--/row-->
                                    </div>
                                    <div class="tab-pane" id="tab9">
                                        <div class="row">
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <label class="control-label col-md-3">@lang('layout.LicenseNumber')</label>
                                                    <div class="col-md-9">
                                                    {!! Form::text('company_license_number', null, array('tabindex' =>'3','class' => 'form-control','autocomplete'=>'off')) !!}
                                                    </div>
                                                </div>
                                            </div> 
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <label class="control-label col-md-3">@lang('layout.LicenseIssueDate')</label>
                                                    <div class="col-md-9">
                                                        <input type="text"  name="license_issue_date"  value="{{convertDate($vendor->license_issue_date)}}" class="form-control date" autocomplete="off">
                                                    </div>
                                                </div>
                                            </div> 
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <label class="control-label col-md-3">@lang('layout.LicenseExpireDate')</label>
                                                    <div class="col-md-9">
                                                        <input type="text"  name="license_expire_date" value="{{convertDate($vendor->license_expire_date)}}"  class="form-control date" autocomplete="off">
                                                    </div>
                                                </div>
                                            </div>
                                        </div> 
                                            <div class="row">
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <label class="control-label col-md-3">@lang('layout.PassportNumber')</label>
                                                    <div class="col-md-9">
                                                    {!! Form::text('passport', null, array('tabindex' =>'3','class' => 'form-control','autocomplete'=>'off')) !!}
                                                    </div>
                                                </div>
                                            </div> 
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <label class="control-label col-md-3">@lang('layout.SSID')</label>
                                                    <div class="col-md-9">
                                                        {!! Form::text('ss_id', null, array('class' => 'form-control')) !!}
                                                    </div>
                                                </div>
                                            </div> 
                                        
                                        </div>  
            
                    
                                    <!--Begin Company Boss And Assistant Informations-->
                                        <div class="row">
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <label class="control-label col-md-3">@lang('layout.BossName')</label>
                                                    <div class="col-md-9">
                                                    {!! Form::text('boss_name', null, array('tabindex' =>'3','class' => 'form-control','autocomplete'=>'off')) !!}
                                                    </div>
                                                </div>
                                            </div> 
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <label class="control-label col-md-3">@lang('layout.BossSSN')</label>
                                                    <div class="col-md-9">
                                                        {!! Form::text('boss_ssn', null, array('class' => 'form-control')) !!}
                                                    </div>
                                                </div>
                                            </div> 
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <label class="control-label col-md-3">@lang('layout.BossPassport')</label>
                                                    <div class="col-md-9">
                                                        {!! Form::text('boss_passport', null, array('class' => 'form-control')) !!}
                                                    </div>
                                                </div>
                                            </div>
                                        </div>                    
            
                                        <div class="row">
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <label class="control-label col-md-3">@lang('layout.AssistantName')</label>
                                                    <div class="col-md-9">
                                                    {!! Form::text('assistant_name', null, array('tabindex' =>'3','class' => 'form-control','autocomplete'=>'off')) !!}
                                                    </div>
                                                </div>
                                            </div> 
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <label class="control-label col-md-3">@lang('layout.AssistantSSN')</label>
                                                    <div class="col-md-9">
                                                        {!! Form::text('assistant_ssn', null, array('class' => 'form-control')) !!}
                                                    </div>
                                                </div>
                                            </div> 
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <label class="control-label col-md-3">@lang('layout.AssistantPassport')</label>
                                                    <div class="col-md-9">
                                                        {!! Form::text('assistant_passport', null, array('class' => 'form-control')) !!}
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    <!--End Company Boss And Assistant Informations-->
            
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                
                </div>
            </div>
            
            <!----------------------------------------------------------------------------------
            ------------------------------------------------------------------------------------
            ----------------------End Other INformations--------------------------------------
            ------------------------------------------------------------------------------------>

                </div>
                <div class="form-actions">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="row">
                                <div class="col-md-offset-3 col-md-9">
                                    <button type="button" onclick="regForm(this)" class="btn green">@lang('layout.Submit')</button>
                                    <a href="{{route('vendor.index')}}" type="button" class="btn default">@lang('layout.Cancel')</a>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6"></div>
                    </div>
                </div>
            {!! Form::close() !!}
            <!-- END FORM-->
            </div>
        </div>

    </div>

@endsection
@push('scripts')

@push('scripts')

<script src="{{URL::asset('multiple-select/js/jquery.multiselect.js')}}"></script>
script>
<script>


    Vue.component('v-select', VueSelect.VueSelect);
  
  var receivable={!! $receivable !!};
  var payable={!! $payable !!};
  var customer={!! $vendor !!};
  var currency={!! json_encode($currency) !!};
  var level_info={!! json_encode($level_info) !!};

  new Vue({
    el:'#app',
    data:{
        payable:payable,
        canUpdate:"{{$canUpdate}}",
        selected_payable:null,
        receivable:receivable,
        selected_receivable:null,
        customer:customer,
        // identify_type: null
        
    },
    mounted:function(){
        // if (customer.identify_type) {
        //         this.identify_type = customer.identify_type;
        //         console.log(this.identify_type);
        //     }
        for(var j=0;j<this.payable.length;j++)
          {
              if(this.payable[j].id==this.customer.payable_id)
              {
                 this.selected_payable=this.payable[j];
              }
            //    if(this.receivable[j].id==this.customer.receivable_id)
            //   {
            //      this.selected_receivable=this.receivable[j];
            //   }
          }

          for(var r=0;r<this.receivable.length;r++)
          {
            //   if(this.payable[r].id==this.customer.payable_id)
            //   {
            //      this.selected_payable=this.payable[r];
            //   }
            if(this.receivable[r].id==this.customer.receivable_id)
              {
                  
                 this.selected_receivable=this.receivable[r];
              }
              
          }

    },

  });


  new Vue({
    el:"#risk_management",
    data:{
        currency:currency,
        level_info:level_info
    },
    mounted()
    {
        for(i=0;i<this.currency.length;i++)
            {
                for(m = 0; m < this.level_info.length ; m++)
                {
                if(this.level_info[m].code == this.currency[i].code)
                {
                    this.currency[i].level=this.level_info[m].amount;
                }
                }
            }
    }
  });

    var gen = {!! json_encode($vendor) !!}
    // console.log('asdf',gen['membership'])
    new Vue({
        el:'#genderApp',
        data:{
            type: gen['gender'],
            members: gen['membership'],
        }
    });
	
	
	var countries = {!!$countries!!};
    var selectedCountry = {!!$selectedCountry!!};
	
     new Vue({
    el:'#countries',
    data:{
        countries:countries,
        selectedCountry:selectedCountry,
    },     
	});    
    
    new Vue({
        el:'#identify_app',
        data:{
        identify_type: null
    },
    mounted:function(){
        if (customer.identify_type) {
            this.identify_type = customer.identify_type;
            // console.log(this.identify_type);
        }
    }
    });

    new Vue({
    el:'#phone',
    data:{
        selectedCountryPhone:selectedCountry
    }
   
	});

    $('#type').multiselect({
        // columns: 2,
        placeholder: "@lang('layout.SelectType')"
    });
    $('#job_title').multiselect({
        // columns: 3,
        placeholder: "@lang('layout.SelectJobTitle')",
    });
    
</script>
@endpush