@extends('layouts.factor-master')
@section('style')
    <style type="text/css">
        .customer_p{
            font-size:30px;
            font-weight:bold;
            font-style:normal;
            color: #32c5d2;
        }
    </style>

@stop
@section('content')

    <?php
    $report = customeReportNew('statement');
    
    $_date = !in_array('date', $report);
    $_transactionID = !in_array('transactionID', $report);
    $_account = !in_array('account', $report);
    $_type = !in_array('type', $report);
    $_receivable = !in_array('receivable', $report);
    $_payable = !in_array('payable', $report);
    $_currency = !in_array('currency', $report);
    $_rate = !in_array('rate', $report);
    $_discount = !in_array('discount', $report);
    $_receivable_home_currency = !in_array('receivable_home_currency', $report);
    $_payable_home_currency = !in_array('payable_home_currency', $report);
    $_description = !in_array('description', $report);
    $_item = !in_array('item', $report);
    $_name = !in_array('name', $report);
    $_quantity = !in_array('quantity', $report);
    $_measure = !in_array('measure', $report);
    $_price = !in_array('price', $report);
    $_total = !in_array('total', $report);
    $_number = !in_array('number', $report);
    $_receivable_total = !in_array('receivable_total', $report);
    $_payable_total = !in_array('payable_total', $report);
    $_details = !in_array('details', $report);
    $_balance = !in_array('balance', $report);
    $_area = !in_array('area', $report);
    $_member_class = !in_array('member_class', $report);
    $_total_item = !in_array('total_item', $report);
    $_report_total = !in_array('report_total', $report);
    $_hesab_sabiqa = !in_array('hesab_sabiqa', $report);
    $_customer_summary = !in_array('customer_summary', $report);
    $_total_home_currency = !in_array('total_home_currency', $report);
    $_customer_code = !in_array('customer_code', $report);
    $_customer_email = !in_array('customer_email', $report);
    $_customer_phone = !in_array('customer_phone', $report);
    $_customer_job = !in_array('customer_job', $report);
    $_measure1 = !in_array('measure1', $report);
    $_measure2 = !in_array('measure2', $report);
    $_ref_no = !in_array('ref_no', $report);

    ?>

    <?php
    if($member){
    ?>
    <table class="main-table">
        <tr class="center">
            <td class="customer_p">{{$member[0]->name}}</td>
            <td>@lang('layout.Code') : {{$member[0]->code}}</td>
            <td>@lang('layout.JobTitle') : {{$member[0]->job_name}}</td>
            <td>@lang('layout.Email') : {{$member[0]->email}}</td>
            <td>@lang('layout.Phone') : {{$member[0]->phone}}, {{$member[0]->phone2}}</td>

        </tr>
    </table>
    <?php
    }
    ?>
    <br>
    <?php
    $count = 0;
    $currency_data = [];
    $total_payable = 0;
    $total_receivable = 0;
    $payables = 0;
    $receivables = 0;
    $balance = 0;
    $statement_flag = '';
    $statement_flag_change = '';

    ?>
    
        <h3 class="table-caption" style="text-align: center;">@lang('layout.StatementDetails')</h3>

        @if($from_date)
            @if($_hesab_sabiqa)
            <div class="col-md-6">
                <div class="portlet sale-summary">
                    <div class="portlet-title">
                        <div class="caption font-red sbold" style="font-size: 20px"> @lang('layout.HesabSabiqa') </div>
                        <div class="tools">
                            <a class="reload" href="javascript:;"> </a>
                        </div>
                    </div>
                    <div class="portlet-body">
                        <div class="table-scrollable">
                            <table class="main-table border-blue-soft">
                                <thead>
                                <tr style="background-color: #2AB4C0">
                                    <th>
                                        <i class="fa fa-briefcase"></i> @lang('layout.Currency')
                                    </th>
                                    <th class="hidden-xs">
                                        <i class="fa fa-user"></i> @lang('layout.SReceivable')</th>
                                    <th>
                                        <i class="fa fa-briefcase"></i> @lang('layout.SPayable') </th>

                                </tr>
                                </thead>
                                <tbody>
                                <?php 

                                $from_date1 = date_create($from_date);
                                $from_date2 =  date_format(date_add($from_date1 , date_interval_create_from_date_string("-1 day")), 'Y-m-d');
                                
                                ?>
                                   
                                @foreach(getStatementDate($member[0]->id,$from_date2) AS $rec)
                                    <tr>
                                        <td class="highlight">
                                            <?php if($sum_previous_balance){ 
                                                $balance = $rec['balance'];
                                                if ($balance > 0) {
                                                    $statement_flag = 'receivable';
                                                    $statement_flag_change = 'payable';
                                                } else {
                                                    $statement_flag = 'payable';
                                                    $statement_flag_change = 'receivable';
                                                }
                                            } ?>
                                            {{$rec['currency']}}
                                        </td>
                                        <td class=""> {{ myRound($rec['invoice']) }}</td>
                                        <td> {{ myRound($rec['payment']) }}</td>

                                    </tr>
                                @endforeach
                                </tbody>
                            </table>
                        </div>

                    </div>
                </div>
            </div>

            @endif
            @endif
            <br>

        <table class="main-table">
            <thead>
            <tr class="bg">
                <td>
                    <div class="center"> @lang('layout.Record') </div>
                </td>
                @if($_transactionID)
                    <td>
                        <div class="center"> @lang('layout.TransactionID') </div>
                    </td>@endif
                @if($_date)
                    <td>
                        <div class="center"> @lang('layout.Date') </div>
                    </td>@endif
                @if($_type)
                    <td>
                        <div class="center"> @lang('layout.Type') </div>
                    </td>@endif
                    @if($_ref_no)
                    <td>
                        <div class="center"> @lang('layout.ReferenceNumber') </div>
                    </td>
                    @endif
                 @if($_area)
                    <td>
                        <div class="center"> @lang('layout.SaleArea') </div>
                    </td>@endif
                @if($_member_class)
                    <td>
                        <div class="center"> @lang('layout.MemberClass') </div>
                    </td>@endif
                @if($_receivable)
                    <td>
                        <div class="center"> @lang('layout.Receivable')</div>
                    </td>@endif
                @if($_payable)
                    <td>
                        <div class="center"> @lang('layout.Payable')</div>
                    </td>@endif
                @if($_currency)
                    <td>
                        <div class="center"> @lang('layout.Currency') </div>
                    </td>@endif
                @if($_rate)
                    <td>
                        <div class="center"> @lang('layout.Rate') </div>
                    </td>@endif
                @if($_discount)
                    <td>
                        <div class="center"> @lang('layout.Discount') </div>
                    </td>@endif

                @if($_description)
                    <td class="center">
                        <div class="center"> @lang('layout.Description') </div>
                    </td>@endif
            </tr>
            </thead>
            @if(count($memberRecord))
            @foreach($memberRecord AS $record)
                <?php

                if ($report_type) {
                    $p = 0;
                    $r = 0;
                    $tpp=0;
                    $trr=0;

                    $r = ($record->type == 'r' OR $record->type == "rr") ? $record->Amount : 0;
                    $p = ($record->type == 'p' OR $record->type == 'pp') ? $record->Amount : 0;

                    $totalg = SumToNumber($p, $r);
                    $tpp = $totalg['a'];
                    $trr = $totalg['b'];

                    if ($report_type == 'Receivable' && $tpp > 0) {
                    } elseif ($report_type == 'Payable' && $trr > 0) {
                    } else {
                        continue;
                    }
                }

                ?>
                <tr @if($record->checkout == 'yes') style="background-color: #c6ffa8" @endif >
                    <td class="center">{{++$count}}</td>
                    @if($_transactionID)
                        <td class="center">{{$record->transaction_id}}</td>
                    @endif
                    @if($_date)
                        <td class="center">{{convertDate($record->Date)}} @if($record->hour) <br/> {!! date_format(date_create($record->hour), 'h:i a') !!} @endif</td>@endif
                    @if($_type)
                        <td class="center"><span>{{__('type.'.$record->Type)}}</span>:
                            {{$record->number}}
							
							@if($record->Type=='BillRoll' && $record->orderNumber != null)
                            {{__('layout.Contract')}} ( {{$record->orderNumber}} )
                            @endif
							@if($record->Type !='BillRoll' && $record->orderNumber != null)
                            {{$record->purchases_num}} {{__('layout.Contract')}} ( {{$record->orderNumber}} )
                            @endif
							@if($record->Type !='BillRoll' && $record->purchases_num != null && $record->orderNumber == null)
                            {{$record->purchases_num}}
                            @endif
							
                            @if($record->Type=='adjustment')
                            {{adjustmentTransactionDetail($record->id)}}
                            @endif
                        </td>@endif
                    @if($_ref_no)
                    <td class="center"> {{$record->ref_no}} 
                    </td>
                    @endif
                    @if($_area)
                        <td class="center">{{$record->areaName}}</td>@endif
                    @if($_member_class)
                        <td class="center">{{$record->className}}</td>@endif
                    <?php
                    $p = 0;
                    $r = 0;
                    $r = ($record->type == 'r' OR $record->type == "rr") ? $record->Amount : 0;

                    $p = ($record->type == 'p' OR $record->type == 'pp') ? $record->Amount : 0;

                    $totalg = SumToNumber($p, $r);
                    $tpp = $totalg['a'];
                    $trr = $totalg['b'];

                    $payables += $tpp;
                    $receivables += $trr;

                    if (array_key_exists($record->Currency, $currency_data)) {

                        if(systemConfig()[30] == 1){
                            $total_payable += $tpp / $record->static_rate * $record->Rate;
                        }else{
                            $total_payable += $tpp / $record->Rate;
                        }

                        if(systemConfig()[30] == 1){
                        $total_receivable += $trr / $record->static_rate * $record->Rate;
                        }else{
                            $total_receivable += $trr / $record->Rate;
                        }

                        $p_p = $currency_data[$record->Currency]['p'];
                        $p_r = $currency_data[$record->Currency]['r'];

                        $b_p_p = $currency_data[$record->Currency]['BP'];
                        $b_p_r = $currency_data[$record->Currency]['BR'];

                        if(systemConfig()[30] == 1){
                        $currency_data[$record->Currency] = [
                            'p' => $tpp + $p_p,
                            'r' => $trr + $p_r,
                            'BP' => $b_p_p + ($tpp / $record->static_rate * $record->Rate),
                            'BR' => $b_p_r + ($trr / $record->static_rate * $record->Rate),
                        ];
                    }else{
                            $currency_data[$record->Currency] = [
                                'p' => $tpp + $p_p,
                                'r' => $trr + $p_r,
                                'BP' => $b_p_p + ($tpp / $record->Rate),
                                'BR' => $b_p_r + ($trr / $record->Rate),
                            ];
                        }


                    } else {

                        if(systemConfig()[30] == 1){
                        $total_payable += $tpp / $record->static_rate * $record->Rate;
                    }else{
                            $total_payable += $tpp / $record->Rate;
                        }

                        if(systemConfig()[30] == 1){
                            $total_receivable += $trr / $record->static_rate * $record->Rate;
                        }else{
                            $total_receivable += $trr / $record->Rate;
                        }

                        if(systemConfig()[30] == 1){
                        $currency_data[$record->Currency] = [
                            'p' => $tpp,
                            'r' => $trr,
                            'BP' => $tpp / $record->static_rate * $record->Rate,
                            'BR' => $trr / $record->static_rate * $record->Rate,
                        ];
                    }else{
                            $currency_data[$record->Currency] = [
                                'p' => $tpp,
                                'r' => $trr,
                                'BP' => $tpp / $record->Rate,
                                'BR' => $trr / $record->Rate,
                            ];

                        }
                    }


                    // begin check for balance
                    if ($statement_flag == '') {
                        if ($tpp) {
                            $statement_flag = 'payable';
                            $statement_flag_change = 'receivable';
                            if(systemConfig()[30] == 1){
                            $balance += $tpp / $record->static_rate * $record->Rate;
                        }else{
                                $balance += $tpp / $record->Rate;
                            }

                        } else {
                            $statement_flag = 'receivable';
                            $statement_flag_change = 'payable';

                            if(systemConfig()[30] == 1){
                            $balance += $trr / $record->static_rate * $record->Rate;
                        }else{
                                $balance += $trr / $record->Rate;
                            }

                        }
                    } else {
                        if ($trr) {
                            if(systemConfig()[30] == 1){
                            ($statement_flag == 'receivable') ? $balance += $trr / $record->static_rate * $record->Rate : $balance -= $trr / $record->static_rate * $record->Rate;
                            }else{
                                ($statement_flag == 'receivable') ? $balance += $trr / $record->Rate : $balance -= $trr / $record->Rate;
                            }
                        } else {
                            if(systemConfig()[30] == 1){
                            ($statement_flag == 'payable') ? $balance += $tpp / $record->static_rate * $record->Rate : $balance -= $tpp / $record->static_rate * $record->Rate;
                        }else{
                            ($statement_flag == 'payable') ? $balance += $tpp / $record->Rate : $balance -= $tpp / $record->Rate;
                        }
                        }
                    }
                    // end check balance
                    ?>
                    @if($_receivable)
                        <td class="center ltr" @if($tpp) style="background-color: #fbc0c0;" @endif >
                            <BDO DIR="LTR">
                                    {{($trr)?myRound($trr):''}}
                            </BDO>
                        </td>
                    @endif
                    @if($_payable)
                        <td class="center ltr" @if($tpp) style="background-color: #fbc0c0;" @endif >
                            <BDO DIR="LTR">
                                    {{($tpp)?myRound($tpp):''}}
                            </BDO>
                        </td>
                    @endif
                    @if($_currency)
                        <td class="center" @if($tpp) style="background-color: #fbc0c0;" @endif >{{$record->Currency}}</td>@endif
                    @if($_rate)
                        <td class="center" @if($tpp) style="background-color: #fbc0c0;" @endif >{{myRound($record->Rate)}}</td>@endif
                    @if($_discount)
                        <td class="center" @if($tpp) style="background-color: #fbc0c0;" @endif >{{$record->discount}}</td>@endif


                    @if($_description)
                        <td class="center">
                            @if(isset($report_format))
                            {{$record->Description}}
                            @else
                            {!! wordwrap($record->Description,40,"<br/>\n",false) !!}
                            @endif


                            </td>@endif
                </tr>
            @endforeach

            <tr class="bg">
                <td class="center" ></td>
                @if($_transactionID)
                    <td class="center" > </td>@endif
                @if($_date)
                <td class="center"  > </td>@endif
                @if($_type)
                <td class="center" ></td>@endif
                @if($_ref_no)
                <td class="center" ></td>
                @endif
                @if($_area)
                <td class="center" ></td>@endif
                @if($_member_class)
                <td class="center" ></td>@endif
                @if($_receivable)
                <td class="center" > @if(count($currency_data) == 1) {{myRound($receivables)}}</td>@endif @endif
                @if($_payable)
                <td class="center" >@if(count($currency_data) == 1) {{myRound($payables)}}</td>@endif @endif
                @if($_currency)
                <td class="center" ></td>@endif
                @if($_rate)
                <td class="center" ></td>@endif
                @if($_discount)
                <td class="center" ></td>@endif
                @if($_description)
                <td class="center" ></td>@endif
            </tr>

            @endif
            
            @if(count($items))
            @foreach($items AS $item)
                
                @if(!$item['items'])
                <tr @if($item['checkout'] == 'yes') style="background-color: #c6ffa8" @endif>
                    <td class="center">{{++$count}}</td>
                    @if($_transactionID)
                        <td class="center">{{$item['transaction_id']}}</td>
                    @endif
                    @if($_date)
                        <td class="center">{{convertDate($item['Date'])}}</td>
					@endif
                    @if($_type)

                        <td class="center"><span>{{__('type.'.$item['Type'])}}</span>:
                            {{$item['number']}}
							
							
                        </td>@endif
                    @if($_ref_no)
                    <td class="center"> </td>
                    @endif
                    @if($_area)<td> </td>@endif
                    @if($_member_class)<td> </td>@endif

                    <?php
                    $p = 0;
                    $r = 0;
                    $tpp=0;
                    $trr=0;

                        $r = ($item['type'] == 'r' OR $item['type'] == "rr") ? $item['Amount'] : 0;

                        $p = ($item['type'] == 'p' OR $item['type'] == 'pp') ? $item['Amount'] : 0;

                        $totalg = SumToNumber($p, $r);
                        $tpp = $totalg['a'];
                        $trr = $totalg['b'];
                      
                    //end check show

                    // begin check for balance
                    if ($statement_flag == '') {
                        if ($tpp) {
                            $statement_flag = 'payable';
                            $statement_flag_change = 'receivable';
                            if(systemConfig()[30] == 1){
                            $balance += $tpp / $item['static_rate'] * $item['Rate'];
                        }else{
                                $balance += $tpp / $item['Rate'];
                            }

                        } else {
                            $statement_flag = 'receivable';
                            $statement_flag_change = 'payable';

                            if(systemConfig()[30] == 1){
                                $balance += $trr / $item['static_rate'] * $item['Rate'];
                        }else{
                                $balance += $trr / $item['Rate'];
                            }

                        }
                    } else {
                        if ($trr) {
                            if(systemConfig()[30] == 1){
                            ($statement_flag == 'receivable') ? $balance += $trr / $item['static_rate'] * $item['Rate'] : $balance -= $trr / $item['static_rate'] * $item['Rate'];
                        }else{
                                ($statement_flag == 'receivable') ? $balance += $trr / $item['Rate'] : $balance -= $trr / $item['Rate'];
                            }
                        } else {
                            if(systemConfig()[30] == 1){
                            ($statement_flag == 'payable') ? $balance += $tpp / $item['static_rate'] * $item['Rate'] : $balance -= $tpp / $item['static_rate'] * $item['Rate'];
                        }else{
                                ($statement_flag == 'payable') ? $balance += $tpp / $item['Rate'] : $balance -= $tpp / $item['Rate'];
                            }

                        }
                    }
                    // end check balance
                    ?>
                    @if($_receivable)
                        <td class="center ltr"  @if($tpp) style="background-color: #fbc0c0;" @endif >
                            <BDO DIR="LTR">
                                    {{($trr)?myRound($trr):''}}
                            </BDO>
                        </td>
                    @endif
                    @if($_payable)
                        <td class="center ltr" @if($tpp) style="background-color: #fbc0c0;" @endif >
                            <BDO DIR="LTR">
                                    {{($tpp)?myRound($tpp):''}}
                            </BDO>
                        </td>
                    @endif
                    @if($_currency)
                        <td class="center" @if($tpp) style="background-color: #fbc0c0;" @endif >{{$item['Currency']}}</td>@endif
                    @if($_rate)
                        <td class="center" @if($tpp) style="background-color: #fbc0c0;" @endif >{{myRound($item['Rate'])}}</td>@endif
                    
                    @if($_discount)<td @if($tpp) style="background-color: #fbc0c0;" @endif > </td>@endif
                    @if($_description)
                        <td class="center">

                            @if(isset($report_format))
                            {{$item['description']}}
                            @else
                            {!! wordwrap($item['description'],40,"<br/>\n",false) !!}
                            @endif

                        </td>@endif
                </tr>
                @endif

            @endforeach
            @endif

        </table>
        <br>
    

    @if(count($items))
        <?php
        $measure_total = [];
        $measure_totalIn = [];
        $check_duplicate=[];
        ?>
        <table class="main-table">


            <tr class="bg">
                <td>
                    <div class="center"> #</div>
                </td>
                @if($_transactionID)
                    <td>
                        <div class="center"> @lang('layout.TransactionID') </div>
                    </td>@endif
                @if($_date)
                    <td>
                        <div class="center"> @lang('layout.Date') </div>
                    </td>@endif
                @if($_type)
                    <td>
                        <div class="center"> @lang('layout.Type') </div>
                    </td>@endif
                @if($_ref_no)
                <td>
                    <div class="center"> @lang('layout.ReferenceNumber') </div>
                </td>
                @endif
                @if($_receivable)
                    <td>
                        <div class="center"> @lang('layout.Receivable')  </div>
                    </td>@endif
                @if($_payable)
                    <td>
                        <div class="center"> @lang('layout.Payable') </div>
                    </td>@endif
                @if($_currency)
                    <td>
                        <div class="center"> @lang('layout.Currency') </div>
                    </td>@endif
                @if($_rate)
                    <td>
                        <div class="center"> @lang('layout.Rate') </div>
                    </td>@endif


                @if($_description)
                    <td>
                        <div class="center"> @lang('layout.Description') </div>
                    </td>@endif
                @if($_item)
                    <td>
                        <div class="center"> @lang('layout.Item') </div>
                    </td>@endif
                @if($_item)
                    <td>
                        <div class="center"> @lang('layout.Quantity') </div>
                    </td>@endif
                @if($_measure)
                    <td>
                        <div class="center"> @lang('layout.Measure') </div>
                    </td>@endif
                @if($_measure && getM2() != '')
                    <td>
                        <div class="center"> @lang('layout.Measure1') </div>
                    </td>
                @endif
                @if($_measure && getM3() != '')
                    <td>
                        <div class="center"> @lang('layout.Measure2') </div>
                    </td>
                @endif     
                @if($_item)
                    <td>
                        <div class="center"> @lang('layout.Price') </div>
                    </td>@endif
                @if($_item)
                    <td>
                        <div class="center"> @lang('layout.Total') </div>
                    </td>@endif
            </tr>
            @foreach($items AS $item)
                <?php
                $p = 0;
                $r = 0;
                $r = ($item['type'] == 'r' OR $item['type'] == "rr") ? $item['Amount'] : 0;

                $p = ($item['type'] == 'p' OR $item['type'] == 'pp') ? $item['Amount'] : 0;

                $totalg = SumToNumber($p, $r);
                $tpp = $totalg['a'];
                $trr = $totalg['b'];
                if (array_key_exists($item['Currency'], $currency_data)) {
                    if(systemConfig()[30] == 1){
                    $total_payable += $tpp / $item['static_rate'] * $item['Rate'];
                }else{
                        $total_payable += $tpp / $item['Rate'];
                    }

                    if(systemConfig()[30] == 1){
                    $total_receivable += $trr / $item['static_rate'] * $item['Rate'];
                    }else{
                        $total_receivable += $trr / $item['Rate'];
                    }

                    $p_p = $currency_data[$item['Currency']]['p'];
                    $p_r = $currency_data[$item['Currency']]['r'];

                    $b_p_p = $currency_data[$item['Currency']]['BP'];
                    $b_p_r = $currency_data[$item['Currency']]['BR'];
                    if(systemConfig()[30] == 1){
                    $currency_data[$item['Currency']] = [
                        'p' => $tpp + $p_p,
                        'r' => $trr + $p_r,
                        'BP' => $b_p_p + ($tpp / $item['static_rate'] * $item['Rate']),
                        'BR' => $b_p_r + ($trr / $item['static_rate'] * $item['Rate']),
                    ];
                }else{
                    $currency_data[$item['Currency']] = [
                        'p' => $tpp + $p_p,
                        'r' => $trr + $p_r,
                        'BP' => $b_p_p + ($tpp / $item['Rate']),
                        'BR' => $b_p_r + ($trr / $item['Rate']),
                    ];
                }
                } else {
                    if(systemConfig()[30] == 1){
                    $total_payable += $tpp / $item['static_rate'] * $item['Rate'];
                }else{
                        $total_payable += $tpp / $item['Rate'];
                    }
                    if(systemConfig()[30] == 1){
                        $total_receivable += $trr / $item['static_rate'] * $item['Rate'];
                    }else{
                        $total_receivable += $trr / $item['Rate'];
                    }

                    if(systemConfig()[30] == 1){
                    $currency_data[$item['Currency']] = [
                        'p' => $tpp,
                        'r' => $trr,
                        'BP' => $tpp / $item['static_rate'] * $item['Rate'],
                        'BR' => $trr / $item['static_rate'] * $item['Rate'],
                    ];
                }else{
                        $currency_data[$item['Currency']] = [
                            'p' => $tpp,
                            'r' => $trr,
                            'BP' => $tpp / $item['Rate'],
                            'BR' => $trr / $item['Rate'],
                        ];
                    }
                }
                ?>




                @if($item['items'])
                    @foreach($item['items'] AS $detail)

                        <?php

                        $can_show=true;

                        if(array_key_exists(__('type.'.$item['Type'].$item['number']), $check_duplicate))
                        {

                            $can_show=false;
                        }
                        else
                        {

                            $check_duplicate[__('type.'.$item['Type'].$item['number'])]=1;
                        }


                        if ($item['type'] == 'r' || $item['type'] == 'rr') {
                            if (array_key_exists($detail['ItemName'], $measure_total)) {

                                if (array_key_exists($detail['Measure'], $measure_total[$detail['ItemName']])) {
                                    $p_q = $measure_total[$detail['ItemName']][$detail['Measure']]['qty'];
                                    $p_t = $measure_total[$detail['ItemName']][$detail['Measure']]['total'];
        
                                    $measure_total[$detail['ItemName']][$detail['Measure']]['qty'] = $p_q + $detail['Qty'];
                                    $measure_total[$detail['ItemName']][$detail['Measure']]['total'] = $p_t + ($detail['Cost'] * $detail['Qty']);
                                    $measure_total[$detail['ItemName']][$detail['Measure']]['Measure'] = $detail['Measure'];
                                } else {
                                    $measure_total[$detail['ItemName']][$detail['Measure']] = [
                                        'type' => 'OutItems',
                                        'qty' => $detail['Qty'],
                                        'total' => ($detail['Cost'] * $detail['Qty']),
                                        'Measure' => $detail['Measure'],
                                    ];
                                }
                            } else {
                                $measure_total[$detail['ItemName']][$detail['Measure']] = [
                                    'type' => 'OutItems',
                                    'qty' => $detail['Qty'],
                                    'total' => ($detail['Cost'] * $detail['Qty']),
                                    'Measure' => $detail['Measure'],
                                ];
                            }
                        }

                        if ($item['type'] == 'p' || $item['type'] == 'pp') {
                            if (array_key_exists($detail['ItemName'], $measure_totalIn)) {

                                if (array_key_exists($detail['Measure'], $measure_totalIn[$detail['ItemName']])) {
                                    $p_q = $measure_totalIn[$detail['ItemName']][$detail['Measure']]['qty'];
                                    $p_t = $measure_totalIn[$detail['ItemName']][$detail['Measure']]['total'];
        
                                    $measure_totalIn[$detail['ItemName']][$detail['Measure']]['qty'] = $p_q + $detail['Qty'];
                                    $measure_totalIn[$detail['ItemName']][$detail['Measure']]['total'] = $p_t + ($detail['Cost'] * $detail['Qty']);
                                    $measure_totalIn[$detail['ItemName']][$detail['Measure']]['Measure'] = $detail['Measure'];
                                } else {
                                    $measure_totalIn[$detail['ItemName']][$detail['Measure']] = [
                                        'type' => 'InItems',
                                        'qty' => $detail['Qty'],
                                        'total' => ($detail['Cost'] * $detail['Qty']),
                                        'Measure' => $detail['Measure'],
                                    ];
                                }
                            } else {
                                $measure_totalIn[$detail['ItemName']][$detail['Measure']] = [
                                    'type' => 'InItems',
                                    'qty' => $detail['Qty'],
                                    'total' => ($detail['Cost'] * $detail['Qty']),
                                    'Measure' => $detail['Measure'],
                                ];
                            }
                        }
                        ?>


                        <tr @if($item['checkout'] == 'yes') style="background-color: #c6ffa8" @endif>
                            <td>
                                <div class="center">{{++$count}}</div>
                            </td>
                            @if($_transactionID)
                                <td class="center">{{$item['transaction_id']}}</td>
                            @endif
                            @if($_date)
                                <td class="center">{{convertDate($item['Date'])}}</td>@endif
                            @if($_type)
                                <td>
                                    <div class="center">
                                        <span>{{__('type.'.$item['Type'])}}</span><span>:</span><span>{{$item['number']}}</span>
                                    </div>
                                    @if($item['Type']=='adjustment')
                                    {{adjustmentTransactionDetail($item['id'])}}
                                    @endif
                                </td>@endif
                                @if($_ref_no)
                                <td>
                                    <div class="center"> {{$item['ref_no']}} </div>
                                </td>
                                @endif
                            @if($_receivable)
                                <td class="center ltr">
                                    <BDO DIR="LTR">
                                        @if(getReportCurrency() !=$item['Currency'] && $can_show)
                                            {{($trr)?myRound($trr):''}}
                                        @endif
                                    </BDO>
                                </td>@endif

                            @if($_payable)
                                <td class="center ltr">
                                    <BDO DIR="LTR">
                                        @if(getReportCurrency() !=$item['Currency'] && $can_show)
                                            {{($tpp)?myRound($tpp):''}}
                                        @endif
                                    </BDO>
                                </td>@endif

                            @if($_currency)
                                <td class="center">{{$item['Currency']}}</td>@endif
                            @if($_rate)
                                <td class="center">{{myRound($item['Rate'])}}</td>@endif
                            @if($_description)
                                <td class="center">

                                    @if(isset($report_format))
                                    {{$item['description']}}
                                    @else
                                    {!! wordwrap($item['description'],40,"<br/>\n",false) !!}
                                    @endif


                                    </td>@endif
                            @if($_item)
                                <td>{{$detail['ItemName']}}</td>@endif
                            @if($_item)
                                <td>{{$detail['Qty']}}</td>@endif
                            @if($_measure)
                                <td>{{$detail['Measure']}}</td>@endif
                            @if($_measure && getM2() != '')
                                <td>{{$detail['Qut_um1']}}</td>
                            @endif
                            @if($_measure && getM3() != '')
                                <td>{{$detail['Qut_um2']}}</td>
                            @endif
                            @if($_item)
                                <td>{{myRound($detail['Cost'])}}</td>@endif
                            @if($_item)
                                <td>{{myRound(($detail['Cost']*$detail['Qty']))}} {{$item['Currency']}}</td>@endif
                        <tr>
                    @endforeach
                @endif





            @endforeach
        </table>
        <?php $countIt=0; ?>
        @if(count($measure_total) || count($measure_totalIn))
            @if($_total_item)
            <table class="main-table">
                <tr class="bg">
                    <td>
                        <div class="center"> @lang('layout.Record') </div>
                    </td>
                    <td>
                        <div class="center"> @lang('layout.Type')</div>
                    </td>
                    <td>
                        <div class="center"> @lang('layout.ItemName')</div>
                    </td>
                    <td>
                        <div class="center"> @lang('layout.Measure')</div>
                    </td>
                    <td>
                        <div class="center"> @lang('layout.Quantity')</div>
                    </td>
                    <td>
                        <div class="center"> @lang('layout.TotalPrice') {{getHomeCurrency()[getCurrencyType()]}} </div>
                    </td>
                </tr>
                @if(count($measure_total))
                @foreach($measure_total AS $k=>$v)
                @if(count($v))
                @foreach($v AS $k1=>$v1)
                    <tr>
                        <td>
                            <div class="center"> {{++$countIt}} </div>
                        </td>
                        <td>
                            <div class="center"> {{__('layout.'.$v1['type'])}}</div>
                        </td>
                        <td>
                            <div class="center"> {{$k}}</div>
                        </td>
                        <td>
                            <div class="center"> {{$v1['Measure']}}</div>
                        </td>
                        <td>
                            <div class="center"> {{$v1['qty']}}</div>
                        </td>
                        <td>
                            <div class="center"> {{myRound($v1['total'])}}</div>
                        </td>
                    </tr>
                @endforeach
                @endif
                @endforeach
                @endif
                
                @if(count($measure_totalIn))
                @foreach($measure_totalIn AS $k=>$v)
                @if(count($v))
                @foreach($v AS $k1=>$v1)
                    <tr>
                        <td>
                            <div class="center"> {{++$countIt}} </div>
                        </td>
                        <td>
                            <div class="center"> {{__('layout.'.$v1['type'])}}</div>
                        </td>
                        <td>
                            <div class="center"> {{$k}}</div>
                        </td>
                        <td>
                            <div class="center"> {{$v1['Measure']}}</div>
                        </td>
                        <td>
                            <div class="center"> {{$v1['qty']}}</div>
                        </td>
                        <td>
                            <div class="center"> {{myRound($v1['total'])}}</div>
                        </td>
                    </tr>
                @endforeach
                @endif
                @endforeach
                @endif

            </table>
            @endif
        @endif
        <br>

    @endif

    <!-- begin sammary -->
    @if(count($currency_data))
        <table class="main-table">

            <tr class="bg">
                @if($_receivable_total)
                    <td>
                        <div class="center"> @lang('layout.ReceivableTotal') </div>
                    </td>@endif
                @if($_payable_total)
                    <td>
                        <div class="center"> @lang('layout.PayableTotal') </div>
                    </td>@endif
                @if($_details)
                    <td>
                        <div class="center"> @lang('layout.Details') </div>
                    </td>@endif
            </tr>

            <tr>

                <?php
                $t_payable = 0;
                $t_receivable = 0;
                $a = SumToNumber($total_payable, $total_receivable);
                $t_payable = $a['a'];
                $t_receivable = $a['b'];
                ?>
                @if($_receivable_total)
                    <td class="center ltr">{{myRound($t_receivable)}} {{getHomeCurrency()[getCurrencyType()]}}</td>@endif
                @if($_payable_total)
                    <td class="center ltr">{{myRound($t_payable)}} {{getHomeCurrency()[getCurrencyType()]}}</td>@endif

                @if($_details)
                    <td width="60%">

                        <table class="main-table" style="width:100%">
                            <tr class="bg">
                                <td width="20%">
                                    <div class="center"> @lang('layout.Currency') </div>
                                </td>
                                <td width="20%">
                                    <div class="center ltr"> @lang('layout.SReceivable') </div>
                                </td>
                                <td width="20%">
                                    <div class="center ltr"> @lang('layout.SPayable') </div>
                                </td>
                                <td width="20%">
                                    <div class="center ltr"> @lang('layout.Balance') </div>
                                </td>
                                @if ($report_type)
                                <td width="10%">
                                    <div class="center ltr"> @lang('layout.Balance') {{getHomeCurrency()[getCurrencyType()]}} </div>
                                </td>
                                <td width="10%">
                                    <div class="center ltr"> @lang('layout.Rate')  </div>
                                </td>
                                @endif
                            </tr>
                            <?php
                            $count = 0;
                            $tempName = '';
                            ?>
                            @foreach($currency_data AS $k=>$v)

                                <?php
                                $rowSpan = -1;
                                if ($tempName == $k) {
                                    $rowSpan++;
                                }
                                $tempName = $k;
                                ?>

                                <tr>
                                    <?php
                                    $bt_payable = 0;
                                    $bt_receivable = 0;
                                    $a = SumToNumber($v['p'], $v['r']);
                                    $bt_payable = $a['a'];
                                    $bt_receivable = $a['b'];

                                    $base_payable = 0;
                                    $base_receivable = 0;
                                    $b = SumToNumber($v['BP'], $v['BR']);
                                    $base_payable = $b['a'];
                                    $base_receivable = $b['b'];

                                    ?>
                                    <td class="center ltr" @if($bt_payable) style="background-color: #fbc0c0;" @endif ><BDO DIR="LTR">{{$k}}</BDO></td>
                                    <td class="center ltr" @if($bt_payable) style="background-color: #fbc0c0;" @endif ><BDO DIR="LTR">{{$v['r']}}</BDO></td>
                                    <td class="center ltr" @if($bt_payable) style="background-color: #fbc0c0;" @endif ><BDO DIR="LTR">{{$v['p']}}</BDO></td>
                                    @if($bt_receivable !=0)
                                    <td class="center ltr" >
                                        <BDO DIR="LTR">
                                            {{myRound($bt_receivable)}} {{$k}}
                                        </BDO>
                                        <span>&nbsp;@lang('layout.Receivable')&nbsp;</span>
                                    </td>
                                    @if ($report_type)
                                    <td class="center ltr" >
                                        <BDO DIR="LTR">
                                            {{myRound($base_receivable)}}
                                        </BDO>
                                    </td>
                                    <td class="center ltr" >
                                        <BDO DIR="LTR">
                                            <div class="center">{{myRound((((systemConfig()[30] == 1 && (currencyList($key)[0]->static_rate))?1:0)?((currencyList($key)[0]->static_rate)/($bt_receivable/$base_receivable)):($bt_receivable/$base_receivable)))}}</div>
                                        </BDO>
                                    </td>
                                    @endif
                                    @else
                                    <td class="center ltr" @if($bt_payable) style="background-color: #fbc0c0;" @endif >
                                        <BDO DIR="LTR">
                                            {{myRound($bt_payable)}} {{$k}}

                                        </BDO>
                                        <span>&nbsp;@lang('layout.Payable')&nbsp;</span>
                                    </td>
                                    @if ($report_type)
                                    <td class="center ltr" @if($bt_payable) style="background-color: #fbc0c0;" @endif >
                                        <BDO DIR="LTR">
                                            {{myRound($base_payable)}}
                                        </BDO>
                                    </td>
                                    <td class="center ltr" @if($bt_payable) style="background-color: #fbc0c0;" @endif >
                                        <BDO DIR="LTR">
                                            <div class="center">{{myRound((((systemConfig()[30] == 1 && (currencyList($key)[0]->static_rate))?1:0)?((currencyList($key)[0]->static_rate)/($bt_payable/$base_payable)):($bt_payable/$base_payable)))}}</div>
                                        </BDO>
                                    </td>
                                    @endif
                                    @endif
                                </tr>
                            @endforeach
                        </table>

                    </td>
                @endif
            </tr>
        </table>
    @endif
    <!-- end sammary -->


    <br>
    @if($from_date || $to_date)
        <div class="col-md-6">
            <div class="portlet sale-summary">
                <div class="portlet-title">
                    <div class="caption font-red sbold" style="font-size: 20px"> @lang('layout.CustomerSummary') </div>
                    <div class="tools">
                        <a class="reload" href="javascript:;"> </a>
                    </div>
                </div>
                <div class="portlet-body">
                    <div class="table-scrollable">
                        <table class="main-table border-blue-soft">
                            <thead>
                            <tr style="background-color: #2AB4C0">
                                <th>
                                    <i class="fa fa-briefcase"></i> @lang('layout.Currency')
                                </th>
                                <th class="hidden-xs">
                                    <i class="fa fa-user"></i> @lang('layout.Receivable')</th>
                                <th>
                                    <i class="fa fa-briefcase"></i> @lang('layout.Payable') </th>

                            </tr>
                            </thead>
                            <tbody>
                            @foreach(getStatement($member[0]->id) AS $rec)
                                <tr>
                                    <td class="highlight">
                                        {{$rec['currency']}}
                                    </td>
                                    <td class=""> {{ myRound($rec['invoice']) }}</td>
                                    <td> {{ myRound($rec['payment']) }}</td>

                                </tr>
                            @endforeach
                            </tbody>
                        </table>
                    </div>

                </div>
            </div>
        </div> 
    @endif




    @if($showFixedAsset)
    @if(count($fixedAssets) > 0)
    <table class="main-table" style="margin-top: 20px; margin-bottom: 20px;">
        <tr>
            <td class="center" colspan="10" style="padding: 10px; font-size: 16px;"> @lang('layout.FixedAsset') </td>
        </tr>
        <tr class="bg">
            <th><div class="center" > @lang('layout.Record') </div></th>
            <th ><div class="center" > @lang('layout.Number') </div></th>
            <th><div class="center" > @lang('layout.Date')</div></th> 
            <th><div class="center"  > @lang('layout.Name')</div></th> 
            <th><div class="center" > @lang('layout.Description')</div></th>
            <th><div class="center" > @lang('layout.Category')</div></th>   
            <th><div class="center" > @lang('layout.Cost')</div></th> 
            <th><div class="center" > @lang('layout.Currency')</div></th> 
            <th><div class="center" > @lang('layout.Rate')</div></th>   
            <th><div class="center" > @lang('layout.SerialNum')</div></th>  
        </tr> 
        <?php 
            $count = 0;
            $totalAmount = 0;
        ?>
        @foreach($fixedAssets as $fixedAsset)
        <?php 
            $totalAmount += $fixedAsset['Cost'];
        ?>
        <tr>
            <td class="center">{{++$count}}</td>
            <td class="center">{{$fixedAsset['number']}}</td>
            <td class="center" >{{convertDate($fixedAsset['date'])}}</td>
            <td class="center">{{$fixedAsset['name']}}</td> 
            <td>{{$fixedAsset['description']}}</td>
            <td class="center" > {{$fixedAsset['category']}}</td> 
            <td class="center" >{{ myRound($fixedAsset['Cost'])}}</td>
            <td class="center" >{{$fixedAsset['currency']}}</td>
            <th><div class="center" >{{myRound($fixedAsset['rate'])}}</div></th> 
            <td class="center" >{{$fixedAsset['serial_number']}}</td>  
        </tr>
        @endforeach
        <tr class="bg">
            <td colspan="6" class="center"> @lang('layout.Total') </td>
            <td class="center"> {{MyRound($totalAmount)}} </td>
        </tr>  
    </table>
    @endif
    @endif







           <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->
@endsection