@extends('layouts.app')
@section('style')
<link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css">
 <link rel="stylesheet" type="text/css" href="{{URL::asset('multiple-select/css/jquery.multiselect.css')}}">
 <style>

/* input:valid{
    border-color: green;
}   */
 
/* input:invalid{
    border-color: red;
} */
</style>
 
@stop
@section('content')
@include('inventories.cmodal') 
@include('customers.amodal')
    <div class="row"  id="app"  v-cloak>

        <div class="portlet light bg-inverse">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>&nbsp;
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.NewVendor') </span>
                </div>
            </div>
            <div class="portlet-body form">
                <!-- BEGIN FORM-->
                {!! Form::open(array('route' => 'vendor.store','method'=>'POST','class'=>'form-horizontal','id'=>'member-form','files'=> true,'autocomplete'=>'off')) !!}
                {{ csrf_field() }}
                <div class="form-body">
                    <div class="row">
                        <div class="col-md-6">
                                <label class="control-label">@lang('layout.FullName')</label>
                                    {!! Form::text('name', null, array('placeholder' => __('layout.FullName'),'class' => 'form-control','v-validate' =>'"required"','data-vv-as' => __('layout.FullName'))) !!} 
                                    <span class="required">@{{ errors.first('name') }}</span>
                        </div>
                        <!--/span-->
                        <div class="col-md-3">
                                <label class="control-label">@lang('layout.Code')</label>
                                    {!! Form::text('code', $code, array('placeholder' => __('layout.Code'),'class' => 'form-control')) !!}  
                        </div>
                        <div class="col-md-3">
                                <label class="control-label">@lang('layout.Type')</label>
                                <select name="type[]" multiple="multiple" class="list-style form-control" id="type">
                                    @foreach($type as $key=>$value)
                                        @if($value == __('type.Vendor'))
                                            <option selected value="{{$key}}">{{$value}}</option>
                                        @else
                                            <option value="{{$key}}">{{$value}}</option>
                                        @endif
                                    @endforeach
                                </select>
                        </div>
                        <!--/span-->
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                                <label class="control-label">@lang('layout.AccountsReceivable')</label>
                                <div class="input-group">
                                    <v-select label="name" v-model="selected_receivable" :options="receivable">
                                    </v-select>
                                    <input type="hidden" name="receivable" :value="(selected_receivable==null)?null:selected_receivable.id">
                                    <span class="btn btn-success  input-group-addon" @click="showcModalAccount = true, acount_type = 'accountsReceivable'" style="background-color:  rgb(84, 199, 211)">
                                        <i class="fa fa-plus" style="color: white"></i>
                                    </span>
                                </div>
                        </div>
                        <div class="col-md-6">
                                <label class="control-label">@lang('layout.AccountsPayable')</label>
                                <div class="input-group">
                                      <v-select label="name" v-model="selected_payable" :options="payable">
                                      </v-select>
                                      <input type="hidden" name="payable" :value="(selected_payable==null)?null:selected_payable.id">
                                      <span class="btn btn-success  input-group-addon" @click="showcModalAccount = true, acount_type = 'accountsPayable'" style="background-color:  rgb(84, 199, 211)">
                                        <i class="fa fa-plus" style="color: white"></i>
                                    </span>
                                </div>
                        </div>
                    </div>
					
                    <br>
                    <!----------------------------------------------------------------------------------
                    ------------------------------------------------------------------------------------
                    ----------------------Begin Other INformations--------------------------------------
                    ------------------------------------------------------------------------------------>
                    <div class="row">
                        <div class="col-md-12">
                            <!-- BEGIN TAB PORTLET-->
                            <div class="portlet light bordered" >
                                
                                <div class="portlet-body">
                                    <div class="tabbable tabbable-tabdrop">
                                        <ul class="nav nav-pills"  style="background-color: rgb(236, 238, 241)">

                                            <li class="active">
                                                <a href="#tab1" data-toggle="tab" aria-expanded="false"><i class="fa fa-home"></i> @lang('layout.Address')</a>
                                            </li>
                                            <li class="">
                                                <a href="#tab2" data-toggle="tab" aria-expanded="false"><i class="fa fa-phone"></i> @lang('layout.Contacts')</a>
                                            </li>
                                            <li class="">
                                                <a href="#tab3" data-toggle="tab" aria-expanded="false"><i class="fa fa-money"></i> @lang('layout.OpeningBalance')</a>
                                            </li>
                                            <li class="">
                                                <a href="#tab4" data-toggle="tab" aria-expanded="true"><i class="fa fa-warning"></i> @lang('layout.RiskManagement')</a>
                                            </li>
                                            <li class="">
                                                <a href="#tab5" data-toggle="tab" aria-expanded="false"><i class="fa fa-calendar"></i> @lang('layout.Date')</a>
                                            </li>
                                            <li class="">
                                                <a href="#tab6" data-toggle="tab" aria-expanded="false"><i class="fa fa-image"></i> @lang('layout.Photo')</a>
                                            </li>
                                            <li class="">
                                                <a href="#tab7" data-toggle="tab" aria-expanded="false"><i class="fa fa-bars"></i> @lang('layout.OtherInfo')</a>
                                            </li> 
                                            <li class="">
                                                <a href="#tab8" data-toggle="tab" aria-expanded="false"><i class="fa fa-archive"></i> @lang('layout.JobTitle')</a>
                                            </li> 
                                            <li class="">
                                                <a href="#tab9" data-toggle="tab" aria-expanded="false"><i class="fa fa-info-circle"></i> @lang('layout.OtherInformations')</a>
                                            </li>

                                            
                                        </ul>
                                        <div class="tab-content">
                                            <div class="tab-pane active" id="tab1">
                                                <div class="row">
                                                    <div class="col-md-4">
                                                            <label class="control-label ">@lang('layout.Address1')</label>
                                                            {!! Form::text('address1', null, array('placeholder' =>__('layout.Address1'),'class' => 'form-control')) !!}
                                                    </div> 
                                                    <div class="col-md-4">
                                                            <label class="control-label ">@lang('layout.Address2')</label>
                                                            {!! Form::text('address2', null, array('class' => 'form-control')) !!}
                                                    </div>
                                                    <div class="col-md-4">
                                                            <label class="control-label ">@lang('layout.PostCode')</label>
                                                            {!! Form::number('post_code', null, array('class' => 'form-control')) !!} 
                                                    </div>
                                                    

                                                </div> 
                                                <div class="row">
                                                    <div class="col-md-6">
                                                        <label class="control-label">@lang('layout.City')</label>
                                                            {!! Form::text('city', null, array('class' => 'form-control')) !!}
                                                </div>
                        
                                                <div class="col-md-6" id="countries">
                                                        <label class="control-label">@lang('layout.Country')</label>
                                                        <v-select label="name" v-model="selectedCountry" :options="countries">
                                                            </v-select>
                                                            <input type="hidden" name="country" :value="(selectedCountry==null)?null:selectedCountry.name">
                                                            <input type="hidden" name="country_dial_code" :value="(selectedCountry==null)?null:selectedCountry.dial_code">
                                                </div>
                                            </div>
                                            </div>
                                            <div class="tab-pane" id="tab2">
                                                <div class="row">
                                                    <div class="col-md-6">
                                                            <label class="control-label col-md-3">@lang('layout.Phone')</label>
                                                            <div class="col-md-7">
                                                                {!! Form::number('phone', null, array('placeholder' =>__('layout.Phone'),'class' => 'form-control')) !!}
                                                            </div>
                                                            <span class="input-group-addon" style="padding: 8px 0px;" v-if="selectedCountry!=null">
                                                                @{{(selectedCountry==null)?null:selectedCountry.dial_code}}
                                                            </span>
                                                    </div>
                            
                                                    <div class="col-md-6">
                                                        <div class="form-group ">
                                                            <label class="control-label col-md-3">@lang('layout.Phone2')</label>
                                                            <div class="col-md-9">
                                                                {!! Form::number('phone2', null, array('tabindex' =>'4','class' => 'form-control')) !!}
                                                            </div>
                                                        </div>
                                                    </div>
                            
                                                    <!--/span-->
                                                
                                                </div>
                                                <div class="row">
                                                    <div class="col-md-6">
                                                        <div class="form-group">
                                                        <label class="control-label col-md-3">@lang('layout.Email')</label>
                                                        <div class="col-md-9">
                                                            {!! Form::text('email', null, array('class' => 'form-control','v-validate' =>'"email"','data-vv-as' => __('layout.Email'))) !!}
                                                        </div>
                                                    </div>
                                                </div> 
                                                </div>
                                            </div>
                                            <div class="tab-pane " id="tab3">
                                                <!---start currency----->
                                                <div class="row" style="margin: 0px">
                                                    <table id="table_content"  class="table table-striped table-bordered table-advance table-hover">                         
                                                        <thead>
                                                                <th>#</th>
                                                                <th style="min-width: 150px">@lang('layout.Currency')</th>
                                                                <th style="min-width: 150px">@lang('layout.Rate')</th>
                                                                <th style="min-width: 300px">@lang('layout.Receivable')</th>
                                                                <th style="min-width: 300px">@lang('layout.Payable')</th>
                                                                <th style="min-width: 300px">@lang('layout.Description')</th>
                                                        </thead>
                                                        <tbody>
                                                            <tr v-for="(currencies,index) in currency">
                                                                <td class="hilight">
                                                                    <div class="input-group">
                                                                    <span>@{{currencies.id}}</span>
                                                                
                                                                    </div>
                                                                </td>
                                                                <td class="hilight">
                                                                    <div class="input-group">
                                                                    <label>@{{currencies.code}}</label>
                                                                    <input type="hidden" :name="'op_currency_code['+index+']'" :value="(!currencies)?null:currencies.code" />
                                                                    </div>
                                                                </td>
                                                                <td class="hilight">
                                                                    <input type="number" :name="'op_currency_rate['+index+']'" v-model="(!currencies)?null:currencies.exchange_rate"  :readonly="(!currencies)?null:currencies.code == defaultCurrency()['code']" class="form-control" />
                                                                </td>
                                                                <td class="hilight">
                                                                        <input type="number" :name="'op_receivable['+index+']'" class="form-control" :disabled="!!currencies.payable"
                                                                                v-model.number="currencies.receivable" />
                                                                        
                                                                        <input type="hidden" :name="'op_type['+index+']'" class="form-control"
                                                                                :value="(currencies.payable && currencies.payable !=null && currencies.payable !=0)?'payable':(currencies.receivable && currencies.receivable !=null && currencies.receivable !=0)?'receivable':''">
                                                                </td>
                                                                <td class="hilight">
                                                                    <input type="number" :name="'op_payable['+index+']'" class="form-control" :disabled="!!currencies.receivable"
                                                                            v-model.number="currencies.payable" />
                                                                    <td class="hilight">
                                                                        <textarea name="descriptionTwo[]" id="" cols="30" rows="1" class="form-control"></textarea>
                                                                    </td>
                                                                </td>
                                                            </tr>
                                                        </tbody>
                                                    </table>
                                                
                                                </div>
                                            </div>
                                            <div class="tab-pane " id="tab4">
                                                <!---start currency----->
                                                <div class="col-md-12" style="margin-top: 8px">
                                                <div class="col-md-12">
                                                    <table id="table_content"  class="table table-striped table-bordered table-advance table-hover">                         
                                                        <thead>
                                                            <th style="min-width: 150px">@lang('layout.ID')</th>
                                                            <th style="min-width: 150px">@lang('layout.Currency')</th>
                                                            <th style="min-width: 150px">@lang('layout.Rate')</th>
                                                            <th style="min-width: 500px">@lang('layout.Amount')</th>
                                                        </thead>
                                                        <tbody>
                                                            <tr v-for="currencies in currency">
                                                                <td class="hilight">
                                                                    <div class="input-group">
                                                                        <span>@{{currencies.id}}</span>
                                                                    
                                                                    </div>
                                                                </td>
                                                                <td class="hilight">
                                                                    <div class="input-group">
                                                                        <label>@{{currencies.code}}</label>
                                                                        <input type="hidden" name="currency_code[]" :value="(!currencies)?null:currencies.code">
                                                                    </div>
                                                                </td>
                                                                <td class="hilight">
                                                                    <div class="input-group">
                                                                        <label>@{{currencies.exchange_rate}}</label>
                                                                        <input type="hidden" name="currency_rate[]" :value="(!currencies)?null:currencies.exchange_rate">
                                                                    </div>
                                                                </td>
                                                                <td class="hilight">
                                                                    <div class="input-group">
                                                                        <input class="form-control" type="number" name="level[]">
                                                                    </div>
                                                                </td>
                                                            </tr>
                                                        </tbody>
                                                    </table>
                                                </div> 
                                                </div>
                                                <!-----end currency------>
                                            </div>
                                            <div class="tab-pane" id="tab5">
                                                <div class="row">
                                                    <div class="col-md-6">
                                                        <div class="form-group">
                                                            <label class="control-label col-md-3">@lang('layout.Date')</label>
                                                            <div class="col-md-9">
                                                                <input type="text" id="reg_date" name="reg_date"  class="form-control date" autocomplete="off">
                                                                
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6">
                                                        <div class="form-group">
                                                            <label class="control-label col-md-3">@lang('layout.DateOfBirth')</label>
                                                            <div class="col-md-9">
                                                                <input type="text" id="date_of_birth" name="date_of_birth" class="form-control date" autocomplete="off">
                                                                
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="tab-pane" id="tab6">
                                                <div class="col-md-3">
                                                    <div class="form-group">
                                                        <label class="control-label col-md-3">@lang('layout.Photo')</label>
                                                    

                                                        <?php
                                                        // $logo = null;
                                                        // if($company && $company->logo!=null)
                                                        // {
                                                        //     $logo =  $company->logo;
                                                        // }
                                                    ?>
                                                    <div class="col-md-4">
                                                        <div class="form-group">
                                                            <div class="fileinput fileinput-new" data-provides="fileinput"> 
                                                                <div class="fileinput-new thumbnail" style="width: 200px; height: 150px;">
                                                                <img src="#" alt=""/>
                                                            </div>
                                                                <div class="fileinput-preview fileinput-exists thumbnail"
                                                                    style="max-width: 200px; max-height: 150px;"></div>
                                                                <div>
                                                                        <span class="btn default btn-file">
                                                                            <span class="fileinput-new">@lang('layout.SelectImage')</span>
                                                                            <span class="fileinput-exists">@lang('layout.Change')</span>
                                                                            <!-- <input type="file" name="photo">  -->
                                                                            {!! Form::file('photo', []) !!}</span>
                                                                    <a href="javascript:;" class="btn default fileinput-exists"
                                                                    data-dismiss="fileinput">@lang('layout.Remove')</a>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>


                                                    </div>
                                                </div>

                                            </div>
                                            <div class="tab-pane" id="tab7">
                                                <div class="row">
                                                    <div class="col-md-3">
                                                            <label class="control-label">@lang('layout.ReferenceNumber')</label>
                                                            {!! Form::text('ref_no',null, array('placeholder' => __('layout.ReferenceNumber'),'class' => 'form-control' ,'autocomplete'=>'off')) !!}
                                                    </div>
                                                    <div class="col-md-3" id="memberClassDiv">
                                                            <label class="control-label ">@lang('layout.Class')</label>
                                                            {{Form::select('class',$class,Null,['class' => 'form-control'])}}
                                                    </div>
                                                    <div class="col-md-3">
                                                        <label class="control-label">@lang('layout.IdentifyType')</label>
                                                        {{-- {!! Form::text('passport', null, array('tabindex' =>'3','class' => 'form-control','autocomplete'=>'off')) !!} --}}
                                                        <select name="identify_type" id="" class="form-control">
                                                            <option value=""> @lang('layout.Select') </option>
                                                            <option value="IdentifyUnreal"> @lang('layout.IdentifyUnreal') </option>
                                                            <option value="IdentifyReal"> @lang('layout.IdentifyReal') </option>
                                                        </select>
                                                </div>
                                                        <div class="col-md-3">
                                                                <label class="control-label">@lang('layout.Description')</label>
                                                                    <textarea name="description" class="form-control"></textarea>  
                                                        </div>
                                                    </div>
                                                                        
                                                    <!--/row-->
                                                    <div class="row">
                                                        <div class="col-md-6">
                                                            <label class="control-label">@lang('layout.Gender')</label>
                                                                    <div style="border: 1px dotted ;">
                                                                        <label class="radio-inline">
                                                                            <input type="radio" name="gender" checked="" value="male"> @lang('layout.Male') </label>
                                                                        <label class="radio-inline">
                                                                            <input type="radio" name="gender" value="female" >
                                                                            @lang('layout.Female') </label>
                                                                    </div>
                                                        </div>
                                                        <!--/span-->
                                                        
                                                        <div class="col-md-6">
                                                                <label class="control-label">@lang('layout.Membership')</label>
                                                                    <div style="border: 1px dotted ;">
                                                                        <label class="radio-inline">
                                                                            <input type="radio" name="membership" value="free" checked=""> @lang('layout.Free') </label>
                                                                        <label class="radio-inline">
                                                                            <input type="radio" name="membership" value="professiona" >
                                                                            @lang('layout.Professional') </label>
                                                            </div>
                                                        </div>
                                                    
                                                    </div>

                                            </div>
                                            <div class="tab-pane" id="tab8">
                                                <div class="row">
                                                    <div class="col-md-6">
                                                        <div class="form-group">
                                                            <label class="control-label col-md-3">@lang('layout.JobTitle')</label>
                                                            <div class="col-md-9">
                                                                <select role="button"    name="job_title_id[]" multiple="multiple"  class="list-style form-control" id="job_title">
                                                                    @foreach($jobTitle as $key=>$value)
                                                                    
                                                                        @if($value == 'Customer')
                                                                            <option selected value="{{$key}}">{{$value}}</option>
                                                                        @else
                                                                            <option value="{{$key}}">{{$value}}</option>
                                                                        @endif
                                                                        
                                                                    @endforeach
                                                                </select>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <!--/row-->
                                            </div>
                                            <div class="tab-pane" id="tab9">
                                                <div class="row">
                                                    <div class="col-md-4">
                                                            <label class="control-label ">@lang('layout.LicenseNumber')</label>
                                                            {!! Form::text('company_license_number', null, array('tabindex' =>'3','class' => 'form-control','autocomplete'=>'off')) !!}
                                                    </div> 
                                                    <div class="col-md-4">
                                                            <label class="control-label ">@lang('layout.LicenseIssueDate')</label>
                                                            <input type="text"  name="license_issue_date"  class="form-control date" autocomplete="off">
                                                    </div> 
                                                    <div class="col-md-4">
                                                            <label class="control-label ">@lang('layout.LicenseExpireDate')</label>
                                                            <input type="text"  name="license_expire_date"  class="form-control date" autocomplete="off">
                                                    </div>
                                                </div> 
                                                    <div class="row">
                                                    <div class="col-md-4">
                                                            <label class="control-label ">@lang('layout.PassportNumber')</label>
                                                            {!! Form::text('passport', null, array('tabindex' =>'3','class' => 'form-control','autocomplete'=>'off')) !!}
                                                    </div> 
                                                    <div class="col-md-4">
                                                            <label class="control-label ">@lang('layout.SSID')</label>
                                                            {!! Form::text('ss_id', null, array('class' => 'form-control')) !!}
                                                    </div> 
                                                
                                                </div>  

                            
                                            <!--Begin Company Boss And Assistant Informations-->
                                                <div class="row">
                                                    <div class="col-md-4">
                                                            <label class="control-label ">@lang('layout.BossName')</label>
                                                            {!! Form::text('boss_name', null, array('tabindex' =>'3','class' => 'form-control','autocomplete'=>'off')) !!}
                                                    </div> 
                                                    <div class="col-md-4">
                                                            <label class="control-label ">@lang('layout.BossSSN')</label>
                                                            {!! Form::text('boss_ssn', null, array('class' => 'form-control')) !!}
                                                    </div> 
                                                    <div class="col-md-4">
                                                            <label class="control-label ">@lang('layout.BossPassport')</label>
                                                            {!! Form::text('boss_passport', null, array('class' => 'form-control')) !!}
                                                    </div>
                                                </div>                    

                                                <div class="row">
                                                    <div class="col-md-4">
                                                            <label class="control-label ">@lang('layout.AssistantName')</label>
                                                            {!! Form::text('assistant_name', null, array('tabindex' =>'3','class' => 'form-control','autocomplete'=>'off')) !!}
                                                    </div> 
                                                    <div class="col-md-4">
                                                            <label class="control-label ">@lang('layout.AssistantSSN')</label>
                                                            {!! Form::text('assistant_ssn', null, array('class' => 'form-control')) !!}
                                                    </div> 
                                                    <div class="col-md-4">
                                                            <label class="control-label ">@lang('layout.AssistantPassport')</label>
                                                            {!! Form::text('assistant_passport', null, array('class' => 'form-control')) !!}
                                                    </div>
                                                </div>
                                            <!--End Company Boss And Assistant Informations-->

                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        
                        </div>
                    </div>

                    <!----------------------------------------------------------------------------------
                    ------------------------------------------------------------------------------------
                    ----------------------End Other INformations--------------------------------------
                    ------------------------------------------------------------------------------------>
                </div>
                 
                <div class="form-actions">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="row">
                                <div class="col-md-12 text-center">
                                    <button type="button"  @click="handleSubmit($event)" class="btn green">@lang('layout.Submit')</button>
									<button type="button" class="btn blue" :disabled="disabled" @click="saveAndNew($event)">@lang('layout.SaveAndNew')</button>
                                    <a href="{{route('vendor.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6"></div>
                    </div>
                </div>
            {!! Form::close() !!}
            <!-- END FORM-->


            <!--******************************************************************************************
            **************************Begin Add New Account Form Modal************************************
            **********************************************************************************************-->

            {!! Form::open(array('method'=>'POST','class'=>'form-horizontal')) !!}
            {{ csrf_field() }}                                        
            <amodal :show="showcModalAccount" @close="showcModalAccount = false">
                <h3 slot='cheader'>@lang('layout.CreateNewAccountStep')</h3>
                <div slot="cbody">
                @if(getAccountNumber()=="true")
                    <label class="cform-label" for="name">@lang('layout.AccountNumber'):</label>
                    <input type="number" name="number" class="cform-control"  v-model="numberAcc" autocomplete="off">
                    <span class="required">@{{account_errors.number}}</span>
                @endif
                    
                    <label class="cform-label" for="name">@lang('layout.AccountName'):</label>
                    {{Form::text('name','null',['class' => 'cform-control','v-model'=>'nameAcc','autocomplete'=>'off'])}}
                    <span class="required">@{{account_errors.name}}</span>
                    
                    {{--<label class="cform-label" for="name">@lang('layout.AccountType'):</label>
                    <select name="type" v-model="typeAcc" class="form-control">
                        <option value="income">@lang('layout.Income')</option>
                        <option value="costOfGoodSold">@lang('layout.CostOfGoodSold')</option>
                        <option value="otherCurrentAsset">@lang('layout.OtherCurrenctAsset')</option>
                    </select>--}}

                    {{--<label class="cform-label" for="parent">@lang('layout.ParentID'):</label>
                    {{Form::select('parent_id',$parent,Null,['class' => 'cform-control','placeholder' => __('layout.SelectParent'),'v-model'=>'parentAcc'])}}--}}

                    <label class="cform-label" for="description">@lang('layout.Description'):</label>
                    {!! Form::textarea('description', null, array('class' => 'cform-control','rows' => 4, 'cols' => 30,'v-model'=>'descriptionAcc')) !!}
                
                </div>
                <div slot="cfooter">
                    <button type="button" class="modal-default-button btn btn-success" @click="saveAccount">
                        @lang('layout.Submit')
                    </button>
                </div>
            </amodal>


            {!! Form::close() !!}
            <!--******************************************************************************************
            ************************** End Add New Account Form Modal*************************************
            **********************************************************************************************--> 

            </div>

        </div>
    </div>
@endsection
@push('scripts')

<script src="{{URL::asset('multiple-select/js/jquery.multiselect.js')}}"></script>

<script>
    @if(App::getLocale())
    Vue.use(VeeValidate, {
        locale: '{{App::getLocale()}}',
    });
    @else
    Vue.use(VeeValidate, {
        locale: 'en',
    });
    @endif

    Vue.component('v-select', VueSelect.VueSelect);


    var Modal = Vue.component('cmodal',
    {
        template:'#cmodal-template',
        props: ['show'],
    });

    Vue.component('amodal', {
      template: '#amodal-template',
      props: ['show']
  });
 
  var receivable={!! $receivable !!};
  var payable={!! $payable !!};
  var currency={!! json_encode($currency) !!};
  var countries = {!!$countries!!};

  var vu = new Vue({
    el:'#app',
    data:{
        payable:payable,
        selected_payable:null,
        receivable:receivable,
        currency:currency,
        selected_receivable:null,
		countries:countries,
        selectedCountry:{
            id:'Afghanistan',
            name:'Afghanistan',
            dial_code:'0093'
        },
		showcModal: false,
        errorMessage: '',
        fieldErrors: [],
        className: null,
        description: null,

        //Begin Account Modal
        showcModalAccount: false,
        disabled: false,
        nameAcc: null,
        numberAcc: null,
        typeAcc: null,
        // parentAcc: null,
        descriptionAcc: null,
        acount_type:'',
        account_errors: '',
        account_success: '',
        //End Account Modal
    },

    methods:{
        handleSubmit(e) {
            this.$validator.validate().then(valid => {
                if (valid) {
                    // console.log(e);
                    // alert(e.target);
                    regForm(e.target);
                }
            });
        },


    //Function to add MemberCLass
    addClass(){
        axios.post("{{route('memberClass.store')}}",{
            name:this.className,
            description:this.description
        })
        .then(function(response){
            this.className = null;
            this.description = null;
            location.reload();
        });
        this.showcModal = false;
    },
	saveAndNew() {
		this.$validator.validate()
		.then(valid => {
			if (valid) {
                vu.disabled=true;
				var url = "{{route('vendor.store')}}";
				form_id = 'member-form';
				var data = $('#' + form_id).serialize();
				toggleBlock(true);
				axios.post(url, data)
					.then(function (response) {
						toggleBlock(0);
						if (response.data.result == 1) {
							$('#' + form_id).trigger('reset');
							//$('#success-sound')[0].play();
							toastr.success('', response.data.message);
							location.reload();
							
						}
						else {
							var message = "{{__('message.Warning')}}";
                            vu.disabled=false;
							//$('#error-sound')[0].play();
							toastr.warning('', message);
						}
					})
					.catch(function (error) {
					  toggleBlock(0);
                      vu.disabled=false;
						console.log(error);
						var message = "{{__('message.Warning')}}";
						//$('#error-sound')[0].play();
						toastr.warning('', message);
					});

			}
		})
	},
    saveAccount: function () {

    if(this.numberAcc != null)
    {
    var test = {name: this.nameAcc, description:this.descriptionAcc, parent_id: this.parentAcc,type: this.acount_type,number:this.numberAcc,add: true};

    }
    else{
        var test = {name: this.nameAcc, description:this.descriptionAcc, parent_id: this.parentAcc,type: this.acount_type,add: true};
    }
    var req = axios.post("{{route('account.addAccount')}}",test)
    .then(function (response) {
        if (response) {
            if(response.data.account.type == "accountsReceivable"){
                vu.selected_receivable = response.data.account;
            } if(response.data.account.type == "accountsPayable"){
                vu.selected_payable = response.data.account;
            } 
            



            vu.account_success = response.data.message;
            if(vu.account_success)
            {
            toastr.success(vu.account_success)

            }

                vu.showcModalAccount = false;
                vu.nameAcc           = null,
                vu.numberAcc           = null,
                vu.descriptionAcc    = null,
                // vu.parentAcc      = null,
                vu.typeAcc           = null;
                vu.acount_type       = '';
                
        }
        })
        .catch(function (error) {
            vu.account_errors = error.response.data.errors;
        

    });
    },
        
    },
    mounted:function(){
        if(this.payable)
        {
            this.selected_payable=this.payable[0];

        }
         if(this.receivable)
        {
            this.selected_receivable=this.receivable[0];
        }
    }
  });



    $('#type').multiselect({
        // columns: 2,
        placeholder: "@lang('layout.SelectType')"
    });
    $('#job_title').multiselect({
        // columns: 3,
        placeholder: "@lang('layout.SelectJobTitle')",
    });


</script>

 
@endpush