@extends('layouts.app')
@section('content')


    <!-- END PAGE HEADER-->
    @if (Session('message'))

        <div class="m-heading-1 border-green m-bordered success-action">

            
            <ul class="success-body">

                <li>{{ Session('message') }}</li>

            </ul>

        </div>

    @endif
    @if (Session('error'))

        <div class="m-heading-1 border-red m-bordered errors-action">

            <h4 class="error-title"><strong>Whoops!</strong> </h4>
            <ul class="error-body">

                <li>{{ Session('error') }}</li>

            </ul>

        </div>

    @endif

    @if (count($errors) > 0)

        <div class="m-heading-1 border-red m-bordered errors-action">

            <h4 class="error-title"><strong>Whoops!</strong>  There were some problems with your input</h4>
            <ul class="error-body">
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>

        </div>

    @endif

    <!-- BEGIN TAB PORTLET-->


    <div class="row">

        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase">@lang('layout.VendorList')</span>
                </div>
                <div class="tools"> </div>
                <div class="btn-group pull-right">

                    <a href="{{route('vendor.create')}}">
                        <!-- <button id="sample_editable_1_new" class="btn green btn-sm btn-outline"> -->
                        <button id="sample_editable_1_new" class="btn btn-success">
                            <i class="fa fa-plus"></i>@lang('layout.AddNew')
                        </button></a>
                </div>
            </div>
            <div class="portlet-body"> 
                <table class="table table-striped table-bordered table-hover" dt-responsive" cellspacing="0" id="vendor">
                    <thead>
                    <tr>
                        {{--<th>Code</th>--}}
                        {{--<th>@lang('layout.ID')</th>--}}
                        <th>@lang('layout.Name') </th>
                        <th>@lang('layout.Email') </th>
                        <th>@lang('layout.Phone') </th>
                        <th>@lang('layout.CreatedAt') </th>
                        <th>@lang('layout.UpdatedAt')</th>
                        <th>@lang('layout.Actions') </th>
                    </tr>
                    </thead>
                    <tfoot>
                     
                    </tfoot>
                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>


    <!-- END TAB PORTLET-->

    <!-- END CONTENT BODY -->


@stop

@push('scripts')

<script>

    $(document).ready(function() {
        $('#vendor').DataTable( {
            ajax:           '{{route("vendor.index")}}',
            scrollY:        450,
            scrollCollapse: true,
            serverSide: true,

            paging:         true,
            columns: [
                // { data: 'id', name: 'id' },
                { data: 'name', name: 'name' },
                { data: 'email', name: 'description' },
                { data: 'phone', name: 'percent' },
                { data: 'created_at', name: 'measure' },
                { data: 'updated_at', name: 'account' },
                { data: 'actions', name: 'account' },
//            { data: 'measure_unit_id', name: 'quantity' },
//            { data: 'measure_unit', name: 'rate' },


            ]


        } );


    } );
</script>


@endpush
