@extends('layouts.app')
@section('style')
 <link rel="stylesheet" type="text/css" href="{{URL::asset('multiple-select/css/jquery.multiselect.css')}}">
 
@stop
@section('content')
    <div class="row">
        @if (count($errors) > 0)
            <div class="m-heading-1 border-red m-bordered errors-action">
                <h4 class="error-title"><strong>Whoops!</strong> There were some problems with your input</h4>
                <ul class="error-body">
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
               </ul>
            </div>
        @endif
        <div class="portlet light bg-inverse">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.Newvendor') </span>
              
                </div>
                <div class="tools">
                    <a href="" class="collapse" data-original-title="" title=""> </a>
                    <a href="#portlet-config" data-toggle="modal" class="config" data-original-title="" title=""> </a>
                    <a href="" class="reload" data-original-title="" title=""> </a>
                    <a href="" class="remove" data-original-title="" title=""> </a>
                </div>
            </div>
            <div class="portlet-body form">
                <!-- BEGIN FORM-->
                {!! Form::open(array('route' => 'vendor.store','method'=>'POST','class'=>'form-horizontal','files'=> true)) !!}
                {{ csrf_field() }}
                <div class="form-body">
                    <h3 class="form-section">@lang('layout.PersonInfoo')</h3>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-3">@lang('layout.Name')</label>
                                <div class="col-md-9">
                                    {!! Form::text('name', null, array('placeholder' => 'Name','class' => 'form-control')) !!} 
                                </div>
                            </div>
                        </div>
                        <!--/span-->
                        <div class="col-md-6">
                            <div class="form-group ">
                                <label class="control-label col-md-3">@lang('layout.Email')</label>
                                <div class="col-md-9">
                                    {!! Form::text('email', null, array('placeholder' => 'Email','class' => 'form-control')) !!}
                                </div>
                            </div>
                        </div>
                        <!--/span-->
                    </div>
                    <!--/row-->
                    <div class="row">
                        <div class="col-md-6">
                             <div class="form-group">
                                <label class="control-label col-md-3">@lang('layout.Gender')</label>
                                <div class="col-md-9">
                                    <div >
                                        <label class="radio-inline">
                                            <input type="radio" name="gender" checked="" value="male"> @lang('layout.Male') </label>
                                        <label class="radio-inline">
                                            <input type="radio" name="gender" value="female" >
                                            @lang('layout.Female') </label>
                                    </div>
                                </div>
                            </div>
                        </div> 
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-3">@lang('layout.DateOfBirth')</label>
                                <div class="col-md-9">
                                    <div class="input-group input-medium date date-picker" data-toggle="toggle" data-date-format="dd-mm-yyyy" data-date-start-date="+0d">
                                        <input name="date_of_birth" type="text" class="form-control" readonly>
                                        <span class="input-group-btn">
                                            <button class="btn default" type="button">
                                                <i class="fa fa-calendar"></i>
                                            </button>
                                         </span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!--/row-->
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-3">@lang('layout.Code')</label>
                                <div class="col-md-9">
                                    {!! Form::text('code', null, array('placeholder' => 'Code','class' => 'form-control')) !!}  
                                </div>
                            </div>
                        </div>
                        <!--/span-->
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-3">@lang('layout.Membership')</label>
                                <div class="col-md-9">
                                    <div>
                                        <label class="radio-inline">
                                            <input type="radio" name="membership" value="free" checked=""> @lang('layout.Free') </label>
                                        <label class="radio-inline">
                                            <input type="radio" name="membership" value="professiona" >
                                            @lang('layout.Professional') </label>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-3">@lang('layout.Date')</label>
                                <div class="col-md-9">
                                     <div class="input-group input-medium date date-picker" data-toggle="toggle" data-date-format="dd-mm-yyyy" data-date-start-date="+0d">
                                        <input name="reg_date" type="text" class="form-control" readonly>
                                        <span class="input-group-btn">
                                            <button class="btn default" type="button">
                                                <i class="fa fa-calendar"></i>
                                            </button>
                                         </span>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-3">@lang('layout.Photo')</label>
                                <div class="col-md-9">
                                    {!! Form::file('photo', null, array('placeholder' => 'mm/dd/yy','class' => 'form-control')) !!}  
                                </div>
                            </div>
                        </div> 
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-3">@lang('layout.Type')</label>
                                <div class="col-md-9">
                                <select name="type[]" multiple="multiple" class="list-style form-control" id="type">
                                    @foreach($type as $key=>$value)
                                        @if($value == 'Employee')
                                            <option selected value="{{$key}}">{{$value}}</option>
                                        @else
                                            <option value="{{$key}}">{{$value}}</option>
                                        @endif
                                    @endforeach
                                </select>
                                </div>
                            </div>
                        </div>
                         <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-3">@lang('layout.Class')</label>
                                <div class="col-md-9">
                                     {{Form::select('class',$class,Null,['class' => 'form-control','placeholder' => 'Select Class'])}}
                                </div>
                            </div>
                        </div>
                    </div> 
                    <h3 class="form-section">@lang('layout.Address')</h3>
                    <!--/row-->
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-3">@lang('layout.Address1')</label>
                                <div class="col-md-9">
                                  {!! Form::text('address1', null, array('placeholder' => 'Address 1','class' => 'form-control')) !!}
                                </div>
                            </div>
                        </div> 
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-3">@lang('layout.Address2')</label>
                                <div class="col-md-9">
                                    {!! Form::text('address2', null, array('placeholder' => 'Address 2','class' => 'form-control')) !!}
                                </div>
                            </div>
                         </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group ">
                                <label class="control-label col-md-3">@lang('layout.Phone')</label>
                                <div class="col-md-9">
                                    {!! Form::text('phone', null, array('placeholder' => 'phone','class' => 'form-control')) !!}
                                </div>
                            </div>
                        </div>
                        <!--/span-->
                         <div class="col-md-6">
                            <div class="form-group ">
                                <label class="control-label col-md-3">@lang('layout.City')</label>
                                <div class="col-md-9">
                                    {!! Form::text('city', null, array('placeholder' => 'City','class' => 'form-control')) !!}
                                </div>
                            </div>
                        </div>
                    </div>
                    <!--/row-->
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-3">@lang('layout.Postcode')</label>
                                <div class="col-md-9">
                                     {!! Form::text('post_code', null, array('placeholder' => 'Post Code','class' => 'form-control')) !!}
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-3 ">@lang('layout.Country')</label>
                                <div class="col-md-9">
                                    <select  class="form-control" name="country">
                                        <option value="af">@lang('layout.Afghanistan')</option>
                                        <option value="ir">@lang('layout.Iran')</option>
                                        <option value="pak">@lang('layout.Pakistan')</option>
                                        <option value="ch">@lang('layout.China')</option>
                                        <option value="us">@lang('layout.UN')</option>
                                        <option value="rs">@lang('layout.Russia')</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <!--/span-->
                    </div>
                    <!--/row-->
                </div>
                 
                <div class="form-actions">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="row">
                                <div class="col-md-offset-3 col-md-9">
                                    <button type="button" onclick="regForm(this)" class="btn green">@lang('layout.Submit')</button>
                                    <button type="button" class="btn default">@lang('layout.Cancel') </button>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6"></div>
                    </div>
                </div>
            {!! Form::close() !!}
            <!-- END FORM-->
            </div>
        </div>

    </div>


@endsection
@push('scripts')

<script src="{{URL::asset('multiple-select/js/jquery.multiselect.js')}}"></script>

<script>
    $('#type').multiselect({
        columns: 4,
        placeholder: 'Select Type'
    });

</script>

<script>

$('.date-picker').datepicker({
            autoclose: true
        });
</script>
@endpush