@extends('layouts.factor-master')
@section('content')

<span>
</span>
<table class="main-table">
  @if($info && $info !=[])

  <thead>
    <tr>
      <th>
        <i class="fa  fa-bars"></i> @lang('layout.ReferenceNumber')</th>
        <th>@lang('layout.PaletNumber')</th>
        <th>@lang('layout.VehicleName')</th>
      <th>
        <i class="fa fa-clock-o"></i> @lang('layout.Date')
      </th>
      <th>
        <i class="fa fa-file-excel-o"></i> @lang('layout.Description')
      </th>
      <th>
        <i class="fa fa-money"></i> @lang('layout.Total')
      </th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td class="hidden-xs"> {{ $info->ref_no }} </td>
      <td class="hidden-xs"> {{ $info->vehicle_name }} </td>
      <td class="hidden-xs"> {{ $info->palet_number }} </td>
      <td class="hidden-xs"> {{ convertDate($info->date) }} </td>
      <td class="hidden-xs"> {{ $info->description }} </td>
      <td class="hidden-xs"> {{ $info->total }} {{Currency()->code}} </td>

    </tr>
  </tbody>
  @endif
</table>

<h3 class="table-caption" style="text-align: center;">@lang('layout.VehicleOilSaleReport')</h3>
<table class="main-table">

  <tr class="bg">
    <td>
      <div class="center">  @lang('layout.Record') </div>
    </td>
    <th>@lang('layout.ItemName')</th>
    <th>@lang('layout.Site')</th>
    <th>@lang('layout.MeasureUnit')</th>
    <th>@lang('layout.Quantity')</th>
    <th>@lang('layout.Price')</th>
  </tr>
  <?php
  $count = 0;
  $total = 0;
  ?>
  @foreach($data AS $record)
  <?php
  $total += $record->quantity;
  ?>
  <tr>
    <td class="center">{{++$count}}</td>
    <td class="center">{{$record->item}}</td>
    <td class="center">{{$record->site}}</td>
    <td class="center">{{$record->measure}}</td>
    <td class="center">{{$record->quantity}}</td>
    <td class="center">{{$record->cost}}</td>
  </tr>
  @endforeach
  <tr>
    <td class="center" colspan="3">@lang('layout.Total')</td>
    <td class="center" colspan="2">{{$total}}</td>
    <td class="center" colspan="1"></td>
  </tr>
</table>

<!--  signature -->
<table style="width: 100%" class="signtable">
  <tr>
    @foreach(getCompanyInfo('sign','reports') AS $info)
    <td style="text-align: left; width:40%">
      <table>

        <tr>
          <td align="right" class="signsize">{{$info['name']}}</td>
        </tr>

      </table>
    </td>
    @endforeach
  </tr>
</table>
<!-- End signature -->
@endsection