@extends('layouts.app')

@section('content')



<div id="print-modal">
    <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show" 
        :value-type="'vehicle_log_book'"
        @closed="closeModal">

        <div slot="body">
		
		<!----------------------------------------------
		----Begin Report Body And Custome Report-------
		----------------------------------------------->
		<div class="row" v-cloak>
				 <div class="tabbable tabbable-tabdrop">

					<ul class="nav nav-tabs">
						
						<li class="active">
							<a href="#tab1" data-toggle="tab" id="tab_main">@lang('menu.Report')</a>
						</li>
						@if(systemConfig()[2] != 0 )
                                @permission(['customreport-list'])
                        <li class="">
                            <a href="#tab2" data-toggle="tab" id="tab_custome">@lang('layout.CustomReportM')</a>
                        </li>
                        @endpermission
                        @endif
					</ul>
					<div class="tab-content">
						 <div class="tab-pane active" id="tab1"> 
								<div class="portlet light bordered">
										<!--Begin Report Type-->
										<div class="row">
											<div class="form-group">

												  <div class="col-md-6">
														<label class="control-label ">@lang('menu.Vehicle') </label>
														<select name="vehicle_id" id="" class="form-control">
															<option value="">@lang('menu.Vehicle')</option>
															@foreach($vehicle as  $v)
																<option value="{{$v->id}}">{{$v->vehicle_name}}</option>
															@endforeach
														</select>
													</div>
											</div>


										</div>

										<div class="row">
											<div class="form-group">
												<div class="col-md-12">
													<div class="form-group">
														<label class="control-label"> @lang('layout.Date')</label>
														<div class="input-group">
															<input class="form-control date" id="range-from-example" name="from_date" autocomplete="off">
														   
															<span class="input-group-addon"> @lang('layout.To') </span>
															<input class="form-control date" id="range-to-example" name="to_date" autocomplete="off">
															
														</div>
													</div>
												</div>
											</div>
										</div>
										
										<!--End Report Type--> 
								</div>
						</div> 

						<div class="tab-pane" id="tab2"> 
						   <div class="portlet light bordered">
								<div class="portlet-body">

									<form  id="saveCustomeReport" role="form" action="{{route('customeReport.storeCustomeReport')}}" method="post" >
										@csrf
										<input type="hidden" name="part_name" value="vehicle_log_books_index">


										<div class="col-md-12 col-sm-12 col-xs-12">

											<div class="mt-checkbox-inline col-md-2" v-for="(row,itemIndex) in customReportData">
                                                <div class="form-group">
                                                    <table class="table table-striped table-bordered table-advance table-hover">
                                                                    <tr>
                                                                        <td style="text-align: center;">@{{ row.Name }}</td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td style="text-align: center;">
                                                                            <input type="hidden" :name="'column_name['+itemIndex+']'" class="form-control" v-model="row.column_name">
    
    
                                                                            <label class="switch">
                                                                                <input type="checkbox" :name="'column_status['+itemIndex+']'" 
                                                                                :checked="row.checkedColumn" >
                                                                                <span class="slider round"></span>
                                                                            </label>
                                                                            <select :name="'column_percentage['+itemIndex+']'" v-model="row.column_percentage" class="form-control" style="width: 90%;">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="2">2 %</option>
                                                                                <option value="6">6 %</option>
                                                                                <option value="10">10 %</option>
                                                                                <option value="15">15 %</option>
                                                                                <option value="20">20 %</option>
                                                                                <option value="25">25 %</option>
                                                                                <option value="30">30 %</option>
                                                                                <option value="40">40 %</option>
                                                                                <option value="50">50 %</option>
                                                                                <option value="60">60 %</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                    </div>
											</div>
										</div>
										<div class="margiv-top-10">
											<!-- <button type="button" onclick="regForm(this)" class="btn green"> <i class="fa fa-save"></i> </button> -->

											<button type="button" onclick="saveCustomeReport(this)" class="btn blue"> <i class="fa fa-save"></i> </button>
										</div>
								</form>
								</div>
						</div>
				</div>
				</div>
			</div>
		</div>
		<!----------------------------------------------
		----Begin Report Body And Custome Report-------
		----------------------------------------------->
									
									


        </div>            
    </report-modal>
</div>

    <!-- END PAGE HEADER-->


    

    <div class="row">
        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase">@lang('layout.VehicleLogBookList')</span>
                </div>
                <div class="tools"> </div>
                <div class="pull-right">
                     <span id="anchore-modal">
                         <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                            <i class="fa fa-print"></i>
                         </a>
                     </span>
                    @permission('VehicleLogBook-create')
                        <a href="{{route('vehicleLogBook.create')}}">
                            <!-- <button id="sample_editable_1_new" class="btn green btn-sm btn-outline"> -->
                            <button id="sample_editable_1_new" class="btn btn-success">
                                <i class="fa fa-plus"></i> @lang('layout.AddNew')
                            </button></a>
                    @endpermission    
                </div>
            </div>
            <div class="portlet-body">
                <template v-cloak id="company_ll">
                    <company @company="setCompany"></company>
                </template>
                <table class="table table-striped table-bordered table-hover" id="vehicleLogBooks">
                    <thead>
                    <tr>
                        <th>@lang('layout.Number')</th>
                        <th>@lang('layout.Driver')</th>
                        <th>@lang('layout.VehicleName')</th>
                        <th>@lang('layout.PlateNumber')</th>
                        <th>@lang('layout.Traveller')</th>
                        <th>@lang('layout.Source')</th>
                        <th>@lang('layout.Destination')</th>
                        <th>@lang('layout.StartOdometer')</th>
                        <th>@lang('layout.FinishOdometer')</th>
                        <th>@lang('layout.Date')</th>
                        <th>@lang('layout.StartTripDate')</th>
                        <th>@lang('layout.EndTripDate')</th>
                        <th>@lang('layout.Description')</th>
                        <th>@lang('layout.User')</th>
                        <th>@lang('layout.Actions')</th>
                    </tr>
                    </thead>
                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>


    <!-- END TAB PORTLET-->

    <!-- END CONTENT BODY -->


@stop
@include('print.modal')
@include('groupCompanyFilter.select')
@push('scripts')
<script>
var cust_rep = {!!customeReportNewData('vehicle_log_books_index')!!};

    $(document).ready(function() {
        $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
        $('#vehicleLogBooks').DataTable( {
            ajax:'{{route("vehicleLogBook.index")}}',
            pageLength:'{{getPageRows()}}',
            order: [["{{orderByColumn()=='number'?2:8}}", "{{getRowOrder()}}"]],
            responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
            scrollCollapse: true,
            paging:         true,
            serverSide: true,


            columns: [  
                { data: 'number',          name: 'vehicle_log_books.number'},
                { data: 'name',         name: 'members.name' },
                { data: 'vehicle_name', name: 'vehicles.vehicle_name'  },
                { data: 'palet_number', name: 'vehicles.palet_number'  },
                { data: 'traveller',          name: 'vehicle_log_books.traveller'},
                { data: 'source',          name: 'vehicle_log_books.source'},
                { data: 'destination',          name: 'vehicle_log_books.destination'},
                { data: 'start_odometer',          name: 'vehicle_log_books.start_odometer'},
                { data: 'finish_odometer',          name: 'vehicle_log_books.finish_odometer'},
                { data: 'Date',         name: 'vehicle_log_books.date'},
                { data: 'start_trip_date',         name: 'vehicle_log_books.start_trip_date'},
                { data: 'end_trip_date',         name: 'vehicle_log_books.end_trip_date'},
                { data: 'description',  name: 'vehicle_log_books.description'},
                { data: 'user',  name: 'users.name'},
                { data: 'actions',      name: 'actions',orderable:false,searchable:false }
            ]
        });
    });
      Vue.component('v-select', VueSelect.VueSelect)


      // new for modal


var vm =new Vue({
            el: '#print-modal',
            data:{
                is_show:false,
                pdfRoute: '{!!route('export.PDFAll') !!}',
                excelRoute: '{!! route('export.ExcelAll') !!}',
				 customReportData:
                [
                 
                 {Name: '@lang("layout.Number")', column_name: 'number',checkedColumn:(cust_rep.number)?'checked':'',column_percentage:(cust_rep.number___percent)?cust_rep.number___percent:''},
                 {Name: '@lang("layout.Driver")', column_name: 'driver',checkedColumn:(cust_rep.driver)?'checked':'',column_percentage:(cust_rep.driver___percent)?cust_rep.driver___percent:''},
                 {Name: '@lang("layout.Description")', column_name: 'description',checkedColumn:(cust_rep.description)?'checked':'',column_percentage:(cust_rep.description___percent)?cust_rep.description___percent:''},
                 {Name: '@lang("layout.VehicleName")', column_name: 'vehicleName',checkedColumn:(cust_rep.vehicleName)?'checked':'',column_percentage:(cust_rep.vehicleName___percent)?cust_rep.vehicleName___percent:''},
                 {Name: '@lang("layout.PlateNumber")', column_name: 'plateNumber',checkedColumn:(cust_rep.plateNumber)?'checked':'',column_percentage:(cust_rep.plateNumber___percent)?cust_rep.plateNumber___percent:''},
                 {Name: '@lang("layout.Traveller")', column_name: 'traveller',checkedColumn:(cust_rep.traveller)?'checked':'',column_percentage:(cust_rep.traveller___percent)?cust_rep.traveller___percent:''},
                 {Name: '@lang("layout.StartOdometer")', column_name: 'startOdometer',checkedColumn:(cust_rep.startOdometer)?'checked':'',column_percentage:(cust_rep.startOdometer___percent)?cust_rep.startOdometer___percent:''},
                 {Name: '@lang("layout.FinishOdometer")', column_name: 'finishOdometer',checkedColumn:(cust_rep.finishOdometer)?'checked':'',column_percentage:(cust_rep.finishOdometer___percent)?cust_rep.finishOdometer___percent:''},
                 {Name: '@lang("layout.Source")', column_name: 'source',checkedColumn:(cust_rep.source)?'checked':'',column_percentage:(cust_rep.source___percent)?cust_rep.source___percent:''},
                 {Name: '@lang("layout.Destination")', column_name: 'destination',checkedColumn:(cust_rep.destination)?'checked':'',column_percentage:(cust_rep.destination___percent)?cust_rep.destination___percent:''},
                 {Name: '@lang("layout.Date")', column_name: 'date',checkedColumn:(cust_rep.date)?'checked':'',column_percentage:(cust_rep.date___percent)?cust_rep.date___percent:''},
                 {Name: '@lang("layout.StartTripDate")', column_name: 'startTripDate',checkedColumn:(cust_rep.startTripDate)?'checked':'',column_percentage:(cust_rep.startTripDate___percent)?cust_rep.startTripDate___percent:''},
                 {Name: '@lang("layout.EndTripDate")', column_name: 'endTripDate',checkedColumn:(cust_rep.endTripDate)?'checked':'',column_percentage:(cust_rep.endTripDate___percent)?cust_rep.endTripDate___percent:''},

                  ],
                  cust_rep:cust_rep
            },  
            methods:{
                closeModal: function(){
                 this.is_show = !this.is_show
                },

    
            }
        });


new Vue({
    el:'#anchore-modal',
    methods:{
        showModal:function(){
            console.log('trr')
            vm.$data.is_show = true;
            
        }
    }
});
 // /new for modal

new Vue({
    el: '#company_ll',
    methods: {
        setCompany: function (event) {
            window.location.reload();
        }
    }
});
 


    
</script>
@endpush
