@extends('layouts.app')
@section('content')
    <div class="row">

        <div class="portlet light bg-inverse" style="min-height: 100%;">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>&nbsp;
                    <span class="caption-subject font-green-haze bold uppercase">  @lang('layout.VehicleLogBookCreate')</span>
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>
                <div class="tools">
                    
                </div>
            </div>
            <div id="app" class="portlet-body form" style="margin-bottom:50%;">
                <!-- BEGIN FORM-->
                {!! Form::open(array('route' => 'vehicleLogBook.store','method'=>'POST','class'=>'form-horizontal', 'id'=>'vehicle_location_form')) !!}
                {{ csrf_field() }}
                <div class="form-body">

                <div class="row">
                    <div class="col-md-12" style="padding: 0px;">
                        <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                            <div class="form-group">
                                <div class="col-md-12 ">
                                    <label class="control-label">@lang('layout.Driver') </label>
                                    <v-select placeholder="@lang('layout.SelectDriver')" label="name"
                                          v-model="selecteddriver"
                                          :options="allDrivers"
                                          @input="getVehicle"
                                          @click.native="getAllVehicle">
                                    </v-select>
                                    <input type="hidden" name="driver_id" v-model.number="(!selecteddriver)?null:selecteddriver.id">
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                            <div class="form-group">
                                <div class="col-md-12 ">
                                    <label class="control-label ">@lang('menu.Vehicle') </label>
                                    <v-select label="name" :options="allVehicles" v-model="selected_driverVehicle" >
                                    </v-select>
                                    <input type="hidden" name="vehicle_id" :value="!selected_driverVehicle?null:selected_driverVehicle.id">
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                            <div class="form-group">
                                <div class="col-md-12 ">
                                    <label class="control-label ">@lang('layout.PaletNumber') </label>
                                    <input type="text" name="palet_number" readonly :value="!selected_driverVehicle?null:selected_driverVehicle.palet_number" class="form-control" >
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                            <div class="form-group">
                                <div class="col-md-12 ">
                                    <label class="control-label ">@lang('layout.Number') </label>
                                    <input type="text" name="number" value="{{$number}}" class="form-control" >
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-12" style="padding: 0px;">
                        <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                            <div class="form-group">
                                <div class="col-md-12 ">
                                    <label class="control-label ">@lang('layout.Source') </label>
                                    {!! Form::text('source', null, array('placeholder' =>__('layout.Source'),'tabindex' =>'3','class' => 'form-control','autocomplete'=>'off')) !!}
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                            <div class="form-group">
                                <div class="col-md-12 ">
                                    <label class="control-label ">@lang('layout.Destination') </label>
                                    {!! Form::text('destination', null, array('placeholder' =>__('layout.Destination'),'class' => 'form-control')) !!}
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                            <div class="form-group">
                                <div class="col-md-12 ">
                                    <label class="control-label ">@lang('layout.StartTripDate') </label>
                                    <input type="text" name="start_trip_date" class="form-control date" autocomplete="off">
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                            <div class="form-group">
                                <div class="col-md-12 ">
                                    <label class="control-label ">@lang('layout.EndTripDate') </label>
                                    <input type="text" name="end_trip_date" class="form-control date" autocomplete="off">
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-md-12" style="padding: 0px;">
                        <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                            <div class="form-group">
                                <div class="col-md-12 ">
                                    <label class="control-label ">@lang('layout.StartOdometer') </label>
                                    <input type="number" v-model="start_odometer" name="start_odometer" class="form-control" autocomplete="off">
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                            <div class="form-group">
                                <div class="col-md-12 ">
                                    <label class="control-label ">@lang('layout.FinishOdometer') </label>
                                    <input type="number" v-model="finish_odometer" name="finish_odometer" class="form-control" autocomplete="off">
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                            <div class="form-group">
                                <div class="col-md-12 ">
                                    <label class="control-label ">@lang('layout.Total') </label>
                                    <input :value="finish_odometer - start_odometer" readonly class="form-control" >
                                </div>
                            </div>
                        </div>

                        <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                            <div class="form-group">
                                <div class="col-md-12 ">
                                    <label class="control-label ">@lang('layout.Date') </label>
                                    <input type="text" name="date" class="form-control date" autocomplete="off">
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-12" style="padding: 0px;">
                        <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                            <div class="form-group">
                                <div class="col-md-12 ">
                                    <label class="control-label ">@lang('layout.Traveller') </label>
                                    {!! Form::text('traveller', null, array('placeholder' =>__('layout.Traveller'),'tabindex' =>'3','class' => 'form-control','autocomplete'=>'off')) !!}
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                            <div class="form-group">
                                <div class="col-md-12 ">
                                    <label class="control-label ">@lang('menu.Item') </label>
                                    <v-select label="name" :options="services" v-model="selected_services" >
                                    </v-select>
                                    <input type="hidden" name="service_id" :value="!selected_services?null:selected_services.id">
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">
                            <div class="form-group">
                                <div class="col-md-12 ">
                                    <label class="control-label ">@lang('layout.Description') </label>
                                    <textarea name="description" class="form-control" rows="1" placeholder="@lang('layout.Description')"></textarea>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                </div>
                <div class="col-xs-12 col-sm-10 col-md-11 text-center">
                    <button type="button" @click="handleSubmit($event)"
                            class="btn green">@lang('layout.Submit')</button>
                    <button type="button" class="btn blue"
                            @click="saveAndNew($event)">@lang('layout.SaveAndNew')</button>
                    <a href="{{route('vehicleLogBook.index')}}" class="btn default"><i
                                class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                </div>
                {!! Form::close() !!}
            </div>
            <!-- END FORM-->
        </div>
    </div>
@endsection
@push('scripts')
    <script>
        @if(App::getLocale())
    Vue.use(VeeValidate, {
        locale: '{{App::getLocale()}}',
    });
    @else
        Vue.use(VeeValidate, {
            locale: 'en',
        });
        @endif

        Vue.component("v-select", VueSelect.VueSelect);


        var allDrivers = {!! $allDrivers !!};
        var allVehicles = {!! $allVehicles !!};
        var services = {!! $services !!};

        let vu = new Vue({
            el: '#app',
            data: {

                allDrivers: allDrivers,
                allVehicles: allVehicles,
                selected_driverVehicle: null,
                services: services,
                selected_services: null,
                start_odometer: null,
                finish_odometer: null,
                selecteddriver: null,
                driver_vehicle:allVehicles,
            },


            methods: {
                handleSubmit(e) {
                    this.$validator.validate().then(valid => {
                        if (valid) {
                            // alert(e.target);
                            regForm(e.target);
                        }
                    });
                },

                 //Get Driver All Vehicles
                    getVehicle() {
                        if (this.selecteddriver) {
                            axios.get("{{route('callMethod.search')}}",
                                {
                                    params: {
                                        driver_vehicle_plate: this.selecteddriver.plate,
                                        method_name: 'Search_driver_vehicle'
                                    },
                                })
                                .then(function (response) {
                                    if (response.data.result != null) {
                                        vu.selected_driverVehicle=response.data.result;
                                    }
                                    else {
                                        vu.selected_driverVehicle=null;
                                    }
                                })
                                .catch(function (error) {
                                    console.log(error);
                                });
                        }
                    },            

                    getAllVehicle() {
                        if (!vu.selecteddriver) {
                        vu.driver_vehicle=vu.allVehicles;
                        }
                    },
                saveAndNew() {
                    this.$validator.validate()
                        .then(valid => {
                            if (valid) {

                                var url = "{{route('vehicleLogBook.store')}}";
                                form_id = 'vehicle_location_form';
                                var data = $('#' + form_id).serialize();

                                axios.post(url, data)
                                .then(function (response) {
                                    if (response.data.result == 1) {
                                        $('#' + form_id).trigger('reset');
                                        toastr.success('', response.data.message);
                                        vu.selected_driverVehicle = null;
                                        vu.selecteddriver = null;
                                        location.reload();
                                    }
                                    else {
                                        var message = "{{__('message.Warning')}}";
                                        //$('#error-sound')[0].play();
                                        toastr.warning('', message);
                                    }
                                })
                                .catch(function (error) {
                                    console.log(error);
                                    var message = "{{__('message.Warning')}}";
                                    //$('#error-sound')[0].play();
                                    toastr.warning('', message);
                                });

                            }
                        })
                }
            }
        })

    </script>
@endpush 