@extends('layouts.factor-master')

@section('content')
<?php


$report = customeReportNew('vehicle_log_books_index');

$_number= !in_array('number', $report);
$_description= !in_array('description', $report);
$_driver= !in_array('driver', $report);
$_vehicleName= !in_array('vehicleName', $report);
$_plateNumber= !in_array('plateNumber', $report);
$_traveller= !in_array('traveller', $report);
$_startOdometer= !in_array('startOdometer', $report);
$_finishOdometer= !in_array('finishOdometer', $report);
$_location= !in_array('location', $report);
$_source= !in_array('source', $report);
$_destination= !in_array('destination', $report);
$_date= !in_array('date', $report);
$_startTripDate= !in_array('startTripDate', $report);
$_endTripDate = !in_array('endTripDate', $report);


$report_percent = customeReportNewPercent('vehicle_log_books_index');
    $_number_percent= (array_key_exists('number___percent', $report_percent))?$report_percent['number___percent']:null;
    $_description_percent= (array_key_exists('description___percent', $report_percent))?$report_percent['description___percent']:null;
    $_driver_percent= (array_key_exists('driver___percent', $report_percent))?$report_percent['driver___percent']:null;
    $_vehicleName_percent= (array_key_exists('vehicleName___percent', $report_percent))?$report_percent['vehicleName___percent']:null;
    $_plateNumber_percent= (array_key_exists('plateNumber___percent', $report_percent))?$report_percent['plateNumber___percent']:null;
    $_traveller_percent= (array_key_exists('traveller___percent', $report_percent))?$report_percent['traveller___percent']:null;
    $_startOdometer_percent= (array_key_exists('startOdometer___percent', $report_percent))?$report_percent['startOdometer___percent']:null;
    $_finishOdometer_percent= (array_key_exists('finishOdometer___percent', $report_percent))?$report_percent['finishOdometer___percent']:null;
    $_location_percent= (array_key_exists('location___percent', $report_percent))?$report_percent['location___percent']:null;
    $_source_percent= (array_key_exists('source___percent', $report_percent))?$report_percent['source___percent']:null;
    $_destination_percent= (array_key_exists('destination___percent', $report_percent))?$report_percent['destination___percent']:null;
    $_date_percent= (array_key_exists('date___percent', $report_percent))?$report_percent['date___percent']:null;
    $_startTripDate_percent= (array_key_exists('startTripDate___percent', $report_percent))?$report_percent['startTripDate___percent']:null;
    $_endTripDate_percent= (array_key_exists('endTripDate___percent', $report_percent))?$report_percent['endTripDate___percent']:null;


?>


<h3 class="table-caption" style="text-align: center;">@lang('layout.VehicleLogBookReport')</h3>
<table   class="main-table">
  <tr>
    @if($from_date)
   <td>
    <span>@lang('layout.FromDate')</span>:
    <BDO DIR="LTR">{{convertDate($from_date)}}</BDO>
  </td>
  @endif
  @if($to_date)
  <td>
    <span>@lang('layout.ToDate')</span>:
    <BDO DIR="LTR">{{convertDate($to_date)}}</BDO>
  </td>
  @endif
</tr>
</table>
<br>
<table class="main-table">

  <thead>
    <tr class="bg">
    <td  class="center" ><div > @lang('layout.Record')</div></td>
    @if($_number)<td  class="center"  @if($_number_percent) width="{{$_number_percent}}%" @endif><div > @lang('layout.Number')</div></td>@endif
    @if($_date)<td  class="center"  @if($_date_percent) width="{{$_date_percent}}%" @endif><div > @lang('layout.Date')</div></td>@endif
    @if($_description)<td  class="center"  @if($_description_percent) width="{{$_description_percent}}%" @endif><div > @lang('layout.Description')</div></td>@endif
    @if($_driver)<td  class="center"  @if($_driver_percent) width="{{$_driver_percent}}%" @endif><div > @lang('layout.Driver')</div></td>@endif
    @if($_vehicleName)<td  class="center"  @if($_vehicleName_percent) width="{{$_vehicleName_percent}}%" @endif><div > @lang('layout.VehicleName')</div></td>@endif
    @if($_plateNumber)<td  class="center"  @if($_plateNumber_percent) width="{{$_plateNumber_percent}}%" @endif><div > @lang('layout.PlateNumber')</div></td>@endif
    @if($_traveller)<td  class="center"  @if($_traveller_percent) width="{{$_traveller_percent}}%" @endif><div > @lang('layout.Traveller') </div></td>@endif
    @if($_source)<td  class="center"  @if($_source_percent) width="{{$_source_percent}}%" @endif><div > @lang('layout.Source')</div></td>@endif
    @if($_destination)<td  class="center"  @if($_destination_percent) width="{{$_destination_percent}}%" @endif><div > @lang('layout.Destination')</div></td>@endif
    @if($_startOdometer)<td  class="center"  @if($_startOdometer_percent) width="{{$_startOdometer_percent}}%" @endif><div > @lang('layout.StartOdometer')</div></td>@endif
    @if($_finishOdometer)<td  class="center"  @if($_finishOdometer_percent) width="{{$_finishOdometer_percent}}%" @endif><div > @lang('layout.FinishOdometer')</div></td>@endif
    @if($_startTripDate)<td  class="center"  @if($_startTripDate_percent) width="{{$_startTripDate_percent}}%" @endif><div > @lang('layout.StartTripDate')</div></td>@endif
    @if($_endTripDate)<td  class="center"  @if($_endTripDate_percent) width="{{$_endTripDate_percent}}%" @endif><div > @lang('layout.EndTripDate')</div></td>@endif
    <td  class="center" ><div > @lang('layout.User')</div></td>
  </tr>
  </thead>
  <?php
  $count = 0;
  ?>
  @foreach($data AS $record)
  <tr>
    <td class="center">{{++$count}}</td>
    @if($_number)<td class="center">{{$record->number}}</td>@endif
    @if($_date)<td class="center">{{convertDate($record->date)}}</td>@endif
    @if($_description)<td style="@if($_description_percent) text-align: justify @endif">{{$record->description}}</td>@endif
    @if($_driver)<td class="center">{{$record->name}}</td>@endif
    @if($_vehicleName)<td class="center">{{$record->vehicle_name}}</td>@endif
    @if($_plateNumber)<td class="center">{{$record->palet_number}}</td>@endif
    @if($_traveller)<td class="center">{{$record->traveller}}</td>@endif
    @if($_source)<td class="center">{{$record->source}}</td>@endif
    @if($_destination)<td class="center">{{$record->destination}}</td>@endif
    @if($_startOdometer)<td class="center">{{$record->start_odometer}}</td>@endif
    @if($_finishOdometer)<td class="center">{{$record->finish_odometer}}</td>@endif
    @if($_startTripDate)<td class="center">{{convertDate($record->start_trip_date)}}</td>@endif
    @if($_endTripDate)<td class="center">{{convertDate($record->end_trip_date)}}</td>@endif
    <td class="center">{{$record->user}}</td>
  </tr>
  @endforeach
</table>

   <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->
@endsection