@extends('layouts.app')

@section('content')



<div id="print-modal">
    <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show" 
        :value-type="'vehicle_Location'"
        @closed="closeModal">

        <div slot="body">
		
		<!----------------------------------------------
		----Begin Report Body And Custome Report-------
		----------------------------------------------->
		<div class="row" v-cloak>
				 <div class="tabbable tabbable-tabdrop">

					<ul class="nav nav-tabs">
						
						<li class="active">
							<a href="#tab1" data-toggle="tab" id="tab_main">@lang('menu.Report')</a>
						</li>
						@if(systemConfig()[2] != 0 )
                                @permission(['customreport-list'])
                        <li class="">
                            <a href="#tab2" data-toggle="tab" id="tab_custome">@lang('layout.CustomReportM')</a>
                        </li>
                        @endpermission
                        @endif
					</ul>
					<div class="tab-content">
						 <div class="tab-pane active" id="tab1"> 
								<div class="portlet light bordered">
										<!--Begin Report Type-->
										<div class="row">
											<div class="form-group">

												  <div class="col-md-6">
														<label class="control-label ">@lang('menu.Vehicle') </label>
														<select name="vehicle_id" id="" class="form-control">
															<option value="">@lang('menu.Vehicle')</option>
															@foreach($vehicle as  $v)
																<option value="{{$v->id}}">{{$v->vehicle_name}}</option>
															@endforeach
														</select>
													</div>
											</div>
										</div>

										<div class="row">
											<div class="form-group">
												<div class="col-md-12">
													<div class="form-group">
														<label class="control-label"> @lang('layout.Date')</label>
														<div class="input-group">
															<input class="form-control date" id="range-from-example" name="from_date" autocomplete="off">
														   
															<span class="input-group-addon"> @lang('layout.To') </span>
															<input class="form-control date" id="range-to-example" name="to_date" autocomplete="off">
															
														</div>
													</div>
												</div>
											</div>
										</div>
										
										<!--End Report Type--> 
								</div>
						</div> 

						<div class="tab-pane" id="tab2"> 
						   <div class="portlet light bordered">
								<div class="portlet-body">

									<form  id="saveCustomeReport" role="form" action="{{route('customeReport.storeCustomeReport')}}" method="post" >
										@csrf
										<input type="hidden" name="part_name" value="vehicle_location_index">


										<div class="col-md-12 col-sm-12 col-xs-12">

											<div class="mt-checkbox-inline col-md-2" v-for="(row,itemIndex) in customReportData">

												<div class="form-group">
													 <label> @{{ row.Name }}</label>

													  <input type="hidden" :name="'column_name['+itemIndex+']'" class="form-control" v-model="row.column_name">


													 <label class="switch">
															<input type="checkbox" :name="'column_status['+itemIndex+']'" 
															:checked="row.checkedColumn" >
														  <span class="slider round"></span>
													</label>
                                                    <select :name="'column_percentage['+itemIndex+']'" v-model="row.column_percentage" class="form-control" style="width: 90%;">
                                                        <option value="">@lang('layout.Select')</option>
                                                        <option value="2">2 %</option>
                                                        <option value="6">6 %</option>
                                                        <option value="10">10 %</option>
                                                        <option value="15">15 %</option>
                                                        <option value="20">20 %</option>
                                                        <option value="25">25 %</option>
                                                        <option value="30">30 %</option>
                                                        <option value="40">40 %</option>
                                                        <option value="50">50 %</option>
                                                        <option value="60">60 %</option>
                                                    </select>

												</div>
											</div>
										</div>
										<div class="margiv-top-10">
											<!-- <button type="button" onclick="regForm(this)" class="btn green"> <i class="fa fa-save"></i> </button> -->

											<button type="button" onclick="saveCustomeReport(this)" class="btn blue"> <i class="fa fa-save"></i> </button>
										</div>
								</form>
								</div>
						</div>
				</div>
				</div>
			</div>
		</div>
		<!----------------------------------------------
		----Begin Report Body And Custome Report-------
		----------------------------------------------->
									
									


        </div>            
    </report-modal>
</div>

    <!-- END PAGE HEADER-->


    

    <div class="row">
        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase">@lang('layout.VehicleLocationList')</span>
                </div>
                <div class="tools"> </div>
                <div class="pull-right">
                    <a href="{{route('vehicleLastLocation.index')}}">
						<button class="btn btn-success">
                            <i class="fa"></i> @lang('layout.LastLocation')
                        </button>
                    </a>

                     <span id="anchore-modal">
                         <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                            <i class="fa fa-print"></i>
                         </a>
                     </span>
                    @permission('vehicle-create')
                        <a href="{{route('vehicleLocation.create')}}">
                            <!-- <button id="sample_editable_1_new" class="btn green btn-sm btn-outline"> -->
                            <button id="sample_editable_1_new" class="btn btn-success">
                                <i class="fa fa-plus"></i> @lang('layout.AddNew')
                            </button></a>
                    @endpermission    
                </div>
            </div>
            <div class="portlet-body">
                <template v-cloak id="company_ll">
                    <company @company="setCompany"></company>
                </template>
                <table class="table table-striped table-bordered table-hover" id="vehicleLocations">
                    <thead>
                    <tr>
                        <th>@lang('layout.Driver')</th>
                        <th>@lang('layout.VehicleName')</th>
                        <th>@lang('layout.PlateNumber')</th>
                        <th>@lang('layout.State')</th>
                        <!-- <th>@lang('layout.Road')</th> -->
                        <th>@lang('layout.Location')</th>
                        <th>@lang('layout.Source')</th>
                        <th>@lang('layout.Destination')</th>
                        <th>@lang('layout.Date')</th>
                        <th>@lang('layout.Description')</th>
                        <th>@lang('layout.User')</th>
                        <th>@lang('layout.Actions')</th>


                    </tr>
                    </thead>
                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>


    <!-- END TAB PORTLET-->

    <!-- END CONTENT BODY -->


@stop
@include('print.modal')
@include('groupCompanyFilter.select')
@push('scripts')
<script>
var cust_rep = {!!customeReportNewData('vehicle_location_index')!!};

    $(document).ready(function() {
        $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
        $('#vehicleLocations').DataTable( {
            ajax:'{{route("vehicleLocation.index")}}',
            pageLength:'{{getPageRows()}}',
            order: [["{{orderByColumn()=='number'?2:8}}", "{{getRowOrder()}}"]],
            responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
            scrollCollapse: true,
            paging:         true,
            serverSide: true,


            columns: [  
                { data: 'name',         name: 'members.name' },
                { data: 'vehicle_name', name: 'vehicles.vehicle_name'  },
                { data: 'palet_number', name: 'vehicles.palet_number'  },
                { data: 'state',          name: 'vehicle_locations.state'},
                // { data: 'road',          name: 'vehicle_locations.road'},
                { data: 'location',          name: 'vehicle_locations.location'},
                { data: 'source',          name: 'vehicle_locations.source'},
                { data: 'destination',          name: 'vehicle_locations.destination'},
                { data: 'Date',         name: 'vehicle_locations.date'},
                { data: 'description',  name: 'vehicle_locations.description'},
                { data: 'user',  name: 'users.name'},
                { data: 'actions',      name: 'actions',orderable:false,searchable:false }




            ]
        });
    });
      Vue.component('v-select', VueSelect.VueSelect)


      // new for modal


var vm =new Vue({
            el: '#print-modal',
            data:{
                is_show:false,
                pdfRoute: '{!!route('export.PDFAll') !!}',
                excelRoute: '{!! route('export.ExcelAll') !!}',
				 customReportData:
                [
                 
                 {Name: '@lang("layout.Driver")', column_name: 'driver',checkedColumn:(cust_rep.driver)?'checked':'',column_percentage:(cust_rep.driver___percent)?cust_rep.driver___percent:''},
                 {Name: '@lang("layout.Description")', column_name: 'description',checkedColumn:(cust_rep.description)?'checked':'',column_percentage:(cust_rep.description___percent)?cust_rep.description___percent:''},
                 {Name: '@lang("layout.VehicleName")', column_name: 'vehicleName',checkedColumn:(cust_rep.vehicleName)?'checked':'',column_percentage:(cust_rep.vehicleName___percent)?cust_rep.vehicleName___percent:''},
                 {Name: '@lang("layout.PlateNumber")', column_name: 'plateNumber',checkedColumn:(cust_rep.plateNumber)?'checked':'',column_percentage:(cust_rep.plateNumber___percent)?cust_rep.plateNumber___percent:''},
                 {Name: '@lang("layout.State")', column_name: 'state',checkedColumn:(cust_rep.state)?'checked':'',column_percentage:(cust_rep.state___percent)?cust_rep.state___percent:''},
                 {Name: '@lang("layout.Road")', column_name: 'road',checkedColumn:(cust_rep.road)?'checked':'',column_percentage:(cust_rep.road___percent)?cust_rep.road___percent:''},
                 {Name: '@lang("layout.Location")', column_name: 'location',checkedColumn:(cust_rep.location)?'checked':'',column_percentage:(cust_rep.location___percent)?cust_rep.location___percent:''},
                 {Name: '@lang("layout.Source")', column_name: 'source',checkedColumn:(cust_rep.source)?'checked':'',column_percentage:(cust_rep.source___percent)?cust_rep.source___percent:''},
                 {Name: '@lang("layout.Destination")', column_name: 'destination',checkedColumn:(cust_rep.destination)?'checked':'',column_percentage:(cust_rep.destination___percent)?cust_rep.destination___percent:''},
                 {Name: '@lang("layout.Date")', column_name: 'date',checkedColumn:(cust_rep.date)?'checked':'',column_percentage:(cust_rep.date___percent)?cust_rep.date___percent:''},

                  ],
                  cust_rep:cust_rep




            },  
            methods:{
                closeModal: function(){
                 this.is_show = !this.is_show
                },

    
            }
        });


new Vue({
    el:'#anchore-modal',
    methods:{
        showModal:function(){
            console.log('trr')
            vm.$data.is_show = true;
            
        }
    }
});
 // /new for modal

new Vue({
    el: '#company_ll',
    methods: {
        setCompany: function (event) {
            window.location.reload();
        }
    }
});
 


    
</script>
@endpush
