@extends('layouts.factor-master')

@section('content')
<?php


$report = customeReportNew('vehicle_location_index');

$_description= !in_array('description', $report);
$_driver= !in_array('driver', $report);
$_vehicleName= !in_array('vehicleName', $report);
$_plateNumber= !in_array('plateNumber', $report);
$_state= !in_array('state', $report);
$_road= !in_array('road', $report);
$_location= !in_array('location', $report);
$_source= !in_array('source', $report);
$_destination= !in_array('destination', $report);
$_date= !in_array('date', $report);





$report_percent = customeReportNewPercent('vehicle_location_index');
    $_description_percent= (array_key_exists('description___percent', $report_percent))?$report_percent['description___percent']:null;
    $_driver_percent= (array_key_exists('driver___percent', $report_percent))?$report_percent['driver___percent']:null;
    $_vehicleName_percent= (array_key_exists('vehicleName___percent', $report_percent))?$report_percent['vehicleName___percent']:null;
    $_plateNumber_percent= (array_key_exists('plateNumber___percent', $report_percent))?$report_percent['plateNumber___percent']:null;
    $_state_percent= (array_key_exists('state___percent', $report_percent))?$report_percent['state___percent']:null;
    $_road_percent= (array_key_exists('road___percent', $report_percent))?$report_percent['road___percent']:null;
    $_location_percent= (array_key_exists('location___percent', $report_percent))?$report_percent['location___percent']:null;
    $_source_percent= (array_key_exists('source___percent', $report_percent))?$report_percent['source___percent']:null;
    $_destination_percent= (array_key_exists('destination___percent', $report_percent))?$report_percent['destination___percent']:null;
    $_date_percent= (array_key_exists('date___percent', $report_percent))?$report_percent['date___percent']:null;
?>


<h3 class="table-caption" style="text-align: center;">@lang('layout.VehicleLocationReport')</h3>

<table class="main-table">
  <tr>
      @if($from_date)
          <td>
              <span>@lang('layout.FromDate')</span>:
              <BDO DIR="LTR"> @if(\Setting::get('jalali_and_gerogarian_date') == 'true')  {{convertDate($from_date, null, null, ((\Setting::get('date_type') == 'jalali')?'gregorian':'jalali'))}}  <span dir="rtl"> &nbsp;&nbsp;&nbsp;  @lang('layout.MarchingAt')  </span>  @endif  {{convertDate($from_date)}}</BDO>
          </td>
      @endif
      @if($to_date)
          <td>
              <span>@lang('layout.ToDate')</span>:
              <BDO DIR="LTR">@if(\Setting::get('jalali_and_gerogarian_date') == 'true')  {{convertDate($to_date, null, null, ((\Setting::get('date_type') == 'jalali')?'gregorian':'jalali'))}}  <span dir="rtl"> &nbsp;&nbsp;&nbsp;  @lang('layout.MarchingAt')  </span>  @endif  {{convertDate($to_date)}}</BDO>
          </td>
      @endif
  </tr>
</table>

<table   class="main-table">
  <tr>
  @if($vehicleName)
  <td>
    <span>@lang('layout.VehicleName')</span>: {{$vehicleName}}
  </td>
  @endif
</tr>
</table>
<br>
<table class="main-table">

  <thead>
    <tr class="bg">
    <td  class="center" ><div > @lang('layout.Record')</div></td>
    @if($_date)<td  class="center"  @if($_date_percent) width="{{$_date_percent}}%" @endif><div > @lang('layout.Date')</div></td>@endif
    @if($_description)<td  class="center"  @if($_description_percent) width="{{$_description_percent}}%" @endif><div > @lang('layout.Description')</div></td>@endif
    
    @if($_driver)<td  class="center"  @if($_driver_percent) width="{{$_driver_percent}}%" @endif><div > @lang('layout.Driver')</div></td>@endif
    @if(!$vehicleName)
    @if($_vehicleName)<td  class="center"  @if($_vehicleName_percent) width="{{$_vehicleName_percent}}%" @endif><div > @lang('layout.VehicleName')</div></td>@endif
    @endif
    @if($_plateNumber)<td  class="center"  @if($_plateNumber_percent) width="{{$_plateNumber_percent}}%" @endif><div > @lang('layout.PlateNumber')</div></td>@endif
    @if($_state)
    <td  class="center"  @if($_state_percent) width="{{$_state_percent}}%" @endif><div > @lang('layout.State') </div></td>
    @endif
    @if($_road)<!-- td><div class="center"> @lang('layout.Road') </div></td -->@endif
    @if($_location)<td  class="center"  @if($_location_percent) width="{{$_location_percent}}%" @endif><div > @lang('layout.Location')</div></td>@endif
    @if($_source)<td  class="center"  @if($_source_percent) width="{{$_source_percent}}%" @endif><div > @lang('layout.Source')</div></td>@endif
    @if($_destination)<td  class="center"  @if($_destination_percent) width="{{$_destination_percent}}%" @endif><div > @lang('layout.Destination')</div></td>@endif
   
    <td  class="center" ><div > @lang('layout.User')</div></td>

  </tr>
  </thead>
  <?php
  $count = 0;
  ?>
  @foreach($data AS $record)
  <tr>
   
    <td class="center">{{++$count}}</td>
    @if($_date)<td class="center">{{convertDate($record->date)}}</td>@endif
    @if($_description)<td style="@if($_description_percent) text-align: justify @endif">{{$record->description}}</td>@endif
    @if($_driver)<td class="center">{{$record->name}}</td>@endif
    @if(!$vehicleName)
    @if($_vehicleName)<td class="center">{{$record->vehicle_name}}</td>@endif
    @endif
    @if($_plateNumber)<td class="center">{{$record->palet_number}}</td>@endif
    @if($_state && $record->state !='')
    <td class="center">{{__('type.' . $record->state) }}</td>
    @endif
    @if($_road)<!-- td class="center">{{$record->road}}</td -->@endif
    @if($_location)<td class="center">{{$record->location}}</td>@endif
    @if($_source)<td class="center">{{$record->source}}</td>@endif
    @if($_destination)<td class="center">{{$record->destination}}</td>@endif

    <td class="center">{{$record->user}}</td>

  </tr>
  @endforeach
</table>

   <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->
@endsection