@extends('layouts.app')


@section('content')

 <div id="print-modal">

    <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute"
        v-if="is_show" 
        :value-type="'VehicleIntroduceDetails'"
        @closed="closeModal">

        <div slot="body">
             <input type="hidden" name="id" value="{{$vehicleM->id}}"/>
            <div class="row">
                <div class="form-group">
                    <div class="col-md-12">
                        <div class="form-group">
                            <label class="control-label"> @lang('layout.Date')</label>
                            <div class="input-group">
                                <input class="form-control date" id="range-from-example" name="from_date"
                                autocomplete="off">
                                <span class="input-group-addon"> @lang('layout.To') </span>
                                <input class="form-control date" id="range-to-example" name="to_date"
                                autocomplete="off">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </report-modal>
</div>

    <div class="portlet">
        <div class="portlet-title" id="backbtn">
            <div class="caption">
                <i class=""></i>@lang('layout.VehicleIntroduceShow')
            </div>
            <div class="tools">
                <a href="javascript:;" class="collapse" data-original-title="" title=""> </a>
                <a href="#portlet-config" data-toggle="modal" class="config" data-original-title="" title=""> </a>
                {{--<a href="javascript:;" class="reload" data-original-title="" title=""> </a>--}}
                {{--<a href="javascript:;" class="remove" data-original-title="" title=""> </a>--}}
            </div>
        </div>
        <div class="portlet-body">
            <div class="table-scrollable">
                <table class="table table-striped table-bordered table-advance table-hover">
                    <thead>
                    <tr>
                        <th>@lang('layout.Number')</th>
                        <th>@lang('layout.ReferenceNumber')</th>
                        <th>@lang('layout.Customer')</th>
                        <th>@lang('layout.Phone')</th>
                        <th>@lang('layout.Date')</th>
                        <th>@lang('layout.Description')</th>
                        <th>@lang('layout.User')</th>
                    </tr>
                    </thead>
                    <tbody>
                    <tr>  
                        <td class="hidden-xs"> {{ $vehicleM->number}}  </td>
                        <td class="hidden-xs"> {{ $vehicleM->ref_no}}  </td>
                        <td class="hidden-xs"> {{ $vehicleM->members_name}}  </td>
                        <td class="hidden-xs"> {{ $vehicleM->phone}}  </td>
                        <td class="hidden-xs"> {{ $vehicleM->date }} </td>
                        <td class="hidden-xs"> {{ $vehicleM->description }}  </td> 
                        <td class="hidden-xs"> {{ $vehicleM->user}}  </td>
                    </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
 <div class="tabbable tabbable-tabdrop">

    <ul class="nav nav-tabs">
        <li class="active">
            <a href="#tab1" data-toggle="tab" id="tab_sale">@lang('layout.VehicleIntroduceShow')</a>
        </li>
        <li class="">
            <a href="#tab2" data-toggle="tab" id="tab_payment">@lang('layout.Attachments')</a>
        </li>
    </ul>
<div class="tab-content">
<div class="tab-pane active" id="tab1">
    <div class="row">
        <!-- app -->

        <!-- BEGIN EXAMPLE TABLE PORTLET-->
            <div class="portlet light bordered">
                <div class="portlet-title">
                    <div class="caption font-dark">
                        <i class="icon-settings font-dark"></i>
                        <span class="caption-subject bold uppercase">@lang('layout.VehicleIntroduceShow')</span>
                    </div>
                    <div class="tools"></div>
                     <div class="actions">
                     
                       <span id="anchore-modal">
                             <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                                <i class="fa fa-print"></i>
                             </a>
                        </span>
                    </div>
                </div>
                <div class="portlet-body">
                    <table class="table table-striped table-bordered table-hover" id="introduce">
                        <thead>
                        <tr>  
                        <th>@lang('layout.Driver')</th>
                        <th>@lang('layout.VehicleName')</th>
                        <th>@lang('layout.RoadActivity')</th>
                        <th>@lang('layout.BaseLoad')</th>
                        <th>@lang('layout.Description')</th>
                        </tr>
                        </thead>
                    </table>
                </div>
            </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>
</div>
    <div class="tab-pane" id="tab2"> 
                    <div class="portlet light bordered">
                <div class="portlet-title">
                    <div class="caption font-dark">
                        <i class="icon-settings font-dark"></i>
                        <span class="caption-subject bold uppercase">@lang('layout.Attachments')</span>
                    </div>
                </div>
                <div class="portlet-body">
                       <div class="portlet light bordered">
                                <div class="portlet-body">

                                            <form role="form" action="{{route('attachment.store')}}" method="post" enctype="multipart/form-data">
                             
                                                @csrf
                                                <input type="hidden" name="redirect_route" value="vehicleIntroduce.show">
                                                <input type="hidden" name="foreign_data_id" value="{{$vehicleM->id}}">
                                                <input type="hidden" name="path" value="uploads/vehicleIntroduce">
                                                <input type="hidden" name="table_name" value="vehicle_introduces">

                                                <div class="row">
                                                    <div class="col-md-4">
                                                        <div class="form-group">
                                                            <label class="control-label">@lang('layout.AttachmentTitle')</label>
                                                                <input type="text" name="title" class="form-control">
                                                        </div>
                                                    </div>
                                                    <div class="col-md-4">
                                                        <div class="form-group">
                                                            <label class="control-label">@lang('layout.Description')</label>
                                                                <textarea name="description" class="form-control"></textarea>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-7">
                                                          <div class="form-group">
                                                            <div class="fileinput fileinput-new" data-provides="fileinput">
                                                                <div class="fileinput-new thumbnail" style="width: 200px; height: 150px;">
                                                                    <img src="" alt=""> </div>
                                                                <div class="fileinput-preview fileinput-exists thumbnail" style="max-width: 200px; max-height: 150px; line-height: 10px;"> </div>
                                                                <div>
                                                                    <span class="btn default btn-file">
                                                                        <span class="fileinput-new">@lang('layout.SelectFile')</span>
                                                                        <span class="fileinput-exists">@lang('layout.Change')</span>
                                                                        <input type="hidden" value="" name=""><input type="file" name="photo"> </span>
                                                                        
                                                                    <a href="javascript:;" class="btn default fileinput-exists" data-dismiss="fileinput"> @lang('layout.Remove') </a>
                                                                </div>

                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                           
                                            <div class="margiv-top-10">
                                                <button type="button" onclick="regForm(this)" class="btn green"> @lang('layout.Submit') </button>
                                                <a href="{{route('dailyExpense.index')}}" class="btn default">@lang('layout.Cancel')</a>
                                            </div>
                                        </form>
                                </div>
                        </div>
                    <table class="table table-striped table-bordered table-hover" id="attachment">
                        <thead>
                        <tr>  
                        <th>@lang('layout.AttachmentTitle')</th>
                        <th>@lang('layout.Description')</th>
                        <th>@lang('layout.Action')</th>
                        </tr>
                        </thead>
                    </table>
                </div>
            </div>
    </div>
</div>
</div>



</div>
@endsection
@include('print.modal')
@push('scripts')

<script>
        $(document).ready(function () {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
        $('#introduce').DataTable({
            ajax:{
                url:'{{route("vehicleIntroduce.show",$vehicleM->id)}}',
                data:{type:'introduce'}
            },
            
            scrollCollapse: true,
            responsive:'{{responsiveDataTable()}}',
            pagingType:'{{paginationType()}}',
            serverSide: true,
            paging: true,
            columns: [
                { data: 'members_name', name: 'members_name' },
                { data: 'name', name: 'name' },
                { data: 'road_activity', name: 'road_activity' },
                { data: 'base_load', name: 'base_load' },
                { data: 'description', name: 'description' },
        ]
        });       

         $('#attachment').DataTable({
            ajax:{
                url:'{{route("vehicleIntroduce.show",$vehicleM->id)}}',
                data:{type:'attachment'}
              },
            
            scrollCollapse: true,
            responsive:'{{responsiveDataTable()}}',
            pagingType:'{{paginationType()}}',
            serverSide: true,
            paging: true,
            columns: [

                { data: 'title', name: 'attachments.title'},
                { data: 'description', name: 'attachments.description'},
                { data: 'actions',         name: 'actions', orderable:false,searchable:false},
        ]
        });

    });

    var vm =new Vue({

            el: '#print-modal',
            data:{
                is_show: false,
                pdfRoute: "{!!route('vehicleIntroduce.report') !!}",
                excelRoute: "{!! route('vehicleIntroduce.report') !!}",
            },
    
            methods:{
                closeModal: function(){
                    this.is_show = !this.is_show;
                }
            }
        });

    new Vue({
        el:'#anchore-modal',
        methods:{
            showModal:function(){
                console.log('trr')
                vm.$data.is_show = true;
            }
        }
    });
</script>


@endpush 
