@extends('layouts.app')
 @section('style')
<link rel="stylesheet" type="text/css" href="{{url('persian-datepicker/dist/css/persian-datepicker.css')}}')}}">

<link href="{{url('/assets/bootstrap-colorpicker/css/colorpicker.css')}}" rel="stylesheet" type="text/css" />
<link href="{{url('/assets/jquery-minicolors/jquery.minicolors.css')}}" rel="stylesheet" type="text/css" />

@stop
@section('content')
    <div class="row">
        @if (count($errors) > 0)
            <div class="m-heading-1 border-red m-bordered errors-action">
                <h4 class="error-title"><strong>Whoops!</strong> There were some problems with your input</h4>
                <ul class="error-body">
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul> 
            </div>
        @endif 
        <div class="portlet light bg-inverse" style="min-height: 100%;">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.CreateNewPorject') </span>
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>
                <div class="tools">
                    <a href="" class="collapse" data-original-title="" title=""> </a>
                    <a href="#portlet-config" data-toggle="modal" class="config" data-original-title="" title=""> </a>
                    <a href="" class="reload" data-original-title="" title=""> </a>
                    <a href="" class="remove" data-original-title="" title=""> </a>
                </div>
            </div>
            
            <div class="portlet-body form" style="margin-bottom:50%;">
                <!-- BEGIN FORM-->
                
                 {!! Form::model($projects, ['method' => 'PATCH','class'=>'form-horizontal','route' => ['project.update',$projects->id]]) !!}

                    <div class="form-body" id="app" v-cloak>
                        <div class="col-md-6">
                            <div class="col-md-12">
                                <label class="control-label ">@lang('layout.ContractName')</label>
                                {{Form::text('name',null,['class' => 'form-control','placeholder' => __('layout.ContractName')])}}
                            </div>
                            <div class="col-md-6">
                                <label class="control-label">@lang('layout.Currency')</label>
                                <select  class="form-control" v-model="selectedCurrency">
                                     <option v-for="curre in currency" :value="curre">@{{ curre.code }}</option>
                                 </select>
                                <input type="hidden" name="currency" v-bind:value="selectedCurrency.code"/>
                            </div> 
                            <div class="col-md-6">
                                <label class="control-label">@lang('layout.Rate')</label>
                                <div class="input-group">
                                    <input  v-model="selectedCurrency.exchange_rate" class="form-control"
                                                   type="number" min="0" step="any" >
                                    <span class="input-group-addon">@{{selectedCurrency.symbol}}</span>
                                 </div>
                                    <input type="hidden" name="currency_rate" :value="selectedCurrency.exchange_rate">
                            </div>
                            <div class="col-md-6">
                                <label class="control-label">@lang('layout.Location')</label>
                                 <input type="text" name="location" class="form-control" value="{{$projects->location}}" placeholder="@lang('layout.Location')">
                            </div>
                            <div class="col-md-6">
                                <label class="control-label">@lang('layout.Province')</label>
                                 <input value="{{$projects->province}}" type="text" name="province" class="form-control" placeholder="@lang('layout.Province')">
                                  
                            </div>
                            <div class="col-md-12" style="padding: 0px;">
                                <div class="col-md-6">
                                    <label class="control-label">@lang('layout.StartDate')</label>
                                    <input type="text" id="getdate" class="form-control" autocomplete="off" name="start_date" value="{{$projects->start_date}}">
                                </div>
                                <div class="col-md-6">
                                    <label class="control-label">@lang('layout.EndDate')</label>
                                    <input type="text" id="dueDate" class="form-control" autocomplete="off" name="end_date" value="{{$projects->end_date}}">
                                </div>

                            </div> 
                            <div class="col-md-12" style="padding: 0px;">
                                <div class="col-md-6">
                                    <label class="control-label">@lang('layout.WorkType')</label>
                                    <input type="text"  class="form-control"  name="work_type" placeholder="@lang('layout.WorkType')" value="{{$projects->work_type}}">
                                </div>
                                <div class="col-md-6">
                                    <label class="control-label">@lang('layout.MaintainanceDuration')</label>
                                    <input type="number" class="form-control" name="maintainance_duration" placeholder ="@lang('layout.MaintainanceDuration')" value="{{$projects->maintainance_duration}}">
                                </div>
                                
                            </div>

                        </div>  
                        <div class="col-md-6">
                            <div class="col-md-12">
                                <label class="control-label">@lang('layout.ProjectCode')</label>
                                {{Form::number('number',null,['class' => 'form-control'])}}
                            </div>
                            <div class="col-md-6">
                                <label class="control-label">@lang('layout.SelectCustomer')</label>
                                 <v-select class="vue-select2" v-model="selectedMember" label="name"
                                                :options="{{$member}}">
                                </v-select>
                                <input type="hidden" name="customer_id" v-model.number="(!selectedMember)?null:selectedMember.id">
                            </div>
                            <div class="col-md-6">
                                <label class="control-label">@lang('layout.Type')</label>
                                 <select class="form-control" name="type">
                                    <?php
                                        $selected='';
                                        if($projects->type)
                                        {
                                            $selected='selected';
                                        }
                                    ?>
                                     <option <?=$selected?> value="pvc">@lang('layout.PVC')</option>
                                     <option <?=$selected?> value="almonaim">@lang('layout.Almoniam')</option>
                                 </select>
                            </div>
                            <div class="col-md-12">
                                <div class="col-md-6">
                                    <label class="control-label">@lang('layout.District')</label>
                                    <input type="text" name="district" class="form-control" value="{{$projects->district}}" placeholder="@lang('layout.District')">
                                </div>
                                <div class="col-md-6">
                                    <label class="control-label">@lang('layout.Color')</label>
                                     <input type="text" id="saturation-demo" class="form-control demo" data-control="saturation" name="color" value="{{$projects->color}}"> </div>
                                </div>
                            </div>

                            

                             <div class="col-md-6">
                                <label class="control-label">@lang('layout.Description')</label>
                                {!! Form::textarea('description', null, array('placeholder' => __('layout.Description'),'class' => 'form-control','rows' => 6, 'cols' => 30)) !!}

                            </div>


                        </div>
                        <div class="col-md-4 col-md-offset-4 text-center">
                        <br>
                        <button type="button" class="btn green" onclick="regForm(this)">@lang('layout.Submit')</button>
                        <a href="{{route('project.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                    </div> 
                    </div>
                     
                {!! Form::close() !!}

            </div>           
                 
            <!-- END FORM-->
        </div>
    </div> 

@endsection 
@push('scripts')

<script src="{{url('vue/select2/vue-select@2.2.0.js')}}')}}"></script>
<script src="{{url('vue/select2/select2.js')}}')}}"></script>
<script src="{{url('/vue/sweetalert1.min.js')}}')}}"></script> 

<script src="{{url('persian-date/dist/persian-date.js')}}')}}" type="text/javascript"></script>
<script src="{{url('persian-datepicker/dist/js/persian-datepicker.js')}}')}}" type="text/javascript"></script>
<script src="{{url('/assets/bootstrap-colorpicker/js/bootstrap-colorpicker.js')}}" type="text/javascript"></script><script src="{{url('/assets/jquery-minicolors/jquery.minicolors.min.js')}}" type="text/javascript"></script>
        <!-- END PAGE LEVEL PLUGINS -->
        <!-- BEGIN THEME GLOBAL SCRIPTS -->
<script src="{{url('/assets/scripts/app.min.js')}}" type="text/javascript"></script>
        <!-- END THEME GLOBAL SCRIPTS -->
        <!-- BEGIN PAGE LEVEL SCRIPTS -->
<script src="{{url('/assets/scripts/components-color-pickers.min.js')}}" type="text/javascript"></script>




<script>
           
    $(document).ready(function(){
      $('#getdate').persianDatepicker({
        observer: true,
        format: 'YYYY/MM/DD',
        altFormat: 'u',
        autoClose:true,
        });

      $('#dueDate').persianDatepicker({
            observer: true,
            format: 'YYYY/MM/DD',
            altFormat: 'u',
            autoClose:true,
        });
    });
        
              // "۱۳۹۶-۰۱-۱۱ ۲۳:۳۳:۲۷ ب ظ" (when i run in my console)  
     Vue.component("v-select", VueSelect.VueSelect);

        var Member    ={!!$member!!}
        var Currency ={!! $currency!!}

    let vu = new Vue({
        el: '#app',
        data: {

            selectedCurrency:Currency,
            currency:{!!  json_encode(getCurrencies()) !!},
                selectedMember:null,
                listAccounts:[],
                currencyList: Currency,
                type: 'bank',
                members:Member, 
                projectDetails:{!!$projects!!}

        },
       
        computed: {
           
        },
        created()
        {
            this.checkSelected();
        },
        methods: {
            checkSelected(){
                    var allCarrencies = {!! json_encode(getCurrencies()) !!};
                    for(var x in allCarrencies){
                        for(z in allCarrencies[x]){
                            if(allCarrencies[x][z] == "{!! $projects->currency !!}"){
                                this.selectedCurrency = allCarrencies[x];
 
                            }
                         
                        }
                    }

                },
            
            setData:function(){
                this.selectedMember = _.find(this.members,(o) => o.id     =={{$projects->customer_id}});
                
                // for(var i=0;i<this.currency.length;i++)
                // {
                //     if(this.currency[i].code=="AFN")
                //     {
                //         this.selectedCurrency =this.currency[i]; 
                //     }
                // }
               
            }
           
        }
    });   
        vu.setData();
</script>

@endpush
 