@extends('layouts.app')
@section('style')
    <style type="text/css">
        .modal-container {
            width: 30% !important;
        }

        .modal.in .modal-dialog {
            margin: 40px auto;
            width: 32%;
        }

    </style>
@stop
@section('content')
@include('layouts.modal')


    <div id="print-modal" v-cloak>
        <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show"
                      :value-type="'VehicleIntroduce'"
                      @closed="closeModal">
            <div slot="body">
                <div class="row">
                    <div class="form-group">
                        <div class="col-md-12">
                            <label class="control-label ">@lang('layout.Driver') </label>
                            <select name="driver_id" id="" class="form-control">
                                <option value="">@lang('layout.Driver')</option>
                                @foreach($drivers as  $v)
                                    <option value="{{$v->id}}">{{$v->name}}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-md-12">
                            <label class="control-label ">@lang('layout.Customer') </label>
                            <v-select label="name" :options="customer" v-model="selected_customer" @search="MemberSearch" ></v-select>
                            <input type="hidden" name="customer_id" :value="!selected_customer?null:selected_customer.id" required>
                        </div>
                        <div class="col-md-12">
                            <label class="control-label"> @lang('layout.Type')</label>
                            <select name="report_type" class="form-control">
                                <option value="">@lang('layout.SelectType')</option>
                                <option value="details">@lang('layout.Details')</option>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="form-group">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="control-label"> @lang('layout.Date')</label>
                                <div class="input-group">
                                    <input class="form-control date" id="range-from-example" name="from_date"
                                           autocomplete="off">

                                    <span class="input-group-addon"> @lang('layout.To') </span>
                                    <input class="form-control date" id="range-to-example" name="to_date" autocomplete="off">

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </report-modal>
    </div>

    <!-- BEGIN TAB PORTLET-->
    <div class="row">
        <!-- app -->

        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bortdered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase">@lang('layout.VehicleIntroduceList')</span>
                </div>
                <div class="tools"></div>
                <div class="pull-right">


                    <span id="anchore-modal">
                         <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                            <i class="fa fa-print"></i>
                         </a>
                     </span>
           
                    @permission('VehicleCMR-create')
                    <a href="{{route('vehicleIntroduce.create')}}">
                        <button class="btn btn-success">
                            <i class="fa fa-plus"></i> @lang('layout.AddNew')
                        </button>
                    </a>
                    @endpermission


                </div>
            </div>
            <div class="portlet-body">
                <template v-cloak id="company_all">
                    <company @company="setCompany"></company>
                </template>
                <table class="table table-striped table-bordered table-hover" id="project">
                    <thead>
                    <tr>
                        <th>@lang('layout.Number')</th>
                        <th>@lang('layout.ReferenceNumber')</th>
                        <th>@lang('layout.Customer')</th>
                        <th>@lang('layout.Phone')</th>
                        <th>@lang('layout.Date')</th>
                        <th>@lang('layout.Description')</th>
                        <th>@lang('layout.User')</th>
                        <th>@lang('layout.Actions')</th>
                    </tr>
                    </thead>
                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>


    <!-- END TAB PORTLET-->
    <div id="factor-obj">

    </div>


    <!-- END TAB PORTLET-->

    <!-- END CONTENT BODY -->

    <iframe id="saleFrames" style="display: none;"></iframe>


    <!-- END CONTENT BODY -->
@stop
@include('groupCompanyFilter.select')
@include('print.modal')
@push('scripts')


    <script>
        

        Vue.component("v-select", VueSelect.VueSelect);


        let data_table;

        $(document).ready(function () {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
            data_table = $('#project').DataTable({
                ajax: '{{route("vehicleIntroduce.index")}}',
                order: [["{{orderByColumn()=='number'?0:3}}", "{{getRowOrder()}}"]],
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                scrollCollapse: true,
                paging: true,
                serverSide: true,
                buttons: [{
                    extend: 'excel',
                    text: '',
                    key: {
                        key: 'x',
                        altkey: true
                    }
                }],
                columns: [
                    {data: 'number', name: 'number'},
                    {data: 'ref_no', name: 'ref_no'},
                    {data: 'members_name', name: 'members.name'},
                    {data: 'phone', name: 'phone'},
                    {data: 'date', name: 'date'},
                    {data: 'description', name: 'description'},
                    {data: 'user', name: 'users.name'},
                    {data: 'actions', name: 'actions', orderable: false, searchable: false}
                ]
            });
        });


        // register modal component
        var Modal = Vue.component('modal', {
            template: '#modal-template',
            methods: {
                ok: function () {
                    this.$emit('ok')
                }
            }
        });

        new Vue({
            el: '#app',
            data: {
                showModal: false,
                selectedproject: null,
                projectList: [],
            },
            methods: {
                onProjectSearch(search, loading) {
                    loading(true);
                    this.searchProject(search, loading, this);
                },

                //ajax call to get items
                searchProject(search, loading, vm) {
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'anyTable',
                            'search_column': 'name',
                            'table_name': 'projects',
                            keyword: search,
                        }
                    })
                        .then(function (response) {
                            this.projectList = [];
                            if (response.data.length > 0) {
                                vm.projectList = response.data;
                                console.log('data', vm.projectList);
                            }
                            loading(false);
                        })
                        .catch(function (error) {
                            console.log(error);
                        })
                },
                ok: function () {
                    this.showModal = !this.showModal;
                },
                close: function (e) {
                    this.showModal = !this.showModal;
                },
                editExample: function () {
//Your other code that launches the modal
                    this.showModal = true;
                    this.$nextTick(function () {
                        $(document).ready(function () {
                            var to, from;
                            to = $("#range-to-example").persianDatepicker(modelDate());
                            from = $("#range-from-example").persianDatepicker(modelDate());
                        });
                    })
                }
            },
        })
        $('#print_pdf_all').on('click', function (e) {
            $('#show-modal').click();
            e.preventDefault();
        })
        new Vue({
            el: '#app2',
            data: {
                showModal: false,
                selectedproject: null,
                projectList: [],
            },
            methods: {
                onProjectSearch(search, loading) {
                    loading(true);
                    this.searchProject(search, loading, this);
                },

                //ajax call to get items
                searchProject(search, loading, vm) {
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'anyTable',
                            'search_column': 'name',
                            'table_name': 'projects',
                            keyword: search,
                        }
                    })
                        .then(function (response) {
                            this.projectList = [];
                            if (response.data.length > 0) {
                                vm.projectList = response.data;
                                console.log('data', vm.projectList);
                            }
                            loading(false);
                        })
                        .catch(function (error) {
                            console.log(error);
                        })
                },
                ok: function () {
//alert('you clicked me');
                    this.showModal = !this.showModal;
                },

                close: function (e) {
                    this.showModal = !this.showModal;
                },
                editExample2: function () {
//Your other code that launches the modal
                    this.showModal = true;
                    this.$nextTick(function () {
                        $(document).ready(function () {
                            var to, from;
                            to = $("#range-to-example2").persianDatepicker(modelDate());
                            from = $("#range-from-example2").persianDatepicker(modelDate());
                        });
                    })
                }
            },
        })

        new Vue({
            el: '#app3',
            data: {
                showModal: false,
                selectedMember: null,
                member: null,
                sdate: null,
                edate: null,
            },
            methods: {
                ok: function () {
                    this.showModal = !this.showModal;

                },
                pdf: function () {
                    alert(this.sdate);
                    alert(this.edate);
                },
                close: function (e) {
                    this.showModal = !this.showModal;
                },
                editExample2: function () {
//Your other code that launches the modal
                    this.showModal = true;
                    this.$nextTick(function () {
                        $(document).ready(function () {
                            var to, from;
                            to = $("#range-to-example2").persianDatepicker(modelDate());
                            from = $("#range-from-example2").persianDatepicker(modelDate());
                        });
                    });


                }
            },
        })

        $(document).ready(function () {
            var to, from;
            to = $("#range-to-example2").persianDatepicker(modelDate());
            from = $("#range-from-example2").persianDatepicker(modelDate());
        });

        $(document).on('click', '#completedProject', function () {

            $('#form_modal2').modal('show');
        });
        $('#excell_all').on('click', function (e) {
            $('#show-modal2').click();
            e.preventDefault();
        });
        $("#excel_send").on('click', function () {
            $('#excel_sdate').val($("#range-from-example2").val());
            $('#excel_edate').val($("#range-to-example2").val());

        });

        $("#pdf_send").on('click', function () {
            $('#pdf_sdate').val($("#range-from-example2").val());
            $('#pdf_edate').val($("#range-to-example2").val());

        });

        new Vue({
            el: '#company_all',
            methods: {
                setCompany: function (event) {
                    if (typeof data_table == 'object'){
                        data_table.clear();
                        data_table.ajax.reload();
                    }
                }
            }
        });


        // new for modal
var vm =new Vue({
            el: '#print-modal',
            data:{
                is_show:false,
                pdfRoute: '{!!route('vehicleIntroduce.report') !!}',
                excelRoute: '{!! route('vehicleIntroduce.report') !!}',
                customer: [],
                selected_customer: null,
            },  
            methods:{
                closeModal: function(){
                 this.is_show = !this.is_show
                },
                MemberSearch: _.debounce((search, loading) => {
                    loading(true);
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'SearchMember', 
                            keyword: search,
                            type: 'Customer'
                        }
                    })
                    .then(function(response) {
                        if (response.data.length > 0) {
                            // console.log(response.data);
                            vm.customer = [];
                            vm.customer = response.data;
                        }
                        loading(false);
                    })
                    .catch(function(error) {
                        loading(false);
                        console.log(error);
                    })
                }, getDebounceTime()),
    
            }
        });


new Vue({
    el:'#anchore-modal',
    methods:{
        showModal:function(){
            console.log('trr')
            vm.$data.is_show = true;
            
        }
    }
});
// /new for modal

    </script>
@endpush
