@extends('layouts.app')
<link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css">

@section('content')
    @include("layouts.Cmodal")
    @include("invoices.modal")
    @include("layouts.Drivermodal")
    <div class="row">
        <div class="portlet light bordered sale">
            <!-- BEGIN TAB PORTLET-->
            <div class="portlet light bordered">
                <div class="portlet-title">
                    <div class="caption">
                        <i class="icon-anchor font-green-sharp"></i>&nbsp;
                        <span class="caption-subject font-green-sharp bold uppercase">@lang('layout.VehicleIntroduceEdit')</span>
                    </div>
                    <div class="actions">
                    </div>
                </div>
                <div id="appInvoice" class="portlet-body">
                    <div class="tabbable tabbable-tabdrop">
                        <div>
                            {{Form::model($vehicleM,['route' => ['vehicleIntroduce.update',$vehicleM->id],'method' => 'PATCH','class' => 'form-horizontal','id'=>'vehicleIntroduce-form'])}}
                            {{ csrf_field() }}
                            <div class="tab-content">

                                <div class="tab-pane active" id="tab1">

                                    <div v-cloak class="portlet-body form" style="margin-bottom:50%;">
                                       

                                        <!-- BEGIN FORM-->


                                        <div class="form-body">
                                            <div class="row">
                                                <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                                                    <!-- begin inputs -->
                                                    <div class="row">
                                                        <div v-show="showWhat('member_class')=='yes'"
                                                             class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                                            <div class="form-group">

                                                                <div class="col-md-12">
                                                                    <label class="control-label">@lang('layout.MemberClass')</label>

                                                                    <v-select label="name" :options="memberClass"
                                                                              v-model="selected_class"
                                                                              @input="memberClassChange()"></v-select>
                                                                    <input type="hidden" name="class_id"
                                                                           :value="!selected_class?null:selected_class.id">
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="row">
                                                        <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                                            <div class="form-group">
                                                                <div class="col-md-12">
                                                                    <label class="control-label">@lang('layout.Customer')</label>
                                                                    <div class="input-group">
                                                                        <v-select label="name" :options="customer" v-model="selected_customer" @search="MemberSearch" @input="memberVehicleIntroduce()" ></v-select>
                                                                        <input type="hidden" name="customer_id"
                                                                           v-validate="'required'"
                                                                           data-vv-as="@lang('layout.Customer')"
                                                                           :value="!selected_customer?null:selected_customer.id"
                                                                           required>
                                                                        <span class="btn btn-success input-group-addon " title="@lang('button.AddNewCustomer')" @click="showModal = true" style="background-color:  rgb(84, 199, 211)">
                                                                            <i class="fa fa-plus" style="color: white"></i>
                                                                        </span> 
                                                                    </div>
                                                                    <span class="required">@{{ errors.first('customer') }}</span>
                                                                </div>
                                                            </div>
                                                        </div>

                                                        <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                                            <div class="form-group">
                                                                <div class="col-md-12">
                                                                    <label class="control-label">@lang('layout.Number')</label>
																	{{Form::text('number',null,['class' => 'form-control','placeholder' => __('layout.Number'),'v-validate' =>'"required"','data-vv-as' => __('layout.Number')])}}

                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                                            <div class="form-group">
                                                                <div class="col-md-12">
                                                                    <label class="control-label">@lang('layout.ReferenceNumber')</label>
																	{{Form::text('ref_number',$vehicleM->ref_no,['class' => 'form-control','placeholder' => __('layout.ReferenceNumber'),'v-validate' =>'""','data-vv-as' => __('layout.ReferenceNumber')])}}

                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                                            <div class="form-group">
                                                                <div class="col-md-12">
                                                                    <label class="control-label">@lang('layout.Date')</label>
                                                                    <input type="text" name="date" class="form-control date" value="{{$vehicleM->date}}" autocomplete="off">
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="row">
                                                        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                                                            <div class="form-group">
                                                                <div class="col-md-12">
                                                                    <label class="control-label">@lang('layout.Description')</label>
                                                                    <textarea name="description" class="form-control" rows="1">{{$vehicleM->description}}</textarea>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    
                                                    </div>

                                                    <!-- end inputs -->
                                                </div>
                                            </div>

                                            <div class="row" style="overflow-x: scroll;">

                                                <!-- begin service -->
                                                <table id="table_content"
                                                       class="table table-striped table-bordered table-advance table-hover">
                                                    <thead>
                                                        <tr>
                                                            <th class="text-center" style="min-width: 8px;">#</th>
                                                            <th class="text-center" style="min-width: 160px;">@lang('layout.SelectDriver')</th>
                                                            <th class="text-center" style="min-width: 160px;">@lang('layout.VehicleName')</th>
                                                            <th class="text-center" style="min-width: 160px;">@lang('layout.RoadActivity')</th>
                                                            <th class="text-center" style="min-width: 160px;">@lang('layout.BaseLoad')</th>
                                                            <th class="text-center" style="min-width: 160px;">@lang('layout.Description')</th>
                                                            <th class="text-center" ></th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <tr v-for="(row,index) in introduces">
                                                            <td>@{{index+1}}</td>
                                                            <td class="highlight">
                                                                <v-select label="name" @click.native="addNew('introduce',index), memberChange(index)" @keyup.native="memberChange(index)" :options="drivers" v-model="row.selectedMember"></v-select>
                                                                <input type="hidden" name="driver[]" :value="!row.selectedMember?null:row.selectedMember.id" >
                                                            </td>
                                                            <td class="highlight">
                                                                <v-select label="name" v-model="row.selected_vehicle" :options="vehicles">
                                                                </v-select>
                                                                <input type="hidden" name="vehicle_id[]" :value="!row.selected_vehicle?null:row.selected_vehicle.id"  />
                                                            </td>
                                                            <td>
                                                                <input type="text" name="road_activity[]" v-model="row.road_activity" placeholder="@lang('layout.RoadActivity')" class="form-control" />
                                                            </td>
                                                            <td>
                                                                <input type="text" name="base_load[]" v-model="row.base_load" placeholder="@lang('layout.BaseLoad')" class="form-control" />
                                                            </td>
                                                            <td>
                                                                <input type="text" name="description_d[]" v-model="row.description" placeholder="@lang('layout.Description')" class="form-control" />
                                                            </td>
                                                            <td>
                                                                <span v-on:click="deleteItem('introduce',index)"><i class="paddint-both glyphicon glyphicon-trash"></i></span>
                                                            </td>
                                                        </tr>

                                                    </tbody>
                                                </table>
                                                <!-- end service -->
												<hr/>
                                            </div>

                                        </div>
                                        <div class="col-xs-12 col-sm-10 col-md-11 text-center">
                                            <button type="button" v-if="isError1 ==false" v-if="!isError"
                                                    @click="handleSubmit($event)"
                                                    class="btn green">@lang('layout.Update')</button>
                                            <a href="{{route('vehicleIntroduce.index')}}" class="btn default"><i
                                                        class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>

                                        </div>
                                        <cmodal :show='showModal' @close="showModal=false">

                                        </cmodal>
										<Drivermodal :show='dShowModal' @close="dShowModal=false">

										</Drivermodal>
                                    </div>


                                </div>


                                {!! Form::close() !!}

                            </div>

                        </div>


                    </div>
                    <p> &nbsp; </p>
                    <p> &nbsp; </p>
                </div>
            </div>
            <!-- END TAB PORTLET-->
        </div>
    </div>

@endsection
@push('scripts')


    <script type="text/javascript">

        @if(App::getLocale())
        Vue.use(VeeValidate, {
            locale: '{{App::getLocale()}}',
        });
        @else
        Vue.use(VeeValidate, {
            locale: 'en',
        });
        @endif



        Vue.component('v-select', VueSelect.VueSelect);

        Vue.component("modal", {
            template: "#modal-template",
            props: ['show'],

        });

        //begin new member
        Vue.component("cmodal", {
            template: '#cmodal-template',

            props: ['show'],
            data() {
                return {
                    types: [],
                    classes: [],
                    receivables: [],
                    payables: [],
                    code: null,
                    selectType: null,
                    selectPay: null,
                    selectedClass: null,
                    selectReceive: null,
                }
            },
            created() {

                axios.get('{{route("customer.create")}}').then(
                    response => {
                        this.types = response.data.types;
                        if (this.types) {
                            for (var i = 0; i < this.types.length; i++) {
                                if (this.types[i].type == "Customer") {
                                    this.selectType = this.types[i];
                                }
                            }
                        }
                        this.receivables = response.data.receivable;
                        this.payables = response.data.payable;
                        this.code = response.data.code;
                        this.classes = response.data.member_class;
                        if (this.receivables.length > 0) {
                            this.selectReceive = this.receivables[0];
                        }
                        if (this.payables.length > 0) {
                            this.selectPay = this.payables[0];
                        }


                    }).catch(error => console.log(error));
            },
            methods: {
                onSubmit() {

                    v.showModal = false;
                    //this.member.type = this.member.type.id;
                    var datas = $("#modalForm").serializeArray();

                    $.ajax({
                        headers: {'X-CSRF-TOKEN': "{{csrf_token()}}"},
                        url: '{{route("customer.store")}}',
                        method: 'post',
                        data: {
                            "name": datas[0]['value'],
                            "code": datas[1]['value'],
                            'email': datas[2]['value'],
                            'phone': datas[3]['value'],
                            'address1': datas[4]['value'],
                            'type': this.selectType.id,
                            'receivable': this.selectReceive.id,
                            'payable': this.selectPay.id,
                            'class': (this.selectedClass) ? this.selectedClass.id : null
                        },


                        dataType: 'json',

                    }).done(function (response) {
                        axios.get('{{route("invoice.create")}}').then(response => {

                            v.customer = response.data.customer;
                            document.getElementById("modalForm").reset();

                        }).catch(error => console.log(error));

                    }).fail(function (error) {
                        console.log('error', error);
                    });

                }
            }
        });
		
        // end new member
		
        // start new driver
		 Vue.component("Drivermodal", {
            template: '#Drivermodal-template',

            props: ['show'],
            data() {
                return {

                    types: [],
                    classes: [],
                    receivables: [],
                    payables: [],
                    code: null,
                    selectType: null,
                    selectPay: null,
                    selectedClass: null,
                    selectReceive: null,
                }
            },
            created() {

                axios.get('{{route("customer.create")}}').then(
                    response => {
                        this.types = response.data.types;
                        if (this.types) {
                            for (var i = 0; i < this.types.length; i++) {
                                if (this.types[i].type == "Driver") {
                                    this.selectType = this.types[i];
                                }
                            }
                        }
                        this.receivables = response.data.receivable;
                        this.payables = response.data.payable;
                        this.code = response.data.code;
                        this.classes = response.data.member_class;

                        if (this.receivables.length > 0) {
                            this.selectReceive = this.receivables[0];
                        }
                        if (this.payables.length > 0) {
                            this.selectPay = this.payables[0];
                        }


                    }).catch(error => console.log(error));
            },
            methods: {
                onSubmit() {

                    v.dShowModal = false;
                    //this.member.type = this.member.type.id;
                    var datas = $("#DriverModalForm").serializeArray();
					console.log('send',datas);
                    $.ajax({
                        headers: {'X-CSRF-TOKEN': "{{csrf_token()}}"},
                        url: '{{route("driver.store")}}',
                        method: 'post',
                        data: {
                            "name": datas[0]['value'],
                            'code': datas[1]['value'],
                            'email': datas[2]['value'],
                            'driver_type': datas[3]['value'],
                            'plate_number': datas[4]['value'],
                            'phone': datas[5]['value'],
                            'address1': datas[6]['value'],
                            'type': this.selectType.id,
                            'receivable': this.selectReceive.id,
                            'payable': this.selectPay.id,
                            'class': (this.selectedClass) ? this.selectedClass.id : null
                        },
                        dataType: 'json',

                    }).done(function (response) {
                        axios.get('{{route("vehicleIntroduce.create")}}').then(response => {
							// console.log('123', response.data.customer);
							v.drivers = response.data.customer;
                            document.getElementById("DriverModalForm").reset();

                        }).catch(error => console.log(error));

                    }).fail(function (error) {
                        console.log('error', error);
                    });

                }
            }
        });
        // end new driver
		
		var allDrivers = {!!$allDrivers!!};
		var vehicles = {!!$vehicles!!};
        var memberClass = {!! $memberClass !!};
        var vehicleM = {!! $vehicleM !!};
        var introduceDetail = {!! $introduceDetail !!};
        var v = new Vue({
            el: '#appInvoice',
            data: {
                vehicleM: vehicleM,
                introduceDetail: introduceDetail,
                showModal: false,
                dShowModal: false,
                saleOrderList: [],
                selected_sale_order: null,
                purchase_orders: false,
                setDatas: [],
                drivers: allDrivers,
                vehicles: vehicles,
                selected_vehicle: null,
                tankers: vehicles,
                selected_tanker: null,
                amount: null,
                qty: null,
                customer: [],
                all_customer: [],
                selected_customer: {!!$selectedCustomer!!},
                selectedMember: null,
                member_id: null,
                temp_items: [],
                types: null,
                introduces: [],
                CusTypes: null,
                memberClass: memberClass,
                selected_class: null,
                ref_no: '',
                msg: '',
                isError1: false,
            },
            computed: {
                
                // check data validation
                isError: function () {
                    var isError = false;
                    //var flag=false;
                    // for (var i = 0; i < this.inventories.length; i++)
                    // {

                    //    if (this.inventories[i].item)
                    //    {
                    //      flag=true;
                    //      if(((this.inventories[i]['item']['rate'] <=0) ))
                    //      {
                    //        rate=this.inventories[i]['item']['rate'];
                    //        new_rate=this.inventories[i]['item']['new_rate'];
                    //        if(rate <=0 && new_rate <=0)
                    //        {
                    //             isError = true;
                    //        }

                    //      }
                    //    }
                    // }
                    if (this.selected_customer == null) {
                        isError = true;
                    }
                    return isError;
                },
            },
            mounted: function () {
				// begin introduce initialization

                for (var t = 0; t < this.introduceDetail.length; t++) {
                    
                    var selected_vehicle=_.find(this.vehicles,(v)=>v.id==this.introduceDetail[t].vehicle_id);
                    var selectedMember=_.find(this.drivers,(v)=>v.id==this.introduceDetail[t].driver_id);
                    this.introduces.push({
                        selected_vehicle: selected_vehicle,
                        selectedMember: selectedMember,
                        base_load: this.introduceDetail[t].base_load,
                        road_activity: this.introduceDetail[t].road_activity,
                        description: this.introduceDetail[t].description
                        });
                }

                this.introduces.push({selected_vehicle: null, selectedMember: null, base_load: null, road_activity: null, description: null});
                
                // end introduce initialization
				
            },
            methods:
                {
                    handleSubmit(e) {
                        this.$validator.validate().then(valid => {
                            if (valid) {
                                v.submitForm(e.target);
                            }
                        });
                    },

                    // detect member change and searh
                    
                    memberChange(index) {
                        if (v.introduces[index].selectedMember && this.selected_customer) {
                            v.introduces[index].selected_vehicle = null;
                            plate = v.introduces[index].selectedMember.plate;
                            if(plate != null){
                                vehicles.filter((vehicle) => {
                                    if (this.selected_customer.id == vehicle.customer_id || vehicle.customer_id == null) {
                                        if (vehicle.palet_number == plate) {
                                            // console.log('llll', vehicle);
                                            v.introduces[index].selected_vehicle = vehicle;
                                        }
                                    }
                                });
                            }
						}
                    },

                    memberClassChange() {
                        if (v.selected_class) {
                            v.customer = [];
                            // v.selected_customer = null;
                            let class_id = v.selected_class.id;
                        
                            axios.get("{{route('callMethod.search')}}", {
                                params: {
                                    method_name: 'SearchMember',
                                    class_id: class_id,
                                    type: 'Customer'
                                }
                            })
                            .then(function(response) {
                                if (response.data.length > 0) {
                                    v.customer = [];
                                    v.customer = response.data;
                                }
                            })
                            .catch(function(error) {
                                console.log(error);
                            })
                        }
                    },

                    memberVehicleIntroduce() {
                        this.vehicles = vehicles;
                        if (this.selected_customer) {
                            // console.log('kkk', vehicles);
                            this.vehicles = vehicles.filter((vehicle) => {
                                if (this.selected_customer.id == vehicle.customer_id || vehicle.customer_id == null) {
                                    // console.log('kkkll', vehicle.customer_id);
                                    return vehicle;
                                }
                            });

                        }
                    },

                    MemberSearch: _.debounce((search, loading) => {
                        loading(true);
                        let class_id = (v.selected_class != undefined) ? v.selected_class.id : null;
                        
                        axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: 'SearchMember', 
                                keyword: search,
                                type: 'Customer',
                                class_id: class_id
                            }
                        })
                        .then(function(response) {
                            if (response.data.length > 0) {
                                // console.log(response.data);
                                v.customer = [];
                                v.customer = response.data;
                            }
                            loading(false);
                        })
                        .catch(function(error) {
                            loading(false);
                            console.log(error);
                        })
                    }, getDebounceTime()),
					
                    // generic function for adding item to list
                    addNew(type = null, index) {
                        this.temp_items = [];
                        if (type != null) {
                            if (type == 'introduce') {
                                if (this.introduces[index + 1] == undefined) {
                                    this.introduces.push({selected_vehicle: null, selectedMember: null, base_load: null, road_activity: null, description: null});
                                }
                            }
                        }

                    },

                    // delete item from list
                    deleteItem(type = null, index) {
                        if (type != null) {
                            if (type == 'introduce') {
                                this.introduces.splice(index, 1);
                            }
                        }

                    },
                    // submit the form
                    submitForm() {

                        if (this.isError == true) {
                            alert('there is no item');
                            return false;
                        }
                        swal({
                            title: "@lang('layout.AreYouSure?')",
                            buttons: ["@lang('layout.Cancel')", "@lang('layout.Submit')"],
                            text: "",
                            icon: "info",
                            dangerMode: true,
                        }).then((willDelete) => {
                            if (willDelete) {
                                document.getElementById("vehicleIntroduce-form").submit()

                            }
                            else {

                            }
                        });

                    },
                },


        });

    </script>



@endpush