@extends('layouts.factor-master')

@section('content')

<h3 class="table-caption" style="text-align: center;">@lang('layout.VehicleIntroduceReport')</h3>
<table class="main-table">
  <thead>
    <tr>
        <th class="center">@lang('layout.Number')</th>
        <th class="center">@lang('layout.ReferenceNumber')</th>
        <th class="center">@lang('layout.Customer')</th>
        <th class="center">@lang('layout.Phone')</th>
        <th class="center">@lang('layout.Date')</th>
        <th class="center">@lang('layout.Description')</th>
        <th class="center">@lang('layout.User')</th>
    </tr>
  </thead>
  <tbody>
    <tr>  
        <td class="hidden-xs"> {{ $vehicleM->number}}  </td>
        <td class="hidden-xs"> {{ $vehicleM->ref_no}}  </td>
        <td class="hidden-xs"> {{ $vehicleM->members_name}}  </td>
        <td class="hidden-xs"> {{ $vehicleM->phone}}  </td>
        <td class="hidden-xs"> {{ $vehicleM->date }} </td>
        <td class="hidden-xs"> {{ $vehicleM->description }}  </td> 
        <td class="hidden-xs"> {{ $vehicleM->user}}  </td>
    </tr>
  </tbody>
</table>

@if($data)
<h3 class="table-caption" style="text-align: center;">@lang('layout.Details')</h3>
<table class="main-table">
  <thead>
  <tr>
    <th> @lang('layout.Record') </th>
    <th>@lang('layout.Driver')</th>
    <th>@lang('layout.VehicleName')</th>
    <th>@lang('layout.RoadActivity')</th>
    <th>@lang('layout.BaseLoad')</th>
    <th>@lang('layout.Description')</th>
  </tr>
  </thead>
  <tbody>
  <?php
  $count = 0;
  ?>
  @foreach($data AS $record)
  <tr>
    <td class="center">{{++$count}}</td>
    <td class="center">{{$record->members_name}}</td>
    <td class="center">{{$record->name}}</td>
    <td class="center">{{$record->road_activity}}</td>
    <td class="center">{{$record->base_load}}</td>
    <td class="center">{{$record->description}}</td>
  </tr>
  @endforeach
  <tbody>
</table>
@endif  

 <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->
@endsection