@extends('layouts.factor-master')

@section('content')

<h3 class="table-caption" style="text-align: center;">@lang('layout.VehicleIntroduceReport')</h3>

<table class="main-table">
  <tr>
      @if($from_date)
          <td>
              <span>@lang('layout.FromDate')</span>:
              <BDO DIR="LTR"> @if(\Setting::get('jalali_and_gerogarian_date') == 'true')  {{convertDate($from_date, null, null, ((\Setting::get('date_type') == 'jalali')?'gregorian':'jalali'))}}  <span dir="rtl"> &nbsp;&nbsp;&nbsp;  @lang('layout.MarchingAt')  </span>  @endif  {{convertDate($from_date)}}</BDO>
          </td>
      @endif
      @if($to_date)
          <td>
              <span>@lang('layout.ToDate')</span>:
              <BDO DIR="LTR">@if(\Setting::get('jalali_and_gerogarian_date') == 'true')  {{convertDate($to_date, null, null, ((\Setting::get('date_type') == 'jalali')?'gregorian':'jalali'))}}  <span dir="rtl"> &nbsp;&nbsp;&nbsp;  @lang('layout.MarchingAt')  </span>  @endif  {{convertDate($to_date)}}</BDO>
          </td>
      @endif
  </tr>
</table>   

<table class="main-table">
<thead>
<tr>
   <td class="center" ><div>  @lang('layout.Record') </div></td>
   <td class="center" ><div> @lang('layout.Number') </div></td>
   <td class="center" ><div> @lang('layout.ReferenceNumber') </div></td>
   <td class="center" ><div> @lang('layout.Date')</div></td>
   <td class="center" ><div> @lang('layout.Description')</div></td> 
   <td class="center" ><div> @lang('layout.Customer')</div></td>
   <td class="center" ><div> @lang('layout.Phone')</div></td>
   
   <td class="center" ><div> @lang('layout.User')</div></td> 
</tr>
</thead>
 <?php
 $count = 0;
 $total_home_currency=0;
 $currencies=[];
 ?>
 @foreach($data AS $record)
 <tr>
    <td class="center">{{++$count}}</td>
    <td class="center">{{$record->number}}</td>
    <td class="center">{{$record->ref_no}}</td>
    <td class="center">{{convertDate($record->date)}}</td>
    <td class="center">{{$record->description}}</td>
    <td class="center">{{$record->members_name}}</td>
    <td class="center">{{$record->phone}}</td>
    
    <td class="center">{{$record->user}}</td>

</tr>
@endforeach

</table>

 <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->
@endsection