@extends('layouts.factor-master')

@section('content')

<h3 class="table-caption" style="text-align: center;">@lang('layout.VehicleIntroduceReport')</h3>
<table style="width: 100%; margin-bottom: 10px;">
  <tr>
    @if($from_date)
    <td colspan="2">
      <span>@lang('layout.FromDate')</span>:
      <BDO DIR="LTR">{{convertDate($from_date)}}</BDO>
    </td>
    @endif
    @if($to_date)
    <td colspan="2">
      <span>@lang('layout.ToDate')</span>:
      <BDO DIR="LTR">{{convertDate($to_date)}}</BDO>
    </td>
    @endif
  </tr>
</table>

<table class="main-table">
<thead>
<tr>
   <td class="center" ><div> @lang('layout.Record')  </div></td>
   <td class="center" ><div> @lang('layout.Number') </div></td>
   <td class="center" ><div> @lang('layout.ReferenceNumber') </div></td>
   <td class="center" ><div> @lang('layout.Date')</div></td>
   <td class="center" ><div> @lang('layout.Description')</div></td> 
   <td class="center" ><div> @lang('menu.TransportCompany') </div></td>
   <td class="center" ><div> @lang('layout.Phone') </div></td>
   <td class="center" ><div> @lang('layout.Driver') </div></td>
   <td class="center" ><div> @lang('layout.Phone') </div></td>
   <td class="center" ><div> @lang('layout.VehicleName') </div></td>
   <td class="center" ><div> @lang('layout.RoadActivity')</div></td>
   <td class="center" ><div> @lang('layout.BaseLoad')</div></td>
   <td class="center" ><div> @lang('layout.Customer')</div></td>
   <td class="center" ><div> @lang('layout.Phone')</div></td>
   
   <td class="center" ><div> @lang('layout.User')</div></td> 
</tr>
</thead>
 <?php
 $count = 0;
 $total_home_currency=0;
 $currencies=[];
 ?>
 @foreach($data AS $record)
 <tr>
    <td class="center">{{++$count}}</td>
    <td class="center">{{$record->number}}</td>
    <td class="center">{{$record->ref_no}}</td>
    <td class="center">{{convertDate($record->date)}}</td>
    <td class="center">{{$record->description}}</td>
    <td class="center">{{$record->transport_company}}</td>
    <td class="center">{{$record->transport_phone}}</td>
    <td class="center">{{$record->driver_name}}</td>
    <td class="center">{{$record->driver_phone}}</td>
    <td class="center">{{$record->vehicle_name}}</td>
    <td class="center">{{$record->road_activity}}</td>
    <td class="center">{{$record->base_load}}</td>
    <td class="center">{{$record->members_name}}</td>
    <td class="center">{{$record->phone}}</td>
    
    <td class="center">{{$record->user}}</td>

</tr>
@endforeach

</table>

 <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->
@endsection