@extends('layouts.app')
<link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css">

@section('content')
    <div class="row">
        <div class="portlet light bg-inverse">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>&nbsp;
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.ReturnVehicleExpensesEdit')</span>
                    {{--<span class="caption-helper">some info...</span>--}}
                </div>
            </div>
            <div class="portlet-body form" style="margin-bottom: 50%;">
                {{Form::model($expenseInfo,['route' => ['vehicleExpenseReturn.update',$expenseInfo->id],'method' => 'PATCH','class' => 'form-horizontal','id'=>'bill-submit'])}}
                {{ csrf_field() }} 
                <div id="app" v-cloak>
                    <div class="row">
                        <div class="col-lg-9 col-md-9 col-sm-12 col-xs-12">
							<div class="row" id="header_feilds">
								<div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">
										<div class="col-md-12">
											<label class="control-label">@lang('menu.Vehicle'):</label>
											  <v-select 
												label="name" 
												:options="vehicles"
												v-model="selected_vehicle" @click="selectRefNumber"
												>
											</v-select>
											<input type="hidden" name="vehicle_id"
											   :value="!selected_vehicle?null:selected_vehicle.id"
											   v-validate="'required'" data-vv-as="@lang('menu.Vehicle')"
											   >
                                               <span class="required">@{{ errors.first('vehicle_id') }}</span>
												
										</div>
									</div>
								</div>
								
								<div class="col-lg-3 col-md-3 col-sm-7 col-xs-12">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label ">@lang('layout.Category')</label>
                                            <select class="form-control" name="category">
                                                <option value="Rent" <?php if($expenseInfo->category == 'Rent'){echo 'selected';}?> ><span class="input-group-addon">@lang('type.Rent')</span></option>
                                                <option value="Simple" <?php if($expenseInfo->category == 'Simple'){echo 'selected';}?> ><span class="input-group-addon">@lang('type.Simple')</span></option>
                                            </select>
                                        </div>
                                    </div>
                                </div>


                                <div class="col-lg-5 col-md-5 col-sm-7 col-xs-12"> 
                                    <div class="form-group">
                                        <div class="col-md-12"> 
                                            <label class="control-label ">@lang('layout.CategoryExpense')</label>
                                            <v-select label="name" :options="VehicleExpenseCategory" v-model="selectedVehicleExpenseCategory"></v-select>
                                            <input type="hidden" name="cat_expense_id" :value="!selectedVehicleExpenseCategory?null:selectedVehicleExpenseCategory.id" required>
                                       
                                        </div>
                                    </div>
                                </div>

                            </div>
                            <div class="row">

                                <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <div class="col-md-12 ">
                                            <label class="control-label">@lang('layout.ExpenseType') </label>
                                            {{Form::select('type',['writeCheck' => __('layout.Writecheck'),'bill' => __('layout.Bill')],'Accounts Receivable',[ 'v-model'=>'expenseType','class'=>'form-control',"v-validate"=>"'required'","data-vv-as"=>__('layout.ExpenseType')])}}
                                            <span class="required">@{{errors.first('type')}}</span>
                                        </div>

                                    </div>
                                </div>
								<div class="col-lg-4 col-md-4 col-sm-7 col-xs-12">

                                    <div class="form-group">
                                        <div class="col-md-6">
                                            <label class="control-label">@lang('layout.ReferenceNumber')</label>
                                            {{Form::text('ref_number',null,['class' => 'form-control','v-model' => 'ref_number'])}}
                                        </div>
										<div class="col-md-6">
                                            <label class="control-label">@lang('layout.Number')</label>
                                            {{Form::number('number',null,['class' => 'form-control'])}}
                                        </div>
                                    </div>
                                </div>
							
                            </div>
                            
                            <div class="row" id="header_feilds">
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">

                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Currency')</label>

                                            <v-select label="code" :options="setRates" v-model="selectedCurrency" @keyup.native="editKey = true" @click.native="editKey = true" @input="(editKey)?accountUpdates():''" ></v-select>
                                            <input type="hidden" name="currency" v-bind:value="selectedCurrency.code"/>
                                        </div>
                                    </div>
                                </div>


                                <div class="col-lg-4 col-md-4 col-sm-7 col-xs-12">
                                    <div class="form-group">

                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Bank')</label>
                                            <select class="form-control" name="bank" v-model="defaultAccount"
                                                    v-on:change="test(defaultAccount)">
                                                <option v-for="Account in accountUpdate" :value="Account.id">@{{
                                                    Account.name }}
                                                </option>
                                            </select>
                                        </div>
										
                                    </div>
                                </div>
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">

                                        <div class="col-md-12" v-if="expenseType == 'writeCheck'">
                                            <label class="control-label">@lang('layout.Expense') </label>
                                            <v-select label="name" :options="expenses"
                                                      v-model="selected_expense_account" @change="setAmount(selected_expense_account)"></v-select>
                                            <input type="hidden" name="expense_id" v-bind:value="(!selected_expense_account)?null:selected_expense_account.id"
												v-validate="'required'" data-vv-as="@lang('layout.Expense')" />
                                               <span class="required">@{{ errors.first('expense_id') }}</span>
                                        </div>

                                        <div class="col-md-12" v-if="expenseType == 'bill'">
                                            <label class="control-label">@lang('layout.Vendor')</label>
                                            <v-select label="name" :options="vendor" @search="MemberSearch" v-model="selected_vendor"></v-select>
                                            <input type="hidden" name="vendor" v-validate="'required'" data-vv-as="@lang('layout.Vendor')" :value="!selected_vendor?null:selected_vendor.id" required>
                                            <span class="required">@{{errors.first('vendor')}}</span>
                                        </div>

                                    </div>
                                </div>
                            </div>
                            <div class="row">

                                <div class="{{ auth()->user()->company()->first()->tag != 1 ? 'col-lg-3 col-md-3': 'col-lg-4 col-md-4' }} col-sm-12 col-xs-12">
                                    <div class="form-group">

                                        <div class="col-md-12 " :class="{'has-error':selectedCurrency.rate < 0}">
                                            <label class="control-label">@lang('layout.Rate') </label>
                                            <div class="input-group">
                                                <input v-model="selectedCurrency.exchange_rate" class="form-control"
                                                       type="number" step="any" min="0">
                                                <span class="input-group-addon">@{{selectedCurrency.symbol}}</span>
                                            </div>
                                        </div>
                                    </div>
                                    <input type="hidden" name="currency_rate" :value="selectedCurrency.exchange_rate">
                                </div>

                                @if(auth()->user()->company()->first()->tag != 1)
                                    <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">

                                        <div class="form-group">

                                            <div class="col-md-12 " :class="{'has-error':selectedCurrency.rate < 0}">
                                                <label class="control-label">@lang('layout.ExchangeRateHQ') </label>
                                                <div class="input-group">
                                                    <input v-model="selectedCurrency.hq_rate" class="form-control"
                                                           type="number" step="any" min="0">
                                                    <span class="input-group-addon">@{{selectedCurrency.symbol}}</span>
                                                </div>
                                            </div>
                                        </div>

                                        <input type="hidden" name="currency_rate_hq" :value="selectedCurrency.hq_rate">
                                    </div>
                                @endif


                                <div class="{{ auth()->user()->company()->first()->tag != 1 ? "col-lg-3 col-md-3" : 'col-lg-4 col-md-4' }} col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Amount')</label>
                                            <span v-show="false">@{{defaultAmount=((!selectedBank?0:selectedBank.balance) + subtotal)}}</span>
                                            <input type="number" class="form-control"
                                                   v-model="Number.parseFloat(defaultAmount).toFixed(precision())" disabled>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-lg-4 col-md-4 col-sm-7 col-xs-12"  v-if="expenseType == 'writeCheck'">
                                    <div class="form-group">

                                        <div class="col-md-12 ">
                                            <label class="control-label">@lang('layout.Amount') </label>

                                            <span v-show="false">@{{totalExpense=(expenseAmount - subtotal)}}</span>
                                            <input type="number" v-model="Number.parseFloat(totalExpense).toFixed(precision())"
                                                   class="form-control" disabled>

                                        </div>
                                    </div>
                                </div>


                            </div>
                            <div class="row">
								<div class="col-md-4">
									<div class="form-group">
										<div class="col-md-12">
										<label class="control-label">@lang('menu.ToRentVehicle'):</label>
											  <v-select 
												label="name" 
												:options="vehicleManagement"
												v-model="selected_rent" @search="vehicleManaSearch"
												>
											</v-select>
											<input type="hidden" name="rent_id"
											   :value="!selected_rent?null:selected_rent.id"
											   v-validate="" data-vv-as="@lang('menu.ToRentVehicle')"
											   >
                                               <span class="required">@{{ errors.first('rent_id') }}</span>
												
										</div>
									</div>
								</div>
                                <div class="col-lg-4 col-md-4 col-sm-7 col-xs-12">

                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Date')</label>
                                            {{Form::text('date',null,['class' => 'form-control date','id'=>'date','autocomplete'=>'off'])}}
                                        </div>
                                    </div>
                                </div>
                                <!-- div class="col-lg-4 col-md-4 col-sm-7 col-xs-12">

                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label ">@lang('layout.Category')</label>
                                            <select class="form-control" name="category_id">
                                                <option v-for="cat in category" :value="cat.id">
                                                    <span class="input-group-addon">@{{cat.name}}</span>
                                                </option>
                                            </select>
                                        </div>
                                    </div>
                                </div -->

                                <div class="col-lg-4 col-md-4 col-sm-7 col-xs-12">

                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Description')</label>
                                            {!! Form::textarea('gDescription', null, array('placeholder' => __('layout.Description'),'class' => 'form-control description','rows' => 1, 'cols' => 30)) !!}
                                        </div>
                                    </div>
                                </div>  

                            </div>
                        </div>
                        <div class="row">
                            <div class="col-lg-3 col-md-4 col-sm-12 col-xs-10">
                                <div class="dashboard-stat2">
                                    <table class="dashboard-tabel" width="100%">

                                        <tr>
                                            <td>
                                                <small>@lang('layout.Total') :</small>
                                            </td>
                                            <td class="text-right">
                                                <span data-counter="counterup" data-value="7800">
                                                    @{{ Number.parseFloat(subtotal).toFixed(2)}}
                                                </span>
                                                <input type="hidden" name="total" :value="subtotal">
                                                <small class="font-green-sharp">@{{selectedCurrency.symbol}}</small>
                                            </td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                        </div>


                    </div>
                    <div class="row">


                    </div>
                    <br>
                    <!-- <div class="form-section"></div> -->
                    <div class="row">
                        <div class="col-xs-12">
                            <div class="table-responsive333 row">
                                <table id="table_content" class="table table-bordered ">
                                    <thead>
                                    <tr>
                                        <th class="text-center" style="width:3px;">#</th>
                                        <th class="text-center" style="min-width: 130px;">
                                            @lang('layout.Description')
                                        </th>
                                        <th class="text-center" style="min-width: 130px;">
                                            @lang('layout.Quantity')
                                        </th>
                                        <th style="min-width: 4px;"></th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <tr v-for=" (row,itemIndex) in rows" class="even">
                                        <td class="td_one"><span span v-if="rows.length >1 "
                                                                 class="badge badge3 badge-success badge-roundless">@{{itemIndex+1}} </span>
                                        </td>
                                        <td>
                                            {{Form::text('description[]',null,['class' => 'form-control','v-on:focus'=>'(rows.length-1 == itemIndex)?addRow():null','v-model'=>'row.description','placeholder' =>__('layout.Description')])}}

                                        </td>
                                        <td width="50%;" class="td_one">
                                            <div class="input-group">
                                                {!! Form::number('amount[]',null, array('placeholder' => __('layout.Amount'),'class' => 'form-control','step'=>'any','min'=>'0','v-on:focus'=>'(rows.length-1 == itemIndex)?addRow():null','v-model'=>'row.amount')) !!}
                                                <span class="input-group-addon">@{{selectedCurrency.symbol}}</span>
                                            </div>
                                        </td>
                                        <td class="text-center">
                                            <span span v-if="rows.length >1 " v-on:click="deleteRow(itemIndex)"><i
                                                        class="paddint-both fa fa-trash"></i></span>
                                        </td>
                                    </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                <div class="col-xs-12 col-sm-12 col-md-10 text-center">
					<button type="button" class="btn green" @click="handleSubmit($event)" >@lang('layout.Update')</button>
                    <a href="{{route('vehicleExpenseReturn.index')}}" class="btn default">
                        <i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                </div>
                </div>
            </div>
            {{Form::close()}}
        </div>
    </div>
@endsection

@push('scripts')
    <script src="{{url('/vue/sweetalert1.min.js')}}"></script>
    <script>
	      @if(App::getLocale())
    Vue.use(VeeValidate, {
        locale: '{{App::getLocale()}}',
    });
    @else
        Vue.use(VeeValidate, {
            locale: 'en',
        });
        @endif
		
        Vue.component('v-select', VueSelect.VueSelect);

        var Banks = {!! $bank!!};
        var Currency ={!! $currency!!};
        var category ={!! $category!!};
        
        let home = {!! $homeCurrency !!};
        let ratesFetched = {!! $rates !!};
		
        var expenseInfo ={!! $expenseInfo!!};
        var vehicleMan ={!! $vehicleMan!!};
        var vehicles ={!! $vehicles!!};
        var vehicle ={!! $vehicle !!};
        var getExpenseDetails ={!! $getExpenseDetails !!};
        var VehicleExpenseCategory ={!! $VehicleExpenseCategory !!};

     let v = new Vue({
            el: '#app',
            data: {
                editKey: false,
                expenseInfo: expenseInfo,
                getExpenseDetails: getExpenseDetails,
                vehicles: vehicles,
                selected_vehicle:vehicle,
                selectedCurrency: home,
                selected_expense_account:null,
                currency: Currency,
                bankes: {!! $banks !!},
                selectedBank: null,
                expenseType: ((expenseInfo['pay_type'] != null)?expenseInfo['pay_type']:'writeCheck'),
                selected_vendor: {!! $selectedVendor !!},
                vendor: [],
                defaultValue: 0,
                defaultAmount: 0,
                defaultAccount: 0,
                amount: null,
                expenses: {!! $expense !!},
                expenseAmount: 0,
                totalExpense: null,
                ref_number: {!! $expenseInfo->ref_number !!},
                expenseId: 0,
                listAccounts: [],
                accountUpdate: [],
                currencyList: Currency,
                category: category,
                type: 'bank',
                description: null,
                vehicleManagement:[],
                selected_rent:vehicleMan,
                VehicleExpenseCategory: VehicleExpenseCategory,
                selectedVehicleExpenseCategory : null,
                rows: [
                    {
                        amount: null,
                        description: null
                    },
                    {
                        amount: null,
                        description: null
                    },
                ],
                account: {},
            },
            computed: {
                setRates() {

                    let rates = [];
                    this.currency.forEach((b) => {
                        ratesFetched.forEach((a) => {

                            if (a.currency_id == b.id) {
                                rates.push({
                                    name: a.name,
                                    code: a.code,
                                    symbol: a.symbol,
                                    rate: a.rate != null ? Number.parseFloat(a.rate) : 1,
                                    exchange_rate: a.rate != null ? Number.parseFloat(a.rate) : 1,
                                    hq_rate: a.hq_rate != null ? Number.parseFloat(a.hq_rate) : 1,
                                    currency: b.id,
                                    id: b.id
                                });
                            }
                        })
                    });

                    this.currency.forEach((a) => {
                        let found = false;
                        rates.forEach((b) => {
                            if (a.id == b.id) {
                                found = true;
                                return;
                            }
                        });

                        if (!found) {
                            rates.push({
                                name: a.name,
                                code: a.code,
                                symbol: a.symbol,
                                rate: 1,
                                exchange_rate: 1,
                                hq_rate: 1,
                                currency: a.id,
                                id: a.id
                            })
                        }
                    });
                   /* this.banks = [];

                    banks.forEach((a) => {
                        rates.forEach((r) => {
                            if (a.code == r.code) {
                                this.banks.push({
                                    amount: a.amount,
                                    balance: a.balance,
                                    code: a.code,
                                    id: a.id,
                                    name: a.name,
                                    rate: r.rate,
                                    hq_rate: r.hq_rate
                                })
                            }
                        });
                    });*/

                    return rates;

                },
                subtotal: function () {
                    var sum = 0;
                    for (var i = 0; i < this.rows.length; i++) {
                        sum += (parseFloat(this.rows[i].amount)) ? parseFloat(this.rows[i].amount) : 0
                    }
                    return sum;
                },
                
            },
            created() {
                this.expenseAmount = this.expenses[0].Amount;
                this.expenseId = this.expenses[0].id;
            },
            methods: {

                MemberSearch: _.debounce((search, loading) => {
                    loading(true);
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'SearchMember', 
                            keyword: search,
                            type: 'Vendor'
                        }
                    })
                    .then(function(response) {
                        if (response.data.length > 0) {
                            v.vendor = [];
                            v.vendor = response.data;
                        }
                        loading(false);
                    })
                    .catch(function(error) {
                        loading(false);
                        console.log(error);
                    })
                }, getDebounceTime()),
				
				accountUpdates() {
                    var b = _.clone(Banks)
                    var test = this.accounts = b.filter((account) => {
                        return (new RegExp(this.selectedCurrency.code.toLowerCase())).test(account.code.toLowerCase())
                    })
					if(test[0]){
                    this.defaultValue = test[0].id;
					}

                    for (var x in this.bankes) {
                        for (z in this.bankes[x]) {
                            if (this.bankes[x][z] == this.defaultValue && z == 'id') {
                                this.selectedBank = this.bankes[x];
                                this.defaultAccount = this.defaultValue;

                                //  console.log('selected bankes',this.selectedBank);
                                break;
                            }
                        }

                    }
                    // return test;
					this.accountUpdate = test;
                },
				
			vehicleManaSearch:_.debounce((search,loading)=>{
			   this.vehicleManagement=[];
			   if(v.selected_vehicle != null){
			   loading(true);
			   var vehicle_id = Number(v.selected_vehicle.id)
					console.log('test',vehicle_id,search);
			   axios.get("{{route('callMethod.search')}}",{
				params:{
				  method_name:'serarchVehicleManage',
				  keyword:search,
				  vehicle_id:vehicle_id,
				}
			   })
			   .then(function (response)
			   {
				 this.vehicleManagement=[];
				 if(response.data.length>0)
				 {
					v.vehicleManagement=response.data;
					// console.log('test 22',response.data);
				 }
				 loading(false);
			   })
			   .catch(function (error)
			   {
				  console.log(error);
			   });
			   }
			},getDebounceTime()),
			
			handleSubmit(e) {
				this.$validator.validate().then(valid => {
					if (valid) {
						// alert(e.target);
						v.submitForm(e.target);
					}
				});
			},
			
			selectRefNumber() {
				if(v.selected_vehicle != null && v.selected_vehicle.id){
					var vehicle_id = v.selected_vehicle.id;
				   axios.get("{{route('callExpenseSearch.search')}}",{
					params:{
					  method_name:'selectRefNumber',
					  vehicle_id:vehicle_id,
					}
				   })
				   .then(function (response)
				   {
					 this.vehicleManagement=[];
					 if(response.data != null)
					 {
						 v.ref_number = response.data.ref_number;
						// console.log('test 22',response.data.ref_number);
					 }
				   })
				   .catch(function (error)
				   {
					  console.log(error);
				   });
				}
			},

                onComplete: function () {
                    document.getElementById("account-form").submit()
//                this.$emit('on-complete')
//                alert('Yay. Done!');
                },
                addRow: function () {
                    this.rows.push(
                        {amount: null}
                    )
                },
                test(defaultAccount) {
                    for (var x in this.bankes) {
                        for (z in this.bankes[x]) {
                            if (this.bankes[x][z] == defaultAccount && z == 'id') {
                                this.selectedBank = this.bankes[x];
                                break;
                            }
                        }
                    }
                },
                deleteRow: function (index) {
                    this.rows.splice(index, 1)
                },
                // submit the form
                    submitForm() {

                        if (this.isError == true) {
                            alert('there is no item');
                            return false;
                        }
                        swal({
                            title: "@lang('layout.AreYouSure?')",
                            buttons: ["@lang('layout.Cancel')", "@lang('layout.Submit')"],
                            text: "",
                            icon: "info",
                            dangerMode: true,
                        }).then((willDelete) => {
                            if (willDelete) {
                                document.getElementById("bill-submit").submit()

                            }
                            else {

                            }
                        });

                    },
                setAmount(expenseId) {
                    for (var x in this.expenses) {
                        for (z in this.expenses[x]) {
                            if (this.expenses[x][z] == this.expenseId) {
                                this.expenseAmount = this.expenses[x].Amount;
                                this.expenseId = this.expenses[x].id;
                                break;
                            }
                        }
                    }
                },
				
            },
			mounted: function () {
				
				if (this.getExpenseDetails) {
					
					this.rows = getExpenseDetails;
                var sum = 0;
                for (var i = 0; i < this.rows.length; i++) {
                        sum += (parseInt(this.rows[i].amount))?parseInt(this.rows[i].amount):0
                }
                this.discountedAmount = sum;
                this.ConstdiscountedAmount = sum;
                this.defaultExpenseAmount = sum;
                
                this.rows.push({amount: null});
				
					
				}
				if (this.expenseInfo) {
					// console.log('asdasd',this.expenses);
					this.selectedCurrency=_.find(this.currency,(v)=>v.code==this.expenseInfo.Currency); 
                    var b = _.clone(Banks)
                    this.accountUpdate = b.filter((account) => {
                        return (new RegExp(this.selectedCurrency.code.toLowerCase())).test(account.code.toLowerCase())
                    }); 
					this.defaultAccount = this.expenseInfo.account_id;
					this.selectedBank=_.find(this.bankes,(v)=>v.id==this.expenseInfo.account_id);
                    if (this.expenseInfo.expense_id != null) {
					    this.selected_expense_account=_.find(this.expenses,(v)=>v.id==this.expenseInfo.expense_id);
                    } 
					this.selectedCurrency.rate = this.expenseInfo.rate;
					this.selectedCurrency.exchange_rate = this.expenseInfo.rate;
                    this.selectedVehicleExpenseCategory=_.find(this.VehicleExpenseCategory,(v)=>v.id==this.expenseInfo.cat_expense_id);
					}
			}
        });


    </script>


@endpush