@extends('layouts.app')
@section('content')
    @include('dailyExpense.modal')
    <!-- END PAGE HEADER-->
    <div id="print-modal" v-cloak>
        <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show"
                      :value-type="'vehicle_expenses'"
                      @closed="closeModal">
            <div slot="body">
                <div class="row">
                    <div class="form-group">
                        <div class="col-md-6">
                            <label class="control-label ">@lang('layout.Category') </label>
                            <select class="form-control" name="category">
                                <option value="">@lang('layout.SelectCategory')</option>
                                <option value="Rent"><span class="input-group-addon">@lang('type.Rent')</span></option>
                                <option value="Simple"><span class="input-group-addon">@lang('type.Simple')</span></option>
                            </select>
                        </div>
                        <div class="col-md-6">
                            <label class="control-label ">@lang('layout.ExpenseCategory') </label>
                            <v-select label="name" :options="VehicleExpenseCategory" v-model="selectedVehicleExpenseCategory"></v-select>
                            <input type="hidden" name="cat_expense_id" :value="!selectedVehicleExpenseCategory?null:selectedVehicleExpenseCategory.id" required>
                        
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="control-label"> @lang('layout.Date')</label>
                                <div class="input-group">
                                    <input class="form-control date" id="range-from-example" name="from_date"
                                           autocomplete="off">
                                    <span class="input-group-addon"> @lang('layout.To') </span>
                                    <input class="form-control date" id="range-to-example" name="to_date">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </report-modal>
    </div>
    <!-- BEGIN TAB PORTLET-->
    <div class="row">
        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>&nbsp;
                    <span class="caption-subject bold uppercase"> @lang('layout.VehicleExpensesList') </span>
                </div>
                <div class="tools"></div>
                <div class="pull-right">
                    <span id="anchore-modal">
                        <button type="submit" @click.prevent="showModal" class="btn btn-success">
                            <i class="fa fa-print"></i>
                        </button>
                    </span>
                    <a href="{{route('vehicleExpense.create')}}">
                        <button class="btn btn-success">
                            <i class="fa fa-plus"></i> @lang('layout.AddNew')
                        </button>
                    </a>
                </div>
            </div>
            <div class="portlet-body">

                <template v-cloak id="company_all">
                    <company @company="setCompany"></company>
                </template>
                <table class="table table-striped table-bordered " id="vehicleExpense">
                    <thead>
                    <tr>
                        <th>#</th>
                        <th>@lang('layout.ReferenceNumber')</th>
                        <th>@lang('layout.Code') @lang('type.Rent')</th>
                        <th>@lang('layout.ExpenseCategory')</th>
                        <th>@lang('layout.VehicleName')</th>
                        <th>@lang('layout.PaletNumber')</th>
                        <th>@lang('layout.Description')</th>
                        <th>@lang('layout.ExpenseAccount')</th>
                        <th>@lang('layout.BankAccount')</th>
                        <th>@lang('layout.Amount')</th>
                        <th>@lang('layout.Currency')</th>
                        <th>@lang('layout.Rate')</th>
                        <th>@lang('layout.Date')</th>
                        <th>@lang('layout.Category')</th>
                        <th>@lang('layout.User')</th>
                        <th>@lang('layout.Actions')</th>
                    </tr>
                    </thead>
                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>


    <!-- END TAB PORTLET-->

    <!-- END CONTENT BODY -->


@endsection

@include('print.modal')
@include('groupCompanyFilter.select')
@push('scripts')

    <script>
        let data_table;
        $(document).ready(function () {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
            data_table = $('#vehicleExpense').DataTable({
                ajax: '{{route("vehicleExpense.index")}}',
                pageLength: '{{getPageRows()}}',
                order: [[0, "{{getRowOrder()}}"]],
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                scrollCollapse: true,
                serverSide: true,
                paging: true,
                columns: [

                    {data: 'number', name: 'vehicle_expenses.number'},
                    {data: 'ref_number', name: 'vehicle_expenses.ref_number'},
                    {data: 'code', name: 'vehicle_managements.code'},
                    {data: 'cat_name', name: 'vehicle_expense_categories.name'},
                    {data: 'Name', name: 'vehicles.vehicle_name'},
                    {data: 'palet_number', name: 'vehicles.palet_number'},
                    {data: 'Description', name: 'vehicle_expenses.description'},
                    {data: 'expense_account', name: 'exA.name'},
                    {data: 'Bank', name: 'accounts.name'},
                    {data: 'amount', name: 'vehicle_expenses_details.amount'},
                    {data: 'Currency', name: 'transactions.unit'},
                    {data: 'Rate', name: 'Rate', orderable: false, searchable: false},
                    {data: 'Date', name: 'vehicle_expenses.date'},
                    {data: 'category', name: 'vehicle_expenses.category'},
                    {data: 'username', name: 'users.name'},
                    {data: 'actions', name: 'actions', orderable: false, searchable: false},
                ]
            });
        });


        var VehicleExpenseCategory = {!!$VehicleExpenseCategory!!};
        var vm = new Vue({
            el: '#print-modal',
            data: {
                is_show: false,
                pdfRoute: '{!!route('vehicleExpense.report') !!}',
                excelRoute: '{!! route('vehicleExpense.report') !!}',
                selectedMember: null,
                memberlist: [],
                VehicleExpenseCategory: VehicleExpenseCategory,
                selectedVehicleExpenseCategory : null,
            },
            methods: {
                closeModal: function () {
                    this.is_show = !this.is_show
                },

                onMemberSearch(search, loading) {
                    loading(true);
                    this.searchMember(search, loading, this);
                },

                searchMember(search, loading, vm) {
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'member',
                            type: 'Customer',
                            search: search,
                        }
                    })
                        .then(function (response) {
                            this.memberlist = [];
                            if (response.data.length > 0) {
                                vm.memberlist = response.data;
                                console.log('data', vm.memberlist);
                            }
                            loading(false);
                        })
                        .catch(function (error) {
                            console.log(error);
                        })
                },

            }
        });


        new Vue({
            el: '#anchore-modal',
            methods: {
                showModal: function () {
                    console.log('trr')
                    vm.$data.is_show = true
                }
            }
        });

        new Vue({
            el: '#company_all',
            methods: {
                setCompany: function (event) {
                   if (typeof data_table == 'object'){
                       data_table.clear();
                       data_table.ajax.reload();
                   }
                }
            }
        });

    </script>


@endpush
