
@extends('layouts.factor-master')


@section('content')
<?php
$report =customeReport('daily_expenses');

$_date=in_array('date', $report);
$_description=in_array('description', $report);
$_amount=in_array('amount', $report);
$_currency=in_array('currency', $report);
$_rate=in_array('rate', $report);
$_category=in_array('category', $report);
$_expense_account=in_array('expense_account', $report);
$_bank_account=in_array('bank_account', $report);
?>
 <h3 class="table-caption" style="text-align: center;">@lang('layout.VehicleExpenseReport')</h3>

 <table class="main-table">
  <tr>
      @if($from_date)
          <td>
              <span>@lang('layout.FromDate')</span>:
              <BDO DIR="LTR"> @if(\Setting::get('jalali_and_gerogarian_date') == 'true')  {{convertDate($from_date, null, null, ((\Setting::get('date_type') == 'jalali')?'gregorian':'jalali'))}}  <span dir="rtl"> &nbsp;&nbsp;&nbsp;  @lang('layout.MarchingAt')  </span>  @endif  {{convertDate($from_date)}}</BDO>
          </td>
      @endif
      @if($to_date)
          <td>
              <span>@lang('layout.ToDate')</span>:
              <BDO DIR="LTR">@if(\Setting::get('jalali_and_gerogarian_date') == 'true')  {{convertDate($to_date, null, null, ((\Setting::get('date_type') == 'jalali')?'gregorian':'jalali'))}}  <span dir="rtl"> &nbsp;&nbsp;&nbsp;  @lang('layout.MarchingAt')  </span>  @endif  {{convertDate($to_date)}}</BDO>
          </td>
      @endif
  </tr>
</table>


<br>

  <table class="main-table">
<thead>
    <tr class="bg">

   <td  class="center"  ><div> @lang('layout.Record') </div></td>
   @if($_date)<td  class="center"  ><div> @lang('layout.Date')</div></td>@endif
   @if($_description)<td  class="center"  ><div> @lang('layout.Description')</div></td>@endif
   @if($_description)<td  class="center"  ><div> @lang('layout.ExpenseCategory')</div></td>@endif
   @if($_amount)<td  class="center"  ><div> @lang('layout.Amount')</div></td>@endif
   @if($_currency)<td  class="center"  ><div> @lang('layout.Currency')</div></td>@endif
   @if($_rate)<td  class="center"  ><div> @lang('layout.Rate')</div></td>@endif
   @if($_rate)<td  class="center"  ><div> @lang('layout.Rate')</div></td>@endif
   @if($_category)<td  class="center"  ><div> @lang('layout.Category')</div></td>@endif
   @if($_expense_account)<td  class="center"  ><div> @lang('layout.ExpenseAccount')</div></td>@endif
   @if($_bank_account)<td  class="center"  ><div> @lang('layout.BankAccount')</div></td>@endif
   <td  class="center"  ><div> @lang('layout.User')</div></td>
  
 </tr>
</thead>
<tbody>
 <?php
 $count = 0;
 $total_home_currency=0;
 $currencies=[];
 ?>
 @foreach($data AS $record)
 <tr>

  <?php

  if(systemConfig()[30] == 1){
   $total_home_currency+= ($record->amount/$record->static_rate * $record->Rate);
  }else{
    $total_home_currency+= ($record->amount/ $record->Rate);
  }

   if(array_key_exists($record->Currency, $currencies))
   {
    $currencies[$record->Currency]=$currencies[$record->Currency]+$record->amount;
  }
  else
  {

    $currencies[$record->Currency]=$record->amount;
  }
  ?>

 <td class="center">{{++$count}}</td>
 @if($_date)<td  class="center">{{convertDate($record->Date)}}</td>@endif
 @if($_description)<td  class="center">{{$record->Description}}</td>@endif
 @if($_description)<td  class="center">{{$record->cat_name}}</td>@endif
 @if($_amount)<td  class="center">{{myRound($record->amount)}}</td>@endif
 @if($_currency)<td class="center">{{$record->Currency}}</td>@endif
 @if($_rate)<td class="center">{{$record->Rate}}</td>@endif
 @if($_rate)<td class="center">{{$record->static_rate}}</td>@endif
 @if($_category)<td  class="center">{{__('type.' . $record->category) }}</td>@endif
 @if($_expense_account)<td class="center">{{$record->expense_account}}</td>@endif
 @if($_bank_account) <td  class="center">{{$record->Bank}}</td>@endif
 <td  class="center">{{$record->username}}</td>
 
</tr>
  @endforeach   
</tbody>
</table>



<table class="main-table">
 <tr class="bg">
  <td colspan="3"><div class="center">@lang('layout.PerCurrency')</div></td>
</tr>
<tr>
  <td><div class="center"> @lang('layout.Record') </div></td>
  <td><div class="center"> @lang('layout.Currency') </div></td>
  <td><div class="center"> @lang('layout.Amount') </div></td>
</tr>
<?php
$count=0;
foreach($currencies As $key=>$currency)
{
  ?>
  <tr>
    <td><div class="center">{{++$count}}</div></td>
    <td><div class="center">{{$key}}</div></td>
    <td><div class="center">{{myRound($currency)}}</div></td>

  </tr>
  <?php
}
?>
<tr>

<td colspan="2"><div class="center">@lang('layout.HomeCurrencyTotal')</div></td>
 <td><div class="center">{{myRound($total_home_currency)}} {{getHomeCurrency()[getCurrencyType()]}}</div></td>

</tr>
</table>
 <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->
@endsection