@extends('layouts.app')
@section('style')
<style type="text/css">
   table.td{
        border-top:0px;
    }
    .header{
    
    }
   
</style>
@stop
@section('content')

    <div class="portlet">
        <div class="portlet-title" id="backbtn">
            <div class="caption">
                <i class=""></i>@lang('layout.VehicleEquipmentShow')
            </div>
            <div class="tools">
                <a href="javascript:;" class="collapse" data-original-title="" title=""> </a>
                <a href="#portlet-config" data-toggle="modal" class="config" data-original-title="" title=""> </a>
            </div>
        </div>
        <div class="portlet-body">
			<!--Begin Tabs-->
                <div class="row">
                   <div class="tabbable tabbable-tabdrop">

                        <ul class="nav nav-tabs">
                            <li class="active">
                                <a href="#tab1" data-toggle="tab" id="tab_sale">@lang('menu.VehicleEquipment')</a>
                            </li>
							<li class="">
								<a href="#tab3" data-toggle="tab" id="tab_attachment">@lang('layout.Attachments')</a>
                            </li>
                        </ul>
                        <div class="tab-content">

                            <div class="tab-pane active" id="tab1"> 
                                <div class="table-scrollable">
									<table class="table table-striped table-bordered table-advance table-hover">
										<thead>
										<tr>
											<th>
												<i class="fa  fa-car"></i> @lang('layout.VehicleName') 
											</th>
											 <th>
												<i class=""></i> @lang('layout.PlateNumber')
											</th>
										  
											<th>
												<i class="fa  "></i> @lang('layout.Name')
											</th>
											<th>
												<i class="fa  "></i> @lang('layout.Value') 
											</th> 
											<th>
												<i class="fa  "></i> @lang('layout.Description') 
											</th> 
											<th>
												<i class="fa  "></i> @lang('layout.Type') 
											</th>
											<th>
												<i class="fa fa-clock-o"></i> @lang('layout.ChangeDate')
											</th>   
											
										</tr>
										</thead>
										<tbody>
										<tr>  
											<td class="hidden-xs"> {{ $vehicleEquipment->vehicle_name}}  </td>
											<td class="hidden-xs"> {{ $vehicleEquipment->palet_number}}  </td>

											<td class="hidden-xs"> {{$vehicleEquipment->name}} </td> 
											<td class="hidden-xs"> {{$vehicleEquipment->value}} </td> 
											<td class="hidden-xs"> {{$vehicleEquipment->description}}  </td>
											<td class="hidden-xs"> {{$vehicleEquipment->type}}  </td>

											<td class="hidden-xs"> {{ convertDate($vehicleEquipment->date) }} </td>

										</tr>
										</tbody>
									</table>
								</div>
                            </div>
							<div class="tab-pane" id="tab3"> 
								<div class="portlet light bordered">
								<div class="portlet-title">
									<div class="caption font-dark">
										<i class="icon-settings font-dark"></i>
										<span class="caption-subject bold uppercase">@lang('layout.Attachments')</span>
									</div>
								</div>
								<div class="portlet-body">
									   <div class="portlet light bordered">
												<div class="portlet-body">

													<form role="form" action="{{route('attachment.store')}}" method="post" enctype="multipart/form-data">
									 
														@csrf
														<input type="hidden" name="redirect_route" value="vehicleEquipment.show">
														<input type="hidden" name="foreign_data_id" value="{{$vehicleEquipment->id}}">
														<input type="hidden" name="path" value="uploads/vehicle">
														<input type="hidden" name="table_name" value="vehicle_equipment">

														<div class="row">
															<div class="col-md-4">
																<div class="form-group">
																	<label class="control-label">@lang('layout.AttachmentTitle')</label>
																		<input type="text" name="title" class="form-control">
																</div>
															</div>
															<div class="col-md-4">
																<div class="form-group">
																	<label class="control-label">@lang('layout.Description')</label>
																		<textarea name="description" class="form-control"></textarea>
																</div>
															</div>
															<div class="col-md-7">
																  <div class="form-group">
																	<div class="fileinput fileinput-new" data-provides="fileinput">
																		<div class="fileinput-new thumbnail" style="width: 200px; height: 150px;">
																			<img src="" alt=""> </div>
																		<div class="fileinput-preview fileinput-exists thumbnail" style="max-width: 200px; max-height: 150px; line-height: 10px;"> </div>
																		<div>
																			<span class="btn default btn-file">
																				<span class="fileinput-new">@lang('layout.SelectFile')</span>
																				<span class="fileinput-exists">@lang('layout.Change')</span>
																				<input type="hidden" value="" name=""><input type="file" name="photo"> </span>
																				
																			<a href="javascript:;" class="btn default fileinput-exists" data-dismiss="fileinput"> @lang('layout.Remove') </a>
																		</div>

																	</div>
																</div>
															</div>
														</div>
												   
													<div class="margiv-top-10">
														<button type="button" onclick="regForm(this)" class="btn green"> @lang('layout.Submit') </button>
														<a href="{{route('dailyExpense.index')}}" class="btn default">@lang('layout.Cancel')</a>
													</div>
												</form>
											</div>
										</div>
									<table class="table table-striped table-bordered table-hover" id="attachment">
										<thead>
										<tr>  
										<th>@lang('layout.AttachmentTitle')</th>
										<th>@lang('layout.Description')</th>
										<th>@lang('layout.Action')</th>
										</tr>
										</thead>
									</table>
								</div>
							</div>
						</div>


						</div>
                     </div>
                </div>
                <!--End Tabs-->
        </div>

    </div>


@endsection

@push('scripts')

<script>
$(document).ready(function () {
	$.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
		 $('#attachment').DataTable({
            ajax:{
                url:'{{route("vehicleEquipment.show",$vehicleEquipment->id)}}',
                data:{type:'attachment'}
              },
            
			scrollCollapse: true,
			responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
            serverSide: true,
            paging: true,
            columns: [

                { data: 'title', name: 'attachments.title'},
                { data: 'description', name: 'attachments.description'},
                { data: 'actions',         name: 'actions', orderable:false,searchable:false},
        ]
        });


    });
</script>
@endpush

 
