@extends('layouts.app')
@section('content')
<div id="print-modal">
    <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show" 
        :value-type="'vehicle_equipment'"
        @closed="closeModal">
        <div slot="body">
            <div class="row">
                <div class="form-group">
                      <div class="col-md-6">
                            <label class="control-label ">@lang('menu.Vehicle') </label>
                            <select name="vehicle_id" id="" class="form-control">
                                <option value="">@lang('menu.Vehicle')</option>
                                @foreach($vehicle as  $v)
                                    <option value="{{$v->id}}">{{$v->vehicle_name}}</option>
                                @endforeach
                            </select>
                        </div>
                </div>
            </div>
            <div class="row">
                <div class="form-group">
                    <div class="col-md-12">
                        <div class="form-group">
                            <label class="control-label"> @lang('layout.Date')</label>
                            <div class="input-group">
                                <input class="form-control date" id="range-from-example" name="from_date" autocomplete="off">             
                                <span class="input-group-addon"> @lang('layout.To') </span>
                                <input class="form-control date" id="range-to-example" name="to_date" autocomplete="off">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>            
    </report-modal>
</div>
    <!-- END PAGE HEADER-->
    <div class="row">
        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase">@lang('layout.VehicleEquipmentList')</span>
                </div>
                <div class="tools"> </div>
                <div class="pull-right">
                     <span id="anchore-modal">
                         <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                            <i class="fa fa-print"></i>
                         </a>
                     </span>
                    @permission('vehicle-create')
                        <a href="{{route('vehicleEquipment.create')}}">
                            <!-- <button id="sample_editable_1_new" class="btn green btn-sm btn-outline"> -->
                            <button id="sample_editable_1_new" class="btn btn-success">
                                <i class="fa fa-plus"></i> @lang('layout.AddNew')
                            </button></a>
                    @endpermission    
                </div>
            </div>
            <div class="portlet-body">
                <template v-cloak id="company_ll">
                    <company @company="setCompany"></company>
                </template>
                <table class="table table-striped table-bordered table-hover" id="vehicleEquipments">
                    <thead>
                    <tr>
                        <th>#</th>
                        <th>@lang('layout.VehicleName')</th>
                        <th>@lang('layout.PlateNumber')</th>
                        <th>@lang('layout.Name')</th>
                        <th>@lang('layout.Value')</th>
                        <th>@lang('layout.Description')</th>
                        <th>@lang('layout.ChangeDate')</th>
                        <th>@lang('layout.Actions')</th>
                    </tr>
                    </thead>
                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>


    <!-- END TAB PORTLET-->

    <!-- END CONTENT BODY -->


@stop
 @include('print.modal')
 @include('groupCompanyFilter.select')
@push('scripts')
<script>
    $(document).ready(function() {
        $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
        $('#vehicleEquipments').DataTable( {
            ajax:'{{route("vehicleEquipment.index")}}',
            pageLength:'{{getPageRows()}}',
            order: [["{{orderByColumn()=='number'?2:6}}", "{{getRowOrder()}}"]],
            responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
            scrollCollapse: true,
            paging:         true,
            serverSide: true,


            columns: [  
                {data: 'DT_RowIndex', name: 'DT_RowIndex',orderable:false,searchable:false},
                { data: 'vehicle_name', name: 'vehicles.vehicle_name'},
                { data: 'palet_number', name: 'vehicles.palet_number'},
                { data: 'name',         name: 'name'},
                { data: 'value',          name: 'value',orderable:false,searchable:false },
                { data: 'description',  name: 'description'},
                { data: 'Date',         name: 'date'},
                { data: 'actions',      name: 'actions',orderable:false,searchable:false }





            ]
        });
    });
      Vue.component('v-select', VueSelect.VueSelect)


      // new for modal


var vm =new Vue({
            el: '#print-modal',
            data:{
                is_show:false,
                pdfRoute: '{!!route('export.PDFAll') !!}',
                excelRoute: '{!! route('export.ExcelAll') !!}',


            },  
            methods:{
                closeModal: function(){
                 this.is_show = !this.is_show
                },

    
            }
        });


new Vue({
    el:'#anchore-modal',
    methods:{
        showModal:function(){
            console.log('trr')
            vm.$data.is_show = true;
            
        }
    }
});
 // /new for modal

 new Vue({
    el: '#company_ll',
    methods: {
        setCompany: function (event) {
            window.location.reload();
        }
    }
});
 


    
</script>
@endpush
