@extends('layouts.app')
<link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css">
@section('content')
    <div class="row">

        <div class="portlet light bg-inverse" style="min-height: 100%;">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>&nbsp;
                    <span class="caption-subject font-green-haze bold uppercase">  @lang('layout.VehicleEquipmentEdit')</span>
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>
                <div class="tools">
                    
                </div>
            </div>
            <div id="app" class="portlet-body form" style="margin-bottom:50%;">
                <!-- BEGIN FORM-->
                {!! Form::model($vehicleEquipment, ['method' => 'PATCH','class'=>'form-horizontal','route' => ['vehicleEquipment.update',$vehicleEquipment->id]]) !!}
                {{ csrf_field() }}
                <div class="form-body">

                <div class="row">      

                    <div class="col-md-3">
                        <div class="form-group">
                            <label class="control-label col-md-3">@lang('menu.Vehicle'):</label>
                            <div class="col-md-9">
                                  <v-select 
                                    label="name" 
                                    :options="allVehicles"
                                    v-model="selected_driverVehicle"
                                    >
                                </v-select>
                                <input type="hidden" name="vehicle_id"
                                   :value="!selected_driverVehicle?null:selected_driverVehicle.id">
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label class="control-label col-md-3">@lang('layout.Date'):</label>
                            <div class="col-md-9">
                                {!! Form::text('date', null, array('placeholder' =>__('layout.Date'),'tabindex' =>'3','class' => 'form-control date','autocomplete'=>'off')) !!}
                            </div>
                        </div>
                    </div> 
       
                </div>

                    <div class="row">
                        <div class="col-xs-12">
                            <div class="table-responsive333 row">
                                <table id="table_content" class="table table-bordered ">
                                    <thead>
                                    <tr>
                                        <th class="text-center" >
                                            @lang('layout.Name')
                                        </th>
                                        <th class="text-center" >
                                            @lang('layout.Value')
                                        </th>
                                        <th class="text-center" >
                                            @lang('layout.Description')
                                        </th>
                                        <th class="text-center" >
                                            @lang('layout.PeriodQuantity')
                                        </th>
                                        <th class="text-center" >
                                            @lang('layout.ChangeDate')
                                        </th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <tr class="even">
                                        
                                        <td  >
                                            <div >
                                                {!! Form::text('name',null, array('placeholder' => __('layout.Name'),'class' => 'form-control','step'=>'any','min'=>'0')) !!}
                                            </div>
                                        </td>  
                                        <td  >
                                            <div >
                                                {!! Form::text('value',null, array('placeholder' => __('layout.Value'),'class' => 'form-control','step'=>'any','min'=>'0')) !!}
                                            </div>
                                        </td>
                                        <td >
                                            {{Form::text('description',null,['class' => 'form-control ','placeholder' =>__('layout.Description')])}}
                                        </td>
                                        <td>
                                            {!! Form::number('period_quantity',null, array('placeholder' => __('layout.PeriodQuantity'),'class' => 'form-control','step'=>'any','min'=>'0')) !!}
                                        </td>
                                        <td >
                                            {!! Form::text('change_date', null, array('placeholder' =>__('layout.ChangeDate'),'class' => 'form-control date','autocomplete'=>'off')) !!}
                                        </td>
                                      
                                    </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>

                   
                </div>
                <div class="col-xs-12 col-sm-10 col-md-11 text-center">
                    <button type="button" @click="handleSubmit($event)"
                            class="btn green">@lang('layout.Submit')</button>
                    <a href="{{route('vehicleEquipment.index')}}" class="btn default"><i
                                class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                </div>
                {!! Form::close() !!}
            </div>
            <!-- END FORM-->
        </div>
    </div>
@endsection
@push('scripts')
    <script>
        @if(App::getLocale())
    Vue.use(VeeValidate, {
        locale: '{{App::getLocale()}}',
    });
    @else
        Vue.use(VeeValidate, {
            locale: 'en',
        });
        @endif

        $(document).ready(function () {
            $('#initial-value-example').persianDatepicker({
                observer: true,
                format: 'YYYY/MM/DD',
                altField: '#observer-example-alt',
                altFormat: 'u',
                autoClose: true,
            });
        });
        Vue.component("v-select", VueSelect.VueSelect);


        var allVehicles = {!! $allVehicles !!};

        let vu = new Vue({
            el: '#app',
            data: {

                allVehicles: allVehicles,
                selected_driverVehicle: {!! json_encode($selected_driverVehicle) !!},

            },


            methods: {
                handleSubmit(e) {
                    this.$validator.validate().then(valid => {
                        if (valid) {
                            // alert(e.target);
                            regForm(e.target);
                        }
                    });
                },    
            }
        })

    </script>
@endpush 