@extends('layouts.app')
<link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css">
@section('content')
    <div class="row">

        <div class="portlet light bg-inverse" style="min-height: 100%;">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>&nbsp;
                    <span class="caption-subject font-green-haze bold uppercase">  @lang('layout.VehicleEquipmentCreate')</span>
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>
                <div class="tools">
                    
                </div>
            </div>
            <div id="app" class="portlet-body form" style="margin-bottom:50%;">
                <!-- BEGIN FORM-->
                {!! Form::open(array('route' => 'vehicleEquipment.store','method'=>'POST','class'=>'form-horizontal', 'id'=>'vehicle_equipment_form')) !!}
                {{ csrf_field() }}
                <div class="form-body">

                <div class="row">
                    <div class="col-md-3">
                        <div class="form-group">
                            <label class="control-label col-md-3">@lang('menu.Vehicle'):</label>
                            <div class="col-md-9">
                                  <v-select 
                                    label="name" 
                                    :options="allVehicles"
                                    v-model="selected_driverVehicle"
                                    >
                                </v-select>
                                <input type="hidden" name="vehicle_id"
                                   :value="!selected_driverVehicle?null:selected_driverVehicle.id" v-validate="'required'" data-vv-as="@lang('menu.Vehicle')">
                                        <span class="required">@{{ errors.first('vehicle_id') }}</span>
                                                    
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label class="control-label col-md-3">@lang('layout.Date'):</label>
                            <div class="col-md-9">
                                <input type="text" name="date" class="form-control date" autocomplete="off" >         
                            </div>
                        </div>
                    </div>

                </div>

                    <div class="row">
                        <div class="col-xs-12">
                            <div class="table-responsive333 row">
                                <table id="table_content" class="table table-bordered ">
                                    <thead>
                                    <tr>
                                        <th class="text-center" style="width:3px;">#</th>
                                        <th class="text-center" >
                                            @lang('layout.Name')
                                        </th>
                                        <th class="text-center" >
                                            @lang('layout.Value')
                                        </th>
                                        <th class="text-center" >
                                            @lang('layout.Description')
                                        </th>
                                        <th class="text-center" >
                                            @lang('layout.PeriodQuantity')
                                        </th>
                                        <th class="text-center" >
                                            @lang('layout.ChangeDate')
                                        </th>
                                        <th style="min-width: 4px;"></th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <tr v-for=" (row,itemIndex) in rows" class="even">
                                        <td class="td_one"><span span v-if="rows.length >1 " class="badge badge3 badge-roundless" style="background-color: transparent !important;color: black; ">@{{itemIndex+1}} </span>
                                        </td>
                                        <td  >
                                            <div >
                                                {!! Form::text('name[]',null, array('placeholder' => __('layout.Name'),'class' => 'form-control','step'=>'any','min'=>'0','v-on:focus'=>'(rows.length-1 == itemIndex)?addRow():null','v-model'=>'row.name')) !!}
                                            </div>
                                        </td>  
                                        <td>
                                            <div >
                                                {!! Form::text('value_text[]',null, array('placeholder' => __('layout.Value'),'class' => 'form-control','step'=>'any','min'=>'0','v-on:focus'=>'(rows.length-1 == itemIndex)?addRow():null','v-model'=>'row.value_text')) !!}
                                            </div>
                                        </td>
                                        <td >
                                            {{Form::text('description[]',null,['class' => 'form-control ','v-on:focus'=>'(rows.length-1 == itemIndex)?addRow():null','placeholder' =>__('layout.Description'),'v-model'=>'row.description'])}}

                                        </td>
                                        <td>
                                            {!! Form::number('period_quantity[]',null, array('placeholder' => __('layout.PeriodQuantity'),'class' => 'form-control','step'=>'any','min'=>'0','v-model'=>'row.period_quantity')) !!}
                                        </td>
                                        <td >
                                            <date_picker :name="'change_date['+itemIndex+']'" placeholder="@lang('layout.ChangeDate')" ></date_picker>
                                        </td>
                                        <td class="text-center">
                                            <span  v-if="rows.length >1 " v-on:click="deleteRow(itemIndex)"><i class="paddint-both fa fa-trash" style="color: red;font-size: 20px"></i></span>
                                        </td>
                                    </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>

                   
                </div>
                <div class="col-xs-12 col-sm-10 col-md-11 text-center">
                    <button type="button" @click="handleSubmit($event)"
                            class="btn green">@lang('layout.Submit')</button>
                    <button type="button" class="btn blue"
                            @click="saveAndNew($event)">@lang('layout.SaveAndNew')</button>
                    <a href="{{route('vehicleLocation.index')}}" class="btn default"><i
                                class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                </div>
                {!! Form::close() !!}
            </div>
            <!-- END FORM-->
        </div>
    </div>
@endsection
@push('scripts')
    <script>
        @if(App::getLocale())
    Vue.use(VeeValidate, {
        locale: '{{App::getLocale()}}',
    });
    @else
        Vue.use(VeeValidate, {
            locale: 'en',
        });
        @endif

        $(document).ready(function () {
            $('#initial-value-example').persianDatepicker({
                observer: true,
                format: 'YYYY/MM/DD',
                altField: '#observer-example-alt',
                altFormat: 'u',
                autoClose: true,
            });
        });
        Vue.component("v-select", VueSelect.VueSelect);


        var allVehicles = {!! $allVehicles !!};
        // alert(allVehicles);
        console.log(allVehicles)

        let vu = new Vue({
            el: '#app',
            data: {

                allVehicles: allVehicles,
                selected_driverVehicle: null,

                 rows: [
                    {
                        value_text: null,
                        name: null,
                        description: null,
                        period_quantity: null,
                        date: null
                    },
                    {
                        value_text: null,
                        name: null,
                        description: null,
                        period_quantity: null,
                        date: null
                    },
                ],
            },


            methods: {
                handleSubmit(e) {
                    this.$validator.validate().then(valid => {
                        if (valid) {
                            // alert(e.target);
                            regForm(e.target);
                        }
                    });
                },      
                



                saveAndNew() {
                    this.$validator.validate()
                        .then(valid => {
                            if (valid) {

                                var url = "{{route('vehicleEquipment.store')}}";
                                form_id = 'vehicle_equipment_form';
                                var data = $('#' + form_id).serialize();

                                axios.post(url, data)
                                    .then(function (response) {
                                        if (response.data.result == 1) {
                                            $('#' + form_id).trigger('reset');
                                            toastr.success('', response.data.message);
                                            vu.selected_driverVehicle = null;
                                            location.reload();
                                        }
                                        else {
                                            var message = "{{__('message.Warning')}}";
                                            //$('#error-sound')[0].play();
                                            toastr.warning('', message);
                                        }
                                    })
                                    .catch(function (error) {
                                        console.log(error);
                                        var message = "{{__('message.Warning')}}";
                                        //$('#error-sound')[0].play();
                                        toastr.warning('', message);
                                    });

                            }
                        })
                },

             addRow: function () {
                    this.rows.push(
                        {amount: null}
                    )
                },
                deleteRow: function (index) {
                    this.rows.splice(index, 1)
                },
            }
        })

    </script>
@endpush 