@extends('layouts.factor-master')

@section('content')
<?php
$report = customeReport('salary_details');
$_date=in_array('date', $report);
$_name=in_array('name', $report);
$_phone=in_array('phone', $report);
$_currency=in_array('currency', $report);
$_amount=in_array('amount', $report);
?>


<h3 class="table-caption" style="text-align: center;">@lang('layout.VehicleEquipmentReport')</h3>

<table class="main-table">
  <tr>
      @if($from_date)
          <td>
              <span>@lang('layout.FromDate')</span>:
              <BDO DIR="LTR"> @if(\Setting::get('jalali_and_gerogarian_date') == 'true')  {{convertDate($from_date, null, null, ((\Setting::get('date_type') == 'jalali')?'gregorian':'jalali'))}}  <span dir="rtl"> &nbsp;&nbsp;&nbsp;  @lang('layout.MarchingAt')  </span>  @endif  {{convertDate($from_date)}}</BDO>
          </td>
      @endif
      @if($to_date)
          <td>
              <span>@lang('layout.ToDate')</span>:
              <BDO DIR="LTR">@if(\Setting::get('jalali_and_gerogarian_date') == 'true')  {{convertDate($to_date, null, null, ((\Setting::get('date_type') == 'jalali')?'gregorian':'jalali'))}}  <span dir="rtl"> &nbsp;&nbsp;&nbsp;  @lang('layout.MarchingAt')  </span>  @endif  {{convertDate($to_date)}}</BDO>
          </td>
      @endif
  </tr>
</table>


<table   class="main-table">
  <tr>

  @if($vehicleName)
  <td>
    <span>@lang('layout.VehicleName')</span>:
    <BDO>{{$vehicleName}}</BDO>
  </td>
  @endif

</tr>
</table>
<br>
<table class="main-table">

  <thead>
    <tr class="bg">
    <td class="center" ><div> @lang('layout.Record') </div></td>
    @if($_date)<td class="center" ><div> @lang('layout.Date')</div></td>@endif
    @if($_currency)<td class="center" ><div> @lang('layout.Description')</div></td>@endif
    @if(!$vehicleName)
    @if($_date)<td class="center" ><div> @lang('layout.VehicleName')</div></td>@endif
    @endif
    @if($_date)<td class="center" ><div> @lang('layout.PlateNumber')</div></td>@endif
    @if($_name)<td class="center" ><div> @lang('layout.Name') </div></td>@endif
    @if($_phone)<td class="center" ><div> @lang('layout.Value')</div></td>@endif
  

  </tr>
  </thead>
  <?php
  $count = 0;
  ?>
  @foreach($data AS $record)
  <tr>
   
    <td class="center">{{++$count}}</td>
    @if($_date)<td class="center">{{convertDate($record->date)}}</td>@endif
    @if($_name)<td class="center">{{$record->description}}</td>@endif
    @if(!$vehicleName)
    @if($_name)<td class="center">{{$record->vehicle_name}}</td>@endif
    @endif
    @if($_name)<td class="center">{{$record->palet_number}}</td>@endif
    @if($_name)<td class="center">{{$record->name}}</td>@endif
    @if($_name)<td class="center">{{$record->value}}</td>@endif

  </tr>
  @endforeach
</table>

   <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->
@endsection