@extends('layouts.app')
@section('content')
@section('style')
@stop
<div class="row">

    <div class="portlet light bg-inverse" style="min-height: 100%;">
        <div class="portlet-title">
            <div class="caption">
                <i class="icon-equalizer font-green-haze"></i>&nbsp;
                <span class="caption-subject font-green-haze bold uppercase">@lang('layout.VehicleCategoriesCreate')</span>
                <!-- <span class="caption-helper">some info...</span> -->
            </div>
            <div class="tools">

            </div>
        </div>
        <div class="portlet-body form" style="margin-bottom:50%;" id="cloth_category" v-cloak>
            <!-- BEGIN FORM-->
            {!! Form::open(array('route' => 'vehicleCategory.store','method'=>'POST','class'=>'form-horizontal','id'=>'vehicleCategory-submit')) !!}
            {{ csrf_field() }}
            <div class="form-body">
                <div class="col-md-9">
                    <div class="form-group">
                        <label class="control-label col-md-3">@lang('layout.Name'):</label>
                        <div class="col-md-9">
                            {{Form::text('name',null,['class' => 'form-control','v-validate' =>'"required"','data-vv-as' => __('layout.Name'),'autofocus'=>'autofocus'])}}
                            <span class="required">@{{ errors.first('name') }}</span>
                        </div>
                    </div>
               
                    <div class="form-group">
                        <label class="control-label col-md-3">@lang('layout.Description'):</label>
                        <div class="col-md-9">
                            {!! Form::textarea('description', null, array('class' => 'form-control','rows' => 6, 'cols' => 30)) !!}

                        </div>
                    </div>
                </div>
            </div>
            <div class="col-xs-12 col-sm-12 col-md-11 text-center">
                <button @click="handleSubmit($event)" type="button" class="btn green">@lang('layout.Submit')</button>
                <button type="button" class="btn blue"
                                    @click="saveAndNew($event)">@lang('layout.SaveAndNew')</button>
                <a href="{{route('vehicleCategory.index')}}" class="btn default"><i
                            class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>

            </div>
            {!! Form::close() !!}
        </div>
        <!-- END FORM-->
    </div>
</div>

@endsection

@push('scripts')

    <script>

        @if(App::getLocale())
    Vue.use(VeeValidate, {
        locale: '{{App::getLocale()}}',
    });
    @else
        Vue.use(VeeValidate, {
            locale: 'en',
        });
        @endif

        let vu = new Vue({
                el: '#cloth_category',
                data: {},
                methods: {
                    handleSubmit(e) {
                        this.$validator.validate().then(valid => {
                            if (valid) {
                                // alert(e.target);
                                regForm(e.target);
                            }
                        });
                    },
                    saveAndNew() {
                    this.$validator.validate()
                        .then(valid => {
                            if (valid) {

                                var url = "{{route('vehicleCategory.store')}}";
                                form_id = 'vehicleCategory-submit';
                                var data = $('#' + form_id).serialize();
                                toggleBlock(true);
                                axios.post(url, data)
                                    .then(function (response) {
                                        toggleBlock(0);
                                        if (response.data.result == 1) {
                                            $('#' + form_id).trigger('reset');
                                            toastr.success('', response.data.message);
                                            location.reload();
                                        }
                                        else {
                                            var message = "{{__('message.Warning')}}";
                                            //$('#error-sound')[0].play();
                                            toastr.warning('', message); 
                                        }
                                    })
                                    .catch(function (error) {
                                        toggleBlock(0);
                                        var message = "{{__('message.Warning')}}";
                                        //$('#error-sound')[0].play();
                                        toastr.warning('', message);
                                    });

                            }
                        })
                },
                }
            })
    </script>
@endpush
