@extends('layouts.app')

@section('style')
<style type="text/css">
    .modal.in .modal-dialog {
        margin: 40px auto;
        width: 80%;
    }
</style>
@stop
@section('content')

<!------------------------------------------------------------------------------------------
-------------------------------------------------------------------------------------------->
<!--Expense Report Modal-->
<div id="print-modal">

    <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show" :value-type="'cmr_details'" @closed="closeModal">

        <div slot="body">
            <input type="hidden" name="id" value="{{$vehicleM->id}}" />
            <div class="row">
                <!-- <div class="form-group">
                    <div class="col-md-12">
                        <div class="form-group">
                            <label class="control-label"> @lang('layout.Date')</label>
                            <div class="input-group">
                                <input class="form-control date" id="range-from-example" name="from_date" autocomplete="off">

                                <span class="input-group-addon"> @lang('layout.To') </span>
                                <input class="form-control date" id="range-to-example" name="to_date" autocomplete="off">

                            </div>
                        </div>
                    </div>
                </div> -->
            </div>
        </div>
    </report-modal>
</div>
<!--End Expense Report Modal-->

<!--Locaion Report Modal-->
<div id="print-modal-location">

    <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show" :value-type="'vehicle_rent_locations'" @closed="closeModal">

        <div slot="body">
            <input type="hidden" name="id" value="{{$vehicleM->id}}" />
            <div class="row">
                <div class="form-group">
                    <div class="col-md-12">
                        <div class="form-group">
                            <label class="control-label"> @lang('layout.Date')</label>
                            <div class="input-group">
                                <input class="form-control date" id="range-from-example" name="from_date" autocomplete="off">

                                <span class="input-group-addon"> @lang('layout.To') </span>
                                <input class="form-control date" id="range-to-example" name="to_date" autocomplete="off">

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </report-modal>
</div>
<!--End Locaion Report Modal-->

<!--Expense Return Report Modal-->
<div id="print-modal-return">

    <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show" :value-type="'vehicle_rent_return'" @closed="closeModal">

        <div slot="body">
            <input type="hidden" name="id" value="{{$vehicleM->id}}" />
            <div class="row">
                <div class="form-group">
                    <div class="col-md-12">
                        <div class="form-group">
                            <label class="control-label"> @lang('layout.Date')</label>
                            <div class="input-group">
                                <input class="form-control date" id="range-from-example" name="from_date" autocomplete="off">

                                <span class="input-group-addon"> @lang('layout.To') </span>
                                <input class="form-control date" id="range-to-example" name="to_date" autocomplete="off">

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </report-modal>
</div>
<!--End Expense Return Report Modal-->

<!--Expense Return Report Modal-->
<div id="print-modal-receive">

    <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show" :value-type="'receivablePayment'" @closed="closeModal">

        <div slot="body">
            <input type="hidden" name="id" value="{{$vehicleM->id}}" />
            <div class="row">
                <!-- <div class="form-group">
                    <div class="col-md-12">
                        <div class="form-group">
                            <label class="control-label"> @lang('layout.Date')</label>
                            <div class="input-group">
                                <input class="form-control date" id="range-from-example" name="from_date" autocomplete="off">
                                <span class="input-group-addon"> @lang('layout.To') </span>
                                <input class="form-control date" id="range-to-example" name="to_date" autocomplete="off">
                            </div>
                        </div>
                    </div>
                </div> -->
            </div>
        </div>
    </report-modal>
</div>
<!--End Expense Return Report Modal-->
<!------------------------------------------------------------------------------------------
-------------------------------------------------------------------------------------------->


<div class="portlet">
    <div class="portlet-title" id="backbtn">
        <div class="caption">
            <i class=""></i>@lang('layout.VehicleRentShow')
        </div>
        <div class="tools">
            <a href="javascript:;" class="collapse" data-original-title="" title=""> </a>
            <a href="#portlet-config" data-toggle="modal" class="config" data-original-title="" title=""> </a>
            {{--<a href="javascript:;" class="reload" data-original-title="" title=""> </a>--}}
            {{--<a href="javascript:;" class="remove" data-original-title="" title=""> </a>--}}
        </div>
    </div>
    <div class="portlet-body">
        <table class="table table-striped table-bordered table-advance   table-hover" id="table_info">
            <thead>
                <tr>
                    <th style="background-color: rgb(80, 129, 141) !important;">
                        <i class="fa fa-bars"></i> @lang('layout.Number')
                    </th>
                    <th style="background-color: rgb(80, 129, 141) !important;">
                        <i class="fa fa-bars"></i> @lang('layout.ReferenceNumber')
                    </th>
                    <th style="background-color: rgb(80, 129, 141) !important;">
                        <i class="fa fa-user"></i> @lang('layout.Customer')
                    </th>
                    <th style="background-color: rgb(80, 129, 141) !important;">
                        <i class="icon-phone"></i> @lang('layout.Phone')
                    </th>
                    <th style="background-color: rgb(80, 129, 141) !important;">
                        <i class="fa "></i> @lang('layout.Count') CMR
                    </th>
                    <th style="background-color: rgb(80, 129, 141) !important;">
                        <i class=""></i> @lang('layout.Address')
                    </th>
                    <th style="background-color: rgb(80, 129, 141) !important;">
                        <i class="fa fa-clock-o"></i> @lang('layout.Date')
                    </th>
                    <th style="background-color: rgb(80, 129, 141) !important;">
                        <i class="fa "></i> @lang('layout.Description')
                    </th>
                    <th style="background-color: rgb(80, 129, 141) !important;">
                        <i class="fa fa-user"></i> @lang('layout.User')
                    </th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td> {{ $vehicleM->number}} </td>
                    <td> {{ $vehicleM->ref_no}} </td>
                    <td> {{ $vehicleM->customer_name}}  {{ $vehicleM->code}} </td>
                    <td> {{ $vehicleM->customer_phone}} </td>
                    <td> {{ $vehicleM->cmr_count}}</td>
                    <td> {{ $vehicleM->address}}</td>
                    <td> {{ $vehicleM->date}}</td>
                    <td> {{ $vehicleM->description}}</td>
                    <td> {{ $vehicleM->user}}</td>
                </tr>
            </tbody>
        </table>
        <table class="table table-striped table-bordered table-advance   table-hover" id="table_info">
            <thead>
                <tr>
                    <th style="background-color: rgb(80, 129, 141) !important;">
                        <i class="fa  "></i> @lang('layout.Currency')
                    </th>
                    <th style="background-color: rgb(80, 129, 141) !important;">
                        <i class="fa "></i> @lang('layout.Rate')
                    </th>
                    <th style="background-color: rgb(80, 129, 141) !important;">
                        <i class="fa "></i> @lang('layout.Amount')
                    </th>
                    <th style="background-color: rgb(80, 129, 141) !important;">
                        <i class="fa fa-get-pocket" style="color: green"></i> @lang('layout.Receive')
                    </th>
                    <th style="background-color: rgb(80, 129, 141) !important;">
                        <i class="fa fa-minus-circle" style="color:#E87E04"></i> @lang('layout.RemainAmount')
                    </th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td> {{ $vehicleM->currency}}</td>
                    <td> {{ $vehicleM->rate}}</td>
                    <td> {{ myRound($vehicleM->amount)}}</td>
                    <td> {{ myRound($totalRecevie)}}</td>
                    <td> {{ myRound($totalPAmount)}}</td>
                </tr>
            </tbody>
        </table>
    </div>
</div>
<div class="row">
    <div class="col-md-12">
        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase">@lang('layout.VehicleCMRDetails')</span>
                </div>

            </div>
            <div class="tabbable-line">
                <ul class="nav nav-tabs ">
                    <li class="active">
                        <a href="#cmr_details" data-toggle="tab" id="expensesd"> CMR @lang('layout.Details') <i class="fa fa-list-alt"></i></a>
                    </li>
                    <li>
                        <a href="#receivablePayment" data-toggle="tab" id="recevie"> @lang('layout.Recevies') <i class="fa fa-credit-card"></i></a>
                    </li>
                    <li>
                        <a href="#attachments_tab" data-toggle="tab" id="attachments"> @lang('layout.Attachments') </a>
                    </li>

                </ul>
                <div class="tab-content">

                    <div class="tab-pane active" id="cmr_details">
                        <div class="">
                            <!-- BEGIN EXAMPLE TABLE PORTLET-->
                            <div class="portlet light bordered">
                                <div class="portlet-title">
                                    <div class="caption font-dark">
                                        <i class="icon-settings font-dark"></i>
                                        <span class="caption-subject bold uppercase">CMR @lang('layout.Details')</span>
                                    </div>
                                    <div class="actions">

                                        <span id="anchore-modal">
                                            <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                                                <i class="fa fa-print"></i>
                                            </a>
                                        </span>

                                    </div>
                                </div>
                                <div class="portlet-body" id="itemsshow">
                                    <table class="table table-striped table-bordered table-hover" id="cmr_details-table">
                                        <thead>
                                            <tr>
                                                <th>@lang('layout.Driver')</th>
                                                <th>@lang('layout.VehicleName')</th>
                                                <th>@lang('layout.Amount')</th>
                                                <th>@lang('layout.Currency')</th>
                                                <th>@lang('layout.Rate')</th>
                                                <th>@lang('layout.Source')</th>
                                                <th>@lang('layout.Destination')</th>
                                            </tr>
                                        </thead>
                                    </table>
                                </div>
                            </div>
                            <!-- END EXAMPLE TABLE PORTLET-->
                        </div>
                    </div>

                    <div class="tab-pane" id="receivablePayment">
                        <div class="tab-pane" id="tab_15_1">

                            <div class="">
                                <!-- BEGIN EXAMPLE TABLE PORTLET-->
                                <div class="portlet light bordered">
                                    <div class="portlet-title">
                                        <div class="caption font-dark">
                                            <i class="icon-settings font-dark"></i>
                                            <span class="caption-subject bold uppercase">@lang('layout.Recevies')</span>
                                        </div>
                                        <div class="actions">
                                            <span id="anchore-modal-receive">
                                                <a href="#" @click.prevent="showModal" id="" class="btn" style="background-color: rgb(80, 129, 141) !important; color: white;">
                                                    <i class="fa fa-print"></i>
                                                </a>
                                            </span>

                                        </div>
                                    </div>
                                    <div class="portlet-body">
                                        <table class="table table-striped table-bordered table-hover" id="receivablePayment-table">
                                            <thead>
                                                <tr>
                                                    <th>@lang('layout.Number')</th>
                                                    <th>@lang('layout.ReferenceNumber')</th>
                                                    <th>@lang('layout.Account')</th>
                                                    <th>@lang('layout.Currency')</th>
                                                    <th>@lang('layout.Rate')</th>
                                                    <th>@lang('layout.Type')</th>
                                                    <th>@lang('layout.Amount')</th>
                                                    <th>@lang('layout.Date')</th>
                                                </tr>
                                            </thead>
                                        </table>
                                    </div>
                                </div>
                                <!-- END EXAMPLE TABLE PORTLET-->
                            </div>
                        </div>
                    </div>

                    <div class="tab-pane" id="attachments_tab">
                        <div class="tab-pane" id="tab_15_1">

                            <!-- BEGIN EXAMPLE TABLE PORTLET-->
                            <div class="portlet light bordered">
                                <div class="portlet-title">
                                    <div class="caption font-dark">
                                        <i class="icon-settings font-dark"></i>
                                        <span class="caption-subject bold uppercase">@lang('layout.Attachments')</span>
                                    </div>

                                </div>
                                <div class="portlet-body">
                                    <div class="portlet light bordered">
                                        <div class="portlet-body">

                                            <form role="form" action="{{route('attachment.store')}}" method="post" enctype="multipart/form-data">
                                                @csrf
                                                <input type="hidden" name="redirect_route" value="vehicleCMR.show">
                                                <input type="hidden" name="foreign_data_id" value="{{$vehicleM->id}}">
                                                <input type="hidden" name="path" value="uploads/vehicle_cmr">
                                                <input type="hidden" name="table_name" value="vehicle_cmr">

                                                <div class="row">
                                                    <div class="col-md-4">
                                                        <div class="form-group">
                                                            <label class="control-label">@lang('layout.AttachmentTitle')</label>
                                                            <input type="text" name="title" class="form-control">
                                                        </div>
                                                    </div>
                                                    <div class="col-md-4">
                                                        <div class="form-group">
                                                            <label class="control-label">@lang('layout.Description')</label>
                                                            <textarea name="description" class="form-control"></textarea>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-7">
                                                        <div class="form-group">
                                                            <div class="fileinput fileinput-new" data-provides="fileinput">
                                                                <div class="fileinput-new thumbnail" style="width: 200px; height: 150px;">
                                                                    <img src="" alt=""> </div>
                                                                <div class="fileinput-preview fileinput-exists thumbnail" style="max-width: 200px; max-height: 150px; line-height: 10px;"> </div>
                                                                <div>
                                                                    <span class="btn default btn-file">
                                                                        <span class="fileinput-new">@lang('layout.SelectFile')</span>
                                                                        <span class="fileinput-exists">@lang('layout.Change')</span>
                                                                        <input type="hidden" value="" name=""><input type="file" name="photo"> </span>

                                                                    <a href="javascript:;" class="btn default fileinput-exists" data-dismiss="fileinput"> @lang('layout.Remove') </a>
                                                                </div>

                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>

                                                <div class="margiv-top-10">
                                                    <button type="button" onclick="regForm(this)" class="btn green"> @lang('layout.Submit') </button>
                                                    <a href="{{route('receive.index')}}" class="btn default">@lang('layout.Cancel')</a>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                    <table class="table table-striped table-bordered table-hover" id="attachment">
                                        <thead>
                                            <tr>
                                                <th>@lang('layout.AttachmentTitle')</th>
                                                <th>@lang('layout.Description')</th>
                                                <th>@lang('layout.Action')</th>
                                            </tr>
                                        </thead>
                                    </table>
                                </div>
                            </div>
                            <!-- END EXAMPLE TABLE PORTLET-->

                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>
@endsection
@include('print.modal')
@push('scripts')
<script>
    function ProjectGlassesPrint(id) {
        @if(!Session('project'))
        var a = document.createElement('a');
        a.href = "{{url('projectGlassPrint')}}/" + id;
        a.target = "_blank";
        document.body.appendChild(a);
        a.click();
        document.body.removeChild(a);
        @else

        var u = "{{url('projectGlassPrint')}}/" + id;
        window.location.href = u;
        @endif
    }

    $(document).ready(function() {
        $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
        $('#cmr_details-table').DataTable({
            scrollCollapse: true,
            responsive:'{{responsiveDataTable()}}',
            pagingType:'{{paginationType()}}',
            serverSide: true,
            paging: true,
            retrieve: true,
            ajax: {
                url: '{{route("vehicleCMR.show",$vehicleM->id)}}',
                data: {
                    type: 'cmr_details'
                }
            },
            columns: [{
                    data: 'name',
                    name: 'name'
                },
                {
                    data: 'vehicle_name',
                    name: 'vehicle_name'
                },
                {
                    data: 'amount',
                    name: 'amount'
                },
                {
                    data: 'currency',
                    name: 'currency'
                },
                {
                    data: 'rate',
                    name: 'rate'
                },
                {
                    data: 'source',
                    name: 'source'
                },
                {
                    data: 'destination',
                    name: 'destination'
                }
            ]
        });
    });

    $(document).ready(function() {
        $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
        $('#recevie').on('shown.bs.tab', function(event) {
            // alert('adads');
            $('#receivablePayment-table').DataTable({
                scrollCollapse: true,
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                serverSide: true,
                paging: true,
                retrieve: true,
                ajax: {
                    url: '{{route("vehicleCMR.show",$vehicleM->id)}}',
                    data: {
                        type: 'receivablePayment'
                    }
                },
                columns: [
                    {
                        data: 'number',
                        name: 'number'
                    },
                    {
                        data: 'ref_no',
                        name: 'ref_no'
                    },
                    {
                        data: 'account',
                        name: 'account'
                    },
                    {
                        data: 'currency',
                        name: 'currency'
                    },
                    {
                        data: 'rate',
                        name: 'rate'
                    },
                    {
                        data: 'type',
                        name: 'type'
                    },
                    {
                        data: 'amount',
                        name: 'amount'
                    },
                    {
                        data: 'date',
                        name: 'date',
                        orderable: false,
                        searchable: false
                    }
                ]
            });
        });

        $(document).ready(function() {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';

            $('#attachment').DataTable({
                ajax: {
                    url: '{{route("vehicleCMR.show",$vehicleM->id)}}',
                    data: {
                        type: 'attachment'
                    }
                },

                scrollCollapse: true,
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                serverSide: true,
                paging: true,
                columns: [

                    {
                        data: 'title',
                        name: 'attachments.title'
                    },
                    {
                        data: 'description',
                        name: 'attachments.description'
                    },
                    {
                        data: 'actions',
                        name: 'actions',
                        orderable: false,
                        searchable: false
                    },
                ]
            });



        });

    });

    //Export Vue

    var vme = new Vue({

        el: '#print-modal',
        data: {
            is_show: false,
            pdfRoute: '{!!route('vehicleCMR.report') !!}',
            excelRoute: '{!! route('vehicleCMR.report') !!}',
        },

        methods: {
            closeModal: function() {
                this.is_show = !this.is_show;
            }
        }
    });

    new Vue({
        el: '#anchore-modal',
        methods: {
            showModal: function() {
                console.log('trr')
                vme.$data.is_show = true;
            }
        }
    });
    //Location Report
    var vml = new Vue({

        el: '#print-modal-location',
        data: {
            is_show: false,
            pdfRoute: '{!!route('vehicleCMR.report') !!}',
            excelRoute: '{!! route('vehicleCMR.report') !!}',
        },

        methods: {
            closeModal: function() {
                this.is_show = !this.is_show;
            }
        }
    });

    new Vue({
        el: '#anchore-modal-location',
        methods: {
            showModal: function() {
                console.log('trr')
                vml.$data.is_show = true;
            }
        }
    });

    //return Report
    var vmr = new Vue({

        el: '#print-modal-return',
        data: {
            is_show: false,
            pdfRoute: '{!!route('vehicleCMR.report') !!}',
            excelRoute: '{!! route('vehicleCMR.report') !!}',
        },

        methods: {
            closeModal: function() {
                this.is_show = !this.is_show;
            }
        }
    });

    new Vue({
        el: '#anchore-modal-return',
        methods: {
            showModal: function() {
                console.log('trr')
                vmr.$data.is_show = true;
            }
        }
    });

    //receive Report
    var vmre = new Vue({

        el: '#print-modal-receive',
        data: {
            is_show: false,
            pdfRoute: '{!!route('vehicleCMR.report') !!}',
            excelRoute: '{!! route('vehicleCMR.report') !!}',
        },

        methods: {
            closeModal: function() {
                this.is_show = !this.is_show;
            }
        }
    });

    new Vue({
        el: '#anchore-modal-receive',
        methods: {
            showModal: function() {
                console.log('trr')
                vmre.$data.is_show = true;
            }
        }
    });
</script>


@endpush