<?php

namespace App\Http\Controllers\Project;
use App\Models\Project; 
use App\Models\Account; 
use App\Models\MemberTyp; 
use App\Models\Member; 
use App\Models\Currency; 
use App\Models\MemberTransaction;
use App\Models\Transaction;
use App\Models\ProjectExpense;
use App\Models\ProjectServices;
use App\Models\ProjectTransaction;
use App\Models\ProjectDetails;
use App\Models\ProjectItem;
use App\Models\ProjectBuild;
use App\Models\ReceivablePayment;
use App\Models\Inventory;
use App\Models\InventorySite;
use App\Models\Item;
use App\Models\MeasureUnit;
use App\Models\Stock;
use App\Models\StockOut;
use App\Models\Glass;
use App\Models\WorkType;
use App\Models\ProjectProgress;
use App\Models\ProjectExpenseDetails;
use Carbon\Carbon;
use App\Models\User;
use DB; 
use Hekmatinasser\Verta\Verta;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Yajra\Datatables\Datatables;

class ProjectController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */ 
    Protected $project;
    Protected $account;
    Protected $member;
    Protected $currency;
    Protected $transaction;
    Protected $projectExpense;
    protected $projectDetails;
    protected $measure;
    protected $item;
    protected $inventory;
    protected $inventorySite;
    protected $glass;
    protected $projectServices;
    protected $customer;
    protected $worktype;
    protected $projecxtProgress;
    protected $projectExpenseDetails;
    protected $receivablePayment;
    protected $projectItem;
    protected $projectBuild;
    protected $projectTransaction;

    public function __construct(
        Project           $project,
        Account           $account,
        MemberTyp         $member,
        Member            $customer,
        Currency          $currency,
        Transaction       $transaction,
        ProjectExpense    $projectExpense,
        ProjectDetails    $projectDetails,
        MeasureUnit       $measure,
        Item              $item,
        InventorySite     $inventorySite,
        Inventory         $inventory,
        Glass             $glass ,
        ProjectServices   $projectServices,
        WorkType          $worktype,
        ProjectProgress   $projectProgress,
        ProjectExpenseDetails   $projectExpenseDetails,
        ReceivablePayment $receivablePayment,
        ProjectItem       $projectItem,
        ProjectBuild      $projectBuild,
        ProjectTransaction $projectTransaction

    )
    {
        $this->currency              = $currency;
        $this->account               = $account;
        $this->project               = $project;
        $this->transaction           = $transaction;
        $this->member                = $member;
        $this->projectExpense        = $projectExpense;
        $this->projectDetails        = $projectDetails;
        $this->measure               = $measure;
        $this->inventory             = $inventory;
        $this->inventorySite         = $inventorySite;
        $this->glass                 = $glass;
        $this->projectServices       = $projectServices;
        $this->item                  = $item;
        $this->customer              = $customer;
        $this->worktype              = $worktype;
        $this->projectProgress       = $projectProgress;
        $this->projectExpenseDetails = $projectExpenseDetails;
        $this->receivablePayment     = $receivablePayment;
        $this->projectItem           = $projectItem;
        $this->projectBuild          = $projectBuild;
        $this->projectTransaction    = $projectTransaction;

    }
    public function index(Request $request)
    {
       
            $projects = $this->project->get(['name','id']);
            // $pro = $project->get()->toArray();
            // dd($pro[0]);
            // $dates = date_diff(date_create($pro[0]['endDate']),date_create($pro[0]['startDate']));
            // dd($dates->days);
        $user = auth()->user();
        if($request->ajax()) // This is check ajax request
        {
            $project = $this->project->getProject();

            return Datatables::of($project) 
                  ->addColumn('startDate', function ($project) {
                $html =   ' <div>
                '.convertDate($project->startDate).
                '
                </div>';
                return $html;
            })
            ->addColumn('endDate', function ($project) {
                $html =   ' <div>
                '.convertDate($project->endDate).
                '
                </div>';
                return $html;
            })

             ->addColumn('actions', function ($project) use ($user) {
                $html = '';
                 $html = '<div class="ui-group-buttons">
                                         <button class="btn btn-success" role="button" onclick="ProjectFactorPrint('.$project->project_id.')"><span class="fa fa-print"></span></button>';

                $html  .=  '<div class="ui-group-buttons">
                <a href="'. route('project.show',['id'=>$project->project_id]) .'" class="btn btn-success" role="button"><span class="fa fa-info-circle"></span></a>';

                
                    $html .= '<a href="'. route('project.edit',['id'=>$project->project_id]) .'" class="btn btn-primary" role="button"><span class="fa fa-pencil"></span></a>';
                

                // if(\Entrust::can('project-delete')) {
                    $html .= '<form action="'. route('project.destroy',['id'=>$project->project_id]) .'" method="post" class="inline">
                    <input type="hidden" name="_method" value="DELETE" />
                    <input type="hidden" name="_token" value="'.csrf_token().'" />
                    <button onclick="deleteItem(this); return false;" class="btn btn-danger " role="button"><span class="fa fa-times"></button>
                    </form>';

                // }
                    // if(\Entrust::can('project-delete')) {
                     // $html .= '<a href="'. route('project-maintenance.show',['id'=>$project->project_id]) .'" class="btn btn-primary" role="button"><span class="fa  "></span> </a>';

                // }
                $html .=  ' </div>';
                return $html;
            })
              ->editColumn('color', function ($project) {
                $color='';
                if($project->color)
                {
                    $html ='<span style="background-color:'.$project->color.';width:10px;height:6px;">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span>';
                    return $html;
                }
               
                return $color;
            })
               ->addColumn('status', function ($project) {
                    $dates = date_diff(date_create($project->endDate),date_create($project->startDate));
                    $html='';
                    if($dates->days>20){
                      $html ='<span width:10px;height:6px;" style="background-color:#f0f000;">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span>';  
                    }
                    if($dates->days<20){
                      $html ='<span width:10px;height:6px;" style="background-color:yello;">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span>';  
                    }
                    if($dates->days<5){
                      $html ='<span width:10px;height:6px;" style="background-color:red;">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span>';  
                    }
                    
                    return $html;
                // return $days;
            })->make(true);
        }
        return view('projects.index',compact('projects'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $member       = $this->member->Customer(); 
        $currency     = $this->currency->get(['code','id']);
        $work_types    = $this->worktype->get(['name','id']);
        $project_progress =$this->projectProgress->get(['name','id']);
        // dd($project_progress);
        $measureList        = $this->measure->getAllUnitMeasure();
        $inventoryList      = $this->inventory->getListOfInventory1();
        
        $all_item           = $this->inventorySite->getInventory();
         
        $inventoryList      = $inventoryList->map(function ($inventoryList) use ($all_item,$measureList){

            $inventorySitelist  =  $all_item->where('inventory_id',$inventoryList->id);
            $itemMeasure        =  $measureList->where('measure_id',$inventoryList->measure_id)->first();
            $itmeMeasureList    =  ($measureList->where('metric_id',$itemMeasure->metric_id))->toArray();

            return [
                'id'           => $inventoryList->id,
                'name'         => $inventoryList->name,
                'avg_cost'     => $inventoryList->avg,
                'rate'         => $inventoryList->rate,
                'measureList'  => $itmeMeasureList,
                'measure_unit' => $itemMeasure->measure_unit,
                'measure'      => $itemMeasure,
                'siteList'     => $inventorySitelist,
                'site'         => $inventorySitelist->first(),
                'qty'          => null
            ];

        });

        $services = $this->item->getServiceList();
        $serviceList = $services->map(function ($services) use ($measureList){

            $itemMeasure        =  $measureList->where('measure_id',$services->um_id)->first();
            $itmeMeasureList    =  ($measureList->where('metric_id',$itemMeasure->metric_id))->toArray();
            return [
                'id'           => $services->id,
                'name'         => $services->name,
                'cost'         => $services->cost,
                'rate'         => $services->rate,
                'measure'      => $itemMeasure,
                'measure_unit' => $itemMeasure->measure_unit,
                'measureList'  => $itmeMeasureList,
                'qty'          => null,
                'height'       => null,
                'width'        =>null,

            ];
        });  
        $inventoryList = json_encode($inventoryList);
        $serviceList = json_encode($serviceList);
       
        return view('projects.create',[ 
            'inventoryList'    => $inventoryList,
            'serviceList'      => $serviceList,
            'measureList'      => $measureList,
            'currency'         => $currency,
            'member'           => $member,
            'work_types'       => $work_types,
            'project_progress' => $project_progress,
        ]);
    }
    public function mpshow( Request $request,$id)
    {
		
		$projectdetail = $this->projectExpense->projectDetail($id);
         // dd($projectdetail);
         $project    = $this->project->get(['number','name','id']);
         $user = auth()->user();
         // $expenseInfoitem  =$this->projectExpenseDetails->InfoProjectExpenseDetailsItem(56);
            // dd($expenseInfoitem->toArray());
        if($request->ajax())
        {
        if(($request->has('type')) && $request->get('type') == 'item')
        {
            $expenseInfoitem  =$this->projectExpenseDetails->InfoProjectExpenseDetailsItem($request->get('item_id'));
            return Datatables::of($expenseInfoitem)->make(true); 
        }
        if(($request->has('type')) && $request->get('type') == 'itemnotstock')
        {
            $expenseInfoitem=$this->projectExpenseDetails->InfoProjectExpenseDetails($request->get('item_id'));
            return Datatables::of($expenseInfoitem)->make(true); 
        }
            $project_expences = $this->projectExpense->everyProjectexpenseList($id);
            return Datatables::of($project_expences)
                ->addColumn('Date', function ($project_expences) {
                    $html =   ' <div>
                    '.convertDate($project_expences->date).
                    '
                    </div>';
                    return $html;
                })
                 ->addColumn('detail', function ($project_expences) {
                    $html = '<div class="ui-group-buttons">';
                    $html .= '<a href="#" class="btn btn-primary" role="button" id="show_btn" data-id="'.$project_expences->id.'"><span class="fa fa-info-circle"></span></a>';
                    $html .=  '</div>';
                return $html;
                })
            ->make(true);
      
        }
		
    
        return view('projects.project-maintenance', compact('project','id','expenseInfo','projectdetail'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        // dd($request->get('totalAmountss'));
        $request->validate([
            'name'                       =>'required',
            'number'                     =>'required',
            'currency'                   =>'required',
            'currency_rate'              =>'required',
            'type'                       =>'required',
            'customer_id'                =>'required',

        ]);
       $start_date = Carbon::now();
       if ($request->get('start_date') != '') {
          $start_date= changeDateFormat($request->get('start_date'));
       }
       $end_date = Carbon::now();
       if ($request->get('end_date') != '') {
          $end_date= changeDateFormat($request->get('end_date'));
       }
        $projectName     = $request->get('name');
        $member          = $this->customer->find($request->get('customer_id'));
        $membername      = $member->name;
        $receivable_id   = $member->receivable_id;

        $project         = $request->get('project'); 
        $production_id   = $request->get('production_id');
        $inventory_id    = $request->get('inventory_id');
        $service_id      = $request->get('service_id');
        $totalAmountss   = $request->get('totalAmountss');

        $total_amountss    = $request->get('totalAmountss');
        $discount = $request->get('discount');
        $discountTotal = $request->get('discountTotal');
        $discount_type = $request->get('discount_type');


        DB::beginTransaction(); 
            // try {
        $customerName = Member::find($request->get('customer_id'))->name;
        $en_remark_dis   = "Discount (".$request->get('number'). ") for " . $customerName;
        $af_remark_dis   = "تخفیف (".$request->get('number').") برای " . $customerName;
        $discountAccount   = $this->account->getCustomerDiscountAccount()->id;
        $discountTran =null;
        // dd($discount);
        if($discount && $discount_type =="currency")
        {
            $discountTr      = pushTransaction($discountAccount, $discount*-1,0,null,null , $en_remark_dis, $af_remark_dis, $start_date);
            $discountTran    = $discountTr->id;
        }
        else if($discount && $discount_type =="percent")
        {
            $discountTr      = pushTransaction($discountAccount,($discount*$total_amountss)/100*-1,0,null,null , $en_remark_dis, $af_remark_dis, $start_date);
            $discountTran    = $discountTr->id;
        }
        $remark_en   = "Project for (".$membername.")";
        $remark_af   = "پروژه برای  (".$membername.")";

        $projectTran      = pushTransaction($receivable_id,$totalAmountss-1,0,null,null , $remark_en, $remark_af, $start_date);

                   
        $p_data=[
            'name'                       =>trim($request->get('name')),
            'number'                     =>$request->get('number'),
            'customer_id'                =>$request->get('customer_id'),
            'start_date'                 =>$start_date,
            'end_date'                   =>$end_date,
            'location'                   =>$request->get('location'),
            'province'                   =>$request->get('province'),
            'district'                   =>$request->get('district'),
            'currency'                   =>$request->get('currency'),
            'rate'                       =>$request->get('currency_rate'),
            'type'                       =>$request->get('type'),
            'color'                      =>$request->get('color'),
            'maintainance_duration'      =>$request->get('maintainance_duration'),
            'work_type_id'               =>$request->get('work_type_id'),
            'project_progress_id'        =>$request->get('project_progress_id'),
            'description'                =>$request->get('description'),
            'discount_transaction'       =>$discountTran!= 0?$discountTran:0,
            'discount_type'              =>$discount_type,
            'project_transaction'        =>$projectTran->id,
        ];
        $projects = $this->project->create($p_data);
        $projectTr    = $this->projectTransaction->create([
            'project_id'      => $projects->id,
            'transaction_id'  => $projectTran->id
        ]);
        if($production_id)
            {
                for ($i=0; $i<count($request->get('production_id')) ; $i++) { 
                  if($production_id[$i] !=null && $production_id[$i]>0)
                  {
                      $production = $projects->projectDetails()->create([
                          'production_item_id'  => $request->get('production_id')[$i],
                          'height'              => $request->get('x')[$i],
                          'width'               => $request->get('width')[$i],
                          'measure_id'          => $request->get('production_measure')[$i],
                          'quantity'            => $request->get('pquantity')[$i],
                          'price'               => $request->get('prate')[$i],
                          'description'         => $request->get('pDescription')[$i],
                      ]);
                  }
                } 
            } 
            if($service_id)
            {
                for($i=0; $i<count($service_id); $i++) { 
                  if($service_id[$i] !=null && $service_id[$i]>0)
                  {
                        $items = $this->item->find($service_id[$i]);

                        $amount = ($request->get('service_qty')[$i] * $request->get('service_price')[$i]);

                        $en_remark = "Project Services (" . $items->name . ") for " . $projectName;
                        $af_remark = $projectName . ") برای" . $items->name . "خدمات (";

                        $inct = pushTransaction($items->account_id, $amount / $request->get('currency_rate'),0, null,null,$en_remark, $af_remark, $start_date);
                        $costt = null;
                        $items = $items->costs()->first(); 
                        if ($items) {
                            $costt =  pushTransaction($items->id, $items->amount, null, null,null,$en_remark, $af_remark, $start_date);
                        }
                      $services    = $projects->projectServices()->create([
                          'item_id'              => $request->get('service_id')[$i],
                          'price'                => $request->get('service_price')[$i],
                          'quantity'             => $request->get('service_qty')[$i],
                          'um_id'                => $request->get('service_measure')[$i],
                          'price'                => $request->get('service_price')[$i], 
                          'income_transaction'   => $inct->id,
                          'cost_transaction'     =>($costt)?$costt->id:null,

                      ]);
                  }
                } 

            } 
         DB::commit();

            // } catch (\Exception $e) {
            //     DB::rollBack();
            //     return redirect()->back()->withErrors(['error'=>'Please Check Your Data!']);
            // }
                return redirect()->route('project.index')->with(['project_id'=>$projects->id,'message'=>__('layout.Project').' '.__('message.CSuccess')]);



    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show(Request $request, $id)
    {
      $project = $this->project->getProjectCustomer($id);
      $remainDate = date_diff(date_create($project->endDate),date_create(date_format(date_create(),"m/d/Y")));
      // dd($remainDate->days);
      $totalMaintain   = $this->projectExpense->getTotalExpense($id);
      $totalRecevie    = $this->receivablePayment->getTotalRecevie($id);
      // $projectItem = $this->projectBuild->getProjectUsedItems($id);
      // dd($projectItem->toArray());
      
      if($request->ajax()){
        if(($request->has('type')) && $request->get('type') == 'expenses')
        {
            $expenses = $this->projectExpense->getexpenses($id);
            return Datatables::of($expenses)->addColumn('actions', function ($project)  {
                                
                $html = '<div class="ui-group-buttons">';
                $html .= '<a href="#" class="btn btn-primary" role="button" id="show_btn" data-id="'.$project->id.'"><span class="fa fa-info-circle"></span></a>';
                $html .=  '</div>';
                return $html;
            })->make(true); 
        } 
        if(($request->has('type')) && $request->get('type') == 'items')
        {
            $items = $this->projectDetails->getItems($id);
            return Datatables::of($items)->make(true); 
        }
        if(($request->has('type')) && $request->get('type') == 'item') 
        {
            $expenseInfoitem  =$this->projectExpenseDetails->InfoProjectExpenseDetailsItem($request->get('item_id'));
            return Datatables::of($expenseInfoitem)->make(true); 
        }
        if(($request->has('type')) && $request->get('type') == 'itemnotstock')
        {
            $expenseInfoitem=$this->projectExpenseDetails->InfoProjectExpenseDetails($request->get('item_id'));
            return Datatables::of($expenseInfoitem)->make(true); 
        }
        if(($request->has('type')) && $request->get('type') == 'receivablePayment')
        {
            $recevies = $this->receivablePayment->getProjectReceive($id);
            
            return Datatables::of($recevies)->make(true); 
        }
        if(($request->has('type')) && $request->get('type') == 'services')
        {
            $services = $this->projectServices->projectServices($id);
            return Datatables::of($services)->make(true); 
        }
        if($request->has('type') && $request->get("type") == 'usedItems'){
            $projectItem = $this->projectBuild->getProjectUsedItems($id);
            return Datatables::of($projectItem)->make(true);
        }
        if($request->has('type') && $request->get("type") == 'glassDetails'){
            $glass = $this->glass->getProjectGlasses($id);
            return Datatables::of($glass)->make(true);
        }

      }
      return view("projects.show",compact("project","remainDate","totalMaintain","totalRecevie"));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $projects=$this->project->projectEdit($id);
       // dd($projects);
        $projectItems = $this->projectDetails->getItems($id);
        // dd($projectItems->toArray());
        $projectServices = $this->projectServices->projectServices($id);
        
        $projectGlasses = $this->glass->projectGlasses($id);
        // dd($projectGlasses);
        
        $member       = $this->member->Customer(); 
        $currency     = $this->currency->get();
        
        $member       = $this->member->Customer(); 
        $currency     = $this->currency->get(['code','id']);
        $work_types    = $this->worktype->get(['name','id']);
        $project_progress =$this->projectProgress->get(['name','id']);
        
        $measureList        = $this->measure->getAllUnitMeasure();
        $inventoryList      = $this->inventory->getListOfInventory1();
        $GlassinventoryList = $this->inventory->getListOfInventory();
        
        $all_item           = $this->inventorySite->getInventory();
         
        $inventoryList      = $inventoryList->map(function ($inventoryList) use ($all_item,$measureList){

            $inventorySitelist  =  $all_item->where('inventory_id',$inventoryList->id);
            $itemMeasure        =  $measureList->where('measure_id',$inventoryList->measure_id)->first();
            $itmeMeasureList    =  ($measureList->where('metric_id',$itemMeasure->metric_id))->toArray();

            return [
                'id'           => $inventoryList->id,
                'name'         => $inventoryList->name,
                'avg_cost'     => $inventoryList->avg,
                'rate'         => $inventoryList->rate,
                'measureList'  => $itmeMeasureList,
                'measure_unit' => $itemMeasure->measure_unit,
                'measure'      => $itemMeasure,
                'siteList'     => $inventorySitelist,
                'site'         => $inventorySitelist->first(),
                'qty'          => null,
                'description'  => null,
                'width'        => null,
                'height'       => null,
            ];

        });

        $services = $this->item->getServiceList();
        $serviceList = $services->map(function ($services) use ($measureList){

            $itemMeasure        =  $measureList->where('measure_id',$services->um_id)->first();
            $itmeMeasureList    =  ($measureList->where('metric_id',$itemMeasure->metric_id))->toArray();
            return [
                'id'           => $services->id,
                'name'         => $services->name,
                'cost'         => $services->cost,
                'rate'         => $services->rate,
                'measure'      => $itemMeasure,
                'measure_unit' => $itemMeasure->measure_unit,
                'measureList'  => $itmeMeasureList,
                'qty'          => null,

            ];
        });  

        $GlassList = $GlassinventoryList->map(function ($inventoryList) use ($all_item,$measureList){

            $inventorySitelist  =  $all_item->where('inventory_id',$inventoryList->id);
            $itemMeasure        =  $measureList->where('measure_id',$inventoryList->measure_id)->first();
            $itmeMeasureList    =  ($measureList->where('metric_id',$itemMeasure->metric_id))->toArray(); 
            if($inventoryList->other_measure_id > 0 && $inventoryList->other_measure_id != ''){
                $other_measure_item = null;
                $other_measure_item = $measureList->where('measure_id',$inventoryList->other_measure_id)->toArray();
                foreach ($other_measure_item as $key => $value) {
                    $value['measure_unit'] = ($inventoryList->otherMeasureExchange != 0)?$inventoryList->otherMeasureExchange:1;
                    $other_measure_item = $value;
                }
                array_push($itmeMeasureList,$other_measure_item);
                
            }
            return [
                'id'           => $inventoryList->id,
                'name'         => $inventoryList->name,
                'avg_cost'     => $inventoryList->avg,
                'rate'         => $inventoryList->rate,
                'measureList'  => $itmeMeasureList,
                'measure_unit' => $itemMeasure->measure_unit,
                'measure'      => $itemMeasure,
                'siteList'     => $inventorySitelist,
                'site'         => $inventorySitelist->first(),
                'qty'          => null,
                'height'       => null,
                'width'        => null,
                'description'  => null,
                'windowType'   => null,
                'speserSize'   => null,
                'other_measure_id'     => $inventoryList->other_measure_id,
                'otherMeasureExchange' => ($inventoryList->otherMeasureExchange != 0)? $inventoryList->otherMeasureExchange:1,
                "oMeasureValue" => 0,
            ];

        });

        $GlassList = json_encode($GlassList);
        $inventoryList = json_encode($inventoryList);
        $serviceList = json_encode($serviceList);
        return view('projects.edit',[ 
            'GlassList'        => $GlassList,
            'inventoryList'    => $inventoryList,
            'serviceList'      => $serviceList,
            'measureList'      => $measureList,
            'currency'         => $currency,
            'member'           => $member,
            'work_types'       => $work_types,
            'project_progress' => $project_progress,
            'projects'         => $projects,
            'member'           => $member,
            'currency'         => $currency,
            "projectItems"     => $projectItems,
            "projectServices"  => $projectServices,
            'projectGlasses'   => $projectGlasses
        ]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        // dd("for test");
        // $request->validate([
        //     'name'                       =>'required',
        //     'number'                     =>'required',
        //     'currency'                   =>'required',
        //     'currency_rate'              =>'required',
        //     'type'                       =>'required',  
        // ]);
        $request->validate([
            'name'                       =>'required',
            'number'                     =>'required',
            'currency'                   =>'required',
            'currency_rate'              =>'required',
            'type'                       =>'required',
            'customer_id'                =>'required',
        ]);
         $start_date = Carbon::now();
       if ($request->get('start_date') != '') {
          $start_date= changeDateFormat($request->get('start_date'));
       }
       $end_date = Carbon::now();
       if ($request->get('end_date') != '') {
          $end_date= changeDateFormat($request->get('end_date'));
       }
        $projectName     = $request->get('name');
        $member          = $this->customer->find($request->get('customer_id'));
        $membername      = $member->name;
        $receivable_id   = $member->receivable_id;

        $project         = $request->get('project'); 
        $production_id   = $request->get('production_id');
        $inventory_id    = $request->get('inventory_id');
        $service_id      = $request->get('service_id');

       $glass_id       = $request->get('glass_id');
       $projectupdate= $this->project->find($id);
       //dd($projects);
       DB::beginTransaction();
       try{
        $this->projectDetails->where('project_id',$id)->delete();
        $projectServices = $this->projectServices->where('project_id',$id)->get();
        foreach($projectServices as $ps){
            $this->transaction->destroy($ps->income_transaction);
            $this->transaction->destroy($ps->cost_transaction);
            $this->projectServices->destroy($ps->id);
        }
        $this->glass->where('project_id',$id)->delete();
        // dd($projectServices);
        $projectServices = null;

        if($production_id)
            {
                for ($i=0; $i<count($request->get('production_id')) ; $i++) { 
                  if($production_id[$i] !=null && $production_id[$i]>0)
                  {
                      $production = $projectupdate->projectDetails()->create([
                          'production_item_id'  => $request->get('production_id')[$i],
                          'height'              => $request->get('x')[$i],
                          'width'               => $request->get('width')[$i],
                          'measure_id'          => $request->get('production_measure')[$i],
                          'quantity'            => $request->get('pquantity')[$i],
                          'price'               => $request->get('pPrice')[$i],
                          'description'         => $request->get('pDescription')[$i],
                      ]);
                  }
                } 
            } 
        if($service_id)
            {
                for($i=0; $i<count($service_id); $i++) { 
                  if($service_id[$i] !=null && $service_id[$i]>0)
                  {
                      $items = $this->item->find($service_id[$i]);

                        $amount = ($request->get('service_qty')[$i] * $request->get('service_price')[$i]);

                        $en_remark = "Project Services (" . $items->name . ") for " . $projectName;
                        $af_remark = $projectName . ") برای" . $items->name . "خدمات (";

                       $inct = pushTransaction($items->account_id, $amount / $request->get('currency_rate'),0, null,null,$en_remark, $af_remark, $start_date);
                       $costt = null;
                        $items = $items->costs()->first(); 
                        if ($items) {
                            $costt =  pushTransaction($items->id, $items->amount, null, null,null,$en_remark, $af_remark, $start_date);
                        }
                      $services    = $projectupdate->projectServices()->create([
                          'item_id'              => $request->get('service_id')[$i],
                          'price'                => $request->get('service_price')[$i],
                          'quantity'             => $request->get('service_qty')[$i],
                          'um_id'                => $request->get('service_measure')[$i],
                          'price'                => $request->get('service_price')[$i], 
                          'income_transaction'   => $inct->id,
                          'cost_transaction'     =>($costt)?$costt->id:null,

                      ]);
                  }
                } 

            }
        if($glass_id)
            {
                for ($i=0; $i<count($glass_id) ; $i++) { 
                  if($glass_id[$i] !=null && $glass_id[$i]>0)
                    {
                      $production = $this->glass->create([
                          'project_id'          => $id,
                          'item_id'             => $glass_id[$i],
                          'height'              => $request->get('g_height')[$i],
                          'width'               => $request->get('g_width')[$i],
                          'measure_id'          => $request->get('g_um_id')[$i],
                          'qty'                 => $request->get('g_qty')[$i],
                          'window_type'         => $request->get('windowType')[$i],
                          'spencer_size'        => $request->get('speserSize')[$i],
                          // 'glass_type'          => $request->get('glassType')[$i],
                          'description'         => $request->get('g_description')[$i],
                      ]);
                    }
                } 
            }
        $total_amountss    = $request->get('totalAmountss');
        $discount = $request->get('discount');
        $discountTotal = $request->get('discountTotal');
        $discount_type = $request->get('discount_type');


        // DB::beginTransaction(); 
            // try {
        $customerName = Member::find($request->get('customer_id'))->name;
        $en_remark_dis   = "Discount (".$request->get('number'). ") for " . $customerName;
        $af_remark_dis   = "تخفیف (".$request->get('number').") برای " . $customerName;
        $discountAccount   = $this->account->getCustomerDiscountAccount()->id;
        $discountTran =null;
        if($discount_type =="currency")
        {
            $discountTr      = pushTransaction($discountAccount, $discount*-1,0,null,null , $en_remark_dis, $af_remark_dis, $start_date);
            $discountTran    = $discountTr->id;
        }
        else if($discount_type =="percent")
        {
            $discountTr      = pushTransaction($discountAccount,($discount*$total_amountss)/100*-1,0,null,null , $en_remark_dis, $af_remark_dis, $start_date);
            $discountTran    = $discountTr->id;
        }
        $data_pupdate=[
          'name'                      =>$request->get('name'),
          'number'                    =>$request->get('number'),
          'customer_id'               =>$request->get('customer_id'),
          'start_date'                =>$start_date,
          'end_date'                  =>$end_date,
          'location'                  =>$request->get('location'),
          'province'                  =>$request->get('province'),
          'district'                  =>$request->get('district'),
          'currency'                  =>$request->get('currency'),
          'rate'                      =>$request->get('currency_rate'),
          'type'                      =>$request->get('type'),
          'color'                     =>$request->get('color'),
          'maintainance_duration'     =>$request->get('maintainance_duration'),
          'work_type'                 =>$request->get('work_type'),
          'description'               =>$request->get('description'),
          'discount_transaction'      =>$discountTran,
          'discount_type'             =>$discount_type
       ];
       $this->transaction->destroy($projectupdate->discount_transaction);
       $this->transaction->destroy($projectupdate->project_transaction);
       $project = $projectupdate->update($data_pupdate);
       DB::commit();
       }
       catch(\Exception $e)
       {
        dd($e);
        DB::rollBack();
        return redirect()->back()->withErrors(['error'=>'Please Check Your Data!']);
        }
        
        return redirect()->route('project.index')->with('message',__('layout.Project').' '.__('message.CSuccess'));
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
        {
            DB::beginTransaction();
            $projects = $this->project->find($id);
            $projectServices = $projects->ProjectServices();
            foreach ($projects->projectServices()->get() as $value) {
            $this->transaction->destroy($value->income_transaction);  
            $this->transaction->destroy($value->cost_transaction);  
            }
            $projects->projectDetails()->delete();
            $projects->projectServices()->delete();
            $projects->delete();
            DB::commit();
            return redirect()->back();
        }


        public function projectPrint($id)
        {
           
          $project              = $this->project->find($id);
          $countServicesQty     = 0;
          $ServicesPrice        = 0;

           $saleService         = $this->projectServices->getProjectServices($id);
           foreach ($saleService as $key ) {
             $countServicesQty  = $key->quantity;
             $ServicesPrice     = $key->price;

           }
           $number              = $project->number;
           Verta::setStringformat('Y/n/j'); 
           $saleItem            = $this->project->getProjectItems($id);
           $currency             = $saleItem[0]->currency;
           $saleItem1           = $saleItem; 
           $date                =   strtotime(($project->start_date));
           $s_date              = date_create($project->start_date);
           $e_date              = date_create($project->end_date);
           $days                = date_diff($s_date,$e_date)->days.' '.__('layout.Day');

            $member             = Member::find($project->customer_id);
            $memberCode         = $member->code;
            $phone              = $member->phone; 
            $address            =' ';
            $city               =' ';
            if($member->information)
            {
                $address        = $member->information->address1;
                $city           = $member->information->city;
            }

           $name   = $member->name;
        
        $renderedHtml=[];
        $data=[];
        $sum = 0;
        $xJomal =0;
        $total = 0;
        $jomla =0;
        $myItems=[];
        $serviceCost=0; 

        // You are my heart You are my soul
        // You are one in a million 

        $sites = null;
        foreach ($saleItem1 as $key=>$item) {
            
            array_push($myItems,[
                      "name"        => $item->name,
                      "width"       => $item->width,
                      "height"      => $item->height,
                      "quantity"    => $item->quantity,
                      "um"          => $item->um,
                      "sDate"       =>$item->sDate,
                      "price"       =>$item->price,
                      "currency"    =>$item->currency,
                   ]);
            $sum = $item->quantity * $item->price;
            $xJomal =$item->quantity;
            $total += $sum;
            $jomla +=$xJomal;
        }
         

          $itemCount=count($myItems);
            $perPage=20;
            $remain=0;
            $pageCount=1;

            if($itemCount>$perPage)
            {       $temp=floor($itemCount/$perPage);
                    $pageCount=$temp;
                    $remain=$itemCount%$perPage;
                    if($remain>0)
                    {
                        $pageCount++;
                    }

            }
            $saleItem=$myItems;
            
            for($i=0;$i<$pageCount;$i++)
            {
                $data=[];
                $temp=array_slice($saleItem, $i*$perPage,$perPage);
                
                foreach ($temp as $key => $value)
                {
                    array_push($data,$value);  
                }

                $paper_type="invoice";
                // dd($paper_type);
                array_push($renderedHtml,
                    view('projects.factor',
                    compact('data','sales','paper_type','member','address','city','paid','payableString','payable','totalAmount','total','date','remainAmount','phone','memberCode','serviceCost','number','countServicesQty','ServicesPrice','currency','days','name'))
                   ->render());   

            }
 
         

          return print_pdf(
            trans('layout.test'),
          merge_html($renderedHtml),
          'A4',
          false);
        }
    }
