@extends('layouts.factor-master')
@section('style')

    <style>
        .small-table td, .main-table td, .main-table tr,
        .small-table th, .main-table th {

        }

        .t1 {
            font-size: 14px;
            font-weight: bold;
            background-color: {{company()['color']}};
        }
    </style>
@stop
@section('content')

    <div>
        <div style=" font-size: 12px !important">
            <!--Table 2 For Customer Information-->
            <table style="width: 100%;">
                <tr>
                    <td style="text-align: left; width:20%">
                        <table class="main-table">
                            <tr>
                                <td align="center" colspan="3">
                                    <b style="font-size: 20px;">@lang('layout.Invoice')</b>
                                </td>

                            </tr>

                            <tr>
                                <td align="right"><b>@lang('layout.InvoiceNumber')</b></td>
                                <td align="right"><b>@lang('layout.Date')</b></td>
                                <td align="right"><b>@lang('layout.Hour')</b></td>
                            </tr>
                            <?php
                            $str_date = convertdate($vehicleM->Date);
                            $date_string = substr($str_date, 0, 10);
                            ?>
                            <tr>
                                <td align="right"><b>{{$vehicleM->code}}</b></td>
                                <td align="right"><b>
                                        @if(getInvoiceDateFormat() == "shamsi")
                                            <?php
                                            $str_date = convertdate($vehicleM->Date, 0, 'jalali');

                                            $date_string = substr($str_date, 0, 10)
                                            ?>
                                            {{$date_string}}

                                        @elseif(getInvoiceDateFormat() =='both')

                                            <?php
                                            $str_date = convertdate($vehicleM->Date, 0, 'jalali');

                                            $date_string = substr($str_date, 0, 10);
                                            echo $date_string;
                                            ?>
                                            &nbsp;/&nbsp;
                                            {{substr($vehicleM->Date,0,10)}}

                                        @elseif(getInvoiceDateFormat() =="meladi")
                                            {{substr($vehicleM->Date,0,10)}}

                                        @else

                                            {{$str_date}}

                                        @endif
                                    </b></td>
                                     <td align="right"><b><?php echo Date('h:i A' , strtotime($vehicleM->Date)); ?></b></td>
                            </tr>
                        </table>
                    </td>

                    <td width="20%"></td>
                    <td style="text-align: right; width:60%">

                    </td>
                </tr>
            </table>
            <!--End Table 2 For Invoice Information-->

            <table style="width: 100%; margin-top: 10px;">
                <tr>
                    <td style="text-align: left; width:40%">
                        <table class="main-table">
                            <tr>
                                <td align="center" colspan="2">
                                    <b>@lang('layout.BillTo')</b>
                                </td>

                            </tr>
                            <tr>
                                <td align="right"><b>@lang('layout.Name')</b></td>
                                <td align="right"><b>
                               
                                    {{$vehicleM->customer_name}}
                                </b></td>
                            </tr>
                            <tr>
                                <td align="right"><b>@lang('layout.Code')</b></td>
                                <td align="right"><b>{{$vehicleM->code}}</b></td>
                            </tr>
                          
                        </table>
                    </td>

                    <td width="20%"></td>
                    <td style="text-align: right; width:30%">
                        <table class="main-table">
                            <tr>
                                <td align="center" colspan="2"><b>@lang('layout.ShipTo')</b></td>
                            </tr>
                            <tr>
                                <td width="25%" align="right"><b>@lang('layout.Address')</b></td>
                                <td width="25%" align="right"><b>{{$vehicleM->address.' '.$vehicleM->city}}</b></td>
                            </tr>
                            <tr>
                                <td align="right"><b>@lang('layout.Phone')</b></td>
                                <td align="right"><b>{{$vehicleM->customer_phone}}</b></td>
                            </tr>
                        </table>
                    </td>
                </tr>
            </table>

            <!--Table 3 For Data  Information-->
            <table class="main-table" style="margin-top: 20px;" cellpadding="5px">
                <tr style="font-weight: bold; font-size: 17px">
                    <td class="mt">
                        <div class="center"><b>@lang('layout.VehicleName')</b></div>
                    </td>

                    <td class="mt">
                        <div class="center"><b>@lang('layout.Quantity')</b></div>
                    </td>  
                    <td class="mt">
                        <div class="center"><b>@lang('layout.Rate')</b></div>
                    </td>
    
                    <td class="mt">
                        <div class="center"><b>@lang('layout.Total')</b></div>
                    </td>

                </tr>
                <tr>

                    <td class="center">{{$vehicleM->vehicle_name}}</td>
                    <td class="center">{{$vehicleM->qty}}</td>
                    <td class="center">{{$vehicleM->price}}</td>
                    <td class="center">{{ myRound($vehicleM->qty*$vehicleM->price)}} {{$vehicleM->currency}}</td>

                </tr>
     
            </table>
            <!--End Table 3 For Data Information--> 
            <!--Table 3 For Data  Information-->
            <table class="main-table" style="margin-top: 20px;" cellpadding="5px">
                <tr style="font-weight: bold; font-size: 17px">
                    <td class="mt">
                        <div class="center"><b>@lang('layout.Code')</b></div>
                    </td>

                    <td class="mt">
                        <div class="center"><b>@lang('layout.Driver')</b></div>
                    </td>  
                    <td class="mt">
                        <div class="center"><b>@lang('layout.Phone')</b></div>
                    </td>
                </tr>
                <tr>
                    <td class="center">{{$vehicleM->driver_code}}</td>
                    <td class="center">{{$vehicleM->driver_name}}</td>
                    <td class="center">{{$vehicleM->driver_phone}}</td>
                </tr>
     
            </table>
            <!--End Table 3 For Data Information--> 
            <table style="width: 100%; ">
                <tr>
                    <td style="text-align: left; width:50%">
                            @if($vehicleM->description)
                                <table class="main-table">
                                    <tr>
                                        <td align="right" style="font-size: 14px;">{{$vehicleM->description}}</td>
                                    </tr>
                                </table>
                            @endif
                    </td>

                    <td style="text-align: right; width:50%">
                        <table class="main-table">
                           
                            <tr>
                                <td width="25%" align="right"><b>@lang('layout.Total')</b></td>
                                <td align="right">
                                    <div class="center" style="font-size: bold;">
                                        <b>
                                           {{ myRound($vehicleM->qty*$vehicleM->price)}} {{$vehicleM->currency}}
                                        </b>
                                    </div>

                                </td>

                            </tr>
                            <tr>
                                <td align="right"><b>@lang('layout.Recipt')</b></td>
                                <td align="right">
                                    <b>
                                        <div class="center">
                                                {{myRound($totalRecevie)}} {{$vehicleM->currency}}
                                        </div>
                                    </b>
                                </td>
                            </tr>  
                            <tr>
                                <td align="right"><b>@lang('layout.Remined')</b></td>
                                <td align="right">
                                    <b>
                                       <div class="center">
                                            <span>
                                                {{myRound($totalPAmount)}} {{$vehicleM->currency}}
                                            </span>

                                        </div>
                                    </b>
                                </td>
                            </tr>       
                        
                        </table>
                    </td>
                </tr>
            </table>
            <!-------------------------------------------------------------------------------------------------------
              - ---End  Table 4 For Total  Information        -------------------------------------------------------
            --------------------------------------------------------------------------------------------------------->



            @if(company()['invoice_message'])
                <table width="100%">
                    <tr>
                        <td style="font-size: 14px;">@lang('layout.Note'): {{company()['invoice_message']}}</td>
                    </tr>
                    <tr>
                        <td></td>
                        <td></td>
                    </tr>
                </table>
            @endif
        <!--End Table 4 For Total  Information-->

        </div>

    </div>

    </div>








  <!--  signature -->
            <table style="width: 100%" class="signtable">
                <tr>
                    @foreach(getCompanyInfo('sign','invoice') AS $info)
                    <td style="text-align: left; width:40%">
                        <table >
                           
                            <tr>
                                <td align="right" class="signsize">{{$info['name']}}</td>
                            </tr>
                            
                        </table>
                    </td>
                     @endforeach
                </tr>
            </table>
             <!-- End signature -->

    <script type="text/javascript">
        window.print();
    </script>
@endsection


