@extends('layouts.app')
<link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css">

@section('content')
@include("layouts.Cmodal")
@include("invoices.modal")
@include("layouts.Drivermodal")
<div class="row">
    <div class="portlet light bordered sale">
        <!-- BEGIN TAB PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-anchor font-green-sharp"></i>&nbsp;
                    <span class="caption-subject font-green-sharp bold uppercase">@lang('layout.VehicleCMRCreate')</span>
                </div>
                <div class="actions">
                </div>
            </div>
            <div id="appInvoice" class="portlet-body">
                <div class="tabbable tabbable-tabdrop">
                    <div>
                        {{Form::model($vehicleM,['route' => ['vehicleCMR.update',$vehicleM->id],'method' => 'PATCH','class' => 'form-horizontal','id'=>'vehicleCMR-form'])}}
                        {{ csrf_field() }}
                        <div class="tab-content">

                            <div class="tab-pane active" id="tab1">

                                <div v-cloak class="portlet-body form" style="margin-bottom:50%;">


                                    <!-- BEGIN FORM-->


                                    <div class="form-body">
                                        <div class="row">
                                            <div class="col-lg-9 col-md-9 col-sm-12 col-xs-12">
                                                <!-- begin inputs -->
                                                <div class="row">
                                                    <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                        <div class="form-group">

                                                            <div class="col-md-12">
                                                                <label class="control-label">@lang('layout.Customer')</label>

                                                                <v-select label="name" :options="customer" v-model="selected_customer" @keyup.native="memberChange()" @Click.native="memberChange()" ></v-select>
                                                                <input type="hidden" name="customer_id" v-validate="'required'" data-vv-as="@lang('layout.Customer')" :value="!selected_customer?null:selected_customer.id" required>
                                                                <span class="required">@{{ errors.first('customer_id') }}</span>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                        <div class="form-group">

                                                            <div class="col-md-12">
                                                                <label class="control-label">@lang('layout.Number')</label>
                                                                {{Form::text('number', null,['class' => 'form-control','placeholder' => __('layout.Number'),'v-validate' =>'"required"','data-vv-as' => __('layout.Number')])}}
                                                                <span class="required">@{{ errors.first('number') }}</span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                        <div class="form-group">

                                                            <div class="col-md-12">
                                                                <label class="control-label">@lang('layout.ReferenceNumber')</label>
                                                                {{Form::text('ref_no',null,['class' => 'form-control','placeholder' => __('layout.ReferenceNumber')])}}

                                                            </div>
                                                        </div>
                                                    </div>

                                                </div>

                                                <div class="row">


                                                    <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                        <div class="form-group">

                                                            <div class="col-md-12">
                                                                <label class="control-label">@lang('layout.Currency')</label>
                                                                <v-select label="code" @input="selectedRate" :options="currency" v-model="selected_currency"></v-select>
                                                                <input type="hidden" name="currency" v-validate="'required'" data-vv-as="@lang('layout.Currency')" :value="selected_currency.code">
                                                                <span class="required">@{{ errors.first('currency') }}</span>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                        <div class="form-group">

                                                            <div class="col-md-12">
                                                                <label class="control-label">@lang('layout.Rate')</label>
                                                                <input type="number" name="currency_rate" v-validate="'required'" data-vv-as="@lang('layout.Rate')" name="rate" v-model="!selected_currency?0:selected_currency.rate" class="form-control" :class="{'has-error':rate<=0}">
                                                                <span class="required">@{{ errors.first('currency_rate') }}</span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                        <div class="form-group">

                                                            <div class="col-md-12">
                                                                <label class="control-label">@lang('layout.Date')</label>

                                                                <input type="text" name="date" value="{{$vehicleM->date}}" class="form-control date" autocomplete="off">
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>

                                                <div class="row">

                                                    <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                                                        <div class="form-group">
                                                            <div class="col-md-12">
                                                                <label class="control-label">@lang('layout.Description')</label>
                                                                <textarea name="description" class="form-control" rows="1">{{$vehicleM->description}}</textarea>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-2">
                                                        <label class=" control-label">@lang('layout.DriverAccount')</label>
                                                        <div>
                                                            <label class="mt-checkbox mt-checkbox-outline">
                                                                <input type="checkbox" name="driver_account" value="yes" <?php if($vehicleM->driver_account == 'yes'){echo 'checked';} ?> >
                                                                <span></span>
                                                            </label>
                                                        </div>
                                                    </div> 
                                                    <div class="col-md-4" >
                                                        <div class="col-md-4" style="padding-right: 0px !important; padding-left: 0px !important;">
                                                            <label class=" control-label">@lang('layout.LocalVehicles')</label>
                                                            <div>
                                                                <label class="mt-checkbox mt-checkbox-outline">
                                                                    <input type="checkbox" name="local_vehicles" value="yes" v-model="local_vehicles" >
                                                                    <span></span>
                                                                </label>
                                                            </div>
                                                        </div>
                                                        <div class="col-md-8" v-if="local_vehicles" >
                                                            <label class="control-label">@lang('layout.IncomeAccount')</label>
                                                            <v-select label="name" v-model="SelectedIncome" :options="incomeAccount"> </v-select>
                                                            <input type="hidden" name="income_id" :value="(SelectedIncome==null)?null:SelectedIncome.id">
                                                        </div>
                                                    </div>

                                                </div>

                                                <!-- end inputs -->
                                            </div>
                                            <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">

                                                <!-- begin total -->
                                                <div class="dashboard-stat2 ">
                                                    <table class="dashboard-tabel" width="100%">
                                                        <tr>
                                                            <td>
                                                                <small>@lang('layout.Total') :</small>
                                                            </td>
                                                            <td class="text-right"><span data-counter="counterup" data-value="7800">@{{ myRound((subtotal - (discount*subtotal/100))-payeds)}}</span>
                                                                <small class="font-green-sharp">
                                                                    @{{selected_currency.symbol}}
                                                                </small>
                                                            </td>
                                                        </tr>

                                                        <tr>
                                                            <td>
                                                                <small>@lang('layout.Payment'):</small>
                                                            </td>
                                                            <td class="text-right">
                                                                <small class="font-green-sharp">
                                                                    <span class="text-right" data-counter="counterup" data-value="7800">@{{ payeds.toFixed(precision())}}</span>
                                                                    <small class="font-green-sharp">
                                                                        @{{selected_currency.symbol}}
                                                                    </small>
                                                                </small>
                                                            </td>
                                                        </tr>


                                                        <tr>
                                                            <td>
                                                                <small>@lang('layout.Sub-Total'):</small>
                                                            </td>
                                                            <td class="text-right">
                                                                <span class="text-right" data-counter="counterup" data-value="7800">@{{ myRound(subtotal)}}</span>
                                                                <small class="font-green-sharp">
                                                                    @{{selected_currency.symbol}}
                                                                </small>
                                                            </td>
                                                        </tr>


                                                    </table>

                                                </div>

                                                <!-- end total -->

                                            </div>

                                        </div>

                                        <div class="row" style="overflow-x: scroll;">

                                            <!-- begin service -->
                                            <table id="table_content" class="table table-striped table-bordered table-advance table-hover">
                                                <thead>
                                                    <tr>
                                                        <th class="text-center" style="min-width: 8px;">#</th>
                                                        <th class="text-center" style="min-width: 160px;">@lang('layout.SelectDriver')</th>
                                                        <th class="text-center" style="min-width: 160px;">@lang('layout.VehicleName')</th>
                                                        <th class="text-center" style="min-width: 160px;">@lang('layout.Source')</th>
                                                        <th class="text-center" style="min-width: 160px;">@lang('layout.Destination')</th>
                                                        <th class="text-center" style="min-width: 160px;">@lang('layout.Price')</th>
                                                        <th class="text-center"></th>

                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <tr v-for="(row,index) in introduces">
                                                        <td>@{{index+1}}</td>
                                                        <td class="highlight">
                                                            <v-select label="name" @click.native="addNew('introduce',index)" :options="drivers" v-model="row.selectedMember"></v-select>
                                                            <input type="hidden" name="driver[]" :value="!row.selectedMember?null:row.selectedMember.id">
                                                        </td>
                                                        <td class="highlight">
                                                            @{{!row.selectedMember?null:row.selectedMember.vehicle_name}}
                                                            <input type="hidden" name="vehicle_id[]" :value="!row.selectedMember?null:row.selectedMember.vehicle_id" />
                                                        </td>
                                                        <td>
                                                            <input type="text" name="source[]" v-model="row.source" placeholder="@lang('layout.Source')" class="form-control" />
                                                        </td>
                                                        <td>
                                                            <input type="text" name="destination[]" v-model="row.destination" placeholder="@lang('layout.Destination')" class="form-control" />
                                                        </td>
                                                        <td>
                                                            <div class="input-group">
                                                                <input type="number" name="amount[]" placeholder="@lang('layout.Price')" v-model="row.amount" class="form-control" v-validate="''" data-vv-as="@lang('layout.Price')" />
                                                                <span class="input-group-addon">
                                                                    @{{selected_currency.symbol}}
                                                                </span>
                                                            </div>
                                                        </td>
                                                        <td>
                                                            <span v-on:click="deleteItem('introduce',index)"><i class="paddint-both glyphicon glyphicon-trash"></i></span>
                                                        </td>
                                                    </tr>

                                                </tbody>
                                            </table>
                                            <!-- end service -->

                                            <!-- begin recevies -->
                                            <table id="table_content" class="table table-striped table-bordered table-advance table-hover">
                                                <div class="panel-heading" style="background-color: #54cad6; color: #ffffff;">
                                                    <h4 class="panel-title">
                                                        @lang('layout.Recevies')
                                                    </h4>
                                                </div>
                                                <thead>
                                                    <tr>
                                                        <th class="text-center" style="min-width: 8px;"> #</th>
                                                        <th class="text-center" style="min-width: 80px;">@lang('layout.ReferenceNumber')</th>
                                                        <th class="text-center" style="min-width: 160px;">@lang('layout.SelectBank')</th>
                                                        <th class="text-center" style="min-width: 100px;"> @lang('layout.Amount')</th>
                                                        <th class="text-center" style="min-width: 120px;"> @lang('layout.Rate')</th>
                                                        <th class="text-center" style="min-width: 80px;">@lang('layout.Currency')</th>
                                                        <th class="text-center" style="min-width: 80px;"> @lang('layout.Amount')</th>
                                                        <th class="text-center" style="min-width: 120px;">@lang('layout.Total')</th>
                                                        <th></th>

                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <tr v-for="(recevie,index) in recevies">
                                                        <td>@{{index+1}}</td>
                                                        <td>
                                                            <input type="text" name="recevie_ref_no[]" v-model="recevie.ref_no" class="form-control" placeholder="@lang('layout.ReferenceNumber')" />
                                                        </td>
                                                        <td class="highlight">
                                                            <v-select label="name" v-model="recevie.item" :options="(recevie.items)" @click.native="addNew('recevie',index)" @input="checkExistingRecevie(index)">

                                                            </v-select>
                                                            <input type="hidden" v-if="recevie.item !=null" name="recevie_id[]" :value="(recevie.item==null)?null:recevie.item.id">
                                                        </td>

                                                        <td>

                                                            <span v-if="recevie.item !=null">
                                                                @{{myRound(Number((recevie.item==null)?null:recevie.item.balance)+Number((recevie.item==null)?null:recevie.item.amount))}}
                                                            </span>
                                                        </td>
                                                        <td>
                                                            <input v-bind:disabled="(recevie.item==null)?false:(recevie.item.code =='{{getHomeCurrency()["code"]}}')" type="number" v-model.number="(recevie.item==null)?null:recevie.item.rate " class="form-control" placeholder="@lang('layout.Rate')" />
                                                            <input v-if="recevie.item !=null" type="hidden" name="recevie_rate[]" v-bind:value="recevie.item.rate">
                                                        </td>
                                                        <td>
                                                            <input type="text" name="recevie_currency[]" class="form-control" v-model="(recevie.item==null)?null:recevie.item.code" placeholder="@lang('layout.Currency')" disabled reqiured />

                                                            <input v-if="recevie.item !==null" type="hidden" name="recevie_currency[]" v-bind:value="recevie.item.code" />
                                                        </td>
                                                        <td>
                                                            <div class="input-group">
                                                                <input type="number" class="form-control" v-model.number="(recevie.item==null)?null:recevie.item.amount " placeholder="@lang('layout.PayAmount')" />

                                                                <input v-if="recevie.item !=null" type="hidden" name="recevie_amount[]" v-bind:value="recevie.item.amount">

                                                                <span class="input-group-addon">@{{(recevie.item==null)?null:recevie.item.code}}</span>
                                                            </div>
                                                        </td>
                                                        <td>
                                                            <div class="input-group">
                                                                <input type="number" class="form-control" :value="(recevie.item==null)?null:totalPayment(recevie.item,selected_currency.rate, null, selected_currency.static_rate).result" placeholder="@lang('layout.Total')" style="min-width: 100px" />
                                                                <span class="input-group-addon">@{{selected_currency.symbol}}</span>
                                                            </div>
                                                        </td>
                                                        <td>
                                                            <span v-on:click="deleteItem('recevie',index)"><i class="paddint-both glyphicon glyphicon-trash"></i></span>
                                                        </td>
                                                    </tr>
                                                </tbody>

                                            </table>
                                            <!-- end recevies -->

                                        </div>

                                    </div>
                                    <div class="col-xs-12 col-sm-10 col-md-11 text-center">
                                        <button type="button" v-if="isError1 ==false" v-if="!isError" @click="handleSubmit($event)" class="btn green">@lang('layout.Update')</button>
                                        <a href="{{route('vehicleCMR.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>

                                    </div>
                                    <cmodal :show='showModal' @close="showModal=false">

                                    </cmodal>
                                    <Drivermodal :show='dShowModal' @close="dShowModal=false">

                                    </Drivermodal>
                                </div>


                            </div>


                            {!! Form::close() !!}

                        </div>

                    </div>


                </div>
                <p> &nbsp; </p>
                <p> &nbsp; </p>
            </div>
        </div>
        <!-- END TAB PORTLET-->
    </div>
</div>

@endsection
@push('scripts')


<script type="text/javascript">
    @if(App::getLocale())
    Vue.use(VeeValidate, {
        locale: '{{App::getLocale()}}',
    });
    @else
    Vue.use(VeeValidate, {
        locale: 'en',
    });
    @endif



    Vue.component('v-select', VueSelect.VueSelect);

    Vue.component("modal", {
        template: "#modal-template",
        props: ['show'],

    });

    var customer ={!! $customer !!};
    var selectedBanks = {!! $selectedBanks !!};
    var currency ={!! $currency !!};
    var banks = {!! $banks !!};
    var bank_pay = {!! $banks !!};
    var vehicleM = {!! $vehicleM !!};
    var drivers = {!! $drivers !!};
    var select_detail = {!! $select_detail !!};
    var income = {!! $income !!};

    var v = new Vue({
        el: '#appInvoice',
        data: {
            local_vehicles:null,
            SelectedIncome:null,
            incomeAccount: income,
            vehicleM: vehicleM,
            showModalSaleOrder: false,
            showModal: false,
            dShowModal: false,
            invoiceDescription: null,
            saleOrderList: [],
            selected_sale_order: null,
            purchase_orders: false,
            setDatas: [],
            drivers: drivers,
            vehicles: [],
            selected_vehicle: null,
            tankers: [],
            selected_tanker: null,
            amount: null,
            qty: null,
            customer: customer,
            all_customer: customer,
            selected_customer: null,
            selectedMember: null,
            member_id: null,
            banks: banks,
            bank_pay: bank_pay,
            all_services: null,
            selected_banks: selectedBanks,
            currency: currency,
            selected_currency: defaultCurrency(),
            rate: 0,
            discountFiled: 0,
            discountIsAmount: false,
            temp_items: [],
            totalAmountes: [],
            types: null,
            inventory_category: null,
            selected_index: 0,
            newCost: [],
            inventories: [],
            services: [],
            recevies: [],
            payments: [],
            select_detail: select_detail,
            introduces: [],
            CusTypes: null,
            selected_class: null,
            selected_area: null,
            ref_no: '',
            msg: '',
            isError1: false,
        },
        computed: {
            selectedRate() {
                this.rate = (this.selected_currency) ? this.selected_currency.rate : 0;

            },
            discount() {
                if (this.discountIsAmount) {

                    if (this.subtotal > 0 && this.discountFiled) {
                        return (parseFloat(this.discountFiled) * 100) / (this.subtotal);
                    } else {
                        return 0;
                    }
                } else {

                    return this.discountFiled
                }

            },

            // calculate subtotal
            subtotal: function() {
                var sum = 0; 
                for (var i = 0; i < this.introduces.length; i++) {
                    if (this.introduces[i].amount != null) {
                        sum = (Number.parseFloat(sum) + Number.parseFloat(this.introduces[i].amount));
                    }
                }

                return sum;
            }, 

            // check receve amount
            payeds: function() {
                var sum = 0;
                for (var i = 0; i < this.recevies.length; i++) { 
                    if (this.recevies[i].item != null && this.recevies[i].item) {
                        if (this.recevies[i].item != null && this.recevies[i]['item']['rate'] > 0) { 
                            @if(systemConfig()[30] == 1)
                            sum += ((this.recevies[i]['item']['amount'] / this.recevies[i]['item']['static_rate'] * this.recevies[i]['item']['rate']) * this.selected_currency.static_rate / this.selected_currency.rate);
                            @else 
                            sum += (this.recevies[i]['item']['amount'] * this.selected_currency.rate / this.recevies[i]['item']['rate']); 
                            @endif  
                        }
                    }
                }
                return sum;
            },


            // check data validation
            isError: function() {
                var isError = false;
                //var flag=false;
                // for (var i = 0; i < this.inventories.length; i++)
                // {

                //    if (this.inventories[i].item)
                //    {
                //      flag=true;
                //      if(((this.inventories[i]['item']['rate'] <=0) ))
                //      {
                //        rate=this.inventories[i]['item']['rate'];
                //        new_rate=this.inventories[i]['item']['new_rate'];
                //        if(rate <=0 && new_rate <=0)
                //        {
                //             isError = true;
                //        }

                //      }
                //    }
                // }
                if (this.selected_customer == null) {
                    isError = true;
                }
                return isError;


            },
        },
        mounted: function () {
            if (this.vehicleM) {
                // console.log(12, this.vehicleM);
                this.selected_currency=_.find(this.currency,(v)=>v.code==this.vehicleM.currency);
                this.selected_customer=_.find(this.customer,(v)=>v.id==this.vehicleM.member_id);
                this.selected_currency.rate = this.vehicleM.rate;

                if (this.vehicleM.local_vehicles == "yes") {
                    this.local_vehicles = true;
                    this.SelectedIncome=_.find(income,(v)=>v.id==this.vehicleM.income_id);
                }
            }

            // begin recevies initialization
            for (var t = 0; t < this.selected_banks.length; t++) {
                var foundFlag = false;
                var tempBank = null;
                for (var y = 0; y < this.banks.length; y++) {
                    if (this.selected_banks[t].id == this.banks[y].id) {
                        foundFlag = true;
                        tempBank = this.banks[y];
                        tempBank.amount = this.selected_banks[t].balance;
                        tempBank.rate = this.selected_banks[t].rate;
                    }
                }
                if (foundFlag) {

                    this.recevies.push({item: tempBank, items: this.banks, ref_no: this.selected_banks[t].ref_no});
                }
            }
            for (var w = 1; w > this.selected_banks.length; w--) {
                this.recevies.push({item: null, items: banks});
            }
            // end recevies initialization

            // begin introduces initialization
            for (var t = 0; t < this.select_detail.length; t++) {
                this.introduces.push({selectedMember: this.select_detail[t], amount: this.select_detail[t].amount, source: this.select_detail[t].source, destination: this.select_detail[t].destination });
            }
            this.introduces.push({selectedMember: null, amount: null, source: null, destination: null });
            // end introduces initialization

        },
        methods: {
            handleSubmit(e) {
                this.$validator.validate().then(valid => {
                    if (valid) {
                        // alert(e.target);
                        //console.log(v.member_chack());
                        if (v.member_chack() == 'true') {
                            var r = confirm("@lang('layout.member_payable_levels')");
                            if (r == true) {
                                v.submitForm(e.target);
                            }
                        } else {
                            v.submitForm(e.target);
                        }
                    }
                });
            },

            // chack_member_payable_levels
            member_chack() {
                var chack = 'false';
                var member_id = v.member_id;
                if (member_id != null) {

                    var totals = Number.parseFloat((v.subtotal - (v.discount * v.subtotal / 100)) - v.payeds);
                    var currency = $("input[name=currency]").val();


                    $.ajax({
                        url: "{{route('callMethod.search')}}",
                        async: false,
                        data: {
                            member_id: v.member_id,
                            method_name: 'Search_member_payable_levels',
                            currency: currency,
                        },
                        success: function(data) {
                            var r_amount = Number.parseFloat(data.amount);
                            var r_m_amount = Number.parseFloat(data.m_amount);
                            var totalss = Number.parseFloat(((isNaN(r_m_amount) ? 0 : r_m_amount) + totals));
                            //console.log(r_m_amount);
                            //console.log('--');
                            //console.log(totals);
                            if (r_amount != 0 && r_amount < totalss) {
                                chack = 'true';
                            } else {
                                chack = 'false';
                            }


                        }.bind(this),

                        error: function(error) {
                            console.log(error)
                        }
                    });
                    /*
                            axios.get("{{route('callMethod.search')}}",
				   {

					params:{
					  member_id:v.member_id,
					  method_name:'Search_member_payable_levels',
					  currency:currency,
					  
					},
				   })
				   .then(function (response)
				   {
					 
						var r_amount = response.data.amount;
						var r_m_amount = response.data.m_amount;
						if(r_amount < (r_m_amount + totals)){
							chack = 'true';
						}
				   })
				   .catch(function (error)
				   {
					  console.log(error);
				   });
			  */
                }
                return chack;
            },

            // detect member change and searh
            memberChange() {
                if (v.selected_customer) {
                    axios.get("{{route('vehicleCMR.create')}}", {
                            params: {
                                customer_id: v.selected_customer.id,
                            }
                        })
                        .then(function(response) {

                            if (response.data.driver != null) {
                                console.log('1231',response.data);
                                v.drivers = response.data.driver;
                                v.introduces = [];
                                v.introduces.push({selectedMember: null, amount: null, source: null, destination: null });
                            }
                        })
                        .catch(function(error) {
                            console.log(error);
                        })
                }
            },

            driverChange(index) {
                if (v.introduces[index].selectedMember) {
                    plate = v.introduces[index].selectedMember.plate;
                    if (plate != null) {
                        axios.get("{{route('callMethod.search')}}", {
                                params: {
                                    method_name: 'Search_driver_vehicle',
                                    driver_vehicle_plate: plate,
                                }
                            })
                            .then(function(response) {
                                v.introduces[index].selected_vehicle = null;
                                if (response.data.result != null) {
                                    v.introduces[index].selected_vehicle = response.data.result;
                                }
                            })
                            .catch(function(error) {
                                console.log(error);
                            })
                    }
                }
            },

            // detect member change and searh
            carChange() {
                if (this.selected_vehicle) {
                    console.log('rrrnn', this.selected_vehicle);
                    // get member contract
                    this.TankerSearch(this.selected_vehicle.tanker_number, this);
                }
            },
            TankerSearch(plate, vm) {
                if (plate != null) {
                    axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: 'Search_driver_vehicle',
                                driver_vehicle_plate: plate,
                            }
                        })
                        .then(function(response) {

                            if (response.data.result != null) {
                                console.log('1231', response.data);

                                v.selected_tanker = response.data.result;
                            }
                        })
                        .catch(function(error) {
                            console.log(error);
                        })
                }
            },

            // generic function for adding item to list
            addNew(type = null, index) {
                this.temp_items = [];
                if (type != null) {
                    if (type == 'introduce') {
                        if (this.introduces[index + 1] == undefined) {
                            this.introduces.push({selectedMember: null, amount: null, source: null, destination: null });
                        }
                    }
                    if (type == 'payment') {
                        if (this.payments[index + 1] == undefined) {
                            this.checkExistingPayment(index, '');
                            this.payments.push({
                                items: this.bank_pay,
                                item: null,
                            });
                        }
                    }
                    if (type == 'recevie') {
                        if (this.recevies[index + 1] == undefined) {
                            this.checkExistingRecevie(index, '');
                            this.recevies.push({
                                items: this.banks,
                                item: null,
                            });
                        }
                    }
                }

            },

            // in here you can check and decide to allow duplicate bank for payment or not
            checkExistingPayment(index = null, name = '') {
                var bank_temp = this.bank_pay.slice();
                var bank_temp1 = [];
                for (var i = 0; i < this.payments.length; i++) {
                    if (this.payments[i].item != null) {
                        var fined = bank_temp.findIndex((item) => item.name == this.payments[i].item.name);
                        if (fined != -1) {
                            var o = bank_temp.splice(bank_temp.findIndex((item) => item.name == this.payments[i].item.name), 1);
                        }
                    }
                }
                this.payments[index].items = bank_temp.filter((item) => {
                    return (new RegExp(name.toLowerCase())).test(item.name.toLowerCase())
                });
                //this.payments[index].items =bank_temp;


            },
            // in here you can check and decide to allow duplicate bank for payment or not
            checkExistingRecevie(index = null, name = '') {
                var bank_temp = this.banks.slice();
                var bank_temp1 = [];
                for (var i = 0; i < this.recevies.length; i++) {
                    if (this.recevies[i].item != null) {
                        var fined = bank_temp.findIndex((item) => item.name == this.recevies[i].item.name);
                        if (fined != -1) {
                            var o = bank_temp.splice(bank_temp.findIndex((item) => item.name == this.recevies[i].item.name), 1);
                        }
                    }
                }
                this.recevies[index].items = bank_temp.filter((item) => {
                    return (new RegExp(name.toLowerCase())).test(item.name.toLowerCase())
                });
                //this.recevies[index].items =bank_temp;
            },

            // in here you can check and decide to allow duplicate service or not
            checkExistingService(index = null, name = '') {
                var service_temp = this.all_services.slice();
                var service_temp1 = [];
                for (var i = 0; i < this.services.length; i++) {
                    if (this.services[i].item != null) {
                        var fined = service_temp.findIndex((item) => item.name == this.services[i].item.name);
                        if (fined != -1) {
                            var o = service_temp.splice(service_temp.findIndex((item) => item.name == this.services[i].item.name), 1);
                        }
                    }
                }
                this.services[index].items = service_temp.filter((item) => {
                    return (new RegExp(name.toLowerCase())).test(item.name.toLowerCase())
                });
                //this.payments[index].items =bank_temp;


            },
            // delete item from list
            deleteItem(type = null, index) {
                if (type != null) {
                    if (type == 'introduce') {
                        this.introduces.splice(index, 1);
                    }
                    if (type == 'payment') {
                        this.payments.splice(index, 1);
                    }
                    if (type == 'recevie') {
                        this.recevies.splice(index, 1);
                    }
                }

            },
            // submit the form
            submitForm() {

                if (this.isError == true) {
                    alert('there is no item');
                    return false;
                }
                swal({
                    title: "@lang('layout.AreYouSure?')",
                    buttons: ["@lang('layout.Cancel')", "@lang('layout.Submit')"],
                    text: "",
                    icon: "info",
                    dangerMode: true,
                }).then((willDelete) => {
                    if (willDelete) {
                        document.getElementById("vehicleCMR-form").submit()

                    } else {

                    }
                });

            },
            defaultValue() {
                this.selected_customer = null;
                this.selected_index = 0;

                this.services = [{
                        items: all_services,
                        item: null,
                    },
                    {
                        items: all_services,
                        item: null,
                    },
                ];
                this.payments = [{
                    items: bank_pay,
                    item: null,
                }];

                this.recevies = [{
                    items: banks,
                    item: null,
                }];

                this.invoiceDescription = null;
                this.saleOrderList = [];
                this.selected_sale_order = null;
                this.member_id = null;
                this.discountFiled = 0;
                this.temp_items = [];
            },
            saveAndNew() {
                this.$validator.validate()
                    .then(valid => {
                        if (valid) {

                            var url = "{{route('vehicleCMR.store')}}";
                            form_id = 'vehicleCMR-form';
                            var data = $('#' + form_id).serialize();
                            toggleBlock(true);
                            axios.post(url, data)
                                .then(function(response) {
                                    toggleBlock(0);
                                    console.log('sss11', response.data);
                                    if (response.data.result == 1) {
                                        $('#' + form_id).trigger('reset');
                                        //$('#success-sound')[0].play();
                                        toastr.success('', response.data.message);
                                        location.reload();
                                    } else {
                                        var message = "{{__('message.Warning')}}";
                                        //$('#error-sound')[0].play();
                                        toastr.warning('', message);
                                    }
                                })
                                .catch(function(error) {
                                    toggleBlock(0);
                                    console.log(error);
                                    var message = "{{__('message.Warning')}}";
                                    //$('#error-sound')[0].play();
                                    toastr.warning('', message);
                                });

                        }
                    })
            },
        },


    });
</script>



@endpush