@extends('layouts.factor-master') 
@section('content') 
<h3 class="table-caption" style="text-align: center;">@lang('layout.VehicleCMRReport')</h3>

<table class="main-table">
  <tr>
      @if($from_date)
          <td>
              <span>@lang('layout.FromDate')</span>:
              <BDO DIR="LTR"> @if(\Setting::get('jalali_and_gerogarian_date') == 'true')  {{convertDate($from_date, null, null, ((\Setting::get('date_type') == 'jalali')?'gregorian':'jalali'))}}  <span dir="rtl"> &nbsp;&nbsp;&nbsp;  @lang('layout.MarchingAt')  </span>  @endif  {{convertDate($from_date)}}</BDO>
          </td>
      @endif
      @if($to_date)
          <td>
              <span>@lang('layout.ToDate')</span>:
              <BDO DIR="LTR">@if(\Setting::get('jalali_and_gerogarian_date') == 'true')  {{convertDate($to_date, null, null, ((\Setting::get('date_type') == 'jalali')?'gregorian':'jalali'))}}  <span dir="rtl"> &nbsp;&nbsp;&nbsp;  @lang('layout.MarchingAt')  </span>  @endif  {{convertDate($to_date)}}</BDO>
          </td>
      @endif
  </tr>
</table>

<table class="main-table">
<thead>
<tr class="bg">
   <th><div class="center">  @lang('layout.Record') </div></th>
   <th><div class="center"> @lang('layout.Number') </div></th>
   <th><div class="center"> @lang('layout.ReferenceNumber') </div></th>
   <th><div class="center"> @lang('layout.Date')</div></th>
   <th><div class="center"> @lang('layout.Description')</div></th> 
   <th><div class="center"> @lang('layout.Customer')</div></th>
   <th><div class="center"> @lang('layout.Phone')</div></th>
   <th><div class="center"> @lang('layout.Count') CMR</div></th>
   <th><div class="center"> @lang('layout.Amount')</div></th>
   <th><div class="center"> @lang('layout.Currency')</div></th>
   <th><div class="center"> @lang('layout.Rate')</div></th>
   <th><div class="center"> @lang('layout.Recevies')</div></th>
  
   <th><div class="center"> @lang('layout.User')</div></th> 
</tr>
</thead>
 <?php
 $count = 0;
 $total_home_currency=0;
 $totalRecevie=0;
 $currencies=[];
 ?>
 @foreach($data AS $record)
  <?php  
    if(systemConfig()[30] == 1){
        $total_home_currency += ($record->amount / $record->static_rate * $record->rate);
    }else{
        $total_home_currency += ($record->amount / $record->rate);
    }

    if(systemConfig()[30] == 1){
      $totalRecevie += ($record->totalRecevie / $record->static_rate * $record->rate);
    }else{
      $totalRecevie += ($record->totalRecevie / $record->rate);
    }  
  ?>
 <tr>
    <td class="center">{{++$count}}</td>
    <td class="center">{{$record->number}}</td>
    <td class="center">{{$record->ref_no}}</td>
    <td class="center">{{convertDate($record->date)}}</td>
    <td class="center">{{$record->description}}</td>
    <td class="center">{{$record->members_name}}</td>
    <td class="center">{{$record->phone}}</td>
    <td class="center">{{$record->cmr_count}}</td>
    <td class="center">{{myRound($record->amount)}}</td>
    <td class="center">{{$record->currency}}</td>
    <td class="center">{{$record->rate}}</td>
    <td class="center">{{myRound($record->totalRecevie)}}</td>
    
    <td class="center">{{$record->user}}</td>
</tr>
@endforeach
  <tr class="bg">
    <th class="center" colspan="4">@lang('layout.Total')</th>
    <th class="center" colspan="4">@lang('layout.Recevies')</th>
    <th class="center" colspan="4">@lang('layout.RemaindAmount')</th>
  </tr>
  <tr class="">
    <th class="center" colspan="4">{{myRound($total_home_currency)}} {{getHomeCurrency()[getCurrencyType()]}}</th>
    <th class="center" colspan="4">{{myRound($totalRecevie)}} {{getHomeCurrency()[getCurrencyType()]}}</th>
    <th class="center" colspan="4">{{myRound($total_home_currency - $totalRecevie)}} {{getHomeCurrency()[getCurrencyType()]}}</th>
  </tr>
</table>

 <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->
@endsection