@extends('layouts.factor-master')

@section('content')

<h3 class="table-caption" style="text-align: center;">@lang('layout.VehicleCMRReport')</h3>
<table style="width: 100%; margin-bottom: 10px;">
  <tr>
    @if($from_date)
    <td colspan="2">
      <span>@lang('layout.FromDate')</span>:
      <BDO DIR="LTR">{{convertDate($from_date)}}</BDO>
    </td>
    @endif
    @if($to_date)
    <td colspan="2">
      <span>@lang('layout.ToDate')</span>:
      <BDO DIR="LTR">{{convertDate($to_date)}}</BDO>
    </td>
    @endif
  </tr>
</table>

<table class="main-table">
  <thead>
    <tr class="bg">
      <th>
        <div class="center">  @lang('layout.Record') </div>
      </th>
      <th>
        <div class="center"> @lang('layout.Number') </div>
      </th>
      <th>
        <div class="center"> @lang('layout.ReferenceNumber') </div>
      </th>
      <td>
        <div class="center"> @lang('menu.TransportCompany') </div>
      </td>
      <td>
        <div class="center"> @lang('layout.Phone') </div>
      </td>
      <th>
        <div class="center"> @lang('layout.Driver')</div>
      </th>
      <td>
        <div class="center"> @lang('layout.Phone') </div>
      </td>
      <th>
        <div class="center"> @lang('layout.VehicleName')</div>
      </th>
      <th>
        <div class="center"> @lang('layout.Source')</div>
      </th>
      <th>
        <div class="center"> @lang('layout.Destination')</div>
      </th>
      <th>
        <div class="center"> @lang('layout.Customer')</div>
      </th>
      <th>
        <div class="center"> @lang('layout.Phone')</div>
      </th>
      <th>
        <div class="center"> @lang('layout.Amount')</div>
      </th>
      <th>
        <div class="center"> @lang('layout.Currency')</div>
      </th>
      <th>
        <div class="center"> @lang('layout.Rate')</div>
      </th>
      <th>
        <div class="center"> @lang('layout.Date')</div>
      </th>
      <th>
        <div class="center"> @lang('layout.Description')</div>
      </th>
      <th>
        <div class="center"> @lang('layout.User')</div>
      </th>
    </tr>
  </thead>
  <?php
  $count = 0;
  $total_home_currency = 0;
  $currencies = [];
  ?>
  @foreach($data AS $record)
  <?php

  if(systemConfig()[30] == 1){
    $total_home_currency += ($record->amount / $record->static_rate * $record->rate);
  }else{
    $total_home_currency += ($record->amount / $record->rate);
  }


  ?>
  <tr>
    <td class="center">{{++$count}}</td>
    <td class="center">{{$record->number}}</td>
    <td class="center">{{$record->ref_no}}</td>
    <td class="center">{{$record->transport_company}}</td>
    <td class="center">{{$record->transport_phone}}</td>
    <td class="center">{{$record->driver_name}}</td>
    <td class="center">{{$record->driver_phone}}</td>
    <td class="center">{{$record->vehicle_name}}</td>
    <td class="center">{{$record->source}}</td>
    <td class="center">{{$record->destination}}</td>
    <td class="center">{{$record->members_name}}</td>
    <td class="center">{{$record->phone}}</td>
    <td class="center">{{$record->amount}}</td>
    <td class="center">{{$record->currency}}</td>
    <td class="center">{{$record->rate}}</td>
    <td class="center">{{convertDate($record->date)}}</td>
    <td class="center">{{$record->description}}</td>
    <td class="center">{{$record->user}}</td>
  </tr>
  @endforeach
  <tr class="bg">
    <th class="center" colspan="5">@lang('layout.Total')</th>
    <th class="center" colspan="7">{{myRound($total_home_currency)}} {{getHomeCurrency()[getCurrencyType()]}}  </th>
  </tr>
</table>


@if($receive)
<h3 class="table-caption" style="text-align: center;">@lang('layout.VehicleRentReceiveReport')</h3>
<table class="main-table">

  <thead>
    <tr class="bg">
      <td class="center" >
        <div >  @lang('layout.Record') </div>
      </td>
      <th class="center" >
        <div > @lang('layout.Number') </div>
      </th>
      <th class="center" >
        <div > @lang('layout.ReferenceNumber') </div>
      </th>
      <td class="center" >
        <div > @lang('layout.Account')</div>
      </td>
      <td class="center" >
        <div > @lang('layout.Currency')</div>
      </td>
      <td class="center" >
        <div > @lang('layout.Rate')</div>
      </td>
      <td class="center" >
        <div > @lang('layout.Amount')</div>
      </td>
      <td class="center" >
        <div > @lang('layout.Type')</div>
      </td>
      <td class="center" >
        <div > @lang('layout.Date')</div>
      </td>

    </tr>
  </thead>
  <?php
  $count = 0;
  $total_rec = 0;
  ?>
  @foreach($receive AS $rec)
  <?php
  if(systemConfig()[30] == 1){
    $total_rec += ($rec->amount / $rec->static_rate * $rec->rate);
}else{
    $total_rec += ($rec->amount / $rec->rate);
  }
  ?>
  <tr>
    <td class="center">{{++$count}}</td>
    <td class="center">{{$rec->number}}</td>
    <td class="center">{{$rec->ref_no}}</td>
    <td class="center">{{$rec->account}}</td>
    <td class="center">{{$rec->currency}}</td>
    <td class="center">{{$rec->rate}}</td>
    <td class="center">{{$rec->amount}}</td>
    <td class="center">{{$rec->type}}</td>
    <td class="center">{{convertDate($rec->date)}}</td>

  </tr>
  @endforeach
  </table>

  <table class="main-table">
    <tr class="bg">
      <th class="center" >@lang('layout.Total')</th>
      <th class="center" >@lang('layout.Recevies')</th>
      <th class="center" >@lang('layout.TotalRemain')</th>
    </tr>
    <tr class="">
      <td class="center" >{{myRound($total_home_currency)}} {{getHomeCurrency()[getCurrencyType()]}}</td>
      <td class="center" >{{myRound($total_rec)}} {{getHomeCurrency()[getCurrencyType()]}}</td>
      <td class="center" >{{myRound($total_home_currency - $total_rec)}} {{getHomeCurrency()[getCurrencyType()]}}</td>
    </tr>
  </table>
  @endif

<!--  signature -->
<table style="width: 100%" class="signtable">
  <tr>
    @foreach(getCompanyInfo('sign','reports') AS $info)
    <td style="text-align: left; width:40%">
      <table>

        <tr>
          <td align="right" class="signsize">{{$info['name']}}</td>
        </tr>

      </table>
    </td>
    @endforeach
  </tr>
</table>
<!-- End signature -->
@endsection