@extends('layouts.factor-master')


@section('content')
    <table class="main-table">
        @if($info && $info !=[])

			<thead>
			<tr>
				<th>
					<i class="fa  fa-truck"></i> @lang('layout.VehicleName')
				</th>
				<th class="hidden-xs">
					<i class="fa "></i> @lang('layout.PaletNumber')
				</th>
				<th class="hidden-xs">
					<i class="fa "></i> @lang('layout.VehicleType')
				</th>
                <th class="hidden-xs">
					<i class="fa "></i> @lang('layout.VehicleCategory')
				</th>
				<th>
					<i class="fa fa"></i> @lang('layout.TankerNumber')
				</th>
				<th>
					<i class="fa fa"></i> @lang('layout.IncomeAccount')
				</th>
				<th>
					<i class="fa fa"></i> @lang('layout.ExpenseAccount')
				</th>
				<th>
					<i class="fa fa"></i> @lang('layout.Description')
				</th>
				
			</tr>
			</thead>
			<tbody>
			<tr> 
				<td class="hidden-xs"> {{ $info->vehicle_name}}  </td>
				<td class="hidden-xs"> {{ $info->palet_number}}  </td>
				<td class="hidden-xs"> {{ $info->vehicle_type }}  </td>
				<td class="hidden-xs"> {{ $info->vehicle_category }}  </td>
				<td class="hidden-xs"> {{ $info->tanker_number }}  </td>
				<td class="hidden-xs"> {{ $info->income }}  </td>
				<td class="hidden-xs"> {{ $info->expense}}  </td>
				<td class="hidden-xs"> {{ $info->description}}  </td>

			</tr>
			</tbody>

        @endif

    </table>


    <h3 class="table-caption" style="text-align: center;">@lang('layout.StatementDetails')</h3>
    <table class="main-table">
        <thead>
        <tr class="bg">

            <td>
                <div class="center"> #</div>
            </td>
            <th>@lang('layout.Account')</th>
			<th>@lang('layout.Description')</th>
			<th>@lang('layout.Currency')</th>
			<th>@lang('layout.Rate')</th>
			<th>@lang('layout.Type')</th>
			<th>@lang('layout.Receive')</th>
            <th>@lang('layout.Expense')</th>
            <th>@lang('layout.TotalInHomeCurrency') {{getHomeCurrency()[getCurrencyType()]}}</th>
            <th>@lang('layout.Balance') {{getHomeCurrency()[getCurrencyType()]}}</th>
			<th>@lang('layout.Date')</th>
        </tr>
        </thead>
        <?php
        $count = 0;
        $total_profit =0;
        $currencies =[];
        $currency_data =[];
        $total_payable = 0;
        $total_receivable = 0;
        $balance = 0;
        ?>
        @foreach($data AS $record)
		<?php
					$p = 0;
                    $r = 0;
                    $tpp=0;
                    $trr=0;
					
                        $r = ($record->type == 'r') ? $record['amount'] : 0;

                        $p = ($record['type'] == 'p') ? $record['amount'] : 0;

                        $totalg = SumToNumber($p, $r);
                        $tpp = $totalg['a'];
                        $trr = $totalg['b'];
                        if (array_key_exists($record->Currency, $currency_data)) {
                            $total_payable += $tpp / $record->Rate;
                            $total_receivable += $trr / $record->Rate;

                            $p_p = $currency_data[$record->Currency]['p'];
                            $p_r = $currency_data[$record->Currency]['r'];

                            $currency_data[$record->Currency] = [
                                'p' => $tpp + $p_p,
                                'r' => $trr + $p_r,
                            ];
                        } else {
                            $total_payable += $tpp / $record->Rate;
                            $total_receivable += $trr / $record->Rate;
                            $currency_data[$record->Currency] = [
                                'p' => $tpp,
                                'r' => $trr,
                            ];
                        }
                    //end check show
		
		  ?>
            <tr>
                <td class="center">{{++$count}}</td>
				<td class="center">{{$record->Account}}</td>
				<td class="center">{{$record->Description}}</td>
				<td class="center">{{$record->Currency}}</td>
				<td class="center">{{$record->Rate}}</td>
				<td class="center">{{ __('type.' . $record->Types) }} : {{$record->number}}</td>
				<td class="center">@if($record->type == 'r') {{myRound($record->amount)}} @endif</td>
                <td class="center">@if($record->type == 'p') {{myRound($record->amount)}} @endif</td>
                <td class="center">@if($record->type == 'r') {{myRound($record->amount_base)}} @else {{myRound($record->amount_base * -1)}} @endif</td>
                <td class="center">{{myRound($total_receivable - $total_payable)}}</td>
				<td class="center">{{convertDate($record->Date)}}</td>
				
            </tr>
        @endforeach
        
    </table>
	
	
	    <!-- begin sammary -->
    @if(count($currency_data))
         <table class="main-table" style="width:100%">
            <tr class="bg">
                <td width="25%">
                    <div class="center"> @lang('layout.Currency') </div>
                </td>
                <td width="25%">
                    <div class="center ltr"> @lang('layout.Receive') </div>
                </td>
                <td width="25%">
                    <div class="center ltr"> @lang('layout.Expense') </div>
                </td>
                <td width="25%">
                    <div class="center ltr"> @lang('layout.Income') </div>
                </td>
            </tr>
            <?php
            $count = 0;
            $tempName = '';
            ?>
            @foreach($currency_data AS $k=>$v)

                <?php
                $rowSpan = -1;
                if ($tempName == $k) {
                    $rowSpan++;
                }
                $tempName = $k;
                ?>

                <tr>
                    <td class="center ltr"><BDO DIR="LTR">{{$k}}</BDO></td>
                    <td class="center ltr"><BDO DIR="LTR">{{myRound($v['r'])}}</BDO></td>
                    <td class="center ltr"><BDO DIR="LTR">{{myRound($v['p'])}}</BDO></td>
                    <td class="center ltr">

                        <?php
                        $bt_payable = 0;
                        $bt_receivable = 0;
                        $a = SumToNumber($v['p'], $v['r']);
                        $bt_payable = $a['a'];
                        $bt_receivable = $a['b'];
                        ?>

                        @if($bt_receivable !=0)
                            <BDO DIR="LTR">
                                {{Currency()->format($bt_receivable,$k)}}
                            </BDO>
                            <span> @lang('layout.TotalProfit') </span>

                        @else
                            <BDO DIR="LTR">
                                {{Currency()->format($bt_payable,$k)}}

                            </BDO>
                            <span> @lang('layout.Loss') </span>
                        @endif
                    </td>
                </tr>
            @endforeach
        </table>

    @endif

    <table class="main-table" style="width:100%">
            <tr class="bg">
                <td width="25%">
                    <div class="center"> @lang('layout.Currency') </div>
                </td>
                <td width="25%">
                    <div class="center ltr"> @lang('layout.Receive') </div>
                </td>
                <td width="25%">
                    <div class="center ltr"> @lang('layout.Expense') </div>
                </td>
                <td width="25%">
                    <div class="center ltr"> @lang('layout.Income') </div>
                </td>
            </tr>
                <tr class="bg">
                    <td class="center ltr"><BDO DIR="LTR">{{getHomeCurrency()[getCurrencyType()]}}</BDO></td>
                    <td class="center ltr"><BDO DIR="LTR">{{myRound($total_receivable)}}</BDO></td>
                    <td class="center ltr"><BDO DIR="LTR">{{myRound($total_payable)}}</BDO></td>
                    <td class="center ltr"><BDO DIR="LTR">{{myRound($total_receivable - $total_payable)}}</BDO></td>
                </tr>
        </table>
    <!-- end sammary -->


 <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->
@endsection