@extends('layouts.app')

@section('content')
<div id="print-modal">
    <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show" :value-type="'vehicle_income'" @closed="closeModal">
        <div slot="body">
            <input type="hidden" name="vehicle_id" value="{{$vehicles->id}}" />
            <div class="row">
                <div class="form-group">
                    <div class="col-md-12">
                        <div class="form-group">
                            <label class="control-label"> @lang('layout.Date')</label>
                            <div class="input-group">
                                <input class="form-control date" id="range-from-example" name="from_date" autocomplete="off">

                                <span class="input-group-addon"> @lang('layout.To') </span>
                                <input class="form-control date" id="range-to-example" name="to_date">

                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="form-group">
                    <div class="col-md-12">
                        <div class="form-group">

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </report-modal>
    <report-modal :pdf-route="pdfRouteAll" :excel-route="excelRouteAll" v-if="logBook_show" :value-type="'vehicle_log_book'" @closed="closeModalLogBook">
        <div slot="body">
            <input type="hidden" name="vehicle_id" value="{{$vehicles->id}}" />
            <div class="row">
                <div class="form-group">
                    <div class="col-md-12">
                        <div class="form-group">
                            <label class="control-label"> @lang('layout.Date')</label>
                            <div class="input-group">
                                <input class="form-control date" id="range-from-example" name="from_date" autocomplete="off">

                                <span class="input-group-addon"> @lang('layout.To') </span>
                                <input class="form-control date" id="range-to-example" name="to_date">

                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="form-group">
                    <div class="col-md-12">
                        <div class="form-group">

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </report-modal>
    <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="load_show" :value-type="'vehicleLoading'" @closed="closeModalLoad">
        <div slot="body">
            <input type="hidden" name="vehicle_id" value="{{$vehicles->id}}" />
            <div class="row">
                <div class="form-group">
                    <div class="col-md-6">
                        <label class="control-label ">@lang('layout.VehicleType') </label>
                        <v-select class="vue-select2" v-model="loadTypeSelected" label="name" :options="loadType">
                        </v-select>
                        <input type="hidden" name="load_types" :value="(loadTypeSelected==null)?null:loadTypeSelected.id">
                    </div>

                </div>
            </div>
            <div class="row">
                <div class="form-group">
                    <div class="col-md-12">
                        <div class="form-group">
                            <label class="control-label"> @lang('layout.Date')</label>
                            <div class="input-group">
                                <input class="form-control date" id="range-from-example" name="from_date" autocomplete="off">

                                <span class="input-group-addon"> @lang('layout.To') </span>
                                <input class="form-control date" id="range-to-example" name="to_date">

                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="form-group">
                    <div class="col-md-12">
                        <div class="form-group">

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </report-modal>
    <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="statement_show" :value-type="'vehicle_statement'" @closed="closeModal1">
        <div slot="body">
            <input type="hidden" name="vehicle_id" value="{{$vehicles->id}}" />

            <div class="row">
                <div class="form-group">

                    <div class="col-md-6">
                        <label class="control-label ">@lang('layout.VehicleType') </label>
                        <v-select class="vue-select2" v-model="ReportTypeSelected" label="name" :options="ReportType">
                        </v-select>
                        <input type="hidden" name="report_types" :value="(ReportTypeSelected==null)?null:ReportTypeSelected.id">
                    </div>

                </div>
            </div>

            <div class="row">
                <div class="form-group">
                    <div class="col-md-12">
                        <div class="form-group">
                            <label class="control-label"> @lang('layout.Date')</label>
                            <div class="input-group">
                                <input class="form-control date" id="range-from-example" name="from_date" autocomplete="off">

                                <span class="input-group-addon"> @lang('layout.To') </span>
                                <input class="form-control date" id="range-to-example" name="to_date">

                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="form-group">
                    <div class="col-md-12">
                        <div class="form-group">

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </report-modal>
</div>


<div class="portlet">
    <div class="portlet-title" id="backbtn">
        <div class="caption">
            <i class=""></i>@lang('layout.VehicleShow')
        </div>
        <div class="tools">
            <a href="javascript:;" class="collapse" data-original-title="" title=""> </a>
            <a href="#portlet-config" data-toggle="modal" class="config" data-original-title="" title=""> </a>
            {{--<a href="javascript:;" class="reload" data-original-title="" title=""> </a>--}}
            {{--<a href="javascript:;" class="remove" data-original-title="" title=""> </a>--}}
        </div>
        <div class=" pull-right">
            <a type="button" class="btn green hidden-print" style="margin-right: 4px !important;" name="btnprint" onclick="window.print()" /><i class="fa fa-print"></i> @lang('layout.Print')</a>
        </div>
    </div>
    <div class="portlet-body">
        <!--Begin Tabs-->
        <div class="">
            <div class="tabbable tabbable-tabdrop">

                <ul class="nav nav-tabs hidden-print">
                    <li class="active">
                        <a href="#tab1" data-toggle="tab" id="tab_sale">@lang('layout.VehicleDetails')</a>
                    </li>
                    <li class="">
                        <a href="#tab2" data-toggle="tab" id="tab_payment">@lang('menu.VehicleEquipment')</a>
                    </li>
                    <li class="">
                        <a href="#tab3" data-toggle="tab" id="tab_attachment">@lang('layout.Attachments')</a>
                    </li>
                </ul>
                <div class="tab-content row">

                    <div class="tab-pane active" id="tab1">
                        <div class="portlet light bortdered">

                            <div class="portlet-body">
                                <div class="table-scrollable">
                                    <table class="table table-striped table-bordered table-advance table-hover">
                                        <thead>
                                            <tr>
                                                <th>
                                                    <i class="fa  fa-truck"></i> @lang('layout.VehicleName')
                                                </th>
                                                <th class="">
                                                    <i class="fa "></i> @lang('layout.PaletNumber')
                                                </th>
                                                <th class="">
                                                    <i class="fa "></i> @lang('layout.VehicleType')
                                                </th> 
                                                <th class="">
                                                    <i class="fa "></i> @lang('layout.VehicleCategory')
                                                </th>
                                                <th>
                                                    <i class="fa fa"></i> @lang('layout.TankerNumber')
                                                </th>
                                                <th>
                                                    <i class="fa fa"></i> @lang('layout.IncomeAccount')
                                                </th>
                                                <th>
                                                    <i class="fa fa"></i> @lang('layout.ExpenseAccount')
                                                </th>
                                                <th>
                                                    <i class="fa fa"></i> @lang('layout.Driver')
                                                </th>
                                                <th>
                                                    <i class="fa fa"></i> @lang('layout.Description')
                                                </th>
                                                <th>
                                                    <i class="fa fa"></i> @lang('layout.RoadActivity')
                                                </th>

                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr>
                                                <td class=""> {{ $vehicles->vehicle_name}} </td>
                                                <td class=""> {{ $vehicles->palet_number}} </td>
                                                <td class=""> {{ $vehicles->vehicle_type }} </td>
                                                <td class=""> {{ $vehicles->vehicle_category }} </td>
                                                <td class=""> {{ $vehicles->tanker_number }} </td>
                                                <td class=""> {{ $vehicles->income }} </td>
                                                <td class=""> {{ $vehicles->expense}} </td>
                                                <td class=""> {{ $vehicles->main_driver}} </td>
                                                <td class=""> {{ $vehicles->description}} </td>
                                                <td class=""> {{ $vehicles->road_activity}} </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                    <table class="table table-striped table-bordered table-advance table-hover">
                                        <thead>
                                            <tr>
                                                <th>
                                                    <i class="fa fa"></i> @lang('layout.Phone')
                                                </th>
                                                <th>
                                                    <i class="fa "></i> @lang('layout.ChassisNumber')
                                                </th>
                                                <th>
                                                    <i class="fa "></i> @lang('layout.EngineNumber')
                                                </th>
                                                <th>
                                                    <i class="fa "></i> @lang('layout.BuildCompany')
                                                </th>
                                                <th>
                                                    <i class="fa "></i> @lang('layout.Model')
                                                </th>
                                                <th>
                                                    <i class="fa "></i> @lang('layout.BuildYear')
                                                </th>
                                                <th>
                                                    <i class="fa "></i> @lang('layout.Color')
                                                </th>
                                                <th>
                                                    <i class="fa "></i> @lang('layout.GarlicLicenseNumber')
                                                </th>
                                                <th>
                                                    <i class="fa "></i> @lang('layout.GarlicLicenseIssueDate')
                                                </th>
                                                <th>
                                                    <i class="fa "></i> @lang('layout.GarlicLicenseEndDate')
                                                </th>
                                                <th>
                                                    <i class="fa "></i> @lang('layout.LogBookStartDate')
                                                </th>
                                                <th>
                                                    <i class="fa "></i> @lang('layout.LogBookEndDate')
                                                </th>

                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr>
                                                <td class=""> {{ $vehicles->phone}} </td>
                                                <td class=""> {{ $vehicles->chassis_number}} </td>
                                                <td class=""> {{ $vehicles->engine_number}} </td>
                                                <td class=""> {{ $vehicles->build_company}} </td>
                                                <td class=""> {{ $vehicles->model}} </td>
                                                <td class=""> {{ $vehicles->build_year}} </td>
                                                <td class=""> {{ $vehicles->color}} </td>
                                                <td class=""> {{ $vehicles->garlic_license_number}} </td>
                                                <td class=""> {{ convertDate($vehicles->garlic_license_issue_date) }} </td>
                                                <td class=""> {{ convertDate($vehicles->garlic_license_end_date) }} </td>
                                                <td class=""> {{ convertDate($vehicles->log_book_start_date) }} </td>
                                                <td class=""> {{ convertDate($vehicles->log_book_end_date) }} </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="tab-pane" id="tab2">
                        <div class="portlet light bortdered">

                            <div class="portlet-body">
                                <table class="table table-striped table-bordered table-hover" id="vehicleEquipment">
                                    <thead>
                                        <tr>
                                            <th>@lang('layout.Name')</th>
                                            <th>@lang('layout.Value')</th>
                                            <th>@lang('layout.Description')</th>
                                            <th>@lang('layout.ChangeDate')</th>
                                            <th>@lang('layout.Action')</th>
                                        </tr>
                                    </thead>
                                </table>
                            </div>
                        </div>
                    </div>
                    <div class="tab-pane" id="tab3">
                        <div class="portlet light bordered">
                            <div class="portlet-title">
                                <div class="caption font-dark">
                                    <i class="icon-settings font-dark"></i>
                                    <span class="caption-subject bold uppercase">@lang('layout.Attachments')</span>
                                </div>
                            </div>
                            <div class="portlet-body">
                                <div class="portlet light bordered">
                                    <div class="portlet-body">

                                        <form role="form" action="{{route('attachment.store')}}" method="post" enctype="multipart/form-data">

                                            @csrf
                                            <input type="hidden" name="redirect_route" value="vehicle.show">
                                            <input type="hidden" name="foreign_data_id" value="{{$vehicles->id}}">
                                            <input type="hidden" name="path" value="uploads/vehicle">
                                            <input type="hidden" name="table_name" value="vehicles">

                                            <div class="row">
                                                <div class="col-md-4">
                                                    <div class="form-group">
                                                        <label class="control-label">@lang('layout.AttachmentTitle')</label>
                                                        <input type="text" name="title" class="form-control">
                                                    </div>
                                                </div>
                                                <div class="col-md-4">
                                                    <div class="form-group">
                                                        <label class="control-label">@lang('layout.Description')</label>
                                                        <textarea name="description" class="form-control"></textarea>
                                                    </div>
                                                </div>
                                                <div class="col-md-7">
                                                    <div class="form-group">
                                                        <div class="fileinput fileinput-new" data-provides="fileinput">
                                                            <div class="fileinput-new thumbnail" style="width: 200px; height: 150px;">
                                                                <img src="" alt=""> </div>
                                                            <div class="fileinput-preview fileinput-exists thumbnail" style="max-width: 200px; max-height: 150px; line-height: 10px;"> </div>
                                                            <div>
                                                                <span class="btn default btn-file">
                                                                    <span class="fileinput-new">@lang('layout.SelectFile')</span>
                                                                    <span class="fileinput-exists">@lang('layout.Change')</span>
                                                                    <input type="hidden" value="" name=""><input type="file" name="photo"> </span>

                                                                <a href="javascript:;" class="btn default fileinput-exists" data-dismiss="fileinput"> @lang('layout.Remove') </a>
                                                            </div>

                                                        </div>
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="margiv-top-10">
                                                <button type="button" onclick="regForm(this)" class="btn green"> @lang('layout.Submit') </button>
                                                <a href="{{route('dailyExpense.index')}}" class="btn default">@lang('layout.Cancel')</a>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                                <table class="table table-striped table-bordered table-hover" id="attachment">
                                    <thead>
                                        <tr>
                                            <th>@lang('layout.AttachmentTitle')</th>
                                            <th>@lang('layout.Description')</th>
                                            <th>@lang('layout.Action')</th>
                                        </tr>
                                    </thead>
                                </table>
                            </div>
                        </div>
                    </div>


                </div>
            </div>
        </div>
        <!--End Tabs-->

    </div>
</div>

<div class=" hidden-print">
    <div class="col-md-12">
        <span id="loading-modal">
            <a href="#" @click.prevent="showModalL" id="" class="btn  btn-success">
                <i class="fa fa-print"> <b> @lang('layout.Loading') </b> </i>
            </a>
        </span>

    </div>
</div>
<div class=" hidden-print">
    <div class="col-md-12">
        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="">
            <div class="tabbable-line tabbable-custom-profile">
                <ul class="nav nav-tabs">
                    <li class="active">
                        <a href="#statements" data-toggle="tab" id="statement-tab">
                            <i class=" icon-basket-loaded"></i><b> @lang('layout.StatementDetails') </b></a>
                    </li>
                    <li class="">
                        <a href="#logBook-tab-href" data-toggle="tab" id="v-logBook-tab">
                            <i class="fa fa-book"></i><b> @lang('layout.VehicleLogBook')</b> </a>
                    </li>
                    <li class="">
                        <a href="#income-tab-href" data-toggle="tab" id="v-income-tab">
                            <i class="icon-note"></i><b> @lang('layout.Income')</b> </a>
                    </li>

                </ul>
                <div class="tab-content padding" style="padding: 0px;">
                    <div class="tab-pane active" id="statements">
                        <div class="row">
                            <div class="col-md-12">
                                <!-- BEGIN EXAMPLE TABLE PORTLET-->
                                <div class="portlet light bordered">
                                    <div class="portlet-title">
                                        <div class="caption font-dark">
                                            <i class="icon-settings font-dark"></i>
                                            <span class="caption-subject bold uppercase">@lang('layout.StatementDetails')</span>
                                        </div>
                                        <div class="actions">
                                            <span id="statement-modal">
                                                <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                                                    <i class="fa fa-print"></i>
                                                </a>
                                            </span>
                                        </div>

                                    </div>
                                    <div class="portlet-body">
                                        <table class="table table-striped table-bordered table-hover" id="statement-table">
                                            <thead>
                                                <tr>
                                                    <th>@lang('layout.Account')</th>
                                                    <th>@lang('layout.Type')</th>
                                                    <th>@lang('layout.Description')</th>
                                                    <th>@lang('layout.Currency')</th>
                                                    <th>@lang('layout.Rate')</th>
                                                    <th>@lang('layout.Receive')</th>
                                                    <th>@lang('layout.Expense')</th>
                                                    <th>@lang('layout.TotalInHomeCurrency') {{getHomeCurrency()["code"]}}</th>
                                                    <th>@lang('layout.Date')</th>
                                                </tr>
                                            </thead>
                                        </table>
                                    </div>
                                </div>
                                <!-- END EXAMPLE TABLE PORTLET-->
                            </div>
                        </div>
                    </div>

                    <div class="tab-pane" id="logBook-tab-href">
                        <div class="row">
                            <div class="col-md-12">
                                <!-- BEGIN EXAMPLE TABLE PORTLET-->
                                <div class="portlet light bordered">
                                    <div class="portlet-title">
                                        <div class="caption font-dark">
                                            <i class="icon-settings font-dark"></i>
                                            <span class="caption-subject bold uppercase">@lang('layout.VehicleLogBook')</span>
                                        </div>

                                        <div class="actions">
                                            <span id="logBook-modal">
                                                <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                                                    <i class="fa fa-print"></i>
                                                </a>
                                            </span>
                                        </div>
                                    </div>
                                    <div class="portlet-body">
                                        <table class="table table-striped table-bordered table-hover" id="v-logBook-table">
                                            <thead>
                                                <tr>
                                                <th>@lang('layout.Number')</th>
                                                <th>@lang('layout.Driver')</th>
                                                <th>@lang('layout.VehicleName')</th>
                                                <th>@lang('layout.PlateNumber')</th>
                                                <th>@lang('layout.Traveller')</th>
                                                <th>@lang('layout.Source')</th>
                                                <th>@lang('layout.Destination')</th>
                                                <th>@lang('layout.StartOdometer')</th>
                                                <th>@lang('layout.FinishOdometer')</th>
                                                <th>@lang('layout.Date')</th>
                                                <th>@lang('layout.StartTripDate')</th>
                                                <th>@lang('layout.EndTripDate')</th>
                                                <th>@lang('layout.Description')</th>
                                                <th>@lang('layout.User')</th>
                                                </tr>
                                            </thead>
                                        </table>
                                    </div>
                                </div>
                                <!-- END EXAMPLE TABLE PORTLET-->
                            </div>
                        </div>
                        <!-- END EXAMPLE TABLE PORTLET-->
                    </div>

                    <div class="tab-pane" id="income-tab-href">
                        <div class="row">
                            <div class="col-md-12">
                                <!-- BEGIN EXAMPLE TABLE PORTLET-->
                                <div class="portlet light bordered">
                                    <div class="portlet-title">
                                        <div class="caption font-dark">
                                            <i class="icon-settings font-dark"></i>
                                            <span class="caption-subject bold uppercase">@lang('layout.Income')</span>
                                        </div>

                                        <div class="actions">
                                            <span id="anchore-modal">
                                                <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                                                    <i class="fa fa-print"></i>
                                                </a>
                                            </span>
                                        </div>
                                    </div>
                                    <div class="portlet-body">
                                        <table class="table table-striped table-bordered table-hover" id="v-income-table">
                                            <thead>
                                                <tr>
                                                    <th>@lang('layout.Transporter_name')</th>
                                                    <th>@lang('layout.Amount')</th>
                                                    <th>@lang('layout.Currency')</th>
                                                    <th>@lang('layout.Rate')</th>
                                                    <th>@lang('layout.LoadingDate')</th>
                                                    <th>@lang('layout.Source')</th>
                                                    <th>@lang('layout.Destination')</th>
                                                    <th>@lang('layout.ItemName')</th>
                                                    <th>@lang('layout.Measure')</th>
                                                    <th>@lang('layout.Quantity')</th>

                                                </tr>
                                            </thead>
                                        </table>
                                    </div>
                                </div>
                                <!-- END EXAMPLE TABLE PORTLET-->
                            </div>
                        </div>
                        <!-- END EXAMPLE TABLE PORTLET-->
                    </div>
                </div>

                @endsection
                @include('print.modal')
                @push('scripts')

                <script>
                    Vue.component('v-select', VueSelect.VueSelect)

                    $(document).ready(function() {
                        $.fn.dataTable.ext.errMode = '{{dataTableWarning()}}';

                        $('#v-service-table').DataTable({

                            ajax: {
                                url: '{{route("service.show",$vehicles->id)}}',
                                data: {
                                    type: 'vehicle'
                                }
                            },
                            pageLength: '{{getPageRows()}}',
                            responsive: '{{responsiveDataTable()}}',
                            pagingType: '{{paginationType()}}',
                            scrollCollapse: true,
                            serverSide: true,
                            paging: true,
                            columns: [{
                                    data: 'customer',
                                    name: 'customer'
                                },
                                {
                                    data: 'date',
                                    name: 'date'
                                },
                                {
                                    data: 'qty',
                                    name: 'qty'
                                },
                                {
                                    data: 'sales_price',
                                    name: 'sales'
                                },
                                {
                                    data: 'unit_measure',
                                    name: 'unit_measure'
                                },
                            ]

                        });


                        $('#vehicleEquipment').DataTable({
                            ajax: {
                                url: '{{route("vehicle.show",$vehicles->id)}}',
                                data: {
                                    type: 'vehicleEquipment'
                                }
                            },
                            serverSide: true,
                            responsive: '{{responsiveDataTable()}}',
                            pagingType: '{{paginationType()}}',
                            scrollCollapse: true,
                            paging: true,
                            columns: [{
                                    data: 'name',
                                    name: 'name'
                                },
                                {
                                    data: 'value',
                                    name: 'value'
                                },
                                {
                                    data: 'description',
                                    name: 'description',
                                    orderable: false,
                                    searchable: false
                                },
                                {
                                    data: 'date',
                                    name: 'date',
                                    orderable: false,
                                    searchable: false
                                },
                                {
                                    data: 'actions',
                                    name: 'actions',
                                    orderable: false,
                                    searchable: false
                                },

                            ]

                        });
                        $('#attachment').DataTable({
                            ajax: {
                                url: '{{route("vehicle.show",$vehicles->id)}}',
                                data: {
                                    type: 'attachment'
                                }
                            },

                            scrollCollapse: true,
                            responsive: '{{responsiveDataTable()}}',
                            pagingType: '{{paginationType()}}',
                            serverSide: true,
                            destroy: true,
                            paging: true,
                            columns: [

                                {
                                    data: 'title',
                                    name: 'attachments.title'
                                },
                                {
                                    data: 'description',
                                    name: 'attachments.description'
                                },
                                {
                                    data: 'actions',
                                    name: 'actions',
                                    orderable: false,
                                    searchable: false
                                },
                            ]
                        });

                        $('#v-logBook-table').DataTable({
                                scrollCollapse: true,
                                responsive: '{{responsiveDataTable()}}',
                                pagingType: '{{paginationType()}}',
                                serverSide: true,
                                paging: true,
                                destroy: true,
                                retrieve: true,
                                ajax: {
                                    url: '{{route("vehicle.show",$vehicles->id)}}',
                                    data: {
                                        type: 'logBook'
                                    }
                                },
                                columns: [
                                    { data: 'number',       name: 'number'},
                                    { data: 'name',         name: 'name' },
                                    { data: 'vehicle_name', name: 'vehicle_name'  },
                                    { data: 'palet_number', name: 'palet_number'  },
                                    { data: 'traveller',          name: 'traveller'},
                                    { data: 'source',          name: 'source'},
                                    { data: 'destination',          name: 'destination'},
                                    { data: 'start_odometer',          name: 'start_odometer'},
                                    { data: 'finish_odometer',          name: 'finish_odometer'},
                                    { data: 'Date',             name: 'Date'},
                                    { data: 'start_trip_date',         name: 'start_trip_date'},
                                    { data: 'end_trip_date',         name: 'end_trip_date'},
                                    { data: 'description',  name: 'description'},
                                    { data: 'user',  name: 'user'}
                                ]
                            });

                        $('#statement-table').DataTable({
                            scrollCollapse: true,
                            responsive: '{{responsiveDataTable()}}',
                            pagingType: '{{paginationType()}}',
                            serverSide: true,
                            paging: true,
                            retrieve: true,
                            order: [
                                [8, "desc"]
                            ],
                            ajax: {
                                url: '{{route("vehicle.show",$vehicles->id)}}',
                                data: {
                                    type: 'statements'
                                }
                            },
                            columns: [{
                                    data: 'Account',
                                    name: 'accounts.name',
                                    orderable: false
                                },
                                {
                                    data: 'Type',
                                    name: 'Type',
                                    orderable: false,
                                    searchable: false
                                },
                                {
                                    data: 'Description',
                                    name: 'vehicle_managements.description',
                                    orderable: false
                                },
                                {
                                    data: 'Currency',
                                    name: 'transactions.unit',
                                    orderable: false
                                },
                                {
                                    data: 'Rate',
                                    name: 'Rate',
                                    orderable: false,
                                    searchable: false
                                },
                                {
                                    data: 'receive',
                                    name: 'receive',
                                    orderable: false,
                                    searchable: false
                                },
                                {
                                    data: 'expense',
                                    name: 'expense',
                                    orderable: false,
                                    searchable: false
                                },
                                {
                                    data: 'totalBase',
                                    name: 'totalBase',
                                    orderable: false,
                                    searchable: false
                                },
                                {
                                    data: 'Date',
                                    name: 'Date',
                                    searchable: false
                                },

                            ]
                        });

                    });


                    $(document).ready(function() {
                        $.fn.dataTable.ext.errMode = '{{dataTableWarning()}}';
                        $('#v-income-tab').on('shown.bs.tab', function(event) {

                            $('#v-income-table').DataTable({
                                scrollCollapse: true,
                                responsive: '{{responsiveDataTable()}}',
                                pagingType: '{{paginationType()}}',
                                serverSide: true,
                                paging: true,
                                retrieve: true,
                                ajax: {
                                    url: '{{route("vehicle.show",$vehicles->id)}}',
                                    data: {
                                        type: 'income'
                                    }
                                },
                                columns: [{
                                        data: 'driver',
                                        name: 'members.name'
                                    },
                                    {
                                        data: 'amount',
                                        name: 'transactions.amount'
                                    },
                                    {
                                        data: 'unit',
                                        name: 'transactions.unit'
                                    },
                                    {
                                        data: 'rate',
                                        name: 'rate',
                                        orderable: false,
                                        searchable: false
                                    },
                                    {
                                        data: 'loading_date',
                                        name: 'loading_date',
                                        orderable: false,
                                        searchable: false
                                    },
                                    {
                                        data: 'source',
                                        name: 'loading_details.source'
                                    },
                                    {
                                        data: 'destination',
                                        name: 'loading_details.destination'
                                    },
                                    {
                                        data: 'item',
                                        name: 'items.name'
                                    },
                                    {
                                        data: 'selected_measure',
                                        name: 'tum.name',
                                        orderable: false,
                                        searchable: false
                                    },
                                    {
                                        data: 'item_quantity',
                                        name: 'loading_details.item_quantity'
                                    },

                                ]
                            });

                        });

                        $('#v-logBook-tab').on('shown.bs.tab', function(event) {
                           
                            $('#v-logBook-table').DataTable({
                                scrollCollapse: true,
                                responsive: '{{responsiveDataTable()}}',
                                pagingType: '{{paginationType()}}',
                                serverSide: true,
                                paging: true,
                                destroy: true,
                                retrieve: true,
                                ajax: {
                                    url: '{{route("vehicle.show",$vehicles->id)}}',
                                    data: {
                                        type: 'logBook'
                                    }
                                },
                                columns: [
                                    { data: 'number',       name: 'number'},
                                    { data: 'name',         name: 'name' },
                                    { data: 'vehicle_name', name: 'vehicle_name'  },
                                    { data: 'palet_number', name: 'palet_number'  },
                                    { data: 'traveller',          name: 'traveller'},
                                    { data: 'source',          name: 'source'},
                                    { data: 'destination',          name: 'destination'},
                                    { data: 'start_odometer',          name: 'start_odometer'},
                                    { data: 'finish_odometer',          name: 'finish_odometer'},
                                    { data: 'Date',             name: 'Date'},
                                    { data: 'start_trip_date',         name: 'start_trip_date'},
                                    { data: 'end_trip_date',         name: 'end_trip_date'},
                                    { data: 'description',  name: 'description'},
                                    { data: 'user',  name: 'user'}
                                ]
                            });

                        });

                        $('#statement-tab').on('shown.bs.tab', function(event) {

                            $('#statement-table').DataTable({
                                scrollCollapse: true,
                                responsive: '{{responsiveDataTable()}}',
                                pagingType: '{{paginationType()}}',
                                serverSide: true,
                                paging: true,
                                destroy: true,
                                retrieve: true,
                                ajax: {
                                    url: '{{route("vehicle.show",$vehicles->id)}}',
                                    data: {
                                        type: 'statements'
                                    }
                                },
                                columns: [{
                                        data: 'Account',
                                        name: 'Account'
                                    },
                                    {
                                        data: 'Description',
                                        name: 'Description'
                                    },
                                    {
                                        data: 'Currency',
                                        name: 'Currency'
                                    },
                                    {
                                        data: 'Rate',
                                        name: 'Rate'
                                    },
                                    {
                                        data: 'Type',
                                        name: 'Type'
                                    },
                                    {
                                        data: 'receive',
                                        name: 'receive'
                                    },
                                    {
                                        data: 'expense',
                                        name: 'expense'
                                    },
                                    {
                                        data: 'totalBase',
                                        name: 'totalBase'
                                    },
                                    {
                                        data: 'Date',
                                        name: 'Date'
                                    },

                                ]
                            });

                        });
                    });



                    var vm = new Vue({
                        el: '#print-modal',
                        data: {
                            is_show: false,
                            load_show: false,
                            statement_show: false,
                            logBook_show: false,
                            pdfRoute: '{!!route('vehicle.report') !!}',
                            excelRoute: '{!! route('vehicle.report') !!}',
                            pdfRouteAll: '{!!route('export.PDFAll') !!}',
                            excelRouteAll: '{!! route('export.ExcelAll') !!}',
                            ReportTypeSelected: null,
                            ReportType: [{
                                    name: '{{ __("type.Rent") }}',
                                    id: 'Rent'
                                },
                                {
                                    name: '{{ __("type.Expenses") }}',
                                    id: 'Expenses'
                                },
                                {
                                    name: '{{ __("type.Return") }}',
                                    id: 'Return'
                                },
                                {
                                    name: '{{ __("type.Loading") }}',
                                    id: 'Loading'
                                },
                            ],
                            loadTypeSelected: null,
                            loadType: [{
                                    name: '{{ __("type.Loading") }}',
                                    id: 'Loading'
                                },
                                {
                                    name: '{{ __("layout.Discharge") }}',
                                    id: 'Discharge'
                                },
                            ]

                        },
                        methods: {
                            closeModal: function() {
                                this.is_show = !this.is_show
                            },
                            closeModalLoad: function() {
                                this.load_show = !this.load_show
                            },
                            closeModal1: function() {
                                this.statement_show = !this.statement_show
                            },
                            closeModalLogBook: function() {
                                this.logBook_show = !this.logBook_show
                            },
                        }
                    });


                    new Vue({
                        el: '#anchore-modal',
                        methods: {
                            showModal: function() {
                                console.log('trr')
                                vm.$data.is_show = true;

                            }
                        }
                    });

                    new Vue({
                        el: '#logBook-modal',
                        methods: {
                            showModal: function() {
                                console.log('trr')
                                vm.$data.logBook_show = true;  //vehicle_log_book

                            }
                        }
                    });

                    new Vue({
                        el: '#loading-modal',
                        methods: {
                            showModalL: function() {
                                console.log('trr')
                                vm.$data.load_show = true;

                            }
                        }
                    });

                    new Vue({
                        el: '#statement-modal',
                        methods: {
                            showModal: function() {
                                console.log('trr1')
                                vm.$data.statement_show = true;

                            }
                        }
                    });
                </script>


                @endpush