@extends('layouts.app')
@section('content')

    <!-- BEGIN TAB PORTLET-->


    <div class="row">
        <div class="col-md-12">
            @if (count($errors) > 0)
                <div class="m-heading-1 border-red m-bordered errors-action">
                    <h4 class="error-title"><strong>Whoops!</strong> There were some problems with your input</h4>
                    <ul class="error-body">
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul> 
                </div>
            @endif 
            <div class="portled">
                <div class="portlet-title">
                    <div class="tools">
                        <a href="" class="collapse" data-original-title="" title=""> </a>
                        <a href="#portlet-config" data-toggle="modal" class="config" data-original-title="" title=""> </a>
                        <a href="" class="reload" data-original-title="" title=""> </a>
                        <a href="" class="remove" data-original-title="" title=""> </a>
                    </div>
                </div>
                <div class="portlet-body form">
                    <div class="form-body"> 

                        <div class="row input-daterange">

                                <div class="col-md-3"> 
                                    <!-- <input type="text" name="daterange" class="form-control"/> -->
                                    <label class="contrl-label col-md-3">@lang('layout.From')</label>
                                    <input type="text" id="from" name="fromdate" class="form-control datepicker" required>
                                </div>
                                <div class="col-md-3">
                                    <label class="contrl-label col-md-3">@lang('layout.To')</label>
                                    <input type="text" id="to" name="todate" class="form-control" required>
                                </div>
                                <div class="col-md-2">
                                    <input type="hidden" id="send_type" name="type" value="services">
                                    <button type="button" id="generate_report" style="margin-top:24px;" class="btn green"> @lang('layout.Search') <i class="fa fa-search"></i></button>
                                </div>
                        </div> 
                    </div>
                </div> 
            </div> 
        </div>
 
        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-body">
                <table class="table table-striped table-bordered table-hover" id="servicestable" cellspacing="0" width="100%">
                    <thead>
                        <tr>
                            <th>Code</th>
                            <th>Name</th>
                            <th>Description</th>
                            <th>Incom Account</th>
                            <th>Rate</th>
                            <th>Measure</th>
                            <th>Cost Account</th>
                            <th>Cost</th>
                        </tr>
                    </thead>

                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>
    <!-- END TAB PORTLET-->
    <!-- END CONTENT BODY -->
@stop

@push('scripts')

<script>
$('#to').datepicker();
$('#from').datepicker();

    $(document).ready(function(){
            var table = $('#servicestable').DataTable({
                    searching: false,
                    paging: true,
                    processing: true,
                    serverSide: true,
                    deferLoading: 0,
                    ajax: {
                        url: '{{ route('report.show') }}',
                        data: function(d) {
                            d.s_date = $("#from").val();
                            d.e_date = $("#to").val();
                            d.types   = $("#send_type").val(); 
                        }
                    },
                    columns: [
                    { data: 'number', name: 'id' },
                    { data: 'name', name: 'name' },
                    { data: 'description', name: 'description' },
                    { data: 'income', name: 'percent' },
                    { data: 'rate', name: 'account' },
                    { data: 'measure', name: 'measure' },
                    { data: 'cost_account', name: 'account' },
                    { data: 'amount', name: 'account' },
                    ]
                });

            $('#generate_report').on('click',function(e){
                    e.preventDefault();
                    table.draw();
                });
        });
</script>


@endpush
